/*
* Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of the License "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description: 
*
*/
package com.nokia.cdt.internal.debug.launch.wizard;

import java.util.List;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;

/**
 * Created for purposes of dependency injection on the LaunchCreationWizard.
 * This instance allows for other factories to be substituted at runtime, for
 * purposes of injecting at runtime LaunchCreationWizard sub-classes created by
 * the automated tests
 * 
 */
public class LaunchCreationWizardInstance {
	
	// The delegate factory
	ILaunchCreationWizardFactory factory;
	
	static private LaunchCreationWizardInstance instance = null;
	
	/**
	 * Returns the singleton
	 * @return
	 */
	public static LaunchCreationWizardInstance getInstance() {
		if (instance == null) {
			instance = new LaunchCreationWizardInstance();
		}
		return instance;
	}
	
	private LaunchCreationWizardInstance() {
		setDefault();
	}
	
	/**
	 * Returns the LaunchCreationWizard generated by the factory.
	 */
	public LaunchCreationWizard create(IProject project, String configurationName, 
			List<IPath> mmps, List<IPath> exes, IPath defaultExecutable,  
			boolean isEmulation, boolean emulatorOnly, String mode) throws Exception {
		return factory.create(project, configurationName, mmps, exes, defaultExecutable, isEmulation, emulatorOnly, mode);
	}
	
	/**
	 * Sets the factory to the default product implementation.  Used by the default initializer and to clear a dependency previously set
	 */
	public void setDefault() {
		set(new ILaunchCreationWizardFactory() {
			
			public LaunchCreationWizard create(IProject project, String configurationName,
					List<IPath> mmps, List<IPath> exes, IPath defaultExecutable,
					boolean isEmulation, boolean emulatorOnly, String mode)
					throws Exception {
				return new LaunchCreationWizard(project, configurationName, mmps, exes, defaultExecutable, isEmulation, emulatorOnly, mode);

			}
		});
	}
	
	/**
	 * Intended to be used by tests to inject a custom factory
	 */
	public void set(ILaunchCreationWizardFactory factory) {
		this.factory = factory;
	}
}
