/*
 * Decompiled with CFR 0.152.
 */
package org.custommonkey.xmlunit;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import org.custommonkey.xmlunit.Diff;
import org.custommonkey.xmlunit.Transform;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class XMLUnit {
    private static DocumentBuilderFactory controlBuilderFactory;
    private static DocumentBuilderFactory testBuilderFactory;
    private static TransformerFactory transformerFactory;
    private static boolean ignoreWhitespace;
    private static final String STRIP_WHITESPACE_STYLESHEET;

    private XMLUnit() {
    }

    public static void setControlParser(String className) throws FactoryConfigurationError {
        System.setProperty("javax.xml.parsers.DocumentBuilderFactory", className);
        controlBuilderFactory = null;
        controlBuilderFactory = XMLUnit.getControlDocumentBuilderFactory();
    }

    public static DocumentBuilder getControlParser() throws ParserConfigurationException {
        controlBuilderFactory = XMLUnit.getControlDocumentBuilderFactory();
        return controlBuilderFactory.newDocumentBuilder();
    }

    public static DocumentBuilderFactory getControlDocumentBuilderFactory() {
        if (controlBuilderFactory == null) {
            controlBuilderFactory = DocumentBuilderFactory.newInstance();
            controlBuilderFactory.setNamespaceAware(true);
        }
        return controlBuilderFactory;
    }

    public static void setControlDocumentBuilderFactory(DocumentBuilderFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("Cannot set control DocumentBuilderFactory to null!");
        }
        controlBuilderFactory = factory;
    }

    public static void setTestParser(String className) throws FactoryConfigurationError {
        System.setProperty("javax.xml.parsers.DocumentBuilderFactory", className);
        testBuilderFactory = null;
        testBuilderFactory = XMLUnit.getTestDocumentBuilderFactory();
    }

    public static DocumentBuilder getTestParser() throws ParserConfigurationException {
        testBuilderFactory = XMLUnit.getTestDocumentBuilderFactory();
        return testBuilderFactory.newDocumentBuilder();
    }

    public static DocumentBuilderFactory getTestDocumentBuilderFactory() {
        if (testBuilderFactory == null) {
            testBuilderFactory = DocumentBuilderFactory.newInstance();
            testBuilderFactory.setNamespaceAware(true);
        }
        return testBuilderFactory;
    }

    public static void setTestDocumentBuilderFactory(DocumentBuilderFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("Cannot set test DocumentBuilderFactory to null!");
        }
        testBuilderFactory = factory;
    }

    public static void setIgnoreWhitespace(boolean ignore) {
        ignoreWhitespace = ignore;
        XMLUnit.getControlDocumentBuilderFactory().setIgnoringElementContentWhitespace(ignore);
        XMLUnit.getTestDocumentBuilderFactory().setIgnoringElementContentWhitespace(ignore);
    }

    public static boolean getIgnoreWhitespace() {
        return ignoreWhitespace;
    }

    public static Diff compare(Reader control, Reader test) throws SAXException, IOException, ParserConfigurationException {
        return new Diff(control, test);
    }

    public static Diff compare(InputSource control, InputSource test) throws SAXException, IOException, ParserConfigurationException {
        return new Diff(control, test);
    }

    public static Diff compare(String control, Reader test) throws SAXException, IOException, ParserConfigurationException {
        return new Diff(new StringReader(control), test);
    }

    public static Diff compare(Reader control, String test) throws SAXException, IOException, ParserConfigurationException {
        return new Diff(control, new StringReader(test));
    }

    public static Diff compare(String control, String test) throws SAXException, IOException, ParserConfigurationException {
        return new Diff(control, test);
    }

    public static Document buildControlDocument(String fromXML) throws SAXException, IOException, ParserConfigurationException {
        return XMLUnit.buildDocument(XMLUnit.getControlParser(), new StringReader(fromXML));
    }

    public static Document buildControlDocument(InputSource fromSource) throws IOException, SAXException, ParserConfigurationException {
        return XMLUnit.buildDocument(XMLUnit.getControlParser(), fromSource);
    }

    public static Document buildTestDocument(String fromXML) throws SAXException, IOException, ParserConfigurationException {
        return XMLUnit.buildDocument(XMLUnit.getTestParser(), new StringReader(fromXML));
    }

    public static Document buildTestDocument(InputSource fromSource) throws IOException, SAXException, ParserConfigurationException {
        return XMLUnit.buildDocument(XMLUnit.getTestParser(), fromSource);
    }

    public static Document buildDocument(DocumentBuilder withBuilder, Reader fromReader) throws SAXException, IOException {
        return XMLUnit.buildDocument(withBuilder, new InputSource(fromReader));
    }

    public static Document buildDocument(DocumentBuilder withBuilder, InputSource fromSource) throws IOException, SAXException {
        return withBuilder.parse(fromSource);
    }

    public static void setTransformerFactory(String className) throws TransformerFactoryConfigurationError {
        System.setProperty("javax.xml.transform.TransformerFactory", className);
        transformerFactory = null;
        XMLUnit.getTransformerFactory();
    }

    public static TransformerFactory getTransformerFactory() throws TransformerFactoryConfigurationError {
        if (transformerFactory == null) {
            transformerFactory = TransformerFactory.newInstance();
        }
        return transformerFactory;
    }

    public static void setSAXParserFactory(String className) {
        System.setProperty("javax.xml.parsers.SAXParserFactory", className);
        XMLUnit.getSAXParserFactory();
    }

    public static SAXParserFactory getSAXParserFactory() {
        SAXParserFactory newFactory = SAXParserFactory.newInstance();
        newFactory.setNamespaceAware(true);
        return newFactory;
    }

    public static Transform getStripWhitespaceTransform(Document forDocument) throws TransformerConfigurationException {
        return new Transform((Node)forDocument, STRIP_WHITESPACE_STYLESHEET);
    }

    public static String getVersion() {
        return "1.0";
    }

    public static Diff compareXML(Reader control, Reader test) throws SAXException, IOException, ParserConfigurationException {
        return new Diff(control, test);
    }

    public static Diff compareXML(String control, Reader test) throws SAXException, IOException, ParserConfigurationException {
        return new Diff(new StringReader(control), test);
    }

    public static Diff compareXML(Reader control, String test) throws SAXException, IOException, ParserConfigurationException {
        return new Diff(control, new StringReader(test));
    }

    public static Diff compareXML(String control, String test) throws SAXException, IOException, ParserConfigurationException {
        return new Diff(control, test);
    }

    public static Diff compareXML(Document control, Document test) {
        return new Diff(control, test);
    }

    static {
        ignoreWhitespace = false;
        STRIP_WHITESPACE_STYLESHEET = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>" + "<xsl:stylesheet xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" version=\"1.0\">" + "<xsl:output method=\"xml\" version=\"1.0\" indent=\"no\"/>" + "<xsl:strip-space elements=\"*\"/>" + "<xsl:template match=\"/\"><xsl:copy-of select=\".\"/></xsl:template>" + "</xsl:stylesheet>";
    }
}

