/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.events;

import org.w3c.dom.events.EventListener;

public class EventListenerList {
    protected int n = 0;
    protected Entry first = null;
    protected EventListener[] listeners = null;

    public EventListener[] getEventListeners() {
        if (this.first == null) {
            return null;
        }
        if (this.listeners != null) {
            return this.listeners;
        }
        this.listeners = new EventListener[this.n];
        Entry entry = this.first;
        for (int i = 0; i < this.n; ++i) {
            this.listeners[i] = entry.listener;
            entry = entry.next;
        }
        return this.listeners;
    }

    public void add(EventListener eventListener) {
        this.first = new Entry(eventListener, this.first);
        this.listeners = null;
        ++this.n;
    }

    public void remove(EventListener eventListener) {
        if (this.first == null) {
            return;
        }
        if (this.first.listener == eventListener) {
            this.first = this.first.next;
            this.listeners = null;
            --this.n;
        } else {
            Entry entry = this.first;
            Entry entry2 = this.first.next;
            while (entry2 != null) {
                if (entry2.listener == eventListener) {
                    entry.next = entry2.next;
                    this.listeners = null;
                    --this.n;
                    break;
                }
                entry = entry2;
                entry2 = entry2.next;
            }
        }
    }

    public boolean contains(EventListener eventListener) {
        Entry entry = this.first;
        while (entry != null) {
            if (eventListener == entry.listener) {
                return true;
            }
            entry = entry.next;
        }
        return false;
    }

    public int size() {
        return this.n;
    }

    protected static class Entry {
        EventListener listener;
        Entry next;

        public Entry(EventListener eventListener, Entry entry) {
            this.listener = eventListener;
            this.next = entry;
        }
    }
}

