/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.batik.util.DoublyLinkedList;
import org.apache.batik.util.HaltingThread;

public class RunnableQueue
implements Runnable {
    public static final RunnableQueueState RUNNING = new RunnableQueueState("Running");
    public static final RunnableQueueState SUSPENDING = new RunnableQueueState("Suspending");
    public static final RunnableQueueState SUSPENDED = new RunnableQueueState("Suspended");
    protected RunnableQueueState state;
    protected Object stateLock = new Object();
    protected boolean wasResumed;
    protected DoublyLinkedList list = new DoublyLinkedList();
    protected int preemptCount = 0;
    protected RunHandler runHandler;
    protected HaltingThread runnableQueueThread;
    private static int threadCount;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RunnableQueue createRunnableQueue() {
        RunnableQueue runnableQueue;
        RunnableQueue runnableQueue2 = runnableQueue = new RunnableQueue();
        synchronized (runnableQueue2) {
            HaltingThread haltingThread = new HaltingThread(runnableQueue, "RunnableQueue-" + threadCount++);
            haltingThread.setDaemon(true);
            haltingThread.start();
            while (runnableQueue.getThread() == null) {
                try {
                    runnableQueue.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        return runnableQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void run() {
        Object object = this;
        // MONITORENTER : object
        this.runnableQueueThread = (HaltingThread)Thread.currentThread();
        this.notify();
        // MONITOREXIT : object
        try {
            try {}
            catch (InterruptedException throwable) {
                Object var8_11 = null;
                RunnableQueue runnableQueue = this;
                // MONITORENTER : runnableQueue
                this.runnableQueueThread = null;
                // MONITOREXIT : runnableQueue
                return;
            }
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            RunnableQueue runnableQueue = this;
            // MONITORENTER : runnableQueue
            this.runnableQueueThread = null;
            // MONITOREXIT : runnableQueue
            throw throwable;
        }
        while (true) {
            Object object2;
            block30: {
                block29: {
                    block28: {
                        if (HaltingThread.hasBeenHalted()) break block28;
                        object2 = this.stateLock;
                        // MONITORENTER : object2
                        if (this.state != RUNNING) break block29;
                        if (this.wasResumed) {
                            this.wasResumed = false;
                            this.executionResumed();
                        }
                        break block30;
                    }
                    Object var8_10 = null;
                    RunnableQueue runnableQueue = this;
                    // MONITORENTER : runnableQueue
                    this.runnableQueueThread = null;
                    // MONITOREXIT : runnableQueue
                    return;
                }
                while (this.state != RUNNING) {
                    this.state = SUSPENDED;
                    this.stateLock.notifyAll();
                    this.executionSuspended();
                    try {
                        this.stateLock.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                this.wasResumed = false;
                this.executionResumed();
            }
            // MONITOREXIT : object2
            object2 = this.list;
            // MONITORENTER : object2
            if (this.state == SUSPENDING) {
                // MONITOREXIT : object2
                continue;
            }
            object = (Link)this.list.pop();
            if (this.preemptCount != 0) {
                --this.preemptCount;
            }
            if (object == null) {
                try {
                    this.list.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
            Runnable runnable = ((Link)object).runnable;
            // MONITOREXIT : object2
            this.runnableStart(runnable);
            try {
                runnable.run();
            }
            catch (ThreadDeath object22) {
                throw object22;
            }
            catch (Throwable threadDeath) {
                threadDeath.printStackTrace();
            }
            ((Link)object).unlock();
            this.runnableInvoked(runnable);
        }
    }

    public HaltingThread getThread() {
        return this.runnableQueueThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeLater(Runnable runnable) {
        if (this.runnableQueueThread == null) {
            throw new IllegalStateException("RunnableQueue not started or has exited");
        }
        DoublyLinkedList doublyLinkedList = this.list;
        synchronized (doublyLinkedList) {
            this.list.push(new Link(runnable));
            this.list.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeAndWait(Runnable runnable) throws InterruptedException {
        if (this.runnableQueueThread == null) {
            throw new IllegalStateException("RunnableQueue not started or has exited");
        }
        if (this.runnableQueueThread == Thread.currentThread()) {
            throw new IllegalStateException("Cannot be called from the RunnableQueue thread");
        }
        LockableLink lockableLink = new LockableLink(runnable);
        DoublyLinkedList doublyLinkedList = this.list;
        synchronized (doublyLinkedList) {
            this.list.push(lockableLink);
            this.list.notify();
        }
        lockableLink.lock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preemptLater(Runnable runnable) {
        if (this.runnableQueueThread == null) {
            throw new IllegalStateException("RunnableQueue not started or has exited");
        }
        DoublyLinkedList doublyLinkedList = this.list;
        synchronized (doublyLinkedList) {
            this.list.add(this.preemptCount, new Link(runnable));
            ++this.preemptCount;
            this.list.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preemptAndWait(Runnable runnable) throws InterruptedException {
        if (this.runnableQueueThread == null) {
            throw new IllegalStateException("RunnableQueue not started or has exited");
        }
        if (this.runnableQueueThread == Thread.currentThread()) {
            throw new IllegalStateException("Cannot be called from the RunnableQueue thread");
        }
        LockableLink lockableLink = new LockableLink(runnable);
        DoublyLinkedList doublyLinkedList = this.list;
        synchronized (doublyLinkedList) {
            this.list.add(this.preemptCount, lockableLink);
            ++this.preemptCount;
            this.list.notify();
        }
        lockableLink.lock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RunnableQueueState getQueueState() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspendExecution(boolean bl) {
        if (this.runnableQueueThread == null) {
            throw new IllegalStateException("RunnableQueue not started or has exited");
        }
        Object object = this.stateLock;
        synchronized (object) {
            this.wasResumed = false;
            if (this.state == SUSPENDED) {
                this.stateLock.notifyAll();
                return;
            }
            if (this.state == RUNNING) {
                this.state = SUSPENDING;
                DoublyLinkedList doublyLinkedList = this.list;
                synchronized (doublyLinkedList) {
                    this.list.notify();
                }
            }
            if (bl) {
                while (this.state == SUSPENDING) {
                    try {
                        this.stateLock.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeExecution() {
        if (this.runnableQueueThread == null) {
            throw new IllegalStateException("RunnableQueue not started or has exited");
        }
        Object object = this.stateLock;
        synchronized (object) {
            this.wasResumed = true;
            if (this.state != RUNNING) {
                this.state = RUNNING;
                this.stateLock.notifyAll();
            }
        }
    }

    public Object getIteratorLock() {
        return this.list;
    }

    public Iterator iterator() {
        return new Iterator(){
            Link head;
            Link link;
            {
                this.head = (Link)RunnableQueue.this.list.getHead();
            }

            public boolean hasNext() {
                if (this.head == null) {
                    return false;
                }
                if (this.link == null) {
                    return true;
                }
                return this.link != this.head;
            }

            public Object next() {
                if (this.head == null || this.head == this.link) {
                    throw new NoSuchElementException();
                }
                if (this.link == null) {
                    this.link = (Link)this.head.getNext();
                    return this.head.runnable;
                }
                Runnable runnable = this.link.runnable;
                this.link = (Link)this.link.getNext();
                return runnable;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public synchronized void setRunHandler(RunHandler runHandler) {
        this.runHandler = runHandler;
    }

    public synchronized RunHandler getRunHandler() {
        return this.runHandler;
    }

    protected synchronized void executionSuspended() {
        if (this.runHandler != null) {
            this.runHandler.executionSuspended(this);
        }
    }

    protected synchronized void executionResumed() {
        if (this.runHandler != null) {
            this.runHandler.executionResumed(this);
        }
    }

    protected synchronized void runnableStart(Runnable runnable) {
        if (this.runHandler != null) {
            this.runHandler.runnableStart(this, runnable);
        }
    }

    protected synchronized void runnableInvoked(Runnable runnable) {
        if (this.runHandler != null) {
            this.runHandler.runnableInvoked(this, runnable);
        }
    }

    protected static class LockableLink
    extends Link {
        protected boolean locked;

        public LockableLink(Runnable runnable) {
            super(runnable);
        }

        public boolean isLocked() {
            return this.locked;
        }

        public synchronized void lock() throws InterruptedException {
            this.locked = true;
            this.notify();
            this.wait();
        }

        public synchronized void unlock() throws InterruptedException {
            while (!this.locked) {
                this.wait();
            }
            this.notify();
        }
    }

    protected static class Link
    extends DoublyLinkedList.Node {
        public Runnable runnable;

        public Link(Runnable runnable) {
            this.runnable = runnable;
        }

        public void unlock() throws InterruptedException {
        }
    }

    public static class RunHandlerAdapter
    implements RunHandler {
        public void runnableStart(RunnableQueue runnableQueue, Runnable runnable) {
        }

        public void runnableInvoked(RunnableQueue runnableQueue, Runnable runnable) {
        }

        public void executionSuspended(RunnableQueue runnableQueue) {
        }

        public void executionResumed(RunnableQueue runnableQueue) {
        }
    }

    public static interface RunHandler {
        public void runnableStart(RunnableQueue var1, Runnable var2);

        public void runnableInvoked(RunnableQueue var1, Runnable var2);

        public void executionSuspended(RunnableQueue var1);

        public void executionResumed(RunnableQueue var1);
    }

    public static class RunnableQueueState {
        final String value;

        private RunnableQueueState(String string) {
            this.value = string.intern();
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return "[RunnableQueueState: " + this.value + "]";
        }
    }
}

