/*
* Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of the License "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description: 
*
*/
/* Generated By:JavaCC: Do not edit this line. PKGParserCore.java */
package com.nokia.carbide.internal.cpp.epoc.engine.parser.generated;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import com.nokia.carbide.internal.api.cpp.epoc.engine.dom.ASTFactory;
import com.nokia.carbide.internal.api.cpp.epoc.engine.dom.IASTListNode;
import com.nokia.carbide.internal.api.cpp.epoc.engine.dom.IASTLiteralTextNode;
import com.nokia.carbide.internal.api.cpp.epoc.engine.dom.IASTNode;
import com.nokia.carbide.internal.api.cpp.epoc.engine.dom.IASTPreprocessorTokenStream;
import com.nokia.carbide.internal.api.cpp.epoc.engine.dom.IToken;
import com.nokia.carbide.internal.api.cpp.epoc.engine.dom.pkg.ASTPKGFactory;
import com.nokia.carbide.internal.api.cpp.epoc.engine.dom.pkg.IASTPKGBinaryConditionExpression;
import com.nokia.carbide.internal.api.cpp.epoc.engine.dom.pkg.IASTPKGConditionExpression;
import com.nokia.carbide.internal.api.cpp.epoc.engine.dom.pkg.IASTPKGConditionalContainer;
import com.nokia.carbide.internal.api.cpp.epoc.engine.dom.pkg.IASTPKGElseContainer;
import com.nokia.carbide.internal.api.cpp.epoc.engine.dom.pkg.IASTPKGEmbeddedSisEntry;
import com.nokia.carbide.internal.api.cpp.epoc.engine.dom.pkg.IASTPKGIfElseifContainer;
import com.nokia.carbide.internal.api.cpp.epoc.engine.dom.pkg.IASTPKGOptionsListOption;
import com.nokia.carbide.internal.api.cpp.epoc.engine.dom.pkg.IASTPKGStatement;
import com.nokia.carbide.internal.api.cpp.epoc.engine.dom.pkg.IASTPKGTranslationUnit;
import com.nokia.carbide.internal.api.cpp.epoc.engine.dom.pkg.IASTPKGUnaryConditionExpressionBase;
import com.nokia.carbide.internal.cpp.epoc.engine.parser.ASTToken;
import com.nokia.carbide.internal.cpp.epoc.engine.parser.ParserBase;
import com.nokia.carbide.internal.cpp.epoc.engine.parser.ParserUtils;
import com.nokia.carbide.internal.cpp.epoc.engine.parser.pkg.PKGTokenManager;

// these must exactly match the leading token used in PKG (minus leading PRJ_)
enum PKGBlock {
                NONE,
        LANGUAGE
};

enum ARGTYPE {
        RAW,
        STRING,
        PATH_IN_STRING,
        INT
}

public class PKGParserCore extends ParserBase implements PKGParserCoreConstants {
        PKGBlock currentBlock;
        public IASTPKGTranslationUnit parse() {
                IASTPKGTranslationUnit tu = ASTPKGFactory.createPKGTranslationUnit();
                try {
                        TranslationUnit(tu);
                } catch (ParseException e) {
                        hadErrors = true;
                        e.printStackTrace();
                }
                com.nokia.cpp.internal.api.utils.core.Check.checkState(tu != null);
                return tu;
    }

  final public void TranslationUnit(IASTPKGTranslationUnit tu) throws ParseException {
        IASTListNode<IASTPKGStatement> statements = null;
        Token eof;
    statements = TopLevelStatements();
    eof = jj_consume_token(0);
                if (statements != null && statements.getChildren().length > 0) {
                        tu.setNodes((IASTListNode)statements);
                        ParserUtils.setSourceRangeForListNode(null, tu.getNodes(), eof);
                        ParserUtils.copySourceInfo(tu, tu.getNodes());
                } else {
                        ParserUtils.setSourceRangeFromTokenSpan(tu.getNodes(), eof, eof);
                        ParserUtils.setSourceRangeFromTokenSpan(tu, eof, eof);
                }
  }

// Handy wrapper for current token incase JAVACC changes in the future
  Token CurrentToken() throws ParseException {
        return token;
  }

// just to give rule something to do for empty statement
  void DoNothing() throws ParseException {
  }

  IASTListNode<IASTPKGStatement> TopLevelStatements() throws ParseException {
        IASTListNode<IASTPKGStatement> stmts = null;
        while (((jj_ntk==-1)?jj_ntk():jj_ntk) != EOF) {
                try {
                        IASTPKGStatement stmt = TopLevelStatementOrProblem();
                        if (stmt != null) {
                                if (stmts == null) {
                                        stmts = ASTFactory.createListNode("\n");
                                }
                                stmts.add(stmt);
                        }
                } catch (ParseException e) {
                        hadErrors = true;
                        getNextToken();
                }
        }
        return stmts;
  }

  IASTPKGStatement createProblemStatement(Token start, Token end, ParseException e) throws ParseException {
        IASTPKGStatement stmt;

        if (end == null) {
                ppRestOfLine(false);
                end = token;
        }
        List<IToken> tokens = new ArrayList<IToken>();
        start = start.next;
        Token ptr = start;
        while (true) {
                if (ptr == null || ptr.kind == EOF)
                        break;
                tokens.add(((ASTToken)ptr).iToken);
                if (ptr == end)
                        break;
                ptr = ptr.next;
        }
        IASTPreprocessorTokenStream stream = ASTFactory.createPreprocessorTokenStream(tokens);
        ParserUtils.setSourceRangeForTokenStream(stream, stream);
        stmt = ASTPKGFactory.creatPKGProblemStatement(stream, createMessage(start, e));
        ParserUtils.copySourceInfo(stmt, stream);
        ParserUtils.expandSourceRangeToLine(stmt);
        hadErrors = true;
        return stmt;
  }

// parse to EOL (i.e. next line number)
  final public IASTLiteralTextNode ppRestOfLine(boolean skip) throws ParseException {
        Token start = token, end = start;
        if (skip || !(start instanceof ASTToken))
                start = end = getNextToken();
            int startLine = start.beginLine;
        if (end.kind != EOF && end.beginLine == startLine) {
                while (true) {
                        end = getNextToken();
                        if (end.kind == EOF || end.beginLine != startLine)
                                break;
                }
            }
                {if (true) return getLiteralTextNodeSpanningUpTo(start, end);}
    throw new Error("Missing return statement in function");
  }

// parse a statement and return either a statement,
// a problem generated parsing that statement,
// or null 
  final public IASTPKGStatement TopLevelStatementOrProblem() throws ParseException {
        IASTPKGStatement stmt;
        Token start = token;
    try {
      stmt = TopLevelStatement();
                        {if (true) return stmt;}
    } catch (ParseException e) {
                {if (true) return createProblemStatement(start, null, e);}
    }
    throw new Error("Missing return statement in function");
  }

// A top level statement can be conditional or others that cannot be within conditonals
  final public IASTPKGStatement TopLevelStatement() throws ParseException {
        IASTPKGStatement node = null;
        Token start = token;
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LANGUAGE_START:
        node = LanguageStatement();
        break;
      case PACKAGE_HEADER_START:
        node = PackageHeaderStatement();
        break;
      case MULTILINGUAL_VENDOR_START:
      case UNIQUE_VENDOR_START:
        node = VendorStatement();
        break;
      case EQUAL:
        node = LogoStatement();
        break;
      default:
        jj_la1[0] = jj_gen;
        if (jj_2_1(2147483647)) {
          node = PackageSignatureStatement();
        } else {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case OPEN_SQUARE_BRACKET:
            node = HardwareDependencyStatement();
            break;
          case OPEN_PARENTHESIS:
            node = SoftwareDependencyOrVersionCompatiblityStatement();
            break;
          case OPEN_CURLY_BRACE:
          case AMPERSAND:
          case STRING:
          case IF:
          case COMMENT_START:
          case OPTIONSLIST_START:
          case PLUS:
            node = ConditionalStatement();
            break;
          default:
            jj_la1[1] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
      }
                        {if (true) return node;}
    } catch (ParseException e) {
                {if (true) return createProblemStatement(start, null, e);}
    }
    throw new Error("Missing return statement in function");
  }

// block or one or more statement eligible within conditional block
  final public IASTListNode<IASTPKGStatement> ConditionalStatements() throws ParseException {
        IASTPKGStatement stmt = null;
        IASTListNode<IASTPKGStatement> stmts = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case OPEN_CURLY_BRACE:
    case AMPERSAND:
    case STRING:
    case IF:
    case COMMENT_START:
    case OPTIONSLIST_START:
    case PLUS:
      stmt = ConditionalStatement();
      stmts = ConditionalStatements();
                if (stmts == null) {
                        stmts = ASTFactory.createListNode("\n");
                }
                if (stmt != null)
                        stmts.add(0, stmt);
                {if (true) return stmts;}
      break;
    default:
      jj_la1[2] = jj_gen;
                if (stmts == null) {
                        stmts = ASTFactory.createListNode("\n");
                }
                {if (true) return stmts;}
    }
    throw new Error("Missing return statement in function");
  }

// statements eligibile within conditional block
  final public IASTPKGStatement ConditionalStatement() throws ParseException {
        IASTPKGStatement node = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case COMMENT_START:
      node = CommentStatement();
      break;
    case OPTIONSLIST_START:
      node = OptionsListStatement();
      break;
    default:
      jj_la1[3] = jj_gen;
      if (jj_2_2(2147483647)) {
        node = EmbeddedSisStatement();
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case OPEN_CURLY_BRACE:
        case STRING:
          node = InstallFileStatement();
          break;
        case PLUS:
          node = PropertiesStatement();
          break;
        case IF:
          node = ConditionalBlock();
          break;
        default:
          jj_la1[4] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
                {if (true) return node;}
    throw new Error("Missing return statement in function");
  }

  final public IASTPKGConditionExpression Condition() throws ParseException {
        IASTLiteralTextNode literalTextNode = null;
        IASTPKGConditionExpression node = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case WORD:
    case COND_EXISTS:
    case COND_APPROP:
    case COND_PACKAGE:
      literalTextNode = ConditionPrimitive();
                        node = ASTPKGFactory.createPKGConditionPrimitiveExpression(literalTextNode);
                        ParserUtils.copySourceInfo(node, literalTextNode);
      break;
    case NOT:
    case OPEN_PARENTHESIS:
      node = UnaryBinaryCondition();
      break;
    default:
      jj_la1[5] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                {if (true) return node;}
    throw new Error("Missing return statement in function");
  }

// NOT(), ()AND(), ()OR()
  final public IASTPKGConditionExpression UnaryBinaryCondition() throws ParseException {
        Token start = null;
        Token endParenthesis = null;
        Token condition = null;
        IASTPKGConditionExpression leftNode = null;
        IASTPKGConditionExpression rightNode = null;
        IASTPKGConditionExpression node = null;
        boolean isAnd=false;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NOT:
      start = jj_consume_token(NOT);
      // even doc say () is mandaotry, example said other wise, relax this rule
                      //<OPEN_PARENTHESIS>
                      leftNode = Condition();
                // for ()
                //node = ASTPKGFactory.createPKGUnaryConditionExpression(true, leftNode);
                //return node;
                if (leftNode instanceof IASTPKGUnaryConditionExpressionBase) {
                        ((IASTPKGUnaryConditionExpressionBase)leftNode).setNegation(true);
                        ParserUtils.setSourceRangeFromTokenSpan(leftNode, start, CurrentToken());
                } else if (leftNode instanceof IASTPKGBinaryConditionExpression) {
                        // () is a unary, so any NOT apply to a binary is to the left child
                        IASTNode leftExpression = ((IASTPKGBinaryConditionExpression)leftNode).getLeftExpression();
                        if (leftExpression instanceof IASTPKGUnaryConditionExpressionBase) {
                                ((IASTPKGUnaryConditionExpressionBase)leftExpression).setNegation(true);
                                ParserUtils.extendSourceRangeToInclude(leftExpression, start);
                        }
                        ParserUtils.setSourceRangeFromTokenSpan(leftNode, start, CurrentToken());
                }
                {if (true) return leftNode;}
      break;
    case OPEN_PARENTHESIS:
      start = jj_consume_token(OPEN_PARENTHESIS);
      leftNode = Condition();
      endParenthesis = jj_consume_token(CLOSE_PARENTHESIS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AND:
      case OR:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case AND:
          condition = jj_consume_token(AND);
                                        isAnd=true;
          break;
        case OR:
          condition = jj_consume_token(OR);
          break;
        default:
          jj_la1[6] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        // even doc say (cond) AND (cond) with two operands only, example have more than two
                                // e.g. (cond) AND (cond) AND (cond) AND (cond), relax this rule
                                //<OPEN_PARENTHESIS>
                                rightNode = Condition();
        break;
      default:
        jj_la1[7] = jj_gen;
        ;
      }
                        // take the ()
                        node = leftNode = ASTPKGFactory.createPKGUnaryConditionExpression(false, leftNode);
                        ParserUtils.setSourceRangeFromTokenSpan(node, start, endParenthesis);
                        if (condition != null) {
                                node = ASTPKGFactory.createPKGBinaryConditionExpression(isAnd, leftNode, rightNode);
                        }
                ParserUtils.setSourceRangeFromTokenSpan(node, start, CurrentToken());
                {if (true) return node;}
      break;
    default:
      jj_la1[8] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public IASTLiteralTextNode ConditionPrimitive() throws ParseException {
        Token start = null;
        IASTLiteralTextNode node = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case WORD:
      start = jj_consume_token(WORD);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case INT:
        jj_consume_token(INT);
        break;
      default:
        jj_la1[9] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EQUAL:
      case LESS_GREATER:
      case LESS:
      case GREATER:
      case LESS_EQUAL:
      case GREATER_EQUAL:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case EQUAL:
          jj_consume_token(EQUAL);
          break;
        case LESS_GREATER:
          jj_consume_token(LESS_GREATER);
          break;
        case LESS:
          jj_consume_token(LESS);
          break;
        case GREATER:
          jj_consume_token(GREATER);
          break;
        case LESS_EQUAL:
          jj_consume_token(LESS_EQUAL);
          break;
        case GREATER_EQUAL:
          jj_consume_token(GREATER_EQUAL);
          break;
        default:
          jj_la1[10] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        HexInteger();
        break;
      default:
        jj_la1[11] = jj_gen;
        ;
      }
      break;
    case COND_EXISTS:
      start = jj_consume_token(COND_EXISTS);
      jj_consume_token(OPEN_PARENTHESIS);
      jj_consume_token(STRING);
      jj_consume_token(CLOSE_PARENTHESIS);
      break;
    case COND_APPROP:
      start = jj_consume_token(COND_APPROP);
      jj_consume_token(OPEN_PARENTHESIS);
      HexInteger();
      jj_consume_token(COMMA);
      HexInteger();
      jj_consume_token(CLOSE_PARENTHESIS);
      break;
    case COND_PACKAGE:
      start = jj_consume_token(COND_PACKAGE);
      jj_consume_token(OPEN_PARENTHESIS);
      HexInteger();
      jj_consume_token(CLOSE_PARENTHESIS);
      break;
    default:
      jj_la1[12] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                node = getRawLiteralTextNodeSpanning(start, CurrentToken());
                ParserUtils.setSourceRangeFromTokenSpan(node, start, CurrentToken());
                {if (true) return node;}
    throw new Error("Missing return statement in function");
  }

  final public IASTPKGStatement ConditionalBlock() throws ParseException {
        IASTPKGStatement node = null;
        IASTListNode<IASTPKGConditionalContainer> containers = ASTPKGFactory.createPKGConditionalContainerListNode();
        Token start = null;
        IASTPKGConditionExpression conditionNode = null;
        IASTPKGConditionalContainer block = null;
    start = jj_consume_token(IF);
    conditionNode = Condition();
    //			{
    //				if (token_source instanceof PKGTokenManager) {
    //					conditionToken = ((PKGTokenManager)token_source).getNextAsCommentBodyToken();
    //				} else {
    //					// it should never gets here
    //					throw generateParseException();
    //				}	
    //			}
                            block = IfElseifContainer(conditionNode);
                        containers.add(block);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ELSEIF:
      label_1:
      while (true) {
        jj_consume_token(ELSEIF);
        conditionNode = Condition();
        //				{
        //					if (token_source instanceof PKGTokenManager) {
        //						conditionToken = ((PKGTokenManager)token_source).getNextAsCommentBodyToken();
        //					} else {
        //						// it should never gets here
        //						throw generateParseException();
        //					}
        //				}
                                        block = IfElseifContainer(conditionNode);
                                containers.add(block);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ELSEIF:
          ;
          break;
        default:
          jj_la1[13] = jj_gen;
          break label_1;
        }
      }
      break;
    default:
      jj_la1[14] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ELSE:
      jj_consume_token(ELSE);
      //				{
      //					if (token_source instanceof PKGTokenManager) {
      //						conditionToken = ((PKGTokenManager)token_source).getNextAsCommentBodyToken();
      //					} else {
      //						// it should never gets here
      //						throw generateParseException();
      //					}
      //				}
                                      block = ElseContainer();
                                containers.add(block);
      break;
    default:
      jj_la1[15] = jj_gen;
      ;
    }
    jj_consume_token(ENDIF);
                ParserUtils.setSourceRangeForListNode(null, containers, null);
                node = ASTPKGFactory.createPKGConditionalBlock(containers);
                ParserUtils.setSourceRangeFromTokenSpan(node, start, CurrentToken());
        {if (true) return node;}
    throw new Error("Missing return statement in function");
  }

// node of container for statements eligible for conditional
// top level <-> TU
// conditional <-> condtional sub choice
  final public IASTPKGIfElseifContainer IfElseifContainer(IASTPKGConditionExpression conditionNode) throws ParseException {
        IASTPKGIfElseifContainer node = null;
//	IASTLiteralTextNode conditionNode = null;
        IASTListNode<IASTPKGStatement> statements = null;
        Token start = token;
    statements = ConditionalStatements();
//		if (condition != null) {
//			conditionNode = getRawLiteralTextNodeSpanning(condition, condition);
//		} else {
//			throw generateParseException();
//		}
                node = ASTPKGFactory.createPKGIfElseifContainer(conditionNode, statements);
                if (statements != null && statements.getChildren().length > 0) {
                        ParserUtils.setSourceRangeForListNode(null, statements, null);
                        ParserUtils.copySourceInfo(node, statements);
                } else {
                        ParserUtils.setSourceRangeFromTokenSpan(statements, start, start);
                        ParserUtils.setSourceRangeFromTokenSpan(node, start, start);
                }
                {if (true) return node;}
    throw new Error("Missing return statement in function");
  }

// node of container for statements eligible for conditional
// top level <-> TU
// conditional <-> condtional sub choice
  final public IASTPKGElseContainer ElseContainer() throws ParseException {
        IASTPKGElseContainer node = null;
        IASTListNode<IASTPKGStatement> statements = null;
        Token start = token;
    statements = ConditionalStatements();
                node = ASTPKGFactory.createPKGElseContainer(statements);
                if (statements != null && statements.getChildren().length > 0) {
                        ParserUtils.setSourceRangeForListNode(null, statements, null);
                        ParserUtils.copySourceInfo(node, statements);
                } else {
                        ParserUtils.setSourceRangeFromTokenSpan(statements, start, start);
                        ParserUtils.setSourceRangeFromTokenSpan(node, start, start);
                }
                {if (true) return node;}
    throw new Error("Missing return statement in function");
  }

// node represent a single item in arguement list
  final public IASTLiteralTextNode Argument() throws ParseException {
        IASTLiteralTextNode node = null;
        Token lastToken = null;
        Token equalToken = null;
        Token firstToken = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INT:
      firstToken = jj_consume_token(INT);
      if (jj_2_3(2147483647)) {
        equalToken = jj_consume_token(EQUAL);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case MINUS:
          jj_consume_token(MINUS);
          break;
        default:
          jj_la1[16] = jj_gen;
          ;
        }
        lastToken = jj_consume_token(INT);
      } else {
        ;
      }
                        if (equalToken == null) {
                                lastToken = firstToken;
                        }
      break;
    case ASTERISK:
    case WORD:
    case STRING:
    case PACKAGE_OPTION:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ASTERISK:
        firstToken = jj_consume_token(ASTERISK);
        break;
      case PACKAGE_OPTION:
        firstToken = jj_consume_token(PACKAGE_OPTION);
        break;
      case WORD:
        firstToken = jj_consume_token(WORD);
        break;
      case STRING:
        firstToken = jj_consume_token(STRING);
        break;
      default:
        jj_la1[17] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                        lastToken = firstToken;
      break;
    default:
      jj_la1[18] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                node = getRawLiteralTextNodeSpanning(firstToken, lastToken);
                {if (true) return node;}
    throw new Error("Missing return statement in function");
  }

// comma seperated arguments
  final public IASTListNode<IASTLiteralTextNode> CommaSeparatedArguments() throws ParseException {
        IASTListNode<IASTLiteralTextNode> args = null;
    args = CommaSeparatedArgumentList();
                if (args == null) {
                        args = ASTFactory.createListNode(",");
                }
                ParserUtils.setSourceRangeForListNode(null, args, null);
                {if (true) return args;}
    throw new Error("Missing return statement in function");
  }

// list of arguments
  final public IASTListNode<IASTLiteralTextNode> CommaSeparatedArgumentList() throws ParseException {
        IASTLiteralTextNode arg = null;
        IASTListNode<IASTLiteralTextNode> args = null;
    // look ahead covering the whole optional part, so other comma after argumentlist
            // will not be ambiguous
            arg = Argument();
    if (jj_2_4(2147483647)) {
      jj_consume_token(COMMA);
      args = CommaSeparatedArgumentList();
    } else {
      ;
    }
                        if (args == null) {
                                args = ASTFactory.createListNode(",");
                        }
                        if (arg != null)
                                args.add(0, arg);
                if (args == null) {
                        args = ASTFactory.createListNode(",");
                }
                {if (true) return args;}
    throw new Error("Missing return statement in function");
  }

// node represent a single quoted string item in arguement list
  final public IASTLiteralTextNode LanguageVariantsQuotedStringArgument() throws ParseException {
        IASTLiteralTextNode node = null;
        Token token = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case AMPERSAND:
      jj_consume_token(AMPERSAND);
      break;
    default:
      jj_la1[19] = jj_gen;
      ;
    }
    token = jj_consume_token(STRING);
                node = getRawLiteralTextNodeSpanning(token, token);
                {if (true) return node;}
    throw new Error("Missing return statement in function");
  }

// comma or nothing(space/eol) seperated arguments of STRING only
  final public IASTListNode<IASTLiteralTextNode> LanguageVariantsQuotedStringArguments() throws ParseException {
        IASTListNode<IASTLiteralTextNode> args = null;
    args = LanguageVariantsQuotedStringArgumentList();
                if (args == null) {
                        args = ASTFactory.createListNode(",");
                }
                ParserUtils.setSourceRangeForListNode(null, args, null);
                {if (true) return args;}
    throw new Error("Missing return statement in function");
  }

  final public IASTListNode<IASTLiteralTextNode> LanguageVariantsQuotedStringArgumentList() throws ParseException {
        IASTLiteralTextNode arg = null;
        IASTListNode<IASTLiteralTextNode> args = null;
        Token comma = null;
    // look ahead covering the whole optional part, so other comma after argumentlist
            // will not be ambiguous
            arg = LanguageVariantsQuotedStringArgument();
    if (jj_2_5(2147483647)) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        comma = jj_consume_token(COMMA);
        break;
      default:
        jj_la1[20] = jj_gen;
        ;
      }
      args = LanguageVariantsQuotedStringArgumentList();
    } else {
      ;
    }
                        if (args == null) {
                                args = ASTFactory.createListNode(",");
                        }
                        if (arg != null) {
                                args.add(0, arg);
                                if (comma != null) {
                                        args.setSeparator(",");
                                }
                        }
                if (args == null) {
                        args = ASTFactory.createListNode(",");
                }
                {if (true) return args;}
    throw new Error("Missing return statement in function");
  }

// node represent a single quoted string item in arguement list
  final public IASTPKGEmbeddedSisEntry LanguageVariantsEmbeddedSisArgument() throws ParseException {
        IASTPKGEmbeddedSisEntry node = null;
        Token start = null;
        Token token = null;
    start = jj_consume_token(AMPERSAND);
    token = jj_consume_token(STRING);
                node = ASTPKGFactory.createEmbeddedSisEntry(ParserUtils.getLiteralTextSpanning(start, token));
                ParserUtils.setSourceRangeFromTokenSpan(node, start, token);
                {if (true) return node;}
    throw new Error("Missing return statement in function");
  }

// comma or nothing(space/eol) seperated arguments of STRING only
  final public IASTListNode<IASTLiteralTextNode> LanguageVariantsEmbeddedSisArguments() throws ParseException {
        IASTListNode<IASTLiteralTextNode> args = null;
    args = LanguageVariantsEmbeddedSisArgumentList();
                if (args == null) {
                        args = ASTFactory.createListNode(",");
                }
                ParserUtils.setSourceRangeForListNode(null, args, null);
                {if (true) return args;}
    throw new Error("Missing return statement in function");
  }

  final public IASTListNode<IASTLiteralTextNode> LanguageVariantsEmbeddedSisArgumentList() throws ParseException {
        IASTPKGEmbeddedSisEntry arg = null;
        IASTListNode<IASTLiteralTextNode> args = null;
        Token comma = null;
    // look ahead covering the whole optional part, so other comma after argumentlist
            // will not be ambiguous
            arg = LanguageVariantsEmbeddedSisArgument();
    if (jj_2_6(2147483647)) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        comma = jj_consume_token(COMMA);
        break;
      default:
        jj_la1[21] = jj_gen;
        ;
      }
      args = LanguageVariantsEmbeddedSisArgumentList();
    } else {
      ;
    }
                        if (args == null) {
                                args = ASTFactory.createListNode(",");
                        }
                        if (arg != null) {
                                args.add(0, arg);
                                if (comma != null) {
                                        args.setSeparator(",");
                                }
                        }
                if (args == null) {
                        args = ASTFactory.createListNode(",");
                }
                {if (true) return args;}
    throw new Error("Missing return statement in function");
  }

  final public IASTLiteralTextNode HexInteger() throws ParseException {
        Token token = null;
        IASTLiteralTextNode hexInteger = null;
        Integer hexValue = null;
    token = jj_consume_token(INT);
                try {
                        String hexString = "";
                        hexString += token.image;
                        if (hexString.startsWith("0x")) {
                                hexString = hexString.substring(2, hexString.length() - 1);
                        }
                        hexValue = Integer.parseInt(hexString, 16);
                } catch (NumberFormatException e) {
                        // nothing is needed
                }
                if (hexValue != null) {
                        hexInteger = getRawLiteralTextNodeSpanning(token, token);
                        if (hexInteger != null) {
                                {if (true) return hexInteger;}
                        }
                }
    throw new Error("Missing return statement in function");
  }

  final public IASTPKGStatement CommentStatement() throws ParseException {
        IASTPKGStatement node = null;
        Token start = null;
        Token commentBody = null;
    start = jj_consume_token(COMMENT_START);
                if (token_source instanceof PKGTokenManager) {
                        commentBody = ((PKGTokenManager)token_source).getNextAsCommentBodyToken();
                } else {
                        // it should never gets here
                        {if (true) throw generateParseException();}
                }
                node = ASTPKGFactory.createPKGCommentStatement(getRawLiteralTextNodeSpanning(commentBody, commentBody));
        ParserUtils.setSourceRangeFromTokenSpan(node, start, commentBody);      // includes ';' too

                {if (true) return node;}
    throw new Error("Missing return statement in function");
  }

  final public IASTPKGStatement LanguageStatement() throws ParseException {
        IASTPKGStatement node = null;
        Token start = null;
        IASTListNode<IASTLiteralTextNode> languages = null;
    start = jj_consume_token(LANGUAGE_START);
    languages = CommaSeparatedArguments();
                node = ASTPKGFactory.createPKGLanguageStatement(languages);
                ParserUtils.setSourceRangeFromTokenSpan(node, start, CurrentToken());
                {if (true) return node;}
    throw new Error("Missing return statement in function");
  }

  final public IASTPKGStatement PackageHeaderStatement() throws ParseException {
        IASTPKGStatement node = null;
        Token start = null;
        IASTListNode<IASTLiteralTextNode> packageNameLocalizedVariants = null;
        IASTLiteralTextNode uid = null;
        IASTListNode<IASTLiteralTextNode> versionAndOptionList = null;
        IASTListNode<IASTLiteralTextNode> version = null;
        IASTListNode<IASTLiteralTextNode> optionList = null;
    start = jj_consume_token(PACKAGE_HEADER_START);
    jj_consume_token(OPEN_CURLY_BRACE);
    packageNameLocalizedVariants = LanguageVariantsQuotedStringArguments();
    jj_consume_token(CLOSE_CURLY_BRACE);
    jj_consume_token(COMMA);
    jj_consume_token(OPEN_PARENTHESIS);
    uid = HexInteger();
    jj_consume_token(CLOSE_PARENTHESIS);
    jj_consume_token(COMMA);
    // unfortunately this comma separated list of version and option is hard to parse
            versionAndOptionList = CommaSeparatedArguments();
                // split the single mixed list into two
                version = ASTFactory.createListNode(",");
                optionList = ASTFactory.createListNode(",");

                Iterator<IASTLiteralTextNode> itr = versionAndOptionList.iterator();

                int count = 0;
                while (itr.hasNext()) {
                        IASTLiteralTextNode childnode = itr.next();
                        itr.remove();
                        if (count < 3)
                                version.add((IASTLiteralTextNode) childnode);
                        else
                                optionList.add((IASTLiteralTextNode) childnode);

                        count++;
                }
                ParserUtils.setSourceRangeForListNode(null, version, null);
                ParserUtils.setSourceRangeForListNode(null, optionList, null);
                if (optionList.size() == 0) {
                        ParserUtils.setSourceRangeFromTokenAfter(optionList, CurrentToken());
        }

                node = ASTPKGFactory.createPKGPackageHeaderStatement(packageNameLocalizedVariants,
                                                                                                                        uid,
                                                                                                                        version,
                                                                                                                        optionList);
                ParserUtils.setSourceRangeFromTokenSpan(node, start, CurrentToken());
                {if (true) return node;}
    throw new Error("Missing return statement in function");
  }

  final public IASTPKGStatement VendorStatement() throws ParseException {
        IASTPKGStatement node = null;
        Token start = null;
        IASTListNode<IASTLiteralTextNode> vendorStringLocalizedVariants = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case MULTILINGUAL_VENDOR_START:
      start = jj_consume_token(MULTILINGUAL_VENDOR_START);
      jj_consume_token(OPEN_CURLY_BRACE);
      vendorStringLocalizedVariants = LanguageVariantsQuotedStringArguments();
      jj_consume_token(CLOSE_CURLY_BRACE);
                node = ASTPKGFactory.createPKGVendorStatement(vendorStringLocalizedVariants, true);
                ParserUtils.setSourceRangeFromTokenSpan(node, start, CurrentToken());
                {if (true) return node;}
      break;
    case UNIQUE_VENDOR_START:
      start = jj_consume_token(UNIQUE_VENDOR_START);
      vendorStringLocalizedVariants = CommaSeparatedArguments();
                if (vendorStringLocalizedVariants.size() > 1) {
                        {if (true) throw new Error("Multlingual vendor variant should follow %{\"vendor_1\"...\"vendor_n\"}");}
                }
                node = ASTPKGFactory.createPKGVendorStatement(vendorStringLocalizedVariants, false);
                ParserUtils.setSourceRangeFromTokenSpan(node, start, CurrentToken());
                {if (true) return node;}
      break;
    default:
      jj_la1[22] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public IASTPKGStatement LogoStatement() throws ParseException {
        IASTPKGStatement node = null;
        Token start = null;
        Token sourcePath = null;
        Token mimeType = null;
        Token destPath = null;
    start = jj_consume_token(EQUAL);
    sourcePath = jj_consume_token(STRING);
    jj_consume_token(COMMA);
    mimeType = jj_consume_token(STRING);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case COMMA:
      jj_consume_token(COMMA);
      destPath = jj_consume_token(STRING);
      break;
    default:
      jj_la1[23] = jj_gen;
      ;
    }
                IASTLiteralTextNode sourcePathNode = null;
                IASTLiteralTextNode mimeTypeNode = null;
                IASTLiteralTextNode destPathNode = null;

                sourcePathNode = getRawLiteralTextNodeSpanning(sourcePath, sourcePath);
                mimeTypeNode = getRawLiteralTextNodeSpanning(mimeType, mimeType);
                if (destPath != null) {
                        destPathNode = getRawLiteralTextNodeSpanning(destPath, destPath);
                }
                node = ASTPKGFactory.createPKGLogoStatement(sourcePathNode, mimeTypeNode, destPathNode);
                ParserUtils.setSourceRangeFromTokenSpan(node, start, CurrentToken());
                {if (true) return node;}
    throw new Error("Missing return statement in function");
  }

  final public IASTPKGStatement PackageSignatureStatement() throws ParseException {
        IASTPKGStatement node = null;
        Token start = null;
        Token key = null;
        Token cert = null;
    start = jj_consume_token(ASTERISK);
    key = jj_consume_token(STRING);
    jj_consume_token(COMMA);
    cert = jj_consume_token(STRING);
                IASTLiteralTextNode keyNode = null;
                IASTLiteralTextNode certNode = null;

                if (key != null) {
                        keyNode = getRawLiteralTextNodeSpanning(key, key);
                }
                if (cert != null) {
                        certNode = getRawLiteralTextNodeSpanning(cert, cert);
                }
                node = ASTPKGFactory.createPKGPackageSignatureStatement(keyNode, certNode);
                ParserUtils.setSourceRangeFromTokenSpan(node, start, CurrentToken());
                {if (true) return node;}
    throw new Error("Missing return statement in function");
  }

  final public IASTPKGStatement HardwareDependencyStatement() throws ParseException {
        IASTPKGStatement node = null;
        Token start = null;
        IASTLiteralTextNode uid = null;
        IASTListNode<IASTLiteralTextNode> version = null;
        IASTListNode<IASTLiteralTextNode> components = null;
    start = jj_consume_token(OPEN_SQUARE_BRACKET);
    uid = HexInteger();
    jj_consume_token(CLOSE_SQUARE_BRACKET);
    jj_consume_token(COMMA);
    version = CommaSeparatedArguments();
    jj_consume_token(COMMA);
    jj_consume_token(OPEN_CURLY_BRACE);
    components = LanguageVariantsQuotedStringArguments();
    jj_consume_token(CLOSE_CURLY_BRACE);
                node = ASTPKGFactory.createPKGHardwareDependencyStatement(uid, version, components);
                ParserUtils.setSourceRangeFromTokenSpan(node, start, CurrentToken());
                {if (true) return node;}
    throw new Error("Missing return statement in function");
  }

  final public IASTPKGStatement SoftwareDependencyOrVersionCompatiblityStatement() throws ParseException {
        IASTPKGStatement node = null;
        Token start = null;
        IASTLiteralTextNode uid = null;
        IASTListNode<IASTLiteralTextNode> versionLowerBound = null;
        IASTListNode<IASTLiteralTextNode> versionUpperBound = null;
        IASTListNode<IASTLiteralTextNode> components = null;
    start = jj_consume_token(OPEN_PARENTHESIS);
    uid = HexInteger();
    jj_consume_token(CLOSE_PARENTHESIS);
    jj_consume_token(COMMA);
    versionLowerBound = CommaSeparatedArguments();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TIDLE:
      jj_consume_token(TIDLE);
      versionUpperBound = CommaSeparatedArguments();
      break;
    default:
      jj_la1[24] = jj_gen;
      ;
    }
    jj_consume_token(COMMA);
    jj_consume_token(OPEN_CURLY_BRACE);
    components = LanguageVariantsQuotedStringArguments();
    jj_consume_token(CLOSE_CURLY_BRACE);
                if (versionUpperBound != null) {
                        node = ASTPKGFactory.createPKGSoftwareDependencyOrVersionCompatibilityStatement(uid, versionLowerBound, versionUpperBound, components);
                } else {
                        node = ASTPKGFactory.createPKGSoftwareDependencyOrVersionCompatibilityStatement(uid, versionLowerBound, components);
                }
                ParserUtils.setSourceRangeFromTokenSpan(node, start, CurrentToken());
                {if (true) return node;}
    throw new Error("Missing return statement in function");
  }

  final public IASTPKGOptionsListOption OptionListOption() throws ParseException {
        IASTPKGOptionsListOption node = null;
        Token start = null;
        Token end = null;
        IASTListNode<IASTLiteralTextNode> localizedOption = null;
    start = jj_consume_token(OPEN_CURLY_BRACE);
    localizedOption = LanguageVariantsQuotedStringArguments();
    end = jj_consume_token(CLOSE_CURLY_BRACE);
                node = ASTPKGFactory.createPKGOptionsListOption(localizedOption);
                ParserUtils.setSourceRangeFromTokenSpan(node, start, end);
                {if (true) return node;}
    throw new Error("Missing return statement in function");
  }

  final public IASTListNode<IASTPKGOptionsListOption> OptionsList() throws ParseException {
        IASTPKGOptionsListOption option = null;
        IASTListNode<IASTPKGOptionsListOption> list = null;
    // look ahead covering the whole optional part, so other comma after argumentlist
            // will not be ambiguous
            option = OptionListOption();
    if (jj_2_7(2147483647)) {
      jj_consume_token(COMMA);
      list = OptionsList();
    } else {
      ;
    }
                        if (list == null) {
                                list = ASTFactory.createListNode(",");
                        }
                        if (option != null)
                                list.add(0, option);
                if (list == null) {
                        list = ASTFactory.createListNode(",");
                }
                ParserUtils.setSourceRangeForListNode(null, list, null);
                {if (true) return list;}
    throw new Error("Missing return statement in function");
  }

  final public IASTPKGStatement OptionsListStatement() throws ParseException {
        IASTPKGStatement node = null;
        Token start = null;
        IASTListNode<IASTPKGOptionsListOption> optionsList = null;
        Token end = null;
    start = jj_consume_token(OPTIONSLIST_START);
    jj_consume_token(OPEN_PARENTHESIS);
    optionsList = OptionsList();
    end = jj_consume_token(CLOSE_PARENTHESIS);
                node = ASTPKGFactory.createPKGOptionsListStatement(optionsList);
                ParserUtils.setSourceRangeFromTokenSpan(node, start, end);
                {if (true) return node;}
    throw new Error("Missing return statement in function");
  }

  final public IASTPKGStatement InstallFileStatement() throws ParseException {
        IASTPKGStatement node = null;
        Token start = null;
        IASTListNode<IASTLiteralTextNode> soureFileLocalizedVarients = null;
        Token targetToken = null;
        IASTListNode<IASTLiteralTextNode> installOptions = null;
        boolean languageDependentSyntax = false;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case OPEN_CURLY_BRACE:
      start = jj_consume_token(OPEN_CURLY_BRACE);
      soureFileLocalizedVarients = LanguageVariantsQuotedStringArguments();
      jj_consume_token(CLOSE_CURLY_BRACE);
      break;
    case STRING:
      start = jj_consume_token(STRING);
                        soureFileLocalizedVarients = ASTFactory.createLiteralTextNodeList();
                        soureFileLocalizedVarients.setSeparator(",");
                        soureFileLocalizedVarients.add(getRawLiteralTextNodeSpanning(start,start));
                        ParserUtils.setSourceRangeForListNode(null, soureFileLocalizedVarients, null);
      break;
    default:
      jj_la1[25] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(MINUS);
    targetToken = jj_consume_token(STRING);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case COMMA:
      jj_consume_token(COMMA);
      installOptions = CommaSeparatedArguments();
      break;
    default:
      jj_la1[26] = jj_gen;
      ;
    }
                if (installOptions == null) {
                        installOptions = ASTFactory.createListNode(",");
                        ParserUtils.setSourceRangeFromTokenAfter(installOptions, targetToken);
                }
                node = ASTPKGFactory.createPKGInstallFileStatement(soureFileLocalizedVarients,
                                                                                                        getRawLiteralTextNodeSpanning(targetToken, targetToken),
                                                                                                        installOptions);
                ParserUtils.setSourceRangeFromTokenSpan(node, start, CurrentToken());
                {if (true) return node;}
    throw new Error("Missing return statement in function");
  }

  final public IASTPKGStatement EmbeddedSisStatement() throws ParseException {
        IASTPKGStatement node = null;
        Token start = null;
        Token sisToken = null;
        IASTListNode<IASTLiteralTextNode> embeddedSisLocalizedVarients = null;
        IASTLiteralTextNode uid = null;
        IASTPKGEmbeddedSisEntry entry = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case OPEN_CURLY_BRACE:
      start = jj_consume_token(OPEN_CURLY_BRACE);
      embeddedSisLocalizedVarients = LanguageVariantsEmbeddedSisArguments();
      jj_consume_token(CLOSE_CURLY_BRACE);
      break;
    case AMPERSAND:
      start = jj_consume_token(AMPERSAND);
      token = jj_consume_token(STRING);
                        embeddedSisLocalizedVarients = ASTFactory.createLiteralTextNodeList();
                        embeddedSisLocalizedVarients.setSeparator(",");
                        entry = ASTPKGFactory.createEmbeddedSisEntry(ParserUtils.getLiteralTextSpanning(start, token));
                        ParserUtils.setSourceRangeFromTokenSpan(entry, start, token);
                        embeddedSisLocalizedVarients.add(entry);
                        ParserUtils.setSourceRangeForListNode(null, embeddedSisLocalizedVarients, null);
      break;
    default:
      jj_la1[27] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(COMMA);
    jj_consume_token(OPEN_PARENTHESIS);
    uid = HexInteger();
    jj_consume_token(CLOSE_PARENTHESIS);
                node = ASTPKGFactory.createPKGEmbeddedSisStatement(embeddedSisLocalizedVarients, uid);
                ParserUtils.setSourceRangeFromTokenSpan(node, start, CurrentToken());
                {if (true) return node;}
    throw new Error("Missing return statement in function");
  }

  final public IASTPKGStatement PropertiesStatement() throws ParseException {
        IASTPKGStatement node = null;
        Token start = null;
        IASTListNode<IASTLiteralTextNode> properties = null;
    start = jj_consume_token(PLUS);
    jj_consume_token(OPEN_PARENTHESIS);
    properties = CommaSeparatedArguments();
    jj_consume_token(CLOSE_PARENTHESIS);
                node = ASTPKGFactory.createPKGPropertiesOrCapabilitiesStatement(properties);
                ParserUtils.setSourceRangeFromTokenSpan(node, start, CurrentToken());
                {if (true) return node;}
    throw new Error("Missing return statement in function");
  }

  final public void Dummy() throws ParseException {
    jj_consume_token(STRING);
    jj_consume_token(RAW);
    jj_consume_token(WORD);
    jj_consume_token(PACKAGE_OPTION);
    jj_consume_token(LESS);
    jj_consume_token(GREATER);
    jj_consume_token(LESS_EQUAL);
    jj_consume_token(GREATER_EQUAL);
    jj_consume_token(LESS_GREATER);
  }

  private boolean jj_2_1(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_1(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  private boolean jj_2_2(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_2(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  private boolean jj_2_3(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_3(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  private boolean jj_2_4(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_4(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(3, xla); }
  }

  private boolean jj_2_5(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_5(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(4, xla); }
  }

  private boolean jj_2_6(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_6(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(5, xla); }
  }

  private boolean jj_2_7(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_7(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(6, xla); }
  }

  private boolean jj_3R_12() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(20)) jj_scanpos = xsp;
    if (jj_3R_5()) return true;
    return false;
  }

  private boolean jj_3_7() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_6()) return true;
    return false;
  }

  private boolean jj_3R_17() {
    if (jj_3R_4()) return true;
    return false;
  }

  private boolean jj_3_3() {
    if (jj_scan_token(EQUAL)) return true;
    return false;
  }

  private boolean jj_3_5() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(20)) jj_scanpos = xsp;
    if (jj_3R_4()) return true;
    return false;
  }

  private boolean jj_3R_14() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_6()) return true;
    return false;
  }

  private boolean jj_3R_5() {
    if (jj_3R_11()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_12()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_18() {
    if (jj_scan_token(EQUAL)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(26)) jj_scanpos = xsp;
    if (jj_scan_token(INT)) return true;
    return false;
  }

  private boolean jj_3R_9() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(3)) jj_scanpos = xsp;
    if (jj_scan_token(STRING)) return true;
    return false;
  }

  private boolean jj_3R_10() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(20)) jj_scanpos = xsp;
    if (jj_3R_4()) return true;
    return false;
  }

  private boolean jj_3_4() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_3()) return true;
    return false;
  }

  private boolean jj_3R_6() {
    if (jj_3R_13()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_14()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_16() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(1)) {
    jj_scanpos = xsp;
    if (jj_scan_token(27)) {
    jj_scanpos = xsp;
    if (jj_scan_token(9)) {
    jj_scanpos = xsp;
    if (jj_scan_token(18)) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_4() {
    if (jj_3R_9()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_10()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_8() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_3()) return true;
    return false;
  }

  private boolean jj_3R_15() {
    if (jj_scan_token(INT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_18()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_1() {
    if (jj_scan_token(ASTERISK)) return true;
    return false;
  }

  private boolean jj_3_6() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(20)) jj_scanpos = xsp;
    if (jj_3R_5()) return true;
    return false;
  }

  private boolean jj_3R_13() {
    if (jj_scan_token(OPEN_CURLY_BRACE)) return true;
    if (jj_3R_17()) return true;
    if (jj_scan_token(CLOSE_CURLY_BRACE)) return true;
    return false;
  }

  private boolean jj_3R_3() {
    if (jj_3R_7()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_8()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_2() {
    if (jj_scan_token(OPEN_CURLY_BRACE)) return true;
    if (jj_scan_token(AMPERSAND)) return true;
    return false;
  }

  private boolean jj_3_2() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_2()) {
    jj_scanpos = xsp;
    if (jj_scan_token(3)) return true;
    }
    return false;
  }

  private boolean jj_3R_7() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_15()) {
    jj_scanpos = xsp;
    if (jj_3R_16()) return true;
    }
    return false;
  }

  private boolean jj_3R_11() {
    if (jj_scan_token(AMPERSAND)) return true;
    if (jj_scan_token(STRING)) return true;
    return false;
  }

  /** User defined Token Manager. */
  public TokenManager token_source;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  private int jj_gen;
  final private int[] jj_la1 = new int[28];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static {
      jj_la1_init_0();
      jj_la1_init_1();
   }
   private static void jj_la1_init_0() {
      jj_la1_0 = new int[] {0x60000800,0x1044002c,0x1044000c,0x10000000,0x440004,0x2a0230,0x180,0x180,0x30,0x400,0x1f800,0x1f800,0x2a0200,0x800000,0x800000,0x1000000,0x4000000,0x8040202,0x8040602,0x8,0x100000,0x100000,0x0,0x100000,0x0,0x40004,0x100000,0xc,};
   }
   private static void jj_la1_init_1() {
      jj_la1_1 = new int[] {0x3,0x64,0x60,0x20,0x40,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3,0x0,0x10,0x0,0x0,0x0,};
   }
  final private JJCalls[] jj_2_rtns = new JJCalls[7];
  private boolean jj_rescan = false;
  private int jj_gc = 0;


  /** Constructor with user supplied Token Manager. */
  public PKGParserCore(TokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 28; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(TokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 28; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen) c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  static private final class LookaheadSuccess extends java.lang.Error { }
  final private LookaheadSuccess jj_ls = new LookaheadSuccess();
  private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 0; Token tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    if (jj_scanpos.kind != kind) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
    return false;
  }


/** Get the next Token. */
  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.List jj_expentries = new java.util.ArrayList();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
    if (pos >= 100) return;
    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      jj_expentry = new int[jj_endpos];
      for (int i = 0; i < jj_endpos; i++) {
        jj_expentry[i] = jj_lasttokens[i];
      }
      jj_entries_loop: for (java.util.Iterator it = jj_expentries.iterator(); it.hasNext();) {
        int[] oldentry = (int[])(it.next());
        if (oldentry.length == jj_expentry.length) {
          for (int i = 0; i < jj_expentry.length; i++) {
            if (oldentry[i] != jj_expentry[i]) {
              continue jj_entries_loop;
            }
          }
          jj_expentries.add(jj_expentry);
          break jj_entries_loop;
        }
      }
      if (pos != 0) jj_lasttokens[(jj_endpos = pos) - 1] = kind;
    }
  }

  /** Generate ParseException. */
  public ParseException generateParseException() {
    jj_expentries.clear();
    boolean[] la1tokens = new boolean[40];
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 28; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 40; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.add(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = (int[])jj_expentries.get(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

  private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 7; i++) {
    try {
      JJCalls p = jj_2_rtns[i];
      do {
        if (p.gen > jj_gen) {
          jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
          switch (i) {
            case 0: jj_3_1(); break;
            case 1: jj_3_2(); break;
            case 2: jj_3_3(); break;
            case 3: jj_3_4(); break;
            case 4: jj_3_5(); break;
            case 5: jj_3_6(); break;
            case 6: jj_3_7(); break;
          }
        }
        p = p.next;
      } while (p != null);
      } catch(LookaheadSuccess ls) { }
    }
    jj_rescan = false;
  }

  private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJCalls(); break; }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; p.first = token; p.arg = xla;
  }

  static final class JJCalls {
    int gen;
    Token first;
    int arg;
    JJCalls next;
  }

}
