/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.svg;

import org.apache.batik.dom.svg.AbstractSVGItem;
import org.apache.batik.dom.svg.AbstractSVGList;
import org.apache.batik.dom.svg.ListHandler;
import org.apache.batik.dom.svg.SVGItem;
import org.apache.batik.dom.svg.SVGPathSegConstants;
import org.apache.batik.parser.DefaultPathHandler;
import org.apache.batik.parser.ParseException;
import org.apache.batik.parser.PathHandler;
import org.apache.batik.parser.PathParser;
import org.w3c.dom.DOMException;
import org.w3c.dom.svg.SVGException;
import org.w3c.dom.svg.SVGPathSeg;
import org.w3c.dom.svg.SVGPathSegArcAbs;
import org.w3c.dom.svg.SVGPathSegArcRel;
import org.w3c.dom.svg.SVGPathSegClosePath;
import org.w3c.dom.svg.SVGPathSegCurvetoCubicAbs;
import org.w3c.dom.svg.SVGPathSegCurvetoCubicRel;
import org.w3c.dom.svg.SVGPathSegCurvetoCubicSmoothAbs;
import org.w3c.dom.svg.SVGPathSegCurvetoCubicSmoothRel;
import org.w3c.dom.svg.SVGPathSegCurvetoQuadraticAbs;
import org.w3c.dom.svg.SVGPathSegCurvetoQuadraticRel;
import org.w3c.dom.svg.SVGPathSegCurvetoQuadraticSmoothAbs;
import org.w3c.dom.svg.SVGPathSegCurvetoQuadraticSmoothRel;
import org.w3c.dom.svg.SVGPathSegLinetoAbs;
import org.w3c.dom.svg.SVGPathSegLinetoHorizontalAbs;
import org.w3c.dom.svg.SVGPathSegLinetoHorizontalRel;
import org.w3c.dom.svg.SVGPathSegLinetoRel;
import org.w3c.dom.svg.SVGPathSegLinetoVerticalAbs;
import org.w3c.dom.svg.SVGPathSegLinetoVerticalRel;
import org.w3c.dom.svg.SVGPathSegList;
import org.w3c.dom.svg.SVGPathSegMovetoAbs;
import org.w3c.dom.svg.SVGPathSegMovetoRel;

public abstract class AbstractSVGPathSegList
extends AbstractSVGList
implements SVGPathSegList,
SVGPathSegConstants {
    public static final String SVG_PATHSEG_LIST_SEPARATOR = " ";

    protected AbstractSVGPathSegList() {
    }

    protected String getItemSeparator() {
        return SVG_PATHSEG_LIST_SEPARATOR;
    }

    protected abstract SVGException createSVGException(short var1, String var2, Object[] var3);

    public SVGPathSeg initialize(SVGPathSeg sVGPathSeg) throws DOMException, SVGException {
        return (SVGPathSeg)this.initializeImpl(sVGPathSeg);
    }

    public SVGPathSeg getItem(int n) throws DOMException {
        return (SVGPathSeg)this.getItemImpl(n);
    }

    public SVGPathSeg insertItemBefore(SVGPathSeg sVGPathSeg, int n) throws DOMException, SVGException {
        return (SVGPathSeg)this.insertItemBeforeImpl(sVGPathSeg, n);
    }

    public SVGPathSeg replaceItem(SVGPathSeg sVGPathSeg, int n) throws DOMException, SVGException {
        return (SVGPathSeg)this.replaceItemImpl(sVGPathSeg, n);
    }

    public SVGPathSeg removeItem(int n) throws DOMException {
        return (SVGPathSeg)this.removeItemImpl(n);
    }

    public SVGPathSeg appendItem(SVGPathSeg sVGPathSeg) throws DOMException, SVGException {
        return (SVGPathSeg)this.appendItemImpl(sVGPathSeg);
    }

    protected SVGItem createSVGItem(Object object) {
        SVGPathSeg sVGPathSeg = (SVGPathSeg)object;
        return this.createPathSegItem(sVGPathSeg);
    }

    protected void doParse(String string, ListHandler listHandler) throws ParseException {
        PathParser pathParser = new PathParser();
        PathSegListBuilder pathSegListBuilder = new PathSegListBuilder(listHandler);
        pathParser.setPathHandler((PathHandler)pathSegListBuilder);
        pathParser.parse(string);
    }

    protected void checkItemType(Object object) {
        if (!(object instanceof SVGPathSeg)) {
            this.createSVGException((short)0, "expected SVGPathSeg", null);
        }
    }

    protected SVGPathSegItem createPathSegItem(SVGPathSeg sVGPathSeg) {
        SVGPathSegItem sVGPathSegItem = null;
        short s = sVGPathSeg.getPathSegType();
        switch (s) {
            case 10: 
            case 11: {
                sVGPathSegItem = new SVGPathSegArcItem(sVGPathSeg);
                break;
            }
            case 1: {
                sVGPathSegItem = new SVGPathSegItem(sVGPathSeg);
                break;
            }
            case 6: 
            case 7: {
                sVGPathSegItem = new SVGPathSegCurvetoCubicItem(sVGPathSeg);
                break;
            }
            case 16: 
            case 17: {
                sVGPathSegItem = new SVGPathSegCurvetoCubicSmoothItem(sVGPathSeg);
                break;
            }
            case 8: 
            case 9: {
                sVGPathSegItem = new SVGPathSegCurvetoQuadraticItem(sVGPathSeg);
                break;
            }
            case 18: 
            case 19: {
                sVGPathSegItem = new SVGPathSegCurvetoQuadraticSmoothItem(sVGPathSeg);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                sVGPathSegItem = new SVGPathSegMovetoLinetoItem(sVGPathSeg);
                break;
            }
            case 12: 
            case 13: {
                sVGPathSegItem = new SVGPathSegLinetoHorizontalItem(sVGPathSeg);
                break;
            }
            case 14: 
            case 15: {
                sVGPathSegItem = new SVGPathSegLinetoVerticalItem(sVGPathSeg);
                break;
            }
        }
        return sVGPathSegItem;
    }

    protected class PathSegListBuilder
    extends DefaultPathHandler {
        protected ListHandler listHandler;

        public PathSegListBuilder(ListHandler listHandler) {
            this.listHandler = listHandler;
        }

        public void startPath() throws ParseException {
            this.listHandler.startList();
        }

        public void endPath() throws ParseException {
            this.listHandler.endList();
        }

        public void movetoRel(float f, float f2) throws ParseException {
            this.listHandler.item(new SVGPathSegMovetoLinetoItem(3, "m", f, f2));
        }

        public void movetoAbs(float f, float f2) throws ParseException {
            this.listHandler.item(new SVGPathSegMovetoLinetoItem(2, "M", f, f2));
        }

        public void closePath() throws ParseException {
            this.listHandler.item(new SVGPathSegItem(1, "z"));
        }

        public void linetoRel(float f, float f2) throws ParseException {
            this.listHandler.item(new SVGPathSegMovetoLinetoItem(5, "l", f, f2));
        }

        public void linetoAbs(float f, float f2) throws ParseException {
            this.listHandler.item(new SVGPathSegMovetoLinetoItem(4, "L", f, f2));
        }

        public void linetoHorizontalRel(float f) throws ParseException {
            this.listHandler.item(new SVGPathSegLinetoHorizontalItem(13, "h", f));
        }

        public void linetoHorizontalAbs(float f) throws ParseException {
            this.listHandler.item(new SVGPathSegLinetoHorizontalItem(12, "H", f));
        }

        public void linetoVerticalRel(float f) throws ParseException {
            this.listHandler.item(new SVGPathSegLinetoVerticalItem(15, "v", f));
        }

        public void linetoVerticalAbs(float f) throws ParseException {
            this.listHandler.item(new SVGPathSegLinetoVerticalItem(14, "V", f));
        }

        public void curvetoCubicRel(float f, float f2, float f3, float f4, float f5, float f6) throws ParseException {
            this.listHandler.item(new SVGPathSegCurvetoCubicItem(7, "c", f, f2, f3, f4, f5, f6));
        }

        public void curvetoCubicAbs(float f, float f2, float f3, float f4, float f5, float f6) throws ParseException {
            this.listHandler.item(new SVGPathSegCurvetoCubicItem(6, "C", f, f2, f3, f4, f5, f6));
        }

        public void curvetoCubicSmoothRel(float f, float f2, float f3, float f4) throws ParseException {
            this.listHandler.item(new SVGPathSegCurvetoCubicSmoothItem(17, "s", f, f2, f3, f4));
        }

        public void curvetoCubicSmoothAbs(float f, float f2, float f3, float f4) throws ParseException {
            this.listHandler.item(new SVGPathSegCurvetoCubicSmoothItem(16, "S", f, f2, f3, f4));
        }

        public void curvetoQuadraticRel(float f, float f2, float f3, float f4) throws ParseException {
            this.listHandler.item(new SVGPathSegCurvetoQuadraticItem(9, "q", f, f2, f3, f4));
        }

        public void curvetoQuadraticAbs(float f, float f2, float f3, float f4) throws ParseException {
            this.listHandler.item(new SVGPathSegCurvetoQuadraticItem(8, "Q", f, f2, f3, f4));
        }

        public void curvetoQuadraticSmoothRel(float f, float f2) throws ParseException {
            this.listHandler.item(new SVGPathSegCurvetoQuadraticSmoothItem(19, "t", f, f2));
        }

        public void curvetoQuadraticSmoothAbs(float f, float f2) throws ParseException {
            this.listHandler.item(new SVGPathSegCurvetoQuadraticSmoothItem(18, "T", f, f2));
        }

        public void arcRel(float f, float f2, float f3, boolean bl, boolean bl2, float f4, float f5) throws ParseException {
            this.listHandler.item(new SVGPathSegArcItem(11, "a", f, f2, f3, bl, bl2, f4, f5));
        }

        public void arcAbs(float f, float f2, float f3, boolean bl, boolean bl2, float f4, float f5) throws ParseException {
            this.listHandler.item(new SVGPathSegArcItem(10, "A", f, f2, f3, bl, bl2, f4, f5));
        }
    }

    public class SVGPathSegCurvetoQuadraticSmoothItem
    extends SVGPathSegItem
    implements SVGPathSegCurvetoQuadraticSmoothAbs,
    SVGPathSegCurvetoQuadraticSmoothRel {
        public SVGPathSegCurvetoQuadraticSmoothItem(short s, String string, float f, float f2) {
            super(s, string);
            this.x = f;
            this.y = f2;
        }

        public SVGPathSegCurvetoQuadraticSmoothItem(SVGPathSeg sVGPathSeg) {
            this.type = sVGPathSeg.getPathSegType();
            switch (this.type) {
                case 18: {
                    this.letter = "T";
                    this.x = ((SVGPathSegCurvetoQuadraticSmoothAbs)sVGPathSeg).getX();
                    this.y = ((SVGPathSegCurvetoQuadraticSmoothAbs)sVGPathSeg).getY();
                    break;
                }
                case 19: {
                    this.letter = "t";
                    this.x = ((SVGPathSegCurvetoQuadraticSmoothRel)sVGPathSeg).getX();
                    this.y = ((SVGPathSegCurvetoQuadraticSmoothRel)sVGPathSeg).getY();
                    break;
                }
            }
        }

        public float getX() {
            return this.x;
        }

        public float getY() {
            return this.y;
        }

        public void setX(float f) {
            this.x = f;
            this.resetAttribute();
        }

        public void setY(float f) {
            this.y = f;
            this.resetAttribute();
        }

        protected String getStringValue() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.letter);
            stringBuffer.append(' ');
            stringBuffer.append(Float.toString(this.x));
            stringBuffer.append(' ');
            stringBuffer.append(Float.toString(this.y));
            return stringBuffer.toString();
        }
    }

    public class SVGPathSegCurvetoCubicSmoothItem
    extends SVGPathSegItem
    implements SVGPathSegCurvetoCubicSmoothAbs,
    SVGPathSegCurvetoCubicSmoothRel {
        public SVGPathSegCurvetoCubicSmoothItem(short s, String string, float f, float f2, float f3, float f4) {
            super(s, string);
            this.x = f3;
            this.y = f4;
            this.x2 = f;
            this.y2 = f2;
        }

        public SVGPathSegCurvetoCubicSmoothItem(SVGPathSeg sVGPathSeg) {
            this.type = sVGPathSeg.getPathSegType();
            switch (this.type) {
                case 16: {
                    this.letter = "S";
                    this.x = ((SVGPathSegCurvetoCubicSmoothAbs)sVGPathSeg).getX();
                    this.y = ((SVGPathSegCurvetoCubicSmoothAbs)sVGPathSeg).getY();
                    this.x2 = ((SVGPathSegCurvetoCubicSmoothAbs)sVGPathSeg).getX2();
                    this.y2 = ((SVGPathSegCurvetoCubicSmoothAbs)sVGPathSeg).getY2();
                    break;
                }
                case 17: {
                    this.letter = "s";
                    this.x = ((SVGPathSegCurvetoCubicSmoothRel)sVGPathSeg).getX();
                    this.y = ((SVGPathSegCurvetoCubicSmoothRel)sVGPathSeg).getY();
                    this.x2 = ((SVGPathSegCurvetoCubicSmoothRel)sVGPathSeg).getX2();
                    this.y2 = ((SVGPathSegCurvetoCubicSmoothRel)sVGPathSeg).getY2();
                    break;
                }
            }
        }

        public float getX() {
            return this.x;
        }

        public float getY() {
            return this.y;
        }

        public void setX(float f) {
            this.x = f;
            this.resetAttribute();
        }

        public void setY(float f) {
            this.y = f;
            this.resetAttribute();
        }

        public float getX2() {
            return this.x2;
        }

        public float getY2() {
            return this.y2;
        }

        public void setX2(float f) {
            this.x2 = f;
            this.resetAttribute();
        }

        public void setY2(float f) {
            this.y2 = f;
            this.resetAttribute();
        }

        protected String getStringValue() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.letter);
            stringBuffer.append(' ');
            stringBuffer.append(Float.toString(this.x2));
            stringBuffer.append(' ');
            stringBuffer.append(Float.toString(this.y2));
            stringBuffer.append(' ');
            stringBuffer.append(Float.toString(this.x));
            stringBuffer.append(' ');
            stringBuffer.append(Float.toString(this.y));
            return stringBuffer.toString();
        }
    }

    public class SVGPathSegLinetoVerticalItem
    extends SVGPathSegItem
    implements SVGPathSegLinetoVerticalAbs,
    SVGPathSegLinetoVerticalRel {
        public SVGPathSegLinetoVerticalItem(short s, String string, float f) {
            super(s, string);
            this.y = f;
        }

        public SVGPathSegLinetoVerticalItem(SVGPathSeg sVGPathSeg) {
            this.type = sVGPathSeg.getPathSegType();
            switch (this.type) {
                case 14: {
                    this.letter = "V";
                    this.y = ((SVGPathSegLinetoVerticalAbs)sVGPathSeg).getY();
                    break;
                }
                case 15: {
                    this.letter = "v";
                    this.y = ((SVGPathSegLinetoVerticalRel)sVGPathSeg).getY();
                    break;
                }
            }
        }

        public float getY() {
            return this.y;
        }

        public void setY(float f) {
            this.y = f;
            this.resetAttribute();
        }

        protected String getStringValue() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.letter);
            stringBuffer.append(' ');
            stringBuffer.append(Float.toString(this.y));
            return stringBuffer.toString();
        }
    }

    public class SVGPathSegLinetoHorizontalItem
    extends SVGPathSegItem
    implements SVGPathSegLinetoHorizontalAbs,
    SVGPathSegLinetoHorizontalRel {
        public SVGPathSegLinetoHorizontalItem(short s, String string, float f) {
            super(s, string);
            this.x = f;
        }

        public SVGPathSegLinetoHorizontalItem(SVGPathSeg sVGPathSeg) {
            this.type = sVGPathSeg.getPathSegType();
            switch (this.type) {
                case 12: {
                    this.letter = "H";
                    this.x = ((SVGPathSegLinetoHorizontalAbs)sVGPathSeg).getX();
                    break;
                }
                case 13: {
                    this.letter = "h";
                    this.x = ((SVGPathSegLinetoHorizontalRel)sVGPathSeg).getX();
                    break;
                }
            }
        }

        public float getX() {
            return this.x;
        }

        public void setX(float f) {
            this.x = f;
            this.resetAttribute();
        }

        protected String getStringValue() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.letter);
            stringBuffer.append(' ');
            stringBuffer.append(Float.toString(this.x));
            return stringBuffer.toString();
        }
    }

    public class SVGPathSegArcItem
    extends SVGPathSegItem
    implements SVGPathSegArcAbs,
    SVGPathSegArcRel {
        public SVGPathSegArcItem(short s, String string, float f, float f2, float f3, boolean bl, boolean bl2, float f4, float f5) {
            super(s, string);
            this.x = f4;
            this.y = f5;
            this.r1 = f;
            this.r2 = f2;
            this.angle = f3;
            this.largeArcFlag = bl;
            this.sweepFlag = bl2;
        }

        public SVGPathSegArcItem(SVGPathSeg sVGPathSeg) {
            this.type = sVGPathSeg.getPathSegType();
            switch (this.type) {
                case 10: {
                    this.letter = "A";
                    this.x = ((SVGPathSegArcAbs)sVGPathSeg).getX();
                    this.y = ((SVGPathSegArcAbs)sVGPathSeg).getY();
                    this.r1 = ((SVGPathSegArcAbs)sVGPathSeg).getR1();
                    this.r2 = ((SVGPathSegArcAbs)sVGPathSeg).getR2();
                    this.angle = ((SVGPathSegArcAbs)sVGPathSeg).getAngle();
                    this.largeArcFlag = ((SVGPathSegArcAbs)sVGPathSeg).getLargeArcFlag();
                    this.sweepFlag = ((SVGPathSegArcAbs)sVGPathSeg).getSweepFlag();
                    break;
                }
                case 11: {
                    this.letter = "a";
                    this.x = ((SVGPathSegArcRel)sVGPathSeg).getX();
                    this.y = ((SVGPathSegArcRel)sVGPathSeg).getY();
                    this.r1 = ((SVGPathSegArcRel)sVGPathSeg).getR1();
                    this.r2 = ((SVGPathSegArcRel)sVGPathSeg).getR2();
                    this.angle = ((SVGPathSegArcRel)sVGPathSeg).getAngle();
                    this.largeArcFlag = ((SVGPathSegArcRel)sVGPathSeg).getLargeArcFlag();
                    this.sweepFlag = ((SVGPathSegArcRel)sVGPathSeg).getSweepFlag();
                    break;
                }
            }
        }

        public float getX() {
            return this.x;
        }

        public float getY() {
            return this.y;
        }

        public void setX(float f) {
            this.x = f;
            this.resetAttribute();
        }

        public void setY(float f) {
            this.y = f;
            this.resetAttribute();
        }

        public float getR1() {
            return this.r1;
        }

        public float getR2() {
            return this.r2;
        }

        public void setR1(float f) {
            this.r1 = f;
            this.resetAttribute();
        }

        public void setR2(float f) {
            this.r2 = f;
            this.resetAttribute();
        }

        public float getAngle() {
            return this.angle;
        }

        public void setAngle(float f) {
            this.angle = f;
            this.resetAttribute();
        }

        public boolean getSweepFlag() {
            return this.sweepFlag;
        }

        public void setSweepFlag(boolean bl) {
            this.sweepFlag = bl;
            this.resetAttribute();
        }

        public boolean getLargeArcFlag() {
            return this.largeArcFlag;
        }

        public void setLargeArcFlag(boolean bl) {
            this.largeArcFlag = bl;
            this.resetAttribute();
        }

        protected String getStringValue() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.letter);
            stringBuffer.append(' ');
            stringBuffer.append(Float.toString(this.r1));
            stringBuffer.append(' ');
            stringBuffer.append(Float.toString(this.r2));
            stringBuffer.append(' ');
            stringBuffer.append(Float.toString(this.angle));
            stringBuffer.append(' ');
            stringBuffer.append(this.largeArcFlag ? "1" : "0");
            stringBuffer.append(' ');
            stringBuffer.append(this.sweepFlag ? "1" : "0");
            stringBuffer.append(' ');
            stringBuffer.append(Float.toString(this.x));
            stringBuffer.append(' ');
            stringBuffer.append(Float.toString(this.y));
            return stringBuffer.toString();
        }
    }

    public class SVGPathSegCurvetoQuadraticItem
    extends SVGPathSegItem
    implements SVGPathSegCurvetoQuadraticAbs,
    SVGPathSegCurvetoQuadraticRel {
        public SVGPathSegCurvetoQuadraticItem(short s, String string, float f, float f2, float f3, float f4) {
            super(s, string);
            this.x = f3;
            this.y = f4;
            this.x1 = f;
            this.y1 = f2;
        }

        public SVGPathSegCurvetoQuadraticItem(SVGPathSeg sVGPathSeg) {
            this.type = sVGPathSeg.getPathSegType();
            switch (this.type) {
                case 8: {
                    this.letter = "Q";
                    this.x = ((SVGPathSegCurvetoQuadraticAbs)sVGPathSeg).getX();
                    this.y = ((SVGPathSegCurvetoQuadraticAbs)sVGPathSeg).getY();
                    this.x1 = ((SVGPathSegCurvetoQuadraticAbs)sVGPathSeg).getX1();
                    this.y1 = ((SVGPathSegCurvetoQuadraticAbs)sVGPathSeg).getY1();
                    break;
                }
                case 9: {
                    this.letter = "q";
                    this.x = ((SVGPathSegCurvetoQuadraticRel)sVGPathSeg).getX();
                    this.y = ((SVGPathSegCurvetoQuadraticRel)sVGPathSeg).getY();
                    this.x1 = ((SVGPathSegCurvetoQuadraticRel)sVGPathSeg).getX1();
                    this.y1 = ((SVGPathSegCurvetoQuadraticRel)sVGPathSeg).getY1();
                    break;
                }
            }
        }

        public float getX() {
            return this.x;
        }

        public float getY() {
            return this.y;
        }

        public void setX(float f) {
            this.x = f;
            this.resetAttribute();
        }

        public void setY(float f) {
            this.y = f;
            this.resetAttribute();
        }

        public float getX1() {
            return this.x1;
        }

        public float getY1() {
            return this.y1;
        }

        public void setX1(float f) {
            this.x1 = f;
            this.resetAttribute();
        }

        public void setY1(float f) {
            this.y1 = f;
            this.resetAttribute();
        }

        protected String getStringValue() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.letter);
            stringBuffer.append(' ');
            stringBuffer.append(Float.toString(this.x1));
            stringBuffer.append(' ');
            stringBuffer.append(Float.toString(this.y1));
            stringBuffer.append(' ');
            stringBuffer.append(Float.toString(this.x));
            stringBuffer.append(' ');
            stringBuffer.append(Float.toString(this.y));
            return stringBuffer.toString();
        }
    }

    public class SVGPathSegCurvetoCubicItem
    extends SVGPathSegItem
    implements SVGPathSegCurvetoCubicAbs,
    SVGPathSegCurvetoCubicRel {
        public SVGPathSegCurvetoCubicItem(short s, String string, float f, float f2, float f3, float f4, float f5, float f6) {
            super(s, string);
            this.x = f5;
            this.y = f6;
            this.x1 = f;
            this.y1 = f2;
            this.x2 = f3;
            this.y2 = f4;
        }

        public SVGPathSegCurvetoCubicItem(SVGPathSeg sVGPathSeg) {
            this.type = sVGPathSeg.getPathSegType();
            switch (this.type) {
                case 6: {
                    this.letter = "C";
                    this.x = ((SVGPathSegCurvetoCubicAbs)sVGPathSeg).getX();
                    this.y = ((SVGPathSegCurvetoCubicAbs)sVGPathSeg).getY();
                    this.x1 = ((SVGPathSegCurvetoCubicAbs)sVGPathSeg).getX1();
                    this.y1 = ((SVGPathSegCurvetoCubicAbs)sVGPathSeg).getY1();
                    this.x2 = ((SVGPathSegCurvetoCubicAbs)sVGPathSeg).getX2();
                    this.y2 = ((SVGPathSegCurvetoCubicAbs)sVGPathSeg).getY2();
                    break;
                }
                case 7: {
                    this.letter = "c";
                    this.x = ((SVGPathSegCurvetoCubicRel)sVGPathSeg).getX();
                    this.y = ((SVGPathSegCurvetoCubicRel)sVGPathSeg).getY();
                    this.x1 = ((SVGPathSegCurvetoCubicRel)sVGPathSeg).getX1();
                    this.y1 = ((SVGPathSegCurvetoCubicRel)sVGPathSeg).getY1();
                    this.x2 = ((SVGPathSegCurvetoCubicRel)sVGPathSeg).getX2();
                    this.y2 = ((SVGPathSegCurvetoCubicRel)sVGPathSeg).getY2();
                    break;
                }
            }
        }

        public float getX() {
            return this.x;
        }

        public float getY() {
            return this.y;
        }

        public void setX(float f) {
            this.x = f;
            this.resetAttribute();
        }

        public void setY(float f) {
            this.y = f;
            this.resetAttribute();
        }

        public float getX1() {
            return this.x1;
        }

        public float getY1() {
            return this.y1;
        }

        public void setX1(float f) {
            this.x1 = f;
            this.resetAttribute();
        }

        public void setY1(float f) {
            this.y1 = f;
            this.resetAttribute();
        }

        public float getX2() {
            return this.x2;
        }

        public float getY2() {
            return this.y2;
        }

        public void setX2(float f) {
            this.x2 = f;
            this.resetAttribute();
        }

        public void setY2(float f) {
            this.y2 = f;
            this.resetAttribute();
        }

        protected String getStringValue() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.letter);
            stringBuffer.append(' ');
            stringBuffer.append(Float.toString(this.x1));
            stringBuffer.append(' ');
            stringBuffer.append(Float.toString(this.y1));
            stringBuffer.append(' ');
            stringBuffer.append(Float.toString(this.x2));
            stringBuffer.append(' ');
            stringBuffer.append(Float.toString(this.y2));
            stringBuffer.append(' ');
            stringBuffer.append(Float.toString(this.x));
            stringBuffer.append(' ');
            stringBuffer.append(Float.toString(this.y));
            return stringBuffer.toString();
        }
    }

    public class SVGPathSegMovetoLinetoItem
    extends SVGPathSegItem
    implements SVGPathSegMovetoAbs,
    SVGPathSegMovetoRel,
    SVGPathSegLinetoAbs,
    SVGPathSegLinetoRel {
        public SVGPathSegMovetoLinetoItem(short s, String string, float f, float f2) {
            super(s, string);
            this.x = f;
            this.y = f2;
        }

        public SVGPathSegMovetoLinetoItem(SVGPathSeg sVGPathSeg) {
            this.type = sVGPathSeg.getPathSegType();
            switch (this.type) {
                case 5: {
                    this.letter = "l";
                    this.x = ((SVGPathSegLinetoRel)sVGPathSeg).getX();
                    this.y = ((SVGPathSegLinetoRel)sVGPathSeg).getY();
                    break;
                }
                case 4: {
                    this.letter = "L";
                    this.x = ((SVGPathSegLinetoAbs)sVGPathSeg).getX();
                    this.y = ((SVGPathSegLinetoAbs)sVGPathSeg).getY();
                    break;
                }
                case 3: {
                    this.letter = "m";
                    this.x = ((SVGPathSegMovetoRel)sVGPathSeg).getX();
                    this.y = ((SVGPathSegMovetoRel)sVGPathSeg).getY();
                    break;
                }
                case 2: {
                    this.letter = "M";
                    this.x = ((SVGPathSegMovetoAbs)sVGPathSeg).getX();
                    this.y = ((SVGPathSegMovetoAbs)sVGPathSeg).getY();
                    break;
                }
            }
        }

        public float getX() {
            return this.x;
        }

        public float getY() {
            return this.y;
        }

        public void setX(float f) {
            this.x = f;
            this.resetAttribute();
        }

        public void setY(float f) {
            this.y = f;
            this.resetAttribute();
        }

        protected String getStringValue() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.letter);
            stringBuffer.append(' ');
            stringBuffer.append(Float.toString(this.x));
            stringBuffer.append(' ');
            stringBuffer.append(Float.toString(this.y));
            return stringBuffer.toString();
        }
    }

    protected class SVGPathSegItem
    extends AbstractSVGItem
    implements SVGPathSeg,
    SVGPathSegClosePath {
        protected short type;
        protected String letter;
        protected float x;
        protected float y;
        protected float x1;
        protected float y1;
        protected float x2;
        protected float y2;
        protected float r1;
        protected float r2;
        protected float angle;
        protected boolean largeArcFlag;
        protected boolean sweepFlag;

        protected SVGPathSegItem() {
        }

        public SVGPathSegItem(short s, String string) {
            this.type = s;
            this.letter = string;
        }

        public SVGPathSegItem(SVGPathSeg sVGPathSeg) {
            this.type = sVGPathSeg.getPathSegType();
            switch (this.type) {
                case 1: {
                    this.letter = "z";
                    break;
                }
            }
        }

        protected String getStringValue() {
            return this.letter;
        }

        public short getPathSegType() {
            return this.type;
        }

        public String getPathSegTypeAsLetter() {
            return this.letter;
        }
    }
}

