/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Arguments;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.IdFunction;
import org.mozilla.javascript.IdScriptable;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeCall;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.NativeGlobal;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.UniqueTag;

public class BaseFunction
extends IdScriptable
implements Function {
    private static final int Id_length = 1;
    private static final int Id_arity = 2;
    private static final int Id_name = 3;
    private static final int Id_prototype = 4;
    private static final int Id_arguments = 5;
    private static final int MAX_INSTANCE_ID = 5;
    private static final int Id_constructor = 6;
    private static final int Id_toString = 7;
    private static final int Id_apply = 8;
    private static final int Id_call = 9;
    private static final int MAX_PROTOTYPE_ID = 9;
    protected String functionName;
    private Object prototypeProperty;
    private int prototypePropertyAttrs;
    private boolean prototypeFlag;

    public BaseFunction() {
        this.setMaxId(5);
        this.prototypePropertyAttrs = 2;
    }

    static void init(Context cx, Scriptable scope, boolean sealed) {
        BaseFunction obj = new BaseFunction();
        obj.prototypeFlag = true;
        obj.functionName = "";
        obj.prototypePropertyAttrs = 7;
        obj.addAsPrototype(9, cx, scope, sealed);
    }

    protected void fillConstructorProperties(Context cx, IdFunction ctor, boolean sealed) {
        ctor.setPrototype(this);
    }

    public String getClassName() {
        return "Function";
    }

    public boolean hasInstance(Scriptable instance) {
        Object protoProp = ScriptableObject.getProperty((Scriptable)this, "prototype");
        if (protoProp instanceof Scriptable && protoProp != Undefined.instance) {
            return ScriptRuntime.jsDelegatesTo(instance, (Scriptable)protoProp);
        }
        throw NativeGlobal.typeError1("msg.instanceof.bad.prototype", this.functionName, instance);
    }

    protected int getIdDefaultAttributes(int id) {
        switch (id) {
            case 1: 
            case 2: 
            case 3: {
                return 7;
            }
            case 4: {
                return this.prototypePropertyAttrs;
            }
            case 5: {
                return 0;
            }
        }
        return super.getIdDefaultAttributes(id);
    }

    protected boolean hasIdValue(int id) {
        if (id == 4) {
            return this.prototypeProperty != Scriptable.NOT_FOUND;
        }
        if (id == 5) {
            return null != this.getActivation(Context.getContext());
        }
        return super.hasIdValue(id);
    }

    protected Object getIdValue(int id) {
        switch (id) {
            case 1: {
                return this.wrap_int(this.getLength());
            }
            case 2: {
                return this.wrap_int(this.getArity());
            }
            case 3: {
                return this.getFunctionName();
            }
            case 4: {
                return this.getPrototypeProperty();
            }
            case 5: {
                return this.getArguments();
            }
        }
        return super.getIdValue(id);
    }

    protected void setIdValue(int id, Object value) {
        if (id == 4) {
            this.prototypeProperty = value != null ? value : UniqueTag.NULL_VALUE;
            return;
        }
        super.setIdValue(id, value);
    }

    protected void deleteIdValue(int id) {
        if (id == 4) {
            this.prototypeProperty = Scriptable.NOT_FOUND;
            return;
        }
        super.deleteIdValue(id);
    }

    public int methodArity(int methodId) {
        if (this.prototypeFlag) {
            switch (methodId) {
                case 6: {
                    return 1;
                }
                case 7: {
                    return 1;
                }
                case 8: {
                    return 2;
                }
                case 9: {
                    return 1;
                }
            }
        }
        return super.methodArity(methodId);
    }

    public Object execMethod(int methodId, IdFunction f, Context cx, Scriptable scope, Scriptable thisObj, Object[] args) throws JavaScriptException {
        if (this.prototypeFlag) {
            switch (methodId) {
                case 6: {
                    return BaseFunction.jsConstructor(cx, scope, args);
                }
                case 7: {
                    return BaseFunction.js_toString(cx, thisObj, args);
                }
                case 8: {
                    return BaseFunction.applyOrCall(true, cx, scope, thisObj, args);
                }
                case 9: {
                    return BaseFunction.applyOrCall(false, cx, scope, thisObj, args);
                }
            }
        }
        return super.execMethod(methodId, f, cx, scope, thisObj, args);
    }

    public void setImmunePrototypeProperty(Object value) {
        this.prototypeProperty = value != null ? value : UniqueTag.NULL_VALUE;
        this.prototypePropertyAttrs = 7;
    }

    protected Scriptable getClassPrototype() {
        Object protoVal = this.getPrototypeProperty();
        if (protoVal == null || !(protoVal instanceof Scriptable) || protoVal == Undefined.instance) {
            protoVal = ScriptableObject.getClassPrototype(this, "Object");
        }
        return (Scriptable)protoVal;
    }

    public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) throws JavaScriptException {
        return Undefined.instance;
    }

    public Scriptable construct(Context cx, Scriptable scope, Object[] args) throws JavaScriptException {
        Scriptable newInstance = this.createObject(cx, scope);
        Object val = this.call(cx, scope, newInstance, args);
        if (val instanceof Scriptable && val != Undefined.instance) {
            return (Scriptable)val;
        }
        return newInstance;
    }

    public Scriptable createObject(Context cx, Scriptable scope) {
        NativeObject newInstance = new NativeObject();
        newInstance.setPrototype(this.getClassPrototype());
        newInstance.setParentScope(this.getParentScope());
        return newInstance;
    }

    public String decompile(Context cx, int indent, boolean justbody) {
        StringBuffer sb = new StringBuffer();
        if (!justbody) {
            sb.append("function ");
            sb.append(this.getFunctionName());
            sb.append("() {\n\t");
        }
        sb.append("[native code, arity=");
        sb.append(this.getArity());
        sb.append("]\n");
        if (!justbody) {
            sb.append("}\n");
        }
        return sb.toString();
    }

    public int getArity() {
        return 0;
    }

    public int getLength() {
        return 0;
    }

    public String getFunctionName() {
        if (this.functionName == null) {
            return "";
        }
        return this.functionName;
    }

    private Object getPrototypeProperty() {
        Object result = this.prototypeProperty;
        if (result == null) {
            BaseFunction baseFunction = this;
            synchronized (baseFunction) {
                result = this.prototypeProperty;
                if (result == null) {
                    this.setupDefaultPrototype();
                    result = this.prototypeProperty;
                }
            }
        } else if (result == UniqueTag.NULL_VALUE) {
            result = null;
        }
        return result;
    }

    private void setupDefaultPrototype() {
        NativeObject obj = new NativeObject();
        int attr = 7;
        obj.defineProperty("constructor", this, 7);
        this.prototypeProperty = obj;
        Scriptable proto = ScriptableObject.getObjectPrototype(this);
        if (proto != obj) {
            obj.setPrototype(proto);
        }
    }

    private Object getArguments() {
        NativeCall activation = this.getActivation(Context.getContext());
        return activation == null ? null : activation.get("arguments", (Scriptable)activation);
    }

    NativeCall getActivation(Context cx) {
        NativeCall activation = cx.currentActivation;
        while (activation != null) {
            if (activation.getFunctionObject() == this) {
                return activation;
            }
            activation = activation.caller;
        }
        return null;
    }

    private static Object jsConstructor(Context cx, Scriptable scope, Object[] args) {
        NativeFunction fn;
        int arglen = args.length;
        StringBuffer sourceBuf = new StringBuffer();
        sourceBuf.append("function (");
        int i = 0;
        while (i < arglen - 1) {
            if (i > 0) {
                sourceBuf.append(',');
            }
            sourceBuf.append(ScriptRuntime.toString(args[i]));
            ++i;
        }
        sourceBuf.append(") {");
        if (arglen != 0) {
            String funBody = ScriptRuntime.toString(args[arglen - 1]);
            sourceBuf.append(funBody);
        }
        sourceBuf.append('}');
        String source = sourceBuf.toString();
        int[] linep = new int[1];
        String filename = Context.getSourcePositionFromStack(linep);
        if (filename == null) {
            filename = "<eval'ed string>";
            linep[0] = 1;
        }
        String sourceName = ScriptRuntime.makeUrlForGeneratedScript(false, filename, linep[0]);
        Scriptable global = ScriptableObject.getTopLevelScope(scope);
        int oldOptLevel = cx.getOptimizationLevel();
        cx.setOptimizationLevel(-1);
        try {
            fn = (NativeFunction)cx.compileFunction(global, source, sourceName, 1, null);
            Object var14_13 = null;
            cx.setOptimizationLevel(oldOptLevel);
        }
        catch (Throwable throwable) {
            Object var14_14 = null;
            cx.setOptimizationLevel(oldOptLevel);
            throw throwable;
        }
        fn.fromFunctionConstructor = true;
        ScriptRuntime.setFunctionProtoAndParent(global, fn);
        return fn;
    }

    private static Object js_toString(Context cx, Scriptable thisObj, Object[] args) {
        int indent = ScriptRuntime.toInt32(args, 0);
        Object val = thisObj.getDefaultValue(ScriptRuntime.FunctionClass);
        if (val instanceof BaseFunction) {
            return ((BaseFunction)val).decompile(cx, indent, false);
        }
        throw NativeGlobal.typeError1("msg.incompat.call", "toString", thisObj);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Object applyOrCall(boolean isApply, Context cx, Scriptable scope, Scriptable thisObj, Object[] args) throws JavaScriptException {
        Object[] callArgs;
        int L = args.length;
        Object function = thisObj.getDefaultValue(ScriptRuntime.FunctionClass);
        Scriptable callThis = L == 0 || args[0] == null || args[0] == Undefined.instance ? ScriptableObject.getTopLevelScope(scope) : ScriptRuntime.toObject(cx, scope, args[0]);
        if (isApply) {
            if (L <= 1) {
                callArgs = ScriptRuntime.emptyArgs;
                return ScriptRuntime.call(cx, function, callThis, callArgs, scope);
            } else {
                Object arg1 = args[1];
                if (arg1 == null || arg1 == Undefined.instance) {
                    callArgs = ScriptRuntime.emptyArgs;
                    return ScriptRuntime.call(cx, function, callThis, callArgs, scope);
                } else {
                    if (!(arg1 instanceof NativeArray) && !(arg1 instanceof Arguments)) throw NativeGlobal.typeError0("msg.arg.isnt.array", scope);
                    callArgs = cx.getElements((Scriptable)arg1);
                }
            }
            return ScriptRuntime.call(cx, function, callThis, callArgs, scope);
        } else if (L <= 1) {
            callArgs = ScriptRuntime.emptyArgs;
            return ScriptRuntime.call(cx, function, callThis, callArgs, scope);
        } else {
            callArgs = new Object[L - 1];
            System.arraycopy(args, 1, callArgs, 0, L - 1);
        }
        return ScriptRuntime.call(cx, function, callThis, callArgs, scope);
    }

    protected String getIdName(int id) {
        switch (id) {
            case 1: {
                return "length";
            }
            case 2: {
                return "arity";
            }
            case 3: {
                return "name";
            }
            case 4: {
                return "prototype";
            }
            case 5: {
                return "arguments";
            }
        }
        if (this.prototypeFlag) {
            switch (id) {
                case 6: {
                    return "constructor";
                }
                case 7: {
                    return "toString";
                }
                case 8: {
                    return "apply";
                }
                case 9: {
                    return "call";
                }
            }
        }
        return null;
    }

    protected int mapNameToId(String s) {
        int id = 0;
        String X = null;
        switch (s.length()) {
            case 4: {
                X = "name";
                id = 3;
                break;
            }
            case 5: {
                X = "arity";
                id = 2;
                break;
            }
            case 6: {
                X = "length";
                id = 1;
                break;
            }
            case 9: {
                char c = s.charAt(0);
                if (c == 'a') {
                    X = "arguments";
                    id = 5;
                    break;
                }
                if (c != 'p') break;
                X = "prototype";
                id = 4;
            }
        }
        if (X != null && X != s && !X.equals(s)) {
            id = 0;
        }
        if (id != 0 || !this.prototypeFlag) {
            return id;
        }
        id = 0;
        X = null;
        switch (s.length()) {
            case 4: {
                X = "call";
                id = 9;
                break;
            }
            case 5: {
                X = "apply";
                id = 8;
                break;
            }
            case 8: {
                X = "toString";
                id = 7;
                break;
            }
            case 11: {
                X = "constructor";
                id = 6;
            }
        }
        if (X != null && X != s && !X.equals(s)) {
            id = 0;
        }
        return id;
    }
}

