/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.IOException;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.IRFactory;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.TokenStream;

class Parser {
    private int lastExprEndLine;
    private IRFactory nf;
    private ErrorReporter er;
    private boolean ok;
    private char[] sourceBuffer = new char[128];
    private int sourceTop;
    private int functionNumber;
    private static final int OFFSET = 4;
    private static final int SETBACK = 2;
    private static final int TOP_LEVEL_SCRIPT_OR_FUNCTION = 0;
    private static final int CONSTRUCTED_FUNCTION = 1;
    private static final int NESTED_FUNCTION = 2;
    private static final boolean printSource = false;

    public Parser(IRFactory nf) {
        this.nf = nf;
    }

    private void mustMatchToken(TokenStream ts, int toMatch, String messageId) throws IOException, JavaScriptException {
        int tt = ts.getToken();
        if (tt != toMatch) {
            this.reportError(ts, messageId);
            ts.ungetToken(tt);
        }
    }

    private void reportError(TokenStream ts, String messageId) throws JavaScriptException {
        this.ok = false;
        ts.reportSyntaxError(messageId, null);
        throw new JavaScriptException((Object)messageId);
    }

    public Object parse(TokenStream ts) throws IOException {
        this.ok = true;
        this.sourceTop = 0;
        this.functionNumber = 0;
        int baseLineno = ts.getLineno();
        Object tempBlock = this.nf.createLeaf(133);
        this.sourceAdd('\u0092');
        while (true) {
            ts.flags |= 0x10;
            int tt = ts.getToken();
            ts.flags &= ~16;
            if (tt <= 0) break;
            if (tt == 110) {
                try {
                    this.nf.addChildToBack(tempBlock, this.function(ts, false));
                    continue;
                }
                catch (JavaScriptException e) {
                    this.ok = false;
                    break;
                }
            }
            ts.ungetToken(tt);
            this.nf.addChildToBack(tempBlock, this.statement(ts));
        }
        if (!this.ok) {
            return null;
        }
        String source = this.sourceToString(0);
        this.sourceBuffer = null;
        Object pn = this.nf.createScript(tempBlock, ts.getSourceName(), baseLineno, ts.getLineno(), source);
        return pn;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object parseFunctionBody(TokenStream ts) throws IOException {
        int oldflags = ts.flags;
        ts.flags &= 0xFFFFFFF3;
        ts.flags |= 2;
        Object pn = this.nf.createBlock(ts.getLineno());
        try {
            try {
                int tt;
                while ((tt = ts.peekToken()) > 0 && tt != 93) {
                    void var4_4;
                    if (var4_4 == 110) {
                        ts.getToken();
                        this.nf.addChildToBack(pn, this.function(ts, false));
                        continue;
                    }
                    this.nf.addChildToBack(pn, this.statement(ts));
                }
            }
            catch (JavaScriptException e) {
                this.ok = false;
                Object var6_7 = null;
                ts.flags = oldflags;
                return pn;
            }
            Object var6_6 = null;
            ts.flags = oldflags;
            return pn;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            ts.flags = oldflags;
            throw throwable;
        }
    }

    private Object function(TokenStream ts, boolean isExpr) throws IOException, JavaScriptException {
        String source;
        Object body;
        Object args;
        String name;
        int baseLineno = ts.getLineno();
        Object memberExprNode = null;
        if (ts.matchToken(44)) {
            name = ts.getString();
            if (!ts.matchToken(94)) {
                if (Context.getContext().hasFeature(2)) {
                    this.sourceAddString(44, name);
                    Object memberExprHead = this.nf.createName(name);
                    name = null;
                    memberExprNode = this.memberExprTail(ts, false, memberExprHead);
                }
                this.mustMatchToken(ts, 94, "msg.no.paren.parms");
            }
        } else if (ts.matchToken(94)) {
            name = null;
        } else {
            name = null;
            if (Context.getContext().hasFeature(2)) {
                memberExprNode = this.memberExpr(ts, false);
            }
            this.mustMatchToken(ts, 94, "msg.no.paren.parms");
        }
        if (memberExprNode != null) {
            this.sourceAdd('a');
            this.sourceAdd('\u0080');
        }
        this.sourceAdd('n');
        this.sourceAdd((char)this.functionNumber);
        ++this.functionNumber;
        int savedSourceTop = this.sourceTop;
        int savedFunctionNumber = this.functionNumber;
        try {
            this.functionNumber = 0;
            this.sourceAdd('n');
            if (name != null) {
                this.sourceAddString(44, name);
            }
            this.sourceAdd('^');
            args = this.nf.createLeaf(94);
            if (!ts.matchToken(95)) {
                boolean first = true;
                do {
                    if (!first) {
                        this.sourceAdd('`');
                    }
                    first = false;
                    this.mustMatchToken(ts, 44, "msg.no.parm");
                    String s = ts.getString();
                    this.nf.addChildToBack(args, this.nf.createName(s));
                    this.sourceAddString(44, s);
                } while (ts.matchToken(96));
                this.mustMatchToken(ts, 95, "msg.no.paren.after.parms");
            }
            this.sourceAdd('_');
            this.mustMatchToken(ts, 92, "msg.no.brace.body");
            this.sourceAdd('\\');
            this.sourceAdd('\u0001');
            body = this.parseFunctionBody(ts);
            this.mustMatchToken(ts, 93, "msg.no.brace.after.body");
            this.sourceAdd(']');
            source = this.sourceToString(savedSourceTop);
            Object var14_15 = null;
            this.sourceTop = savedSourceTop;
            this.functionNumber = savedFunctionNumber;
        }
        catch (Throwable throwable) {
            Object var14_16 = null;
            this.sourceTop = savedSourceTop;
            this.functionNumber = savedFunctionNumber;
            throw throwable;
        }
        Object pn = this.nf.createFunction(name, args, body, ts.getSourceName(), baseLineno, ts.getLineno(), source, isExpr || memberExprNode != null);
        if (memberExprNode != null) {
            pn = this.nf.createBinary(97, 128, memberExprNode, pn);
        }
        if (!isExpr) {
            if (memberExprNode != null) {
                this.sourceAdd('Y');
            }
            this.sourceAdd('\u0001');
            this.wellTerminated(ts, 110);
        }
        return pn;
    }

    private Object statements(TokenStream ts) throws IOException {
        int tt;
        Object pn = this.nf.createBlock(ts.getLineno());
        while ((tt = ts.peekToken()) > 0 && tt != 93) {
            this.nf.addChildToBack(pn, this.statement(ts));
        }
        return pn;
    }

    private Object condition(TokenStream ts) throws IOException, JavaScriptException {
        this.mustMatchToken(ts, 94, "msg.no.paren.cond");
        this.sourceAdd('^');
        Object pn = this.expr(ts, false);
        this.mustMatchToken(ts, 95, "msg.no.paren.after.cond");
        this.sourceAdd('_');
        return pn;
    }

    private boolean wellTerminated(TokenStream ts, int lastExprType) throws IOException, JavaScriptException {
        int tt = ts.peekTokenSameLine();
        if (tt == -1) {
            return false;
        }
        if (tt != 0 && tt != 1 && tt != 89 && tt != 93) {
            int version = Context.getContext().getLanguageVersion();
            if ((tt == 110 || lastExprType == 110) && version < 120) {
                return true;
            }
            this.reportError(ts, "msg.no.semi.stmt");
        }
        return true;
    }

    private String matchLabel(TokenStream ts) throws IOException, JavaScriptException {
        int lineno = ts.getLineno();
        String label = null;
        int tt = ts.peekTokenSameLine();
        if (tt == 44) {
            ts.getToken();
            label = ts.getString();
        }
        if (lineno == ts.getLineno()) {
            this.wellTerminated(ts, -1);
        }
        return label;
    }

    private Object statement(TokenStream ts) throws IOException {
        try {
            return this.statementHelper(ts);
        }
        catch (JavaScriptException e) {
            int t;
            int lineno = ts.getLineno();
            while ((t = ts.getToken()) != 89 && t != 1 && t != 0 && t != -1) {
            }
            return this.nf.createExprStatement(this.nf.createName("error"), lineno);
        }
    }

    private Object statementHelper(TokenStream ts) throws IOException, JavaScriptException {
        Object pn = null;
        boolean skipsemi = false;
        int lastExprType = 0;
        int tt = ts.getToken();
        switch (tt) {
            case 113: {
                skipsemi = true;
                this.sourceAdd('q');
                int lineno = ts.getLineno();
                Object cond = this.condition(ts);
                this.sourceAdd('\\');
                this.sourceAdd('\u0001');
                Object ifTrue = this.statement(ts);
                Object ifFalse = null;
                if (ts.matchToken(114)) {
                    this.sourceAdd(']');
                    this.sourceAdd('r');
                    this.sourceAdd('\\');
                    this.sourceAdd('\u0001');
                    ifFalse = this.statement(ts);
                }
                this.sourceAdd(']');
                this.sourceAdd('\u0001');
                pn = this.nf.createIf(cond, ifTrue, ifFalse, lineno);
                break;
            }
            case 115: {
                skipsemi = true;
                this.sourceAdd('s');
                pn = this.nf.createSwitch(ts.getLineno());
                Object cur_case = null;
                this.mustMatchToken(ts, 94, "msg.no.paren.switch");
                this.sourceAdd('^');
                this.nf.addChildToBack(pn, this.expr(ts, false));
                this.mustMatchToken(ts, 95, "msg.no.paren.after.switch");
                this.sourceAdd('_');
                this.mustMatchToken(ts, 92, "msg.no.brace.switch");
                this.sourceAdd('\\');
                this.sourceAdd('\u0001');
                while ((tt = ts.getToken()) != 93 && tt != 0) {
                    switch (tt) {
                        case 116: {
                            this.sourceAdd('t');
                            cur_case = this.nf.createUnary(116, this.expr(ts, false));
                            this.sourceAdd('c');
                            this.sourceAdd('\u0001');
                            break;
                        }
                        case 117: {
                            cur_case = this.nf.createLeaf(117);
                            this.sourceAdd('u');
                            this.sourceAdd('c');
                            this.sourceAdd('\u0001');
                            break;
                        }
                        default: {
                            this.reportError(ts, "msg.bad.switch");
                        }
                    }
                    this.mustMatchToken(ts, 99, "msg.no.colon.case");
                    Object case_statements = this.nf.createLeaf(133);
                    while ((tt = ts.peekToken()) != 93 && tt != 116 && tt != 117 && tt != 0) {
                        this.nf.addChildToBack(case_statements, this.statement(ts));
                    }
                    this.nf.addChildToBack(cur_case, case_statements);
                    this.nf.addChildToBack(pn, cur_case);
                }
                this.sourceAdd(']');
                this.sourceAdd('\u0001');
                break;
            }
            case 118: {
                skipsemi = true;
                this.sourceAdd('v');
                int lineno = ts.getLineno();
                Object cond = this.condition(ts);
                this.sourceAdd('\\');
                this.sourceAdd('\u0001');
                Object body = this.statement(ts);
                this.sourceAdd(']');
                this.sourceAdd('\u0001');
                pn = this.nf.createWhile(cond, body, lineno);
                break;
            }
            case 119: {
                this.sourceAdd('w');
                this.sourceAdd('\\');
                this.sourceAdd('\u0001');
                int lineno = ts.getLineno();
                Object body = this.statement(ts);
                this.sourceAdd(']');
                this.mustMatchToken(ts, 118, "msg.no.while.do");
                this.sourceAdd('v');
                Object cond = this.condition(ts);
                pn = this.nf.createDoWhile(body, cond, lineno);
                break;
            }
            case 120: {
                Object cond;
                Object init;
                skipsemi = true;
                this.sourceAdd('x');
                int lineno = ts.getLineno();
                Object incr = null;
                this.mustMatchToken(ts, 94, "msg.no.paren.for");
                this.sourceAdd('^');
                tt = ts.peekToken();
                if (tt == 89) {
                    init = this.nf.createLeaf(132);
                } else if (tt == 123) {
                    ts.getToken();
                    init = this.variables(ts, true);
                } else {
                    init = this.expr(ts, true);
                }
                tt = ts.peekToken();
                if (tt == 103 && ts.getOp() == 63) {
                    ts.matchToken(103);
                    this.sourceAdd('?');
                    cond = this.expr(ts, false);
                } else {
                    this.mustMatchToken(ts, 89, "msg.no.semi.for");
                    this.sourceAdd('Y');
                    cond = ts.peekToken() == 89 ? this.nf.createLeaf(132) : this.expr(ts, false);
                    this.mustMatchToken(ts, 89, "msg.no.semi.for.cond");
                    this.sourceAdd('Y');
                    incr = ts.peekToken() == 95 ? this.nf.createLeaf(132) : this.expr(ts, false);
                }
                this.mustMatchToken(ts, 95, "msg.no.paren.for.ctrl");
                this.sourceAdd('_');
                this.sourceAdd('\\');
                this.sourceAdd('\u0001');
                Object body = this.statement(ts);
                this.sourceAdd(']');
                this.sourceAdd('\u0001');
                if (incr == null) {
                    pn = this.nf.createForIn(init, cond, body, lineno);
                    break;
                }
                pn = this.nf.createFor(init, cond, incr, body, lineno);
                break;
            }
            case 75: {
                int lineno = ts.getLineno();
                Object catchblocks = null;
                Object finallyblock = null;
                skipsemi = true;
                this.sourceAdd('K');
                this.sourceAdd('\\');
                this.sourceAdd('\u0001');
                Object tryblock = this.statement(ts);
                this.sourceAdd(']');
                this.sourceAdd('\u0001');
                catchblocks = this.nf.createLeaf(133);
                boolean sawDefaultCatch = false;
                int peek = ts.peekToken();
                if (peek == 125) {
                    while (ts.matchToken(125)) {
                        if (sawDefaultCatch) {
                            this.reportError(ts, "msg.catch.unreachable");
                        }
                        this.sourceAdd('}');
                        this.mustMatchToken(ts, 94, "msg.no.paren.catch");
                        this.sourceAdd('^');
                        this.mustMatchToken(ts, 44, "msg.bad.catchcond");
                        String varName = ts.getString();
                        this.sourceAddString(44, varName);
                        Object catchCond = null;
                        if (ts.matchToken(113)) {
                            this.sourceAdd('q');
                            catchCond = this.expr(ts, false);
                        } else {
                            sawDefaultCatch = true;
                        }
                        this.mustMatchToken(ts, 95, "msg.bad.catchcond");
                        this.sourceAdd('_');
                        this.mustMatchToken(ts, 92, "msg.no.brace.catchblock");
                        this.sourceAdd('\\');
                        this.sourceAdd('\u0001');
                        this.nf.addChildToBack(catchblocks, this.nf.createCatch(varName, catchCond, this.statements(ts), ts.getLineno()));
                        this.mustMatchToken(ts, 93, "msg.no.brace.after.body");
                        this.sourceAdd(']');
                        this.sourceAdd('\u0001');
                    }
                } else if (peek != 126) {
                    this.mustMatchToken(ts, 126, "msg.try.no.catchfinally");
                }
                if (ts.matchToken(126)) {
                    this.sourceAdd('~');
                    this.sourceAdd('\\');
                    this.sourceAdd('\u0001');
                    finallyblock = this.statement(ts);
                    this.sourceAdd(']');
                    this.sourceAdd('\u0001');
                }
                pn = this.nf.createTryCatchFinally(tryblock, catchblocks, finallyblock, lineno);
                break;
            }
            case 62: {
                int lineno = ts.getLineno();
                this.sourceAdd('>');
                pn = this.nf.createThrow(this.expr(ts, false), lineno);
                if (lineno != ts.getLineno()) break;
                this.wellTerminated(ts, -1);
                break;
            }
            case 121: {
                int lineno = ts.getLineno();
                this.sourceAdd('y');
                String label = this.matchLabel(ts);
                if (label != null) {
                    this.sourceAddString(44, label);
                }
                pn = this.nf.createBreak(label, lineno);
                break;
            }
            case 122: {
                int lineno = ts.getLineno();
                this.sourceAdd('z');
                String label = this.matchLabel(ts);
                if (label != null) {
                    this.sourceAddString(44, label);
                }
                pn = this.nf.createContinue(label, lineno);
                break;
            }
            case 124: {
                skipsemi = true;
                this.sourceAdd('|');
                int lineno = ts.getLineno();
                this.mustMatchToken(ts, 94, "msg.no.paren.with");
                this.sourceAdd('^');
                Object obj = this.expr(ts, false);
                this.mustMatchToken(ts, 95, "msg.no.paren.after.with");
                this.sourceAdd('_');
                this.sourceAdd('\\');
                this.sourceAdd('\u0001');
                Object body = this.statement(ts);
                this.sourceAdd(']');
                this.sourceAdd('\u0001');
                pn = this.nf.createWith(obj, body, lineno);
                break;
            }
            case 123: {
                int lineno = ts.getLineno();
                pn = this.variables(ts, false);
                if (ts.getLineno() != lineno) break;
                this.wellTerminated(ts, -1);
                break;
            }
            case 5: {
                Object retExpr = null;
                this.sourceAdd('\u0005');
                if ((ts.flags & 2) == 0) {
                    this.reportError(ts, "msg.bad.return");
                }
                ts.flags |= 0x10;
                tt = ts.peekTokenSameLine();
                ts.flags &= ~16;
                int lineno = ts.getLineno();
                if (tt != 0 && tt != 1 && tt != 89 && tt != 93) {
                    retExpr = this.expr(ts, false);
                    if (ts.getLineno() == lineno) {
                        this.wellTerminated(ts, -1);
                    }
                    ts.flags |= 4;
                } else {
                    ts.flags |= 8;
                }
                pn = this.nf.createReturn(retExpr, lineno);
                break;
            }
            case 92: {
                skipsemi = true;
                pn = this.statements(ts);
                this.mustMatchToken(ts, 93, "msg.no.brace.block");
                break;
            }
            case -1: 
            case 1: 
            case 89: {
                pn = this.nf.createLeaf(132);
                skipsemi = true;
                break;
            }
            default: {
                lastExprType = tt;
                int tokenno = ts.getTokenno();
                ts.ungetToken(tt);
                int lineno = ts.getLineno();
                pn = this.expr(ts, false);
                if (ts.peekToken() == 99) {
                    if (lastExprType != 44 || ts.getTokenno() != tokenno) {
                        this.reportError(ts, "msg.bad.label");
                    }
                    ts.getToken();
                    String name = ts.getString();
                    pn = this.nf.createLabel(name, lineno);
                    this.sourceAdd('c');
                    this.sourceAdd('\u0001');
                    return pn;
                }
                if (lastExprType == 110) {
                    if (this.nf.getLeafType(pn) != 110) {
                        this.reportError(ts, "msg.syntax");
                    }
                    this.nf.setFunctionExpressionStatement(pn);
                }
                pn = this.nf.createExprStatement(pn, lineno);
                if (ts.getLineno() != lineno && (lastExprType != 110 || ts.getLineno() != this.lastExprEndLine)) break;
                this.wellTerminated(ts, lastExprType);
                break;
            }
        }
        ts.matchToken(89);
        if (!skipsemi) {
            this.sourceAdd('Y');
            this.sourceAdd('\u0001');
        }
        return pn;
    }

    private Object variables(TokenStream ts, boolean inForInit) throws IOException, JavaScriptException {
        Object pn = this.nf.createVariables(ts.getLineno());
        boolean first = true;
        this.sourceAdd('{');
        do {
            this.mustMatchToken(ts, 44, "msg.bad.var");
            String s = ts.getString();
            if (!first) {
                this.sourceAdd('`');
            }
            first = false;
            this.sourceAddString(44, s);
            Object name = this.nf.createName(s);
            if (ts.matchToken(97)) {
                if (ts.getOp() != 128) {
                    this.reportError(ts, "msg.bad.var.init");
                }
                this.sourceAdd('a');
                this.sourceAdd('\u0080');
                Object init = this.assignExpr(ts, inForInit);
                this.nf.addChildToBack(name, init);
            }
            this.nf.addChildToBack(pn, name);
        } while (ts.matchToken(96));
        return pn;
    }

    private Object expr(TokenStream ts, boolean inForInit) throws IOException, JavaScriptException {
        Object pn = this.assignExpr(ts, inForInit);
        while (ts.matchToken(96)) {
            this.sourceAdd('`');
            pn = this.nf.createBinary(96, pn, this.assignExpr(ts, inForInit));
        }
        return pn;
    }

    private Object assignExpr(TokenStream ts, boolean inForInit) throws IOException, JavaScriptException {
        Object pn = this.condExpr(ts, inForInit);
        if (ts.matchToken(97)) {
            this.sourceAdd('a');
            this.sourceAdd((char)ts.getOp());
            pn = this.nf.createBinary(97, ts.getOp(), pn, this.assignExpr(ts, inForInit));
        }
        return pn;
    }

    private Object condExpr(TokenStream ts, boolean inForInit) throws IOException, JavaScriptException {
        Object pn = this.orExpr(ts, inForInit);
        if (ts.matchToken(98)) {
            this.sourceAdd('b');
            Object ifTrue = this.assignExpr(ts, false);
            this.mustMatchToken(ts, 99, "msg.no.colon.cond");
            this.sourceAdd('c');
            Object ifFalse = this.assignExpr(ts, inForInit);
            return this.nf.createTernary(pn, ifTrue, ifFalse);
        }
        return pn;
    }

    private Object orExpr(TokenStream ts, boolean inForInit) throws IOException, JavaScriptException {
        Object pn = this.andExpr(ts, inForInit);
        if (ts.matchToken(100)) {
            this.sourceAdd('d');
            pn = this.nf.createBinary(100, pn, this.orExpr(ts, inForInit));
        }
        return pn;
    }

    private Object andExpr(TokenStream ts, boolean inForInit) throws IOException, JavaScriptException {
        Object pn = this.bitOrExpr(ts, inForInit);
        if (ts.matchToken(101)) {
            this.sourceAdd('e');
            pn = this.nf.createBinary(101, pn, this.andExpr(ts, inForInit));
        }
        return pn;
    }

    private Object bitOrExpr(TokenStream ts, boolean inForInit) throws IOException, JavaScriptException {
        Object pn = this.bitXorExpr(ts, inForInit);
        while (ts.matchToken(11)) {
            this.sourceAdd('\u000b');
            pn = this.nf.createBinary(11, pn, this.bitXorExpr(ts, inForInit));
        }
        return pn;
    }

    private Object bitXorExpr(TokenStream ts, boolean inForInit) throws IOException, JavaScriptException {
        Object pn = this.bitAndExpr(ts, inForInit);
        while (ts.matchToken(12)) {
            this.sourceAdd('\f');
            pn = this.nf.createBinary(12, pn, this.bitAndExpr(ts, inForInit));
        }
        return pn;
    }

    private Object bitAndExpr(TokenStream ts, boolean inForInit) throws IOException, JavaScriptException {
        Object pn = this.eqExpr(ts, inForInit);
        while (ts.matchToken(13)) {
            this.sourceAdd('\r');
            pn = this.nf.createBinary(13, pn, this.eqExpr(ts, inForInit));
        }
        return pn;
    }

    private Object eqExpr(TokenStream ts, boolean inForInit) throws IOException, JavaScriptException {
        Object pn = this.relExpr(ts, inForInit);
        while (ts.matchToken(102)) {
            this.sourceAdd('f');
            this.sourceAdd((char)ts.getOp());
            pn = this.nf.createBinary(102, ts.getOp(), pn, this.relExpr(ts, inForInit));
        }
        return pn;
    }

    private Object relExpr(TokenStream ts, boolean inForInit) throws IOException, JavaScriptException {
        Object pn = this.shiftExpr(ts);
        while (ts.matchToken(103)) {
            int op = ts.getOp();
            if (inForInit && op == 63) {
                ts.ungetToken(103);
                break;
            }
            this.sourceAdd('g');
            this.sourceAdd((char)op);
            pn = this.nf.createBinary(103, op, pn, this.shiftExpr(ts));
        }
        return pn;
    }

    private Object shiftExpr(TokenStream ts) throws IOException, JavaScriptException {
        Object pn = this.addExpr(ts);
        while (ts.matchToken(104)) {
            this.sourceAdd('h');
            this.sourceAdd((char)ts.getOp());
            pn = this.nf.createBinary(ts.getOp(), pn, this.addExpr(ts));
        }
        return pn;
    }

    /*
     * WARNING - void declaration
     */
    private Object addExpr(TokenStream ts) throws IOException, JavaScriptException {
        int tt;
        Object pn = this.mulExpr(ts);
        while ((tt = ts.getToken()) == 23 || tt == 24) {
            void var2_3;
            this.sourceAdd((char)var2_3);
            pn = this.nf.createBinary((int)var2_3, pn, this.mulExpr(ts));
        }
        ts.ungetToken(tt);
        return pn;
    }

    private Object mulExpr(TokenStream ts) throws IOException, JavaScriptException {
        int tt;
        Object pn = this.unaryExpr(ts);
        while ((tt = ts.peekToken()) == 25 || tt == 26 || tt == 27) {
            tt = ts.getToken();
            this.sourceAdd((char)tt);
            pn = this.nf.createBinary(tt, pn, this.unaryExpr(ts));
        }
        return pn;
    }

    private Object unaryExpr(TokenStream ts) throws IOException, JavaScriptException {
        ts.flags |= 0x10;
        int tt = ts.getToken();
        ts.flags &= ~16;
        switch (tt) {
            case 105: {
                this.sourceAdd('i');
                this.sourceAdd((char)ts.getOp());
                return this.nf.createUnary(105, ts.getOp(), this.unaryExpr(ts));
            }
            case 23: 
            case 24: {
                this.sourceAdd('i');
                this.sourceAdd((char)tt);
                return this.nf.createUnary(105, tt, this.unaryExpr(ts));
            }
            case 106: 
            case 107: {
                this.sourceAdd((char)tt);
                return this.nf.createUnary(tt, 130, this.memberExpr(ts, true));
            }
            case 31: {
                this.sourceAdd('\u001f');
                return this.nf.createUnary(31, this.unaryExpr(ts));
            }
            case -1: {
                break;
            }
            default: {
                ts.ungetToken(tt);
                int lineno = ts.getLineno();
                Object pn = this.memberExpr(ts, true);
                int peeked = ts.peekToken();
                if ((peeked == 106 || peeked == 107) && ts.getLineno() == lineno) {
                    int pf = ts.getToken();
                    this.sourceAdd((char)pf);
                    return this.nf.createUnary(pf, 131, pn);
                }
                return pn;
            }
        }
        return this.nf.createName("err");
    }

    private Object argumentList(TokenStream ts, Object listNode) throws IOException, JavaScriptException {
        ts.flags |= 0x10;
        boolean matched = ts.matchToken(95);
        ts.flags &= ~16;
        if (!matched) {
            boolean first = true;
            do {
                if (!first) {
                    this.sourceAdd('`');
                }
                first = false;
                this.nf.addChildToBack(listNode, this.assignExpr(ts, false));
            } while (ts.matchToken(96));
            this.mustMatchToken(ts, 95, "msg.no.paren.arg");
        }
        this.sourceAdd('_');
        return listNode;
    }

    private Object memberExpr(TokenStream ts, boolean allowCallSyntax) throws IOException, JavaScriptException {
        Object pn;
        ts.flags |= 0x10;
        int tt = ts.peekToken();
        ts.flags &= ~16;
        if (tt == 30) {
            ts.getToken();
            this.sourceAdd('\u001e');
            pn = this.nf.createLeaf(30);
            this.nf.addChildToBack(pn, this.memberExpr(ts, false));
            if (ts.matchToken(94)) {
                this.sourceAdd('^');
                pn = this.argumentList(ts, pn);
            }
            if ((tt = ts.peekToken()) == 92) {
                this.nf.addChildToBack(pn, this.primaryExpr(ts));
            }
        } else {
            pn = this.primaryExpr(ts);
        }
        return this.memberExprTail(ts, allowCallSyntax, pn);
    }

    /*
     * WARNING - void declaration
     */
    private Object memberExprTail(TokenStream ts, boolean allowCallSyntax, Object pn) throws IOException, JavaScriptException {
        int tt;
        this.lastExprEndLine = ts.getLineno();
        while ((tt = ts.getToken()) > 0) {
            void var4_4;
            if (var4_4 == 108) {
                this.sourceAdd('l');
                this.mustMatchToken(ts, 44, "msg.no.name.after.dot");
                String s = ts.getString();
                this.sourceAddString(44, s);
                pn = this.nf.createBinary(108, pn, this.nf.createName(ts.getString()));
                this.lastExprEndLine = ts.getLineno();
                continue;
            }
            if (var4_4 == 90) {
                this.sourceAdd('Z');
                pn = this.nf.createBinary(90, pn, this.expr(ts, false));
                this.mustMatchToken(ts, 91, "msg.no.bracket.index");
                this.sourceAdd('[');
                this.lastExprEndLine = ts.getLineno();
                continue;
            }
            if (allowCallSyntax && var4_4 == 94) {
                pn = this.nf.createUnary(43, pn);
                this.sourceAdd('^');
                pn = this.argumentList(ts, pn);
                this.lastExprEndLine = ts.getLineno();
                continue;
            }
            ts.ungetToken((int)var4_4);
            break;
        }
        return pn;
    }

    private Object primaryExpr(TokenStream ts) throws IOException, JavaScriptException {
        ts.flags |= 0x10;
        int tt = ts.getToken();
        ts.flags &= ~16;
        switch (tt) {
            case 110: {
                return this.function(ts, true);
            }
            case 90: {
                this.sourceAdd('Z');
                Object pn = this.nf.createLeaf(134);
                ts.flags |= 0x10;
                boolean matched = ts.matchToken(91);
                ts.flags &= ~16;
                if (!matched) {
                    boolean first = true;
                    do {
                        ts.flags |= 0x10;
                        tt = ts.peekToken();
                        ts.flags &= ~16;
                        if (!first) {
                            this.sourceAdd('`');
                        } else {
                            first = false;
                        }
                        if (tt == 91) break;
                        if (tt == 96) {
                            this.nf.addChildToBack(pn, this.nf.createLeaf(109, 74));
                            continue;
                        }
                        this.nf.addChildToBack(pn, this.assignExpr(ts, false));
                    } while (ts.matchToken(96));
                    this.mustMatchToken(ts, 91, "msg.no.bracket.arg");
                }
                this.sourceAdd('[');
                return this.nf.createArrayLiteral(pn);
            }
            case 92: {
                Object pn = this.nf.createLeaf(135);
                this.sourceAdd('\\');
                if (!ts.matchToken(93)) {
                    boolean first = true;
                    block19: do {
                        Object property;
                        if (!first) {
                            this.sourceAdd('`');
                        } else {
                            first = false;
                        }
                        tt = ts.getToken();
                        switch (tt) {
                            case 44: 
                            case 46: {
                                String s = ts.getString();
                                this.sourceAddString(44, s);
                                property = this.nf.createString(ts.getString());
                                break;
                            }
                            case 45: {
                                double n = ts.getNumber();
                                this.sourceAddNumber(n);
                                property = this.nf.createNumber(n);
                                break;
                            }
                            case 93: {
                                ts.ungetToken(tt);
                                break block19;
                            }
                            default: {
                                this.reportError(ts, "msg.bad.prop");
                                break block19;
                            }
                        }
                        this.mustMatchToken(ts, 99, "msg.no.colon.prop");
                        this.sourceAdd('\u0087');
                        this.nf.addChildToBack(pn, property);
                        this.nf.addChildToBack(pn, this.assignExpr(ts, false));
                    } while (ts.matchToken(96));
                    this.mustMatchToken(ts, 93, "msg.no.brace.prop");
                }
                this.sourceAdd(']');
                return this.nf.createObjectLiteral(pn);
            }
            case 94: {
                this.sourceAdd('^');
                Object pn = this.expr(ts, false);
                this.sourceAdd('_');
                this.mustMatchToken(ts, 95, "msg.no.paren");
                return pn;
            }
            case 44: {
                String name = ts.getString();
                this.sourceAddString(44, name);
                return this.nf.createName(name);
            }
            case 45: {
                double n = ts.getNumber();
                this.sourceAddNumber(n);
                return this.nf.createNumber(n);
            }
            case 46: {
                String s = ts.getString();
                this.sourceAddString(46, s);
                return this.nf.createString(s);
            }
            case 56: {
                String flags = ts.regExpFlags;
                ts.regExpFlags = null;
                String re = ts.getString();
                this.sourceAddString(56, '/' + re + '/' + flags);
                return this.nf.createRegExp(re, flags);
            }
            case 109: {
                this.sourceAdd('m');
                this.sourceAdd((char)ts.getOp());
                return this.nf.createLeaf(109, ts.getOp());
            }
            case 127: {
                this.reportError(ts, "msg.reserved.id");
                break;
            }
            case -1: {
                break;
            }
            default: {
                this.reportError(ts, "msg.syntax");
            }
        }
        return null;
    }

    private void sourceAdd(char c) {
        if (this.sourceTop == this.sourceBuffer.length) {
            this.increaseSourceCapacity(this.sourceTop + 1);
        }
        this.sourceBuffer[this.sourceTop] = c;
        ++this.sourceTop;
    }

    private void sourceAddString(int type, String str) {
        this.sourceAdd((char)type);
        this.sourceAddString(str);
    }

    private void sourceAddString(String str) {
        int nextTop;
        int L = str.length();
        int lengthEncodingSize = 1;
        if (L >= 32768) {
            lengthEncodingSize = 2;
        }
        if ((nextTop = this.sourceTop + lengthEncodingSize + L) > this.sourceBuffer.length) {
            this.increaseSourceCapacity(nextTop);
        }
        if (L >= 32768) {
            this.sourceBuffer[this.sourceTop] = (char)(0x8000 | L >>> 16);
            ++this.sourceTop;
        }
        this.sourceBuffer[this.sourceTop] = (char)L;
        ++this.sourceTop;
        str.getChars(0, L, this.sourceBuffer, this.sourceTop);
        this.sourceTop = nextTop;
    }

    private void sourceAddNumber(double n) {
        this.sourceAdd('-');
        long lbits = (long)n;
        if ((double)lbits != n) {
            lbits = Double.doubleToLongBits(n);
            this.sourceAdd('D');
            this.sourceAdd((char)(lbits >> 48));
            this.sourceAdd((char)(lbits >> 32));
            this.sourceAdd((char)(lbits >> 16));
            this.sourceAdd((char)lbits);
        } else {
            if (lbits < 0L) {
                Context.codeBug();
            }
            if (lbits <= 65535L) {
                this.sourceAdd('S');
                this.sourceAdd((char)lbits);
            } else {
                this.sourceAdd('J');
                this.sourceAdd((char)(lbits >> 48));
                this.sourceAdd((char)(lbits >> 32));
                this.sourceAdd((char)(lbits >> 16));
                this.sourceAdd((char)lbits);
            }
        }
    }

    private void increaseSourceCapacity(int minimalCapacity) {
        int newCapacity;
        if (minimalCapacity <= this.sourceBuffer.length) {
            Context.codeBug();
        }
        if ((newCapacity = this.sourceBuffer.length * 2) < minimalCapacity) {
            newCapacity = minimalCapacity;
        }
        char[] tmp = new char[newCapacity];
        System.arraycopy(this.sourceBuffer, 0, tmp, 0, this.sourceTop);
        this.sourceBuffer = tmp;
    }

    private String sourceToString(int offset) {
        if (offset < 0 || this.sourceTop < offset) {
            Context.codeBug();
        }
        return new String(this.sourceBuffer, offset, this.sourceTop - offset);
    }

    static String decompile(Object encodedSourcesTree, boolean fromFunctionConstructor, int version, int indent, boolean justbody) {
        StringBuffer result = new StringBuffer();
        Object[] srcData = new Object[1];
        int type = fromFunctionConstructor ? 1 : 0;
        Parser.decompile_r(encodedSourcesTree, version, indent, type, justbody, srcData, result);
        return result.toString();
    }

    /*
     * Unable to fully structure code
     */
    private static void decompile_r(Object encodedSourcesTree, int version, int indent, int type, boolean justbody, Object[] srcData, StringBuffer result) {
        block140: {
            block141: {
                childNodes = null;
                if (encodedSourcesTree == null) {
                    source = null;
                } else if (encodedSourcesTree instanceof String) {
                    source = (String)encodedSourcesTree;
                } else {
                    childNodes = (Object[])encodedSourcesTree;
                    source = (String)childNodes[0];
                }
                if (source == null) {
                    return;
                }
                length = source.length();
                if (length == 0) {
                    return;
                }
                if (type != 2) {
                    if (!justbody) {
                        result.append('\n');
                    }
                    j = 0;
                    while (j < indent) {
                        result.append(' ');
                        ++j;
                    }
                }
                i = 0;
                token = source.charAt(i);
                ++i;
                if (token != 'n') break block140;
                if (justbody) break block141;
                result.append("function ");
                if (source.charAt(i) == '^' && version != 120 && type == 1) {
                    result.append("anonymous");
                }
                ** GOTO lbl479
            }
            block112: while (true) {
                token = source.charAt(i);
                ++i;
                switch (token) {
                    case '\u0001': {
                        ** GOTO lbl479
                    }
                    case ',': {
                        i = Parser.getSourceString(source, i, null);
                        continue block112;
                    }
                    case '^': 
                    case '_': 
                    case '`': {
                        continue block112;
                    }
                    default: {
                        throw new RuntimeException();
                    }
                }
                break;
            }
        }
        if (token == '\u0092') ** GOTO lbl479
        throw new RuntimeException();
lbl-1000:
        // 1 sources

        {
            switch (source.charAt(i)) {
                case ',': 
                case '8': {
                    i = Parser.getSourceString(source, i + 1, srcData);
                    result.append((String)srcData[0]);
                    continue block113;
                }
                case '-': {
                    i = Parser.getSourceNumber(source, i + 1, srcData);
                    number = ((Number)srcData[0]).doubleValue();
                    result.append(ScriptRuntime.numberToString(number, 10));
                    continue block113;
                }
                case '.': {
                    i = Parser.getSourceString(source, i + 1, srcData);
                    result.append('\"');
                    result.append(ScriptRuntime.escapeString((String)srcData[0]));
                    result.append('\"');
                    continue block113;
                }
                case 'm': {
                    switch (source.charAt(++i)) {
                        case '4': {
                            result.append("true");
                            break;
                        }
                        case '3': {
                            result.append("false");
                            break;
                        }
                        case '1': {
                            result.append("null");
                            break;
                        }
                        case '2': {
                            result.append("this");
                            break;
                        }
                        case ' ': {
                            result.append("typeof");
                            break;
                        }
                        case '\u0084': {
                            result.append("void");
                            break;
                        }
                        case 'J': {
                            result.append("undefined");
                        }
                    }
                    break;
                }
                case 'n': {
                    functionNumber = source.charAt(++i);
                    if (childNodes == null || functionNumber + '\u0001' > childNodes.length) {
                        throw Context.reportRuntimeError(Context.getMessage1("msg.no.function.ref.found", new Integer(functionNumber)));
                    }
                    Parser.decompile_r(childNodes[functionNumber + '\u0001'], version, indent, 2, false, srcData, result);
                    break;
                }
                case '`': {
                    result.append(", ");
                    break;
                }
                case '\\': {
                    if (Parser.nextIs(source, length, i, 1)) {
                        indent += 4;
                    }
                    result.append('{');
                    break;
                }
                case ']': {
                    if (justbody && type != 2 && i + 1 == length) break;
                    if (Parser.nextIs(source, length, i, 1)) {
                        indent -= 4;
                    }
                    if (Parser.nextIs(source, length, i, 118) || Parser.nextIs(source, length, i, 114)) {
                        indent -= 4;
                        result.append("} ");
                        break;
                    }
                    result.append('}');
                    break;
                }
                case '^': {
                    result.append('(');
                    break;
                }
                case '_': {
                    if (Parser.nextIs(source, length, i, 92)) {
                        result.append(") ");
                        break;
                    }
                    result.append(')');
                    break;
                }
                case 'Z': {
                    result.append('[');
                    break;
                }
                case '[': {
                    result.append(']');
                    break;
                }
                case '\u0001': {
                    result.append('\n');
                    if (i + 1 >= length) break;
                    less = 0;
                    nextToken = source.charAt(i + 1);
                    if (nextToken == 't' || nextToken == 'u') {
                        less = 2;
                    } else if (nextToken == ']') {
                        less = 4;
                    } else if (nextToken == ',' && source.charAt(afterName = Parser.getSourceString(source, i + 2, null)) == 'c') {
                        less = 4;
                    }
                    while (less < indent) {
                        result.append(' ');
                        ++less;
                    }
                    break;
                }
                case 'l': {
                    result.append('.');
                    break;
                }
                case '\u001e': {
                    result.append("new ");
                    break;
                }
                case '\u001f': {
                    result.append("delete ");
                    break;
                }
                case 'q': {
                    result.append("if ");
                    break;
                }
                case 'r': {
                    result.append("else ");
                    break;
                }
                case 'x': {
                    result.append("for ");
                    break;
                }
                case '?': {
                    result.append(" in ");
                    break;
                }
                case '|': {
                    result.append("with ");
                    break;
                }
                case 'v': {
                    result.append("while ");
                    break;
                }
                case 'w': {
                    result.append("do ");
                    break;
                }
                case 'K': {
                    result.append("try ");
                    break;
                }
                case '}': {
                    result.append("catch ");
                    break;
                }
                case '~': {
                    result.append("finally ");
                    break;
                }
                case '>': {
                    result.append("throw ");
                    break;
                }
                case 's': {
                    result.append("switch ");
                    break;
                }
                case 'y': {
                    if (Parser.nextIs(source, length, i, 44)) {
                        result.append("break ");
                        break;
                    }
                    result.append("break");
                    break;
                }
                case 'z': {
                    if (Parser.nextIs(source, length, i, 44)) {
                        result.append("continue ");
                        break;
                    }
                    result.append("continue");
                    break;
                }
                case 't': {
                    result.append("case ");
                    break;
                }
                case 'u': {
                    result.append("default");
                    break;
                }
                case '\u0005': {
                    if (Parser.nextIs(source, length, i, 89)) {
                        result.append("return");
                        break;
                    }
                    result.append("return ");
                    break;
                }
                case '{': {
                    result.append("var ");
                    break;
                }
                case 'Y': {
                    if (Parser.nextIs(source, length, i, 1)) {
                        result.append(';');
                        break;
                    }
                    result.append("; ");
                    break;
                }
                case 'a': {
                    switch (source.charAt(++i)) {
                        case '\u0080': {
                            result.append(" = ");
                            break;
                        }
                        case '\u0017': {
                            result.append(" += ");
                            break;
                        }
                        case '\u0018': {
                            result.append(" -= ");
                            break;
                        }
                        case '\u0019': {
                            result.append(" *= ");
                            break;
                        }
                        case '\u001a': {
                            result.append(" /= ");
                            break;
                        }
                        case '\u001b': {
                            result.append(" %= ");
                            break;
                        }
                        case '\u000b': {
                            result.append(" |= ");
                            break;
                        }
                        case '\f': {
                            result.append(" ^= ");
                            break;
                        }
                        case '\r': {
                            result.append(" &= ");
                            break;
                        }
                        case '\u0014': {
                            result.append(" <<= ");
                            break;
                        }
                        case '\u0015': {
                            result.append(" >>= ");
                            break;
                        }
                        case '\u0016': {
                            result.append(" >>>= ");
                        }
                    }
                    break;
                }
                case 'b': {
                    result.append(" ? ");
                    break;
                }
                case '\u0087': {
                    result.append(':');
                    break;
                }
                case 'c': {
                    if (Parser.nextIs(source, length, i, 1)) {
                        result.append(':');
                        break;
                    }
                    result.append(" : ");
                    break;
                }
                case 'd': {
                    result.append(" || ");
                    break;
                }
                case 'e': {
                    result.append(" && ");
                    break;
                }
                case '\u000b': {
                    result.append(" | ");
                    break;
                }
                case '\f': {
                    result.append(" ^ ");
                    break;
                }
                case '\r': {
                    result.append(" & ");
                    break;
                }
                case 'f': {
                    switch (source.charAt(++i)) {
                        case '5': {
                            result.append(version == 120 ? " == " : " === ");
                            break;
                        }
                        case '6': {
                            result.append(version == 120 ? " != " : " !== ");
                            break;
                        }
                        case '\u000e': {
                            result.append(" == ");
                            break;
                        }
                        case '\u000f': {
                            result.append(" != ");
                        }
                    }
                    break;
                }
                case 'g': {
                    switch (source.charAt(++i)) {
                        case '\u0011': {
                            result.append(" <= ");
                            break;
                        }
                        case '\u0010': {
                            result.append(" < ");
                            break;
                        }
                        case '\u0013': {
                            result.append(" >= ");
                            break;
                        }
                        case '\u0012': {
                            result.append(" > ");
                            break;
                        }
                        case '@': {
                            result.append(" instanceof ");
                        }
                    }
                    break;
                }
                case 'h': {
                    switch (source.charAt(++i)) {
                        case '\u0014': {
                            result.append(" << ");
                            break;
                        }
                        case '\u0015': {
                            result.append(" >> ");
                            break;
                        }
                        case '\u0016': {
                            result.append(" >>> ");
                        }
                    }
                    break;
                }
                case 'i': {
                    switch (source.charAt(++i)) {
                        case ' ': {
                            result.append("typeof ");
                            break;
                        }
                        case '\u0084': {
                            result.append("void ");
                            break;
                        }
                        case '\u0081': {
                            result.append('!');
                            break;
                        }
                        case '\u001c': {
                            result.append('~');
                            break;
                        }
                        case '\u0017': {
                            result.append('+');
                            break;
                        }
                        case '\u0018': {
                            result.append('-');
                        }
                    }
                    break;
                }
                case 'j': {
                    result.append("++");
                    break;
                }
                case 'k': {
                    result.append("--");
                    break;
                }
                case '\u0017': {
                    result.append(" + ");
                    break;
                }
                case '\u0018': {
                    result.append(" - ");
                    break;
                }
                case '\u0019': {
                    result.append(" * ");
                    break;
                }
                case '\u001a': {
                    result.append(" / ");
                    break;
                }
                case '\u001b': {
                    result.append(" % ");
                    break;
                }
                default: {
                    throw new RuntimeException();
                }
            }
            ++i;
lbl479:
            // 7 sources

            ** while (i < length)
        }
lbl480:
        // 1 sources

        if (type != 2 && !justbody) {
            result.append('\n');
        }
    }

    private static boolean nextIs(String source, int length, int i, int token) {
        return i + 1 < length ? source.charAt(i + 1) == token : false;
    }

    private static int getSourceString(String source, int offset, Object[] result) {
        int length = source.charAt(offset);
        ++offset;
        if ((0x8000 & length) != 0) {
            length = (Short.MAX_VALUE & length) << 16 | source.charAt(offset);
            ++offset;
        }
        if (result != null) {
            result[0] = source.substring(offset, offset + length);
        }
        return offset + length;
    }

    private static int getSourceNumber(String source, int offset, Object[] result) {
        char type = source.charAt(offset);
        ++offset;
        if (type == 'S') {
            if (result != null) {
                char ival = source.charAt(offset);
                result[0] = new Integer(ival);
            }
            ++offset;
        } else if (type == 'J' || type == 'D') {
            if (result != null) {
                long lbits = (long)source.charAt(offset) << 48;
                lbits |= (long)source.charAt(offset + 1) << 32;
                lbits |= (long)source.charAt(offset + 2) << 16;
                double dval = type == 'J' ? (double)lbits : Double.longBitsToDouble(lbits |= (long)source.charAt(offset + 3));
                result[0] = new Double(dval);
            }
            offset += 4;
        } else {
            throw new RuntimeException();
        }
        return offset;
    }
}

