<!--
This file provides macro definitions that can create files and classes.
They set up a hierarchy of location names which may be referenced by 
clients.

This depends on the CommonMacros.inc file.

2.1	Source file
This is the location used for the main source file.  It is not owned.
2.1.1	System includes region
Owned region for #include <...>, which are grouped together
2.1.2	User includes region
Owned region for #include "...", which must follow all system includes
2.1.3	Constants region
Owned region for literals, etc.
2.2	Header file
2.2.1	System includes region
Owned region for #include <...>
Typically used for child components which can be added or removed as design time, or the base class declarations used in the baseClassInfo property.
Note: S60 style guide recommends against too many #includes " use forwards instead " but they are required if you need to declare a class requiring a base class from the header.
2.2.2	Added includes region
Non-owned region for #include <...>
This provides decls needed for non-owned methods or non-deletable components and methods.
Typically used for system headers providing declarations needed for event handlers but not by the normal class declaration.  We cannot delete these #includes automatically since event handler stubs are not deleted automatically.
2.2.3	User includes region
Not needed, in S60 practice.  Typically the main source file includes any needed user includes.  This one may be needed if any components generate classes based on other classes defined by components.
2.2.4	Forward declarations region
Owned region for forward class and struct declarations used where a class is only referenced with a pointer or reference.  The source file must include the actual header #include.
2.2.5	Class
Non-owned class declaration for the primary class generated by a component.  These are grouped by access specifier first, to avoid a lot of repeated accessor usage (a violation of S60 coding conventions, and ugly in general). 
2.2.5.1	Public access region
Non-owned location decorated with a "public:" accessor.  This has a "unique-prototypes" filter.
Usually contains non-owned NewL(), NewLC(), destructor declarations.
2.2.5.1.1	Owned methods region
Owned section for methods that other generated classes may wish to use, esp. static constructor methods, e.g. for transient components; or getters/setters for instance variables.
This has a "unique-prototypes" filter.
2.2.5.1.2	Owned types region
Owned section for types that other generated classes may wish to use, esp. enums.
2.2.5.2	Protected access region
Non-owned location decorated with a "protected:" accessor.  This has a "unique-prototypes" filter.
This will contain base class method overrides.  These are non-owned because the definitions are non-owned, which is because the user may have already overridden the method, and we don"t want to destroy/conflict with their changes.
Note that unlike S60, we do not need a special region for overridden methods here, because the protected access region itself can be the target.
2.2.5.3	Private access region
Non-owned location decorated with a "private:" accessor.  This has a "unique-prototypes" filter.
Usually contains non-owned constructor.
2.2.5.3.1	Instance variables region
Owned
2.2.5.3.2	Generated methods region
Owned declarations for methods used by the implementation, e.g. listbox utilities.
This has a "unique-prototypes" filter.
2.2.5.3.3	Generated types region
Owned declarations for types used by the implementation, e.g. inner classes.

-->

<!--

-->
<defineMacro id="SourceFileTemplate"
	help="Defines the basic structure for a source file. 

This defines a file with system includes, user includes, and constants.">
	<macroArgument name="Dir" optional="true" default="${src}" 
		help="Project-relative directory for file"/>
	
	<macroArgument name="FileName" optional="true" default="${instanceName$title}.cpp" 
		help="Filename, inside $(Dir), to create"/>
	
	<macroArgument name="HeaderFileName" optional="true" default="${instanceName$title}.h" 
		help="Filename of associated header to #include, or blank for no #include" />

	<macroArgument name="LocationPrefix" optional="true" default="SOURCE" 
		help="String which is prefixed to the location ids defined by this macro." />
	
	<macroArgument name="InitialFileHeadContent" optional="true" default="" 
		help="optional stock text for the source file (before system includes, user includes, 
	constants). $p$
	NOTE: one-time text, should not depend on modifiable properties $p$
	NOTE: does not need to specify default source file template (comments), which is automatic."/>

	<macroArgument name="RealizeSystemIncludes" optional="true" default="true"
			help="flag that can be used to avoid generating the system includes section unless it is used.
		$p$
	NOTE: due to issues with the source generator, this shouldn't be set 'false' unless
	you really expect there to be no system includes ever defined, otherwise, the section
	will appear out of order when generated." />
	

	<macroArgument name="SystemIncludesRegionName" optional="true" default="Generated System Includes" 
		help="name of the generated section for system includes"/>
	
	<macroArgument name="InitialSystemIncludesContent" optional="true" default="" 
		help="optional stock text for the system includes" />

	<macroArgument name="RealizeUserIncludes" optional="true" default="true"
		help="flag that can be used to avoid generating the user includes section unless it is used.
		$p$
	NOTE: due to issues with the source generator, this shouldn't be set 'false' unless
	you really expect there to be no user includes ever defined, otherwise, the section
	will appear out of order when generated." />
	
	<macroArgument name="UserIncludesRegionName" optional="true" default="Generated User Includes" 
		help="name of the generated section for user includes"/>

	<macroArgument name="InitialUserIncludesContent" optional="true" default="" 
		help="optional stock text for the user includes"/>

	<macroArgument name="RealizeConstants" optional="true" default="true" 
		help="flag that can be used to avoid generating the constants section unless it is used.
		$p$
	NOTE: due to issues with the source generator, this shouldn't be set 'false' unless
	you really expect there to be no constants ever defined, otherwise, the section
	will appear out of order when generated."/>
	
	<macroArgument name="ConstantsRegionName" optional="true" default="Generated Constants" 
		help="name of the generated section for constants" />

	<macroArgument name="InitialConstantsContent" optional="true" default="" 
		help="optional stock text for the constants" />
	
	<macroArgument name="InitialFileTailContent" optional="true" default="" 
		help="optional stock text for the source file (after system includes, user includes, 
	constants) which appears at the very end of the file.
		 $p$
	NOTE: one-time text, should not depend on modifiable properties
		 $p$
	NOTE: this really comes at the very end during initial file generation
		(unless you emit other templates with mode=&quot;at-end&quot;), so if you simply
		want content after these sections but before other templates you add,
		just create templates for location=&quot;$(LocationPrefix)_FILE&quot;. "
		/>

	<!--====================================================================-->

	<defineLocation id="$(LocationPrefix)_FILE" 
		domain="cpp" dir="$(Dir)" 
		file="$(FileName)"
		owned="false"
		location="">
		
		<template>$(InitialFileHeadContent)</template>
		 
	</defineLocation>

	<defineLocation id="$(LocationPrefix)_OWNED_SYSTEM_INCLUDES" 
		baseLocation="$(LocationPrefix)_FILE"
		location="region($(SystemIncludesRegionName))"
		filter="unique-includes"
		owned="true"
		realize="$(RealizeSystemIncludes)">
		<template>$(InitialSystemIncludesContent)</template>
	</defineLocation>		
	
	<defineLocation id="$(LocationPrefix)_OWNED_USER_INCLUDES" 
		baseLocation="$(LocationPrefix)_FILE"
		location="region($(UserIncludesRegionName))"
		filter="unique-includes"
		owned="true"
		realize="$(RealizeUserIncludes)" >
		<template><![CDATA[$(InitialUserIncludesContent)
<% if ($(HeaderFileName::as-string).length > 0) { %>#include "$(HeaderFileName)"<% } %>
]]>		</template>
	</defineLocation>		

	<defineLocation id="$(LocationPrefix)_OWNED_CONSTANTS" 
		baseLocation="$(LocationPrefix)_FILE"
		location="region($(ConstantsRegionName))"
		owned="true"
		realize="$(RealizeConstants)">
		<template>$(InitialConstantsContent)</template>
	</defineLocation>

	<template location="$(LocationPrefix)_FILE" mode="at-end">
$(InitialFileTailContent)
	</template>
	
</defineMacro>




<defineMacro id="HeaderFileTemplate"
		help="	
Defines the basic structure for a header file. 
$p$
This defines a file with an include guard, system includes, user includes,
event handler includes (non-owned but modifiable), constants,
and forward declarations.
">
	<macroArgument name="Dir" optional="true" default="${inc}" 
		help="Project-relative directory for file"/>

	<macroArgument name="FileName" optional="true" default="${instanceName$title}.h" 
		help="Filename, inside $(Dir), to create" />

	<macroArgument name="IncludeGuardMacro" optional="true" default="${instanceName$upper}_H" 
		help="Include guard macro (#ifndef ...) to use" />
	
	<macroArgument name="LocationPrefix" optional="true" default="HEADER" 
		help="String which is prefixed to the location ids defined by this macro." />
	
	<macroArgument name="InitialFileHeadContent" optional="true" default="" 
		help="optional stock text for the top of the header file.
		
		NOTE: one-time text, should not depend on modifiable properties
		
		NOTE: does not need to specify header file template (comments) or #ifdef guards. "/>

	<macroArgument name="RealizeEventHandlerIncludes" optional="true" default="true" 
		help="flag that can be used to avoid generating the section unless it is used.
		$p$
	NOTE: due to issues with the source generator, this shouldn't be set 'false' unless
	you really expect there to be no event handler includes ever defined, otherwise, the section
	will appear out of order when generated." />
		
	<macroArgument name="InitialEventHandlerIncludesContent" optional="true" default="" 
		help="optional stock text for the event handler includes.
		$p$
		NOTE: one-time text, should not depend on modifiable properties"/>

	
	<macroArgument name="RealizeOwnedSystemIncludes" optional="true" default="true" 
		help="flag that can be used to avoid generating the system includes section unless it is used.
		$p$
	NOTE: due to issues with the source generator, this shouldn't be set 'false' unless
	you really expect there to be no system includes ever defined, otherwise, the section
	will appear out of order when generated." />
	

	<macroArgument name="OwnedSystemIncludesRegionName" optional="true" default="Generated System Includes"
		help="name of the generated section for system includes" />

	<macroArgument name="RealizeOwnedUserIncludes" optional="true" default="true"
			help="flag that can be used to avoid generating the user includes section unless it is used.
		$p$
	NOTE: due to issues with the source generator, this shouldn't be set 'false' unless
	you really expect there to be no user includes ever defined, otherwise, the section
	will appear out of order when generated." />
	
	<macroArgument name="OwnedUserIncludesRegionName" optional="true" default="Generated User Includes" 
		help="name of the generated section for user includes" />
	
	<macroArgument name="InitialOwnedSystemIncludesContent" optional="true" default="" 
		help="optional stock text for the added system includes" />

	<macroArgument name="InitialOwnedUserIncludesContent" optional="true" default="" 
		help="optional stock text for the user includes." />

	<macroArgument name="RealizeOwnedConstants" optional="true" default="true" 
		help="flag that can be used to avoid generating the constants section unless it is used.
		$p$
	NOTE: due to issues with the source generator, this shouldn't be set 'false' unless
	you really expect there to be no constants ever defined, otherwise, the section
	will appear out of order when generated." />

	<macroArgument name="InitialOwnedConstantsContent" optional="true" default="" 
		help="optional stock text for the constants" />

	<macroArgument name="RealizeOwnedForwardDeclarations" optional="true" default="true" 
		help="flag that can be used to avoid generating the forward declarations section unless it is used.
		$p$
	NOTE: due to issues with the source generator, this shouldn't be set 'false' unless
	you really expect there to be no forward decls ever defined, otherwise, the section
	will appear out of order when generated." />

	<macroArgument name="InitialOwnedForwardDeclarationsContent" optional="true" default="" 
		help="optional stock text for the forward declarations" />

	<macroArgument name="RealizeOwnedTypedefs" optional="true" default="true" 
		help="flag that can be used to avoid generating the typedefs section unless it is used.
		$p$
		NOTE: due to issues with the source generator, this should't be set 'false' unless
		you really expect there to be no typedefs ever defined, otherwise, the section
		will appear out of order when generated."/>

	<macroArgument name="OwnedTypedefsRegionName" optional="true" default="Generated Typedefs" 
		help="name of the generated section for owned typedefs"/>

	<macroArgument name="InitialOwnedTypedefsContent" optional="true" default="" 
		help="optional stock text for the initial typedefs" />
	
	<macroArgument name="InitialFileTailContent" optional="true" default="" 
		help="optional stock text for the end of the header file.
		$p$
		NOTE: one-time text, should not depend on modifiable properties
		 $p$
		NOTE: this really comes at the very end during initial file generation
		(unless you emit other templates with mode=&quot;at-end&quot;), so if you simply
		want content after these sections but before other templates you add,
		just create templates for location=&quot;$(LocationPrefix)HEADER_FILE&quot;.
		"/>

	<!--====================================================================-->
	
	<defineLocation id="$(LocationPrefix)_FILE" 
		domain="cpp" dir="$(Dir)" 
		file="$(FileName)"
		owned="false"
		location="">
		
		<template><![CDATA[
#ifndef $(IncludeGuardMacro)
#define $(IncludeGuardMacro)
$(InitialFileHeadContent)
]]>		</template>
		 
	</defineLocation>
	
	<defineLocation id="$(LocationPrefix)_OWNED_SYSTEM_INCLUDES" 
		baseLocation="$(LocationPrefix)_FILE"
		location="region($(OwnedSystemIncludesRegionName))"
		filter="unique-includes"
		owned="true"
		realize="$(RealizeOwnedSystemIncludes)">
		<template>$(InitialOwnedSystemIncludesContent)</template>
	</defineLocation>		
	
	<defineLocation id="$(LocationPrefix)_EVENT_HANDLER_INCLUDES" 
		baseLocation="$(LocationPrefix)_FILE"
		location="region(Event Handler Includes)"
		filter="unique-includes"
		owned="false"
		realize="$(RealizeEventHandlerIncludes)">
		<template>$(InitialEventHandlerIncludesContent)</template>
	</defineLocation>		
	
	<defineLocation id="$(LocationPrefix)_OWNED_USER_INCLUDES" 
		baseLocation="$(LocationPrefix)_FILE"
		location="region($(OwnedUserIncludesRegionName))"
		filter="unique-includes"
		owned="true"
		realize="$(RealizeOwnedUserIncludes)" >
		<template>$(InitialOwnedUserIncludesContent)</template>
	</defineLocation>		
	
	<defineLocation id="$(LocationPrefix)_OWNED_TYPEDEFS" 
		baseLocation="$(LocationPrefix)_FILE"
		location="region($(OwnedTypedefsRegionName))"
		owned="true"
		realize="$(RealizeOwnedTypedefs)" >
		<template>$(InitialOwnedTypedefsContent)</template>
	</defineLocation>

	<defineLocation id="$(LocationPrefix)_OWNED_CONSTANTS" 
		baseLocation="$(LocationPrefix)_FILE"
		location="region(Generated Constants)"
		owned="true"
		realize="$(RealizeOwnedConstants)">
		<template>$(InitialOwnedConstantsContent)</template>
	</defineLocation>

	<defineLocation id="$(LocationPrefix)_OWNED_FORWARD_DECLARATIONS" 
		baseLocation="$(LocationPrefix)_FILE"
		location="region(Generated Forward Declarations)"
		owned="true"
		realize="$(RealizeOwnedForwardDeclarations)">
		<template>$(InitialOwnedForwardDeclarationsContent)</template>
	</defineLocation>

	<template location="$(LocationPrefix)_FILE" mode="at-end"><![CDATA[
$(InitialFileTailContent)
#endif // $(IncludeGuardMacro)
]]> </template>
	
</defineMacro>


<defineMacro id="ClassTemplate"
		help="Defines the basic structure for a class with public, protected, and private regions,
with owned sections therein for common purposes.
" >
	<macroArgument name="LocationPrefix" optional="true" default="" 
		help="String which is prefixed to the location ids defined by this macro.
	Useful when one component defines multiple files."/>

	<macroArgument name="BaseLocation" optional="true" default="HEADER_FILE" 
		help="name of the base location in which to place the class, defaults to HEADER_FILE" />
	
	<macroArgument name="ClassName" optional="true" default="${className}" 
		help="name of the class to generate" />

	<macroArgument name="BaseClassName" 
			help="name of the base class, from which this class derives " />

	<macroArgument name="BaseClassAccessor" optional="true" default="public" 
		help="accessor for the base class, from which this class derives" />

	<macroArgument name="ExtraBaseClasses" optional="true" 
		help="extra interface classes, separated by commas" />

	<macroArgument name="ExtraOwnedBases" optional="true" 
		help="extra interface classes, separated by commas" />

	<macroArgument name="ClassComment" optional="true" default="" 
		help="optional text for the class comment" />
	
	<macroArgument name="InitialClassHeadContent" optional="true" default="" 
		help="optional text for the start of the class
		 $p$
	NOTE: one-time code, should not depend on modifiable properties" />

	<!-- public: -->

	<macroArgument name="InitialPublicHeadContent" optional="true" default="" 
		help="optional text for the start of the public section (follows &quot;public:&quot;)
		 $p$
	NOTE: one-time code, should not depend on modifiable properties" />

	<macroArgument name="RealizePublicOwnedTypes" optional="true" default="true" 
		help="flag that can be used to avoid generating the public types section unless it is used.
		$p$
	NOTE: if InitialPublicOwnedTypesContent is set, this flag is ignored." />

	<macroArgument name="InitialPublicOwnedTypesContent" optional="true" default="" 
		help="optional text for the public owned types section" />

	<macroArgument name="RealizePublicOwnedMethods" optional="true" default="true" 
		help="flag that can be used to avoid generating the public owned methods section unless it is used.
		$p$
	NOTE: if InitialPublicOwnedMethodsContent is set, this flag is ignored." />

	<macroArgument name="InitialPublicOwnedMethodsContent" optional="true" default="" 
		help="optional text for the public owned methods section " />
	
	<macroArgument name="InitialPublicTailContent" optional="true" default="" 
		help="optional text for the end of the public section (follows &quot;public:&quot;)
		 $p$
	NOTE: one-time code, should not depend on modifiable properties
		$p$
	NOTE: content appears at the end of all initially generated public content.
		" />

	<!-- protected: -->

	<macroArgument name="InitialProtectedHeadContent" optional="true" default="" 
		help="optional text for the start of the protected section (follows &quot;protected:&quot;)
		 $p$
	NOTE: one-time code, should not depend on modifiable properties" />

	<macroArgument name="RealizeProtectedOverriddenMethods" optional="true" default="true" 
		help="flag that can be used to avoid generating the protected overridden methods section unless it is used."/>

	<macroArgument name="InitialProtectedOverriddenMethodsContent" optional="true" default="" 
		help="optional text for the the protected overridden methods section"/>

	<macroArgument name="RealizeProtectedUserHandlers" optional="true" default="true" 
		help="flag that can be used to avoid generating the protected user handlers section
		unless it is used.  This is used for the prototypes for the user-editable 
		event handler methods."/>

	<macroArgument name="InitialProtectedUserHandlersContent" optional="true" default="" 
		help="optional text for the protected user handlers section"/>

	
	<macroArgument name="InitialProtectedTailContent" optional="true" default="" 
		help="optional text for the end of the protected section 
		$p$
	NOTE: one-time code, should not depend on modifiable properties
		$p$
	NOTE: content appears at the end of all initially generated protected content."/>

	<!-- private: -->
	
	<macroArgument name="InitialPrivateHeadContent" optional="true" default="" 
		help="optional text for the start of the private section (follows &quot;private:&quot;)
		 $p$
	NOTE: one-time code, should not depend on modifiable properties"/>

	<macroArgument name="RealizePrivateOwnedTypes" optional="true" default="true" 
		help="flag that can be used to avoid generating the private owned types section unless it is used.
		$p$
	NOTE: if InitialPrivateOwnedTypesContent is set, this flag is ignored."/>

	<macroArgument name="InitialPrivateOwnedTypesContent" optional="true" default="" 
		help="optional text for the the private types section"/>

	<macroArgument name="RealizePrivateOwnedInstanceVariables" optional="true" default="true" 
		help="flag that can be used to avoid generating the private instance variables section unless it is used."/>

	<macroArgument name="InitialPrivateOwnedInstanceVariablesContent" optional="true" default="" 
		help=" optional text for the the private instance variables section"/>

	<macroArgument name="RealizePrivateOwnedMethods" optional="true" default="true" 
		help="flag that can be used to avoid generating the private owned methods section unless it is used."/>

	<macroArgument name="InitialPrivateOwnedMethodsContent" optional="true" default="" 
		help="optional text for the private owned methods section"/>

	<macroArgument name="RealizePrivateMethods" optional="true" default="true" 
		help="flag that can be used to avoid generating the private methods section unless it is used."/>

	<macroArgument name="InitialPrivateMethodsContent" optional="true" default="" 
		help="optional text for the private methods section"/>

	<macroArgument name="InitialPrivateTailContent" optional="true" default="" 
		help="optional text for the end of the private section 
		$p$
	NOTE: one-time code, should not depend on modifiable properties
		$p$
	NOTE: content appears at the end of all initially generated private content."/>

	<!--=========================-->
	
	<macroArgument name="InitialClassTailContent" optional="true" default="" 
		help="optional text for the end of the class
		 $p$
	NOTE: one-time code, should not depend on modifiable properties"
		/>
	
	<!--====================================================================-->

	<defineLocation id="$(LocationPrefix)CLASS" 
		owned="false"
		location="class($(ClassName))"
		baseLocation="$(BaseLocation)">
		
		<template>
$(ClassComment)			
class $(ClassName) : $(BaseClassAccessor) $(BaseClassName)
	{
	};
		</template>
		 
	</defineLocation>
		
	<template location="$(LocationPrefix)CLASS">
$(InitialClassHeadContent)
	</template>

	<defineLocation id="$(LocationPrefix)CLASS_BASES" 
		baseLocation="$(LocationPrefix)CLASS"
		owned="false"
		filter="unique-bases"
		location="bases()">
	</defineLocation>
		
	<template location="$(LocationPrefix)CLASS_BASES"><![CDATA[<% 
	if ($(ExtraBaseClasses::is-defined)) { 
%>, $(ExtraBaseClasses)<% } 
%> ]]></template>

						<defineLocation baseLocation="$(LocationPrefix)CLASS_BASES"
								owned="true" id="$(LocationPrefix)OWNED_BASES"
								filter="unique-bases"
								 location="region(Generated Content)"
								 realize="true">
								<template>
								</template>
						</defineLocation>

						<template location="$(LocationPrefix)OWNED_BASES">
<![CDATA[<% 
	if ($(ExtraOwnedBases::is-defined)) { 
%>, $(ExtraOwnedBases)<% } 
%> ]]>					</template>
	
	<!-- the filter allows the location to accept new content -->
	<defineLocation id="$(LocationPrefix)CLASS_PUBLIC" 
		baseLocation="$(LocationPrefix)CLASS"
		location="region(Public Section)"
		owned="false"
		filter="unique-prototypes"
		realize="true">
		<template><![CDATA[
public:<% contrib.indentAdjust(-1); %>]]>
		</template>
		<template location="$(LocationPrefix)CLASS_PUBLIC">
$(InitialPublicHeadContent)
		</template>
		<template location="$(LocationPrefix)CLASS_PUBLIC" mode="at-end">$(InitialPublicTailContent)
		</template>
	</defineLocation>		

		
	<defineLocation id="$(LocationPrefix)CLASS_PUBLIC_OWNED_TYPES"
		baseLocation="$(LocationPrefix)CLASS_PUBLIC"
		location="region(Generated Types)"
		owned="true"
		filter="unique-prototypes"
		realize="$(RealizePublicOwnedTypes)">
		<template>$(InitialPublicOwnedTypesContent)
		</template>
	</defineLocation>

	<defineLocation id="$(LocationPrefix)CLASS_PUBLIC_OWNED_METHODS"
		baseLocation="$(LocationPrefix)CLASS_PUBLIC"
		location="region(Generated Methods)"
		owned="true"
		filter="unique-prototypes"
		realize="$(RealizePublicOwnedMethods)">
		<template>$(InitialPublicOwnedMethodsContent)
		</template>
	</defineLocation>

	<!-- the filter allows the location to accept new content -->
	<defineLocation id="$(LocationPrefix)CLASS_PROTECTED" 
		baseLocation="$(LocationPrefix)CLASS"
		location="region(Protected Section)"
		owned="false"
		filter="unique-prototypes"
		realize="true">
		<template><![CDATA[
protected:<% contrib.indentAdjust(-1); %>]]>
		</template>
		<template location="$(LocationPrefix)CLASS_PROTECTED">
$(InitialProtectedHeadContent)
		</template>
		<template location="$(LocationPrefix)CLASS_PROTECTED" mode="at-end">$(InitialProtectedTailContent)
		</template>
	</defineLocation>		


	<defineLocation id="$(LocationPrefix)CLASS_PROTECTED_OVERRIDDEN_METHODS"
		baseLocation="$(LocationPrefix)CLASS_PROTECTED"
		location="region(Overridden Methods)"
		owned="true"
		filter="unique-prototypes"
		realize="$(RealizeProtectedOverriddenMethods)">
		<template>$(InitialProtectedOverriddenMethodsContent)
		</template>
	</defineLocation>

	<defineLocation id="$(LocationPrefix)CLASS_PROTECTED_USER_HANDLERS" 
		baseLocation="$(LocationPrefix)CLASS_PROTECTED"
		location="region(User Handlers)"
		owned="false"
		filter="unique-prototypes"
		realize="$(RealizeProtectedUserHandlers)">
		<template>$(InitialProtectedUserHandlersContent)
		</template>
	</defineLocation>		

	<!-- the filter allows the location to accept new content -->
	<defineLocation id="$(LocationPrefix)CLASS_PRIVATE" 
		baseLocation="$(LocationPrefix)CLASS"
		location="region(Private Section)"
		owned="false"
		filter="unique-prototypes"
		realize="true">
		<template><![CDATA[
private:<% contrib.indentAdjust(-1);%>
]]>     </template>
		<template location="$(LocationPrefix)CLASS_PRIVATE">
$(InitialPrivateHeadContent)
		</template>
		<template location="$(LocationPrefix)CLASS_PRIVATE" mode="at-end">$(InitialPrivateTailContent)
		</template>
	</defineLocation>		

		
	<defineLocation id="$(LocationPrefix)CLASS_PRIVATE_OWNED_TYPES"
		baseLocation="$(LocationPrefix)CLASS_PRIVATE"
		location="region(Generated Types)"
		owned="true"
		filter="unique-prototypes"
		realize="$(RealizePrivateOwnedTypes)">
		<template>$(InitialPrivateOwnedTypesContent)
		</template>
	</defineLocation>

	<defineLocation id="$(LocationPrefix)CLASS_PRIVATE_OWNED_INSTANCE_VARIABLES"
		baseLocation="$(LocationPrefix)CLASS_PRIVATE"
		location="region(Generated Instance Variables)"
		owned="true"
		filter="unique-prototypes"
		realize="$(RealizePrivateOwnedInstanceVariables)">
		<template>$(InitialPrivateOwnedInstanceVariablesContent)
		</template>
	</defineLocation>

	<defineLocation id="$(LocationPrefix)CLASS_PRIVATE_OWNED_METHODS"
		baseLocation="$(LocationPrefix)CLASS_PRIVATE"
		location="region(Generated Owned Methods)"
		owned="true"
		filter="unique-prototypes"
		realize="$(RealizePrivateOwnedMethods)">
		<template>$(InitialPrivateOwnedMethodsContent)
		</template>
	</defineLocation>

	<defineLocation id="$(LocationPrefix)CLASS_PRIVATE_METHODS"
		baseLocation="$(LocationPrefix)CLASS_PRIVATE"
		location="region(Generated Not Owned Methods)"
		owned="false"
		filter="unique-prototypes"
		realize="$(RealizePrivateMethods)">
		<template>$(InitialPrivateMethodsContent)
		</template>
	</defineLocation>
		
	<template location="$(LocationPrefix)CLASS" mode="at-end">$(InitialClassTailContent)
	</template>

</defineMacro>




<defineMacro id="AddCppIncludes"
	help="Generate #includes for a space-separated list of headers.  
	$p$
	Note: you cannot use variable substitution, script escapes, etc. in the list. 
	Instead, just write explicit contributions for the include, e.g. &lt;template location=&quot;MAIN_OWNED_SYSTEM_INCLUDES&quot;&gt; ... ">
	
	<macroArgument name="Headers" 
		help="a space-separated list of header files "/> 
	
	<macroArgument name="Location" optional="true" 
		help="location where includes should go (either this or Phase should be set)"/>

	<macroArgument name="Phase" optional="true" 
		help="phase where includes should go (either this or Location should be set)"/>
	 
	<macroArgument name="IsUser" optional="true" default="false" 
		help="&quot;User&quot; or &lt;system&gt; includes?" />
	
	<inline><![CDATA[
	var headers = $(Headers::as-string).split(" ");
	var prefix, suffix;
	if ($(IsUser)) {
		prefix = "#include \"";
		suffix = "\"\n";
	} else {
		prefix = "#include <";
		suffix = ">\n";
	}
	for (var h in headers) {
		var contrib = null;
		if ($(Location::is-defined)) {
			contrib = Engine.createContributionForLocation($(Location::as-string));
		} else {
			contrib = Engine.createContributionForPhase($(Phase::as-string)); 
		}
		contrib.setText(prefix + headers[h] + suffix);
		contribs.add(contrib);
	}
	]]>
	</inline>
</defineMacro>

<defineMacro id="ResolvePhases"
	help="This macro fixes up phase -&gt; location mappings on the current contributions,
	or optionally, another list.  
	$p$
	The mappings are Phase=Location pairs separated
	by spaces.  
	$p$
	This may be called multiple times.">
	
	<macroArgument name="Mappings" 
		help="A space-separated list of Phase=Location mappings."/>
	
	<macroArgument name="ContribsList" optional="true" default="contribs" 
		help="The array or list of IContribution upon which to apply the fixups."/>
	
	<inline><![CDATA[
		var mappings = $(Mappings::as-string).split(" ");
		for (var entry in mappings) {
			var info = entry.split("=");
			Engine.assignLocationsForPhase($(ContribsList), info[0], info[1]);		
		}
]]>	</inline>
	
</defineMacro>
	