/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image;

import org.apache.batik.ext.awt.image.TransferFunction;

public class DiscreteTransfer
implements TransferFunction {
    public byte[] lutData;
    public int[] tableValues;
    private int n;

    public DiscreteTransfer(int[] nArray) {
        this.tableValues = nArray;
        this.n = nArray.length;
    }

    private void buildLutData() {
        this.lutData = new byte[256];
        for (int i = 0; i <= 255; ++i) {
            int n = (int)Math.floor((float)(i * this.n) / 255.0f);
            if (n == this.n) {
                n = this.n - 1;
            }
            this.lutData[i] = (byte)(this.tableValues[n] & 0xFF);
        }
    }

    public byte[] getLookupTable() {
        this.buildLutData();
        return this.lutData;
    }
}

