/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.MissingResourceException;
import org.apache.batik.css.engine.CSSContext;
import org.apache.batik.css.engine.CSSEngine;
import org.apache.batik.css.engine.value.ShorthandManager;
import org.apache.batik.css.engine.value.ValueManager;
import org.apache.batik.css.parser.ExtendedParser;
import org.apache.batik.css.parser.ExtendedParserWrapper;
import org.apache.batik.dom.AbstractDOMImplementation;
import org.apache.batik.dom.AbstractDocument;
import org.apache.batik.dom.AbstractStylableDocument;
import org.apache.batik.dom.DomExtension;
import org.apache.batik.dom.GenericElement;
import org.apache.batik.dom.GenericElementNS;
import org.apache.batik.dom.StyleSheetFactory;
import org.apache.batik.dom.util.DOMUtilities;
import org.apache.batik.dom.util.DoublyIndexedTable;
import org.apache.batik.i18n.Localizable;
import org.apache.batik.i18n.LocalizableSupport;
import org.apache.batik.util.Service;
import org.apache.batik.util.XMLResourceDescriptor;
import org.w3c.css.sac.Parser;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.css.DOMImplementationCSS;
import org.w3c.dom.css.ViewCSS;

public abstract class ExtensibleDOMImplementation
extends AbstractDOMImplementation
implements DOMImplementationCSS,
StyleSheetFactory,
Localizable {
    protected DoublyIndexedTable customFactories;
    protected List customValueManagers;
    protected List customShorthandManagers;
    protected static final String RESOURCES = "org.apache.batik.dom.resources.Messages";
    protected LocalizableSupport localizableSupport;
    protected static List extensions = null;
    static /* synthetic */ Class class$org$apache$batik$dom$DomExtension;

    public ExtensibleDOMImplementation() {
        this.initLocalizable();
        Iterator iterator = ExtensibleDOMImplementation.getDomExtensions().iterator();
        while (iterator.hasNext()) {
            DomExtension domExtension = (DomExtension)iterator.next();
            domExtension.registerTags(this);
        }
    }

    public void setLocale(Locale locale) {
        this.localizableSupport.setLocale(locale);
    }

    public Locale getLocale() {
        return this.localizableSupport.getLocale();
    }

    protected void initLocalizable() {
        this.localizableSupport = new LocalizableSupport(RESOURCES, this.getClass().getClassLoader());
    }

    public String formatMessage(String string, Object[] objectArray) throws MissingResourceException {
        return this.localizableSupport.formatMessage(string, objectArray);
    }

    public void registerCustomElementFactory(String string, String string2, ElementFactory elementFactory) {
        if (this.customFactories == null) {
            this.customFactories = new DoublyIndexedTable();
        }
        this.customFactories.put(string, string2, elementFactory);
    }

    public void registerCustomCSSValueManager(ValueManager valueManager) {
        if (this.customValueManagers == null) {
            this.customValueManagers = new LinkedList();
        }
        this.customValueManagers.add(valueManager);
    }

    public void registerCustomCSSShorthandManager(ShorthandManager shorthandManager) {
        if (this.customShorthandManagers == null) {
            this.customShorthandManagers = new LinkedList();
        }
        this.customShorthandManagers.add(shorthandManager);
    }

    public CSSEngine createCSSEngine(AbstractStylableDocument abstractStylableDocument, CSSContext cSSContext) {
        ShorthandManager[] shorthandManagerArray;
        ValueManager[] valueManagerArray;
        Parser parser;
        String string = XMLResourceDescriptor.getCSSParserClassName();
        try {
            parser = (Parser)Class.forName(string).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new DOMException(15, this.formatMessage("css.parser.class", new Object[]{string}));
        }
        catch (InstantiationException instantiationException) {
            throw new DOMException(15, this.formatMessage("css.parser.creation", new Object[]{string}));
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new DOMException(15, this.formatMessage("css.parser.access", new Object[]{string}));
        }
        ExtendedParser extendedParser = ExtendedParserWrapper.wrap((Parser)parser);
        if (this.customValueManagers == null) {
            valueManagerArray = new ValueManager[]{};
        } else {
            valueManagerArray = new ValueManager[this.customValueManagers.size()];
            shorthandManagerArray = this.customValueManagers.iterator();
            int n = 0;
            while (shorthandManagerArray.hasNext()) {
                valueManagerArray[n++] = (ValueManager)shorthandManagerArray.next();
            }
        }
        if (this.customShorthandManagers == null) {
            shorthandManagerArray = new ShorthandManager[]{};
        } else {
            shorthandManagerArray = new ShorthandManager[this.customShorthandManagers.size()];
            Iterator iterator = this.customShorthandManagers.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                shorthandManagerArray[n++] = (ShorthandManager)iterator.next();
            }
        }
        CSSEngine cSSEngine = this.createCSSEngine(abstractStylableDocument, cSSContext, extendedParser, valueManagerArray, shorthandManagerArray);
        abstractStylableDocument.setCSSEngine(cSSEngine);
        return cSSEngine;
    }

    public abstract CSSEngine createCSSEngine(AbstractStylableDocument var1, CSSContext var2, ExtendedParser var3, ValueManager[] var4, ShorthandManager[] var5);

    public abstract ViewCSS createViewCSS(AbstractStylableDocument var1);

    public Element createElementNS(AbstractDocument abstractDocument, String string, String string2) {
        String string3;
        ElementFactory elementFactory;
        if (string == null) {
            return new GenericElement(string2.intern(), abstractDocument);
        }
        if (this.customFactories != null && (elementFactory = (ElementFactory)this.customFactories.get(string, string3 = DOMUtilities.getLocalName(string2))) != null) {
            return elementFactory.create(DOMUtilities.getPrefix(string2), abstractDocument);
        }
        return new GenericElementNS(string.intern(), string2.intern(), abstractDocument);
    }

    protected static synchronized List getDomExtensions() {
        if (extensions != null) {
            return extensions;
        }
        extensions = new LinkedList();
        Iterator iterator = Service.providers((Class)(class$org$apache$batik$dom$DomExtension == null ? (class$org$apache$batik$dom$DomExtension = ExtensibleDOMImplementation.class$("org.apache.batik.dom.DomExtension")) : class$org$apache$batik$dom$DomExtension));
        block0: while (iterator.hasNext()) {
            DomExtension domExtension;
            DomExtension domExtension2 = (DomExtension)iterator.next();
            float f = domExtension2.getPriority();
            ListIterator<DomExtension> listIterator = extensions.listIterator();
            do {
                if (listIterator.hasNext()) continue;
                listIterator.add(domExtension2);
                continue block0;
            } while (!((domExtension = (DomExtension)listIterator.next()).getPriority() > f));
            listIterator.previous();
            listIterator.add(domExtension2);
        }
        return extensions;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static interface ElementFactory {
        public Element create(String var1, Document var2);
    }
}

