/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.SVGShapeElementBridge;
import org.apache.batik.bridge.UnitProcessor;
import org.apache.batik.gvt.ShapeNode;
import org.apache.batik.gvt.ShapePainter;
import org.apache.batik.parser.UnitProcessor;
import org.w3c.dom.Element;
import org.w3c.dom.events.MutationEvent;

public class SVGRectElementBridge
extends SVGShapeElementBridge {
    public String getLocalName() {
        return "rect";
    }

    public Bridge getInstance() {
        return new SVGRectElementBridge();
    }

    protected void buildShape(BridgeContext bridgeContext, Element element, ShapeNode shapeNode) {
        UnitProcessor.Context context = UnitProcessor.createContext(bridgeContext, element);
        String string = element.getAttributeNS(null, "x");
        float f = 0.0f;
        if (string.length() != 0) {
            f = UnitProcessor.svgHorizontalCoordinateToUserSpace(string, "x", context);
        }
        string = element.getAttributeNS(null, "y");
        float f2 = 0.0f;
        if (string.length() != 0) {
            f2 = UnitProcessor.svgVerticalCoordinateToUserSpace(string, "y", context);
        }
        if ((string = element.getAttributeNS(null, "width")).length() == 0) {
            throw new BridgeException(element, "attribute.missing", new Object[]{"width", string});
        }
        float f3 = UnitProcessor.svgHorizontalLengthToUserSpace(string, "width", context);
        string = element.getAttributeNS(null, "height");
        if (string.length() == 0) {
            throw new BridgeException(element, "attribute.missing", new Object[]{"height", string});
        }
        float f4 = UnitProcessor.svgVerticalLengthToUserSpace(string, "height", context);
        string = element.getAttributeNS(null, "rx");
        boolean bl = string.length() != 0;
        float f5 = 0.0f;
        if (bl) {
            f5 = UnitProcessor.svgHorizontalLengthToUserSpace(string, "rx", context);
        }
        f5 = f5 > f3 / 2.0f ? f3 / 2.0f : f5;
        string = element.getAttributeNS(null, "ry");
        boolean bl2 = string.length() != 0;
        float f6 = 0.0f;
        if (bl2) {
            f6 = UnitProcessor.svgVerticalLengthToUserSpace(string, "ry", context);
        }
        f6 = f6 > f4 / 2.0f ? f4 / 2.0f : f6;
        RectangularShape rectangularShape = null;
        rectangularShape = bl && bl2 ? (f5 == 0.0f || f6 == 0.0f ? new Rectangle2D.Float(f, f2, f3, f4) : new RoundRectangle2D.Float(f, f2, f3, f4, f5 * 2.0f, f6 * 2.0f)) : (bl ? (f5 == 0.0f ? new Rectangle2D.Float(f, f2, f3, f4) : new RoundRectangle2D.Float(f, f2, f3, f4, f5 * 2.0f, f5 * 2.0f)) : (bl2 ? (f6 == 0.0f ? new Rectangle2D.Float(f, f2, f3, f4) : new RoundRectangle2D.Float(f, f2, f3, f4, f6 * 2.0f, f6 * 2.0f)) : new Rectangle2D.Float(f, f2, f3, f4)));
        shapeNode.setShape((Shape)rectangularShape);
    }

    public void handleDOMAttrModifiedEvent(MutationEvent mutationEvent) {
        String string = mutationEvent.getAttrName();
        if (string.equals("x") || string.equals("y") || string.equals("width") || string.equals("height") || string.equals("rx") || string.equals("ry")) {
            this.buildShape(this.ctx, this.e, (ShapeNode)this.node);
            this.handleGeometryChanged();
        } else {
            super.handleDOMAttrModifiedEvent(mutationEvent);
        }
    }

    protected ShapePainter createShapePainter(BridgeContext bridgeContext, Element element, ShapeNode shapeNode) {
        Shape shape = shapeNode.getShape();
        Rectangle2D rectangle2D = shape.getBounds2D();
        if (rectangle2D.getWidth() == 0.0 || rectangle2D.getHeight() == 0.0) {
            return null;
        }
        return super.createShapePainter(bridgeContext, element, shapeNode);
    }
}

