/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.shell;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.tools.ToolErrorReporter;
import org.mozilla.javascript.tools.shell.Main;

class Runner
implements Runnable {
    private Scriptable scope;
    private Function f;
    private Script s;
    private Object[] args;

    Runner(Scriptable scope, Function func, Object[] args) {
        this.scope = scope;
        this.f = func;
        this.args = args;
    }

    Runner(Scriptable scope, Script script) {
        this.scope = scope;
        this.s = script;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        Context cx = Main.enterContext();
        try {
            try {
                if (this.f != null) {
                    this.f.call(cx, this.scope, this.scope, this.args);
                }
                this.s.exec(cx, this.scope);
            }
            catch (JavaScriptException e) {
                Context.reportError(ToolErrorReporter.getMessage("msg.uncaughtJSException", e.getMessage()));
                Object var4_3 = null;
                Context.exit();
                return;
            }
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            Context.exit();
            throw throwable;
        }
        Context.exit();
    }
}

