/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.fop.fonts.FontMetrics;

public class FontInfo {
    private Map usedFonts;
    private Map triplets = new HashMap();
    private Map fonts = new HashMap();

    public FontInfo() {
        this.usedFonts = new HashMap();
    }

    public boolean isSetupValid() {
        return this.triplets.containsKey("any,normal,400");
    }

    public void addFontProperties(String name, String family, String style, int weight) {
        String key = FontInfo.createFontKey(family, style, weight);
        this.triplets.put(key, name);
    }

    public void addMetrics(String name, FontMetrics metrics) {
        this.fonts.put(name, metrics);
    }

    public String fontLookup(String family, String style, int weight) {
        String key = FontInfo.createFontKey(family, style, weight);
        String f = (String)this.triplets.get(key);
        if (f == null) {
            f = this.findAdjustWeight(family, style, weight);
            if (f == null) {
                key = FontInfo.createFontKey("any", style, weight);
                f = (String)this.triplets.get(key);
            }
            if (f == null) {
                f = this.findAdjustWeight(family, style, weight);
            }
            if (f == null) {
                f = (String)this.triplets.get("any,normal,400");
            }
        }
        this.usedFonts.put(f, this.fonts.get(f));
        return f;
    }

    public String findAdjustWeight(String family, String style, int weight) {
        String key;
        String f = null;
        int newWeight = weight;
        if (newWeight < 400) {
            while (f == null && newWeight > 0) {
                key = FontInfo.createFontKey(family, style, newWeight -= 100);
                f = (String)this.triplets.get(key);
            }
        } else if (newWeight == 500) {
            key = FontInfo.createFontKey(family, style, 400);
            f = (String)this.triplets.get(key);
        } else if (newWeight > 500) {
            while (f == null && newWeight < 1000) {
                key = FontInfo.createFontKey(family, style, newWeight += 100);
                f = (String)this.triplets.get(key);
            }
            newWeight = weight;
            while (f == null && newWeight > 400) {
                key = FontInfo.createFontKey(family, style, newWeight -= 100);
                f = (String)this.triplets.get(key);
            }
        }
        if (f == null) {
            key = FontInfo.createFontKey(family, style, 400);
            f = (String)this.triplets.get(key);
        }
        return f;
    }

    public boolean hasFont(String family, String style, int weight) {
        String key = FontInfo.createFontKey(family, style, weight);
        return this.triplets.containsKey(key);
    }

    public static String createFontKey(String family, String style, int weight) {
        return family + "," + style + "," + weight;
    }

    public Map getFonts() {
        return Collections.unmodifiableMap(this.fonts);
    }

    public Map getUsedFonts() {
        return this.usedFonts;
    }

    public FontMetrics getMetricsFor(String fontName) {
        this.usedFonts.put(fontName, this.fonts.get(fontName));
        return (FontMetrics)this.fonts.get(fontName);
    }
}

