/*
* Copyright (c) 2005 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of the License "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description: 
*
*/

package com.nokia.sdt.component.symbian.test.srcmapping;

import com.nokia.sdt.component.symbian.ComponentSystemPlugin;
import com.nokia.sdt.component.symbian.reconcileProperty.ReconcilePropertyImplementationFactory;
import com.nokia.sdt.datamodel.adapter.IReconcileProperty;
import com.nokia.sdt.sourcegen.doms.rss.dom.*;

/**
 * Test CBA when generated by reference from an owning component 
 * 
 *
 */
public class SrcMappingTestCBA extends SrcMappingBase {

    static final String CONTAINER = "MyContainer";

    /* (non-Javadoc)
     * @see com.nokia.sdt.component.symbian.test.SrcMappingBase#setUp()
     */
    protected void setUp() throws Exception {
        super.setUp();
        
        // register the factory for reconciling properties
        ComponentSystemPlugin.initializeImplementationsRegistry();
        ReconcilePropertyImplementationFactory fac = new ReconcilePropertyImplementationFactory();
        
        ComponentSystemPlugin.getImplementationTypes().addInterface(
                IReconcileProperty.class.getName(),
                fac.getCodeImplAdapterClass(),
                fac.getScriptImplAdapterClass());
                
    }
    
    public void testCBABuiltin() throws Exception {
        exportInstance("com.nokia.sdt.series60.test.CBAHolder","testCBAHolder_Builtin");
        checkNoMessages();

        exportInstance("com.nokia.sdt.series60.test.CBA", "testCBA_Builtin");
        checkNoMessages();

        rewriteTu(tu);
        checkRefFile("ref/TestCBABuiltin.rss", sf);

        // make sure only one resource is written
        IAstResourceDefinition[] defs = tu.getResourceDefinitions();
        assertEquals(1, defs.length);
        
        // get the struct pointing to the builtin
        IAstResourceDefinition def = tu.findResourceDefinitionOfType("EIK_APP_INFO");
        assertNotNull(def);
        
        checkMemberInit(def, "cba", IAstIdExpression.class, "r_avkon_softkeys_options_exit");
    }

    public void testCBACustom() throws Exception {
        exportInstance("com.nokia.sdt.series60.test.CBAHolder","testCBAHolder_Custom");
        checkNoMessages();

        exportInstance("com.nokia.sdt.series60.test.CBA", "testCBA_Custom");
        checkNoMessages();
        
        rewriteTu(tu);
        checkRefFile("ref/TestCBACustom.rss", sf);

        // make sure four resources are written:
            // EIK_APP_INFO pointing to new CBA
            // CBA
            // two CBA_BUTTONs
        IAstResourceDefinition[] defs = tu.getResourceDefinitions();
        assertEquals(4, defs.length);
        
        // get the struct pointing to the custom CBA
        IAstResourceDefinition def = tu.findResourceDefinitionOfType("EIK_APP_INFO");
        assertNotNull(def);
        
        IAstMemberInitializer init = def.findMemberInitializer("cba");
        assertNotNull(init);

        IAstExpression expr = init.getInitializerExpression().getExpression();
        assertTrue(expr instanceof IAstIdExpression);
        IAstIdExpression id = ((IAstIdExpression) expr);
        
        // get the CBA
        IAstResourceDefinition cba = tu.findResourceDefinition(id.getName().getName());
        assertNotNull(cba);
        
        // make sure it specifies two initializers
        init = cba.findMemberInitializer("buttons");
        assertNotNull(init);
        
        expr = init.getInitializerExpression().getExpression();
        assertNotNull(expr);
        assertTrue(expr instanceof IAstExpressionList);
        IAstExpressionList elist = (IAstExpressionList) expr;
        
        // make sure each initializer is a CBA_BUTTON resource
        IAstExpression inits[] = elist.getList();
        assertEquals(2, inits.length);
        assertTrue(inits[0] instanceof IAstIdExpression);
        assertTrue(inits[1] instanceof IAstIdExpression);
        
        id = (IAstIdExpression) inits[0];
        IAstResourceDefinition cbabutton = tu.findResourceDefinition(id.getName().getName());
        assertNotNull(cbabutton);
        
        id = (IAstIdExpression) inits[1];
        IAstResourceDefinition cbabutton2 = tu.findResourceDefinition(id.getName().getName());
        assertNotNull(cbabutton2);
        
        // make sure they're not the same!
        // (this was a problem deriving resource names from property=".")
        assertNotSame(cbabutton, cbabutton2);
        
        assertEquals("CBA_BUTTON", cbabutton.getStructType().getStructName().getName());
        assertEquals("CBA_BUTTON", cbabutton2.getStructType().getStructName().getName());
        
        checkMemberInit(cbabutton,  "id", IAstIdExpression.class, "EAknSoftkeyOptions");
        checkMemberInit(cbabutton,  "txt", IAstLiteralExpression.K_STRING, "\"Options\"");

        // unique, using com.nokia.sdt.component.symbian.NAME_ALG_COMMANDS
        // instance name is testEnumUniqueness1
        // property name is theCmd

        checkMemberInit(cbabutton2,  "id", IAstIdExpression.class, 
                "E"+CONTAINER+"TestCBA_CustomRightId");
        checkMemberInit(cbabutton2,  "txt", IAstLiteralExpression.K_STRING, "\"Snork\"");
    }

    public void testCBA2Builtin() throws Exception {
        exportInstance("com.nokia.sdt.series60.test.CBAHolder2","testCBAHolder2_Builtin");
        checkNoMessages();

        exportInstance("com.nokia.sdt.series60.test.CBA", "testCBA2_Builtin");
        checkNoMessages();
        
        rewriteTu(tu);
        checkRefFile("ref/TestCBA2Builtin.rss", sf);

        // make sure only one resource is written
        IAstResourceDefinition[] defs = tu.getResourceDefinitions();
        assertEquals(1, defs.length);
        
        // get the struct pointing to the builtin
        IAstResourceDefinition def = tu.findResourceDefinitionOfType("EIK_APP_INFO");
        assertNotNull(def);
        
        checkMemberInit(def, "cba", IAstIdExpression.class, "r_avkon_softkeys_options_exit");
    }

    public void testCBA2Custom() throws Exception {
        exportInstance("com.nokia.sdt.series60.test.CBAHolder2","testCBAHolder2_Custom");
        checkNoMessages();

        exportInstance("com.nokia.sdt.series60.test.CBA", "testCBA2_Custom");
        checkNoMessages();
        
        rewriteTu(tu);
        checkRefFile("ref/TestCBA2Custom.rss", sf);

        // make sure four resources are written:
            // EIK_APP_INFO pointing to new CBA
            // CBA
            // two CBA_BUTTONs
        IAstResourceDefinition[] defs = tu.getResourceDefinitions();
        assertEquals(4, defs.length);
        
        // get the struct pointing to the custom CBA
        IAstResourceDefinition def = tu.findResourceDefinitionOfType("EIK_APP_INFO");
        assertNotNull(def);
        
        IAstMemberInitializer init = def.findMemberInitializer("cba");
        assertNotNull(init);

        IAstExpression expr = init.getInitializerExpression().getExpression();
        assertTrue(expr instanceof IAstIdExpression);
        IAstIdExpression id = ((IAstIdExpression) expr);
        
        // get the CBA
        IAstResourceDefinition cba = tu.findResourceDefinition(id.getName().getName());
        assertNotNull(cba);
        
        // make sure it specifies two initializers
        init = cba.findMemberInitializer("buttons");
        assertNotNull(init);
        
        expr = init.getInitializerExpression().getExpression();
        assertNotNull(expr);
        assertTrue(expr instanceof IAstExpressionList);
        IAstExpressionList elist = (IAstExpressionList) expr;
        
        // make sure each initializer is a CBA_BUTTON resource
        IAstExpression inits[] = elist.getList();
        assertEquals(2, inits.length);
        assertTrue(inits[0] instanceof IAstIdExpression);
        assertTrue(inits[1] instanceof IAstIdExpression);
        
        id = (IAstIdExpression) inits[0];
        IAstResourceDefinition cbabutton = tu.findResourceDefinition(id.getName().getName());
        assertNotNull(cbabutton);
        
        id = (IAstIdExpression) inits[1];
        IAstResourceDefinition cbabutton2 = tu.findResourceDefinition(id.getName().getName());
        assertNotNull(cbabutton2);
        
        // make sure they're not the same!
        // (this was a problem when deriving resource names from property=".")
        assertNotSame(cbabutton, cbabutton2);
        
        assertEquals("CBA_BUTTON", cbabutton.getStructType().getStructName().getName());
        assertEquals("CBA_BUTTON", cbabutton2.getStructType().getStructName().getName());
        
        checkMemberInit(cbabutton,  "id", IAstIdExpression.class, "EAknSoftkeyOptions");
        checkMemberInit(cbabutton,  "txt", IAstLiteralExpression.K_STRING, "\"Options\"");

        // unique, using com.nokia.sdt.component.symbian.NAME_ALG_COMMANDS
        // instance name is testEnumUniqueness1
        // property name is theCmd

        checkMemberInit(cbabutton2,  "id", IAstIdExpression.class, 
                "E"+CONTAINER+"TestCBA2_CustomRightId");
        checkMemberInit(cbabutton2,  "txt", IAstLiteralExpression.K_STRING, "\"Snork\"");
    }
    
    public void testCBAStandaloneBuiltin() throws Exception {
        exportInstance("com.nokia.sdt.series60.test.CBAstandalone", "testCBAstandalone_Builtin");
        checkNoMessages();
        
        rewriteTu(tu);
        checkRefFile("ref/TestCBAstandaloneBuiltin.rss", sf);

        // make sure only one resource is written
        IAstResourceDefinition[] defs = tu.getResourceDefinitions();
        assertEquals(1, defs.length);
        
        // get the struct pointing to the builtin
        IAstResourceDefinition def = tu.findResourceDefinitionOfType("EIK_APP_INFO");
        assertNotNull(def);
        
        checkMemberInit(def, "cba", IAstIdExpression.class, "r_avkon_softkeys_options_exit");
    }

    public void testCBAStandaloneCustom() throws Exception {
        exportInstance("com.nokia.sdt.series60.test.CBAstandalone", "testCBAstandalone_Custom");
        checkNoMessages();
        
        rewriteTu(tu);
        checkRefFile("ref/TestCBAstandaloneCustom.rss", sf);

        // make sure four resources are written:
            // EIK_APP_INFO pointing to new CBA
            // CBA
            // two CBA_BUTTONs
        IAstResourceDefinition[] defs = tu.getResourceDefinitions();
        assertEquals(4, defs.length);
        
        // get the struct pointing to the custom CBA
        IAstResourceDefinition def = tu.findResourceDefinitionOfType("EIK_APP_INFO");
        assertNotNull(def);
        
        IAstMemberInitializer init = def.findMemberInitializer("cba");
        assertNotNull(init);

        IAstExpression expr = init.getInitializerExpression().getExpression();
        assertTrue(expr instanceof IAstIdExpression);
        IAstIdExpression id = ((IAstIdExpression) expr);
        
        // get the CBA
        IAstResourceDefinition cba = tu.findResourceDefinition(id.getName().getName());
        assertNotNull(cba);
        
        // make sure it specifies two initializers
        init = cba.findMemberInitializer("buttons");
        assertNotNull(init);
        
        expr = init.getInitializerExpression().getExpression();
        assertNotNull(expr);
        assertTrue(expr instanceof IAstExpressionList);
        IAstExpressionList elist = (IAstExpressionList) expr;
        
        // make sure each initializer is a CBA_BUTTON resource
        IAstExpression inits[] = elist.getList();
        assertEquals(2, inits.length);
        assertTrue(inits[0] instanceof IAstIdExpression);
        assertTrue(inits[1] instanceof IAstIdExpression);
        
        id = (IAstIdExpression) inits[0];
        IAstResourceDefinition cbabutton = tu.findResourceDefinition(id.getName().getName());
        assertNotNull(cbabutton);
        
        id = (IAstIdExpression) inits[1];
        IAstResourceDefinition cbabutton2 = tu.findResourceDefinition(id.getName().getName());
        assertNotNull(cbabutton2);
        
        // make sure they're not the same!
        // (this was a problem when deriving resource names from property=".")
        assertNotSame(cbabutton, cbabutton2);
        
        assertEquals("CBA_BUTTON", cbabutton.getStructType().getStructName().getName());
        assertEquals("CBA_BUTTON", cbabutton2.getStructType().getStructName().getName());
        
        checkMemberInit(cbabutton,  "id", IAstIdExpression.class, "EAknSoftkeyOptions");
        checkMemberInit(cbabutton,  "txt", IAstLiteralExpression.K_STRING, "\"Options\"");

        // unique, using com.nokia.sdt.component.symbian.NAME_ALG_COMMANDS
        // instance name is testEnumUniqueness1
        // property name is theCmd

        checkMemberInit(cbabutton2,  "id", IAstIdExpression.class, 
                "E"+CONTAINER+"TestCBAstandalone_CustomRightId");
        checkMemberInit(cbabutton2,  "txt", IAstLiteralExpression.K_STRING, "\"Snork\"");
    }

}
