/*
* Copyright (c) 2006 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of the License "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description: 
*
*/


include("../implLibrary.js")
include("../renderLibrary.js")
include("../srcgenLibrary.js")

function StatusPaneContextVisual() {
}

StatusPaneContextVisual.prototype.draw = function(instance, laf, graphics) {
	var properties = instance.properties;
	
	if (laf.getBoolean("show.context.icon", true)) {
		graphics.setBackground(getBackgroundColor(instance, laf));

		// do not blend, since status pane has two different colors
		renderImage(StatusPaneContextVisual.prototype, instance, laf, graphics, 
			0, 0, "image", false);
	}
	
}

StatusPaneContextVisual.prototype.getViewableSize = function(instance, propertyId, laf) {
	var	size = instance.properties.size;
	return new Point(size.width, size.height);
}

StatusPaneContextVisual.prototype.isScaling = function(instance, propertyId, laf) {
	return isScalingIcons();
}

StatusPaneContextVisual.prototype.getAlignmentWeights = function(instance, propertyId, laf) {
	return new Point(ImageUtils.ALIGN_CENTER_OR_LEFT, ImageUtils.ALIGN_CENTER_OR_TOP);
}

StatusPaneContextVisual.prototype.isPreservingAspectRatio = function(instance, propertyId, laf) {
	return true;
}


StatusPaneContextVisual.prototype.getPreferredSize = function(instance, laf, wHint, hHint) {
	return null; // needs implementation	
}

setupCommonDirectImageEditing(StatusPaneContextVisual.prototype, "image", 
	null  // areafunction
)
