/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdScriptable;
import org.mozilla.javascript.NativeCall;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.UniqueTag;

class Arguments
extends IdScriptable {
    private static final int Id_callee = 1;
    private static final int Id_length = 2;
    private static final int Id_caller = 3;
    private static final int MAX_INSTANCE_ID = 3;
    private Object callerObj;
    private Object calleeObj;
    private Object lengthObj;
    private NativeCall activation;
    private Object[] args;

    public Arguments(NativeCall activation) {
        this.setMaxId(3);
        this.activation = activation;
        Scriptable parent = activation.getParentScope();
        this.setParentScope(parent);
        this.setPrototype(ScriptableObject.getObjectPrototype(parent));
        this.args = activation.getOriginalArguments();
        this.lengthObj = new Integer(this.args.length);
        NativeFunction funObj = activation.funObj;
        this.calleeObj = funObj;
        this.callerObj = funObj.version <= 130 && funObj.version != 0 ? null : Scriptable.NOT_FOUND;
    }

    public String getClassName() {
        return "Arguments";
    }

    public boolean has(int index, Scriptable start) {
        if (0 <= index && index < this.args.length && this.args[index] != Scriptable.NOT_FOUND) {
            return true;
        }
        return super.has(index, start);
    }

    public Object get(int index, Scriptable start) {
        Object value;
        if (0 <= index && index < this.args.length && (value = this.args[index]) != Scriptable.NOT_FOUND) {
            String argName;
            if (this.sharedWithActivation(index) && (value = this.activation.get(argName = this.activation.funObj.argNames[index], (Scriptable)this.activation)) == Scriptable.NOT_FOUND) {
                Context.codeBug();
            }
            return value;
        }
        return super.get(index, start);
    }

    private boolean sharedWithActivation(int index) {
        NativeFunction f = this.activation.funObj;
        short definedCount = f.argCount;
        if (index < definedCount) {
            if (index < definedCount - 1) {
                String argName = f.argNames[index];
                int i = index + 1;
                while (i < definedCount) {
                    if (argName.equals(f.argNames[i])) {
                        return false;
                    }
                    ++i;
                }
            }
            return true;
        }
        return false;
    }

    public void put(int index, Scriptable start, Object value) {
        if (0 <= index && index < this.args.length && this.args[index] != Scriptable.NOT_FOUND) {
            if (this.sharedWithActivation(index)) {
                String argName = this.activation.funObj.argNames[index];
                this.activation.put(argName, (Scriptable)this.activation, value);
                return;
            }
            Arguments arguments = this;
            synchronized (arguments) {
                if (this.args[index] != Scriptable.NOT_FOUND) {
                    if (this.args == this.activation.getOriginalArguments()) {
                        this.args = (Object[])this.args.clone();
                    }
                    this.args[index] = value;
                    return;
                }
            }
        }
        super.put(index, start, value);
    }

    public void delete(int index) {
        if (0 <= index && index < this.args.length) {
            Arguments arguments = this;
            synchronized (arguments) {
                if (this.args[index] != Scriptable.NOT_FOUND) {
                    if (this.args == this.activation.getOriginalArguments()) {
                        this.args = (Object[])this.args.clone();
                    }
                    this.args[index] = Scriptable.NOT_FOUND;
                    return;
                }
            }
        }
        super.delete(index);
    }

    protected int getIdDefaultAttributes(int id) {
        switch (id) {
            case 1: 
            case 2: 
            case 3: {
                return 2;
            }
        }
        return super.getIdDefaultAttributes(id);
    }

    protected boolean hasIdValue(int id) {
        switch (id) {
            case 1: {
                return this.calleeObj != Scriptable.NOT_FOUND;
            }
            case 2: {
                return this.lengthObj != Scriptable.NOT_FOUND;
            }
            case 3: {
                return this.callerObj != Scriptable.NOT_FOUND;
            }
        }
        return super.hasIdValue(id);
    }

    protected Object getIdValue(int id) {
        switch (id) {
            case 1: {
                return this.calleeObj;
            }
            case 2: {
                return this.lengthObj;
            }
            case 3: {
                Object value = this.callerObj;
                if (value == UniqueTag.NULL_VALUE) {
                    value = null;
                } else if (value == null) {
                    NativeCall caller = this.activation.caller;
                    value = caller == null ? null : caller.get("arguments", (Scriptable)caller);
                }
                return value;
            }
        }
        return super.getIdValue(id);
    }

    protected void setIdValue(int id, Object value) {
        switch (id) {
            case 1: {
                this.calleeObj = value;
                return;
            }
            case 2: {
                this.lengthObj = value;
                return;
            }
            case 3: {
                this.callerObj = value != null ? value : UniqueTag.NULL_VALUE;
                return;
            }
        }
        super.setIdValue(id, value);
    }

    protected void deleteIdValue(int id) {
        switch (id) {
            case 1: {
                this.calleeObj = Scriptable.NOT_FOUND;
                return;
            }
            case 2: {
                this.lengthObj = Scriptable.NOT_FOUND;
                return;
            }
            case 3: {
                this.callerObj = Scriptable.NOT_FOUND;
                return;
            }
        }
        super.deleteIdValue(id);
    }

    protected String getIdName(int id) {
        switch (id) {
            case 1: {
                return "callee";
            }
            case 2: {
                return "length";
            }
            case 3: {
                return "caller";
            }
        }
        return null;
    }

    protected int mapNameToId(String s) {
        int id = 0;
        String X = null;
        if (s.length() == 6) {
            char c = s.charAt(5);
            if (c == 'e') {
                X = "callee";
                id = 1;
            } else if (c == 'h') {
                X = "length";
                id = 2;
            } else if (c == 'r') {
                X = "caller";
                id = 3;
            }
        }
        if (X != null && X != s && !X.equals(s)) {
            id = 0;
        }
        return id;
    }
}

