/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.debugger;

import org.mozilla.javascript.tools.debugger.ScriptItem;

class SourceInfo {
    private String sourceUrl;
    private String source;
    private int endLine;
    private boolean[] breakableLines;
    private static final byte BREAK_FLAG = 1;
    private static final byte OLD_BREAK_FLAG = 2;
    private byte[] breakpoints;

    static String getShortName(String url) {
        int lastSlash = url.lastIndexOf(47);
        if (lastSlash < 0) {
            lastSlash = url.lastIndexOf(92);
        }
        String shortName = url;
        if (lastSlash >= 0 && lastSlash + 1 < url.length()) {
            shortName = url.substring(lastSlash + 1);
        }
        return shortName;
    }

    SourceInfo(String sourceUrl, String source) {
        this.sourceUrl = sourceUrl;
        this.source = source;
    }

    String getUrl() {
        return this.sourceUrl;
    }

    String getSource() {
        return this.source;
    }

    synchronized void setSource(String source) {
        if (!this.source.equals(source)) {
            this.source = source;
            this.endLine = 0;
            this.breakableLines = null;
            if (this.breakpoints != null) {
                int i = this.breakpoints.length - 1;
                while (i >= 0) {
                    if (this.breakpoints[i] == 1) {
                        this.breakpoints[i] = 2;
                    }
                    --i;
                }
            }
        }
    }

    synchronized void updateLineInfo(ScriptItem item) {
        int newLength;
        int[] lines = item.getScript().getLineNumbers();
        if (lines.length == 0) {
            return;
        }
        int fnFirstLine = lines[0];
        int fnEndLine = fnFirstLine + 1;
        int i = 1;
        while (i != lines.length) {
            int line = lines[i];
            if (line < fnFirstLine) {
                fnFirstLine = line;
            } else if (line >= fnEndLine) {
                fnEndLine = line + 1;
            }
            ++i;
        }
        item.setFirstLine(fnFirstLine);
        if (this.endLine < fnEndLine) {
            this.endLine = fnEndLine;
        }
        if (this.breakableLines == null) {
            newLength = 20;
            if (newLength < this.endLine) {
                newLength = this.endLine;
            }
            this.breakableLines = new boolean[newLength];
        } else if (this.breakableLines.length < this.endLine) {
            newLength = this.breakableLines.length * 2;
            if (newLength < this.endLine) {
                newLength = this.endLine;
            }
            boolean[] tmp = new boolean[newLength];
            System.arraycopy(this.breakableLines, 0, tmp, 0, this.breakableLines.length);
            this.breakableLines = tmp;
        }
        int breakpointsEnd = this.breakpoints == null ? 0 : this.breakpoints.length;
        int i2 = 0;
        while (i2 != lines.length) {
            int line = lines[i2];
            this.breakableLines[line] = true;
            if (line < breakpointsEnd && this.breakpoints[line] == 2) {
                this.breakpoints[line] = 1;
            }
            ++i2;
        }
    }

    boolean breakableLine(int line) {
        boolean[] breakableLines = this.breakableLines;
        if (breakableLines != null && line < breakableLines.length) {
            return breakableLines[line];
        }
        return false;
    }

    boolean hasBreakpoint(int line) {
        byte[] breakpoints = this.breakpoints;
        if (breakpoints != null && line < breakpoints.length) {
            return breakpoints[line] == 1;
        }
        return false;
    }

    synchronized boolean placeBreakpoint(int line) {
        if (this.breakableLine(line)) {
            if (this.breakpoints == null) {
                this.breakpoints = new byte[this.endLine];
            } else if (line >= this.breakpoints.length) {
                byte[] tmp = new byte[this.endLine];
                System.arraycopy(this.breakpoints, 0, tmp, 0, this.breakpoints.length);
                this.breakpoints = tmp;
            }
            this.breakpoints[line] = 1;
            return true;
        }
        return false;
    }

    synchronized boolean removeBreakpoint(int line) {
        boolean wasBreakpoint = false;
        if (this.breakpoints != null && line < this.breakpoints.length) {
            wasBreakpoint = this.breakpoints[line] != 1;
            this.breakpoints[line] = 0;
        }
        return wasBreakpoint;
    }

    synchronized void removeAllBreakpoints() {
        this.breakpoints = null;
    }
}

