/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image;

import java.awt.Color;
import org.apache.batik.ext.awt.image.Light;

public abstract class AbstractLight
implements Light {
    private double[] color;

    public static final double sRGBToLsRGB(double d) {
        if (d <= 0.003928) {
            return d / 12.92;
        }
        return Math.pow((d + 0.055) / 1.055, 2.4);
    }

    public double[] getColor(boolean bl) {
        double[] dArray = new double[3];
        if (bl) {
            dArray[0] = AbstractLight.sRGBToLsRGB(this.color[0]);
            dArray[1] = AbstractLight.sRGBToLsRGB(this.color[1]);
            dArray[2] = AbstractLight.sRGBToLsRGB(this.color[2]);
        } else {
            dArray[0] = this.color[0];
            dArray[1] = this.color[1];
            dArray[2] = this.color[2];
        }
        return dArray;
    }

    public AbstractLight(Color color) {
        this.setColor(color);
    }

    public void setColor(Color color) {
        this.color = new double[3];
        this.color[0] = (double)color.getRed() / 255.0;
        this.color[1] = (double)color.getGreen() / 255.0;
        this.color[2] = (double)color.getBlue() / 255.0;
    }

    public boolean isConstant() {
        return true;
    }

    public double[][][] getLightMap(double d, double d2, double d3, double d4, int n, int n2, double[][][] dArray) {
        double[][][] dArrayArray = new double[n2][][];
        for (int i = 0; i < n2; ++i) {
            dArrayArray[i] = this.getLightRow(d, d2, d3, n, dArray[i], null);
            d2 += d4;
        }
        return dArrayArray;
    }

    public double[][] getLightRow(double d, double d2, double d3, int n, double[][] dArray, double[][] dArray2) {
        double[][] dArray3 = dArray2;
        if (dArray3 == null) {
            dArray3 = new double[n][3];
        }
        for (int i = 0; i < n; ++i) {
            this.getLight(d, d2, dArray[i][3], dArray3[i]);
            d += d3;
        }
        return dArray3;
    }
}

