/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.optimizer;

import org.mozilla.classfile.JavaVariable;
import org.mozilla.javascript.VariableTable;
import org.mozilla.javascript.optimizer.TypeEvent;

final class OptLocalVariable
implements JavaVariable {
    private String itsName;
    private boolean itsIsParameter;
    private int itsIndex = -1;
    private short itsJRegister = (short)-1;
    private boolean itsLiveAcrossCall;
    private boolean itsIsNumber;
    private TypeEvent itsTypeUnion;
    private int initPC;

    public OptLocalVariable(String name, boolean isParameter) {
        this.itsName = name;
        this.itsIsParameter = isParameter;
        int typeEvent = isParameter ? 3 : 0;
        this.itsTypeUnion = new TypeEvent(typeEvent);
    }

    public String toString() {
        return "LocalVariable : '" + this.getName() + "', index = " + this.getIndex() + ", LiveAcrossCall = " + this.itsLiveAcrossCall + ", isNumber = " + this.itsIsNumber + ", isParameter = " + this.isParameter() + ", JRegister = " + this.itsJRegister;
    }

    public String getName() {
        return this.itsName;
    }

    public String getTypeDescriptor() {
        return this.isNumber() ? "D" : "Ljava/lang/Object;";
    }

    public short getJRegister() {
        return this.itsJRegister;
    }

    void assignJRegister(short aJReg) {
        this.itsJRegister = aJReg;
    }

    public int getStartPC() {
        return this.initPC;
    }

    int getIndex() {
        return this.itsIndex;
    }

    void setIndex(int index) {
        this.itsIndex = index;
    }

    void setStartPC(int pc) {
        this.initPC = pc;
    }

    void setIsNumber() {
        this.itsIsNumber = true;
    }

    boolean isNumber() {
        return this.itsIsNumber;
    }

    boolean isParameter() {
        return this.itsIsParameter;
    }

    void markLiveAcrossCall() {
        this.itsLiveAcrossCall = true;
    }

    void clearLiveAcrossCall() {
        this.itsLiveAcrossCall = false;
    }

    boolean isLiveAcrossCall() {
        return this.itsLiveAcrossCall;
    }

    boolean assignType(int aType) {
        return this.itsTypeUnion.add(aType);
    }

    int getTypeUnion() {
        return this.itsTypeUnion.getEvent();
    }

    static OptLocalVariable get(VariableTable vars, int index) {
        return (OptLocalVariable)vars.getVariable(index);
    }

    static OptLocalVariable get(VariableTable vars, String name) {
        return (OptLocalVariable)vars.getVariable(name);
    }

    static void establishIndices(VariableTable vars) {
        int N = vars.size();
        int i = 0;
        while (i != N) {
            OptLocalVariable.get((VariableTable)vars, (int)i).itsIndex = i;
            ++i;
        }
    }

    static OptLocalVariable[] toArray(VariableTable vars) {
        Object[] array = null;
        if (vars != null) {
            array = new OptLocalVariable[vars.size()];
            vars.getAllVariables(array);
        }
        return array;
    }
}

