/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.io.CopyUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;

public final class IOUtils {
    private static final int DEFAULT_BUFFER_SIZE = 4096;

    public static void closeQuietly(Reader input) {
        if (input == null) {
            return;
        }
        try {
            input.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeQuietly(Writer output) {
        if (output == null) {
            return;
        }
        try {
            output.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeQuietly(OutputStream output) {
        if (output == null) {
            return;
        }
        try {
            output.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeQuietly(InputStream input) {
        if (input == null) {
            return;
        }
        try {
            input.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static String toString(InputStream input) throws IOException {
        StringWriter sw = new StringWriter();
        CopyUtils.copy(input, (Writer)sw);
        return sw.toString();
    }

    public static String toString(InputStream input, String encoding) throws IOException {
        StringWriter sw = new StringWriter();
        CopyUtils.copy(input, (Writer)sw, encoding);
        return sw.toString();
    }

    public static byte[] toByteArray(InputStream input) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        CopyUtils.copy(input, (OutputStream)output);
        return output.toByteArray();
    }

    public static String toString(Reader input) throws IOException {
        StringWriter sw = new StringWriter();
        CopyUtils.copy(input, (Writer)sw);
        return sw.toString();
    }

    public static byte[] toByteArray(Reader input) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        CopyUtils.copy(input, (OutputStream)output);
        return output.toByteArray();
    }

    public static byte[] toByteArray(String input) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        CopyUtils.copy(input, (OutputStream)output);
        return output.toByteArray();
    }

    public static String toString(byte[] input) throws IOException {
        StringWriter sw = new StringWriter();
        CopyUtils.copy(input, (Writer)sw);
        return sw.toString();
    }

    public static String toString(byte[] input, String encoding) throws IOException {
        StringWriter sw = new StringWriter();
        CopyUtils.copy(input, (Writer)sw, encoding);
        return sw.toString();
    }

    public static boolean contentEquals(InputStream input1, InputStream input2) throws IOException {
        int ch2;
        BufferedInputStream bufferedInput1 = new BufferedInputStream(input1);
        BufferedInputStream bufferedInput2 = new BufferedInputStream(input2);
        int ch = ((InputStream)bufferedInput1).read();
        while (-1 != ch) {
            ch2 = ((InputStream)bufferedInput2).read();
            if (ch != ch2) {
                return false;
            }
            ch = ((InputStream)bufferedInput1).read();
        }
        ch2 = ((InputStream)bufferedInput2).read();
        return -1 == ch2;
    }
}

