/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen.font.table;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.batik.svggen.font.table.CmapFormat;

public class CmapFormat4
extends CmapFormat {
    public int language;
    private int segCountX2;
    private int searchRange;
    private int entrySelector;
    private int rangeShift;
    private int[] endCode;
    private int[] startCode;
    private int[] idDelta;
    private int[] idRangeOffset;
    private int[] glyphIdArray;
    private int segCount;
    private int first;
    private int last;

    protected CmapFormat4(RandomAccessFile randomAccessFile) throws IOException {
        super(randomAccessFile);
        int n;
        this.format = 4;
        this.segCountX2 = randomAccessFile.readUnsignedShort();
        this.segCount = this.segCountX2 / 2;
        this.endCode = new int[this.segCount];
        this.startCode = new int[this.segCount];
        this.idDelta = new int[this.segCount];
        this.idRangeOffset = new int[this.segCount];
        this.searchRange = randomAccessFile.readUnsignedShort();
        this.entrySelector = randomAccessFile.readUnsignedShort();
        this.rangeShift = randomAccessFile.readUnsignedShort();
        this.last = -1;
        for (n = 0; n < this.segCount; ++n) {
            this.endCode[n] = randomAccessFile.readUnsignedShort();
            if (this.endCode[n] <= this.last) continue;
            this.last = this.endCode[n];
        }
        randomAccessFile.readUnsignedShort();
        for (n = 0; n < this.segCount; ++n) {
            this.startCode[n] = randomAccessFile.readUnsignedShort();
            if (n != 0 && this.startCode[n] >= this.first) continue;
            this.first = this.startCode[n];
        }
        for (n = 0; n < this.segCount; ++n) {
            this.idDelta[n] = randomAccessFile.readUnsignedShort();
        }
        for (n = 0; n < this.segCount; ++n) {
            this.idRangeOffset[n] = randomAccessFile.readUnsignedShort();
        }
        n = (this.length - 16 - this.segCount * 8) / 2;
        this.glyphIdArray = new int[n];
        for (int i = 0; i < n; ++i) {
            this.glyphIdArray[i] = randomAccessFile.readUnsignedShort();
        }
    }

    public int getFirst() {
        return this.first;
    }

    public int getLast() {
        return this.last;
    }

    public int mapCharCode(int n) {
        try {
            if (n < 0 || n >= 65534) {
                return 0;
            }
            for (int i = 0; i < this.segCount; ++i) {
                if (this.endCode[i] < n) continue;
                if (this.startCode[i] <= n) {
                    if (this.idRangeOffset[i] > 0) {
                        return this.glyphIdArray[this.idRangeOffset[i] / 2 + (n - this.startCode[i]) - (this.segCount - i)];
                    }
                    return (this.idDelta[i] + n) % 65536;
                }
                break;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.err.println("error: Array out of bounds - " + arrayIndexOutOfBoundsException.getMessage());
        }
        return 0;
    }

    public String toString() {
        return super.toString() + ", segCountX2: " + this.segCountX2 + ", searchRange: " + this.searchRange + ", entrySelector: " + this.entrySelector + ", rangeShift: " + this.rangeShift + ", endCode: " + this.endCode + ", startCode: " + this.endCode + ", idDelta: " + this.idDelta + ", idRangeOffset: " + this.idRangeOffset;
    }
}

