/*
* Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of the License "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description: 
*
*/
/* Generated By:JavaCC: Do not edit this line. MMPParserCore.java */
package com.nokia.carbide.internal.cpp.epoc.engine.parser.generated;

import com.nokia.carbide.internal.api.cpp.epoc.engine.dom.*;
import com.nokia.carbide.internal.api.cpp.epoc.engine.dom.mmp.*;
import com.nokia.carbide.internal.cpp.epoc.engine.parser.*;
import com.nokia.carbide.internal.cpp.epoc.engine.parser.mmp.*;

import java.util.List;
import java.util.ArrayList;

public class MMPParserCore extends ParserBase implements MMPParserCoreConstants {
    public IASTMMPTranslationUnit parse() {
                IASTMMPTranslationUnit tu = ASTMMPFactory.createMMPTranslationUnit();
                try {
                        TranslationUnit(tu);
                } catch (ParseException e) {
                        hadErrors = true;
                        e.printStackTrace();
                }
                return tu;
    }

  final public void TranslationUnit(IASTMMPTranslationUnit tu) throws ParseException {
        IASTListNode<IASTMMPStatement> statements = null;
        Token eof;
    statements = Statements();
    eof = jj_consume_token(0);
                if (statements != null) {
                        tu.setNodes((IASTListNode)statements);
                        ParserUtils.setSourceRangeForListNode(null, tu.getNodes(), eof);
                        ParserUtils.copySourceInfo(tu, tu.getNodes());
                } else {
                        ParserUtils.setSourceRangeFromTokenSpan(tu.getNodes(), eof, eof);
                        ParserUtils.setSourceRangeFromTokenSpan(tu, eof, eof);
                }
  }

  IASTListNode<IASTMMPStatement> Statements() throws ParseException {
        IASTListNode<IASTMMPStatement> stmts = null;
        while (((jj_ntk==-1)?jj_ntk():jj_ntk) != EOF) {
                try {
                        IASTMMPStatement stmt = StatementOrProblem();
                        if (stmt != null) {
                                if (stmts == null) {
                                        stmts = ASTMMPFactory.createMMPStatementListNode();
                                }
                                stmts.add(stmt);
                        }
                } catch (ParseException e) {
                        hadErrors = true;
                        getNextToken();
                }
        }
        return stmts;
  }

  IASTMMPStatement createProblemStatement(Token start, Token end, ParseException e) throws ParseException {
        IASTMMPStatement stmt;

        if (end == null) {
                ppRestOfLine(false);
                end = token;
        }
        List<IToken> tokens = new ArrayList<IToken>();
        start = start.next;
        Token ptr = start;
        while (true) {
                if (ptr == null || ptr.kind == EOF)
                        break;
                tokens.add(((ASTToken)ptr).iToken);
                if (ptr == end)
                        break;
                ptr = ptr.next;
        }
        // special case for this token, which only ends blocks, and does not
        // show up as an UnknownStatement; thus, we need to keep moving or else
        // we report this problem ad infinitum
        if (start.kind == END) {
                getNextToken();
        }
        IASTPreprocessorTokenStream stream = ASTFactory.createPreprocessorTokenStream(tokens);
        ParserUtils.setSourceRangeForTokenStream(stream, stream);
        stmt = ASTMMPFactory.createMMPProblemStatement(stream, createMessage(start, e));
        ParserUtils.copySourceInfo(stmt, stream);
        ParserUtils.expandSourceRangeToLine(stmt);
        hadErrors = true;
        return stmt;
  }

  final public IASTMMPStatement StatementOrProblem() throws ParseException {
        IASTMMPStatement stmt;
        Token start = token;
    try {
      stmt = Statement();
                        {if (true) return stmt;}
    } catch (ParseException e) {
                {if (true) return createProblemStatement(start, null, e);}
    }
    throw new Error("Missing return statement in function");
  }

  final public IASTMMPStatement Statement() throws ParseException {
        IASTMMPStatement node;
        Token end = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case FLAG_STATEMENT:
    case SINGLE_ARGUMENT_STATEMENT:
    case ARGUMENT:
    case LIST_ARGUMENT_STATEMENT:
    case AIF:
    case BITMAP_SOURCE:
    case OPTION:
    case LINKEROPTION:
    case OPTION_REPLACE:
    case START:
    case UID:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case FLAG_STATEMENT:
        node = FlagStatement();
        break;
      case SINGLE_ARGUMENT_STATEMENT:
        node = SingleArgumentStatement();
        break;
      case LIST_ARGUMENT_STATEMENT:
        node = ListArgumentStatement();
        break;
      case AIF:
        node = AifStatement();
        break;
      case BITMAP_SOURCE:
        node = BitmapSourceStatement();
        break;
      case UID:
        node = UidStatement();
        break;
      case ARGUMENT:
        node = UnknownStatement();
        break;
      case OPTION:
      case LINKEROPTION:
      case OPTION_REPLACE:
        node = OptionStatement();
        break;
      case START:
        node = StartBlockStatement();
        break;
      default:
        jj_la1[0] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                if (node != null && end != null) {
                        ParserUtils.expandSourceRangeToLine(node);
                        ParserUtils.extendSourceRangeToInclude(node, end);
                }
                {if (true) return node;}
      break;
    case EOL:
      node = Empty();
                {if (true) return null;}
      break;
    default:
      jj_la1[1] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public IASTMMPStatement FlagStatement() throws ParseException {
        IASTMMPStatement node;
        Token start, eol;
    start = jj_consume_token(FLAG_STATEMENT);
    Arguments();
    eol = jj_consume_token(EOL);
                node = ASTMMPFactory.createMMPFlagStatement(
                        getLiteralTextNodeSpanning(start, start));
                ParserUtils.setSourceRangeFromTokenSpan(node, start, eol);
                {if (true) return node;}
    throw new Error("Missing return statement in function");
  }

  final public IASTMMPStatement SingleArgumentStatement() throws ParseException {
        IASTMMPStatement node;
        Token start, eol;
        Token arg;
    start = jj_consume_token(SINGLE_ARGUMENT_STATEMENT);
    arg = jj_consume_token(ARGUMENT);
    Arguments();
    eol = jj_consume_token(EOL);
                node = ASTMMPFactory.createMMPSingleArgumentStatement(
                        getLiteralTextNodeSpanning(start, start),
                        getLiteralTextNodeSpanning(arg, arg));
                ParserUtils.setSourceRangeFromTokenSpan(node, start, eol);
                {if (true) return node;}
    throw new Error("Missing return statement in function");
  }

  final public IASTMMPStatement ListArgumentStatement() throws ParseException {
        IASTMMPStatement node;
        Token start, eol;
        IASTListNode<IASTLiteralTextNode> args = null;
    start = jj_consume_token(LIST_ARGUMENT_STATEMENT);
    args = Arguments();
    eol = jj_consume_token(EOL);
                if (args.size() == 0)
                ParserUtils.setSourceRangeFromTokenAfter(args, start);

                node = ASTMMPFactory.createMMPListArgumentStatement(
                        getLiteralTextNodeSpanning(start, start),
                        args);
                ParserUtils.setSourceRangeFromTokenSpan(node, start, eol);
                {if (true) return node;}
    throw new Error("Missing return statement in function");
  }

  final public IASTLiteralTextNode Argument() throws ParseException {
        Token token = null;
    token = jj_consume_token(ARGUMENT);
                {if (true) return getLiteralTextNodeSpanning(token, token);}
    throw new Error("Missing return statement in function");
  }

  final public IASTListNode<IASTLiteralTextNode> Arguments() throws ParseException {
        IASTLiteralTextNode arg = null;
        IASTListNode<IASTLiteralTextNode> args = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ARGUMENT:
      args = ArgumentList();
      break;
    default:
      jj_la1[2] = jj_gen;
      ;
    }
                if (args == null) {
                        args = ASTFactory.createLiteralTextNodeList();
                        args.setSeparator(" ");
                }
                if (arg != null)
                        args.add(0, arg);
                ParserUtils.setSourceRangeForListNode(null, args, null);
                {if (true) return args;}
    throw new Error("Missing return statement in function");
  }

  final public IASTListNode<IASTLiteralTextNode> ArgumentList() throws ParseException {
        IASTLiteralTextNode arg = null;
        IASTListNode<IASTLiteralTextNode> args = null;
    arg = Argument();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ARGUMENT:
      args = ArgumentList();
      break;
    default:
      jj_la1[3] = jj_gen;
      ;
    }
                if (args == null) {
                        args = ASTFactory.createLiteralTextNodeList();
                }
                if (arg != null)
                        args.add(0, arg);
                {if (true) return args;}
    throw new Error("Missing return statement in function");
  }

  final public IASTMMPStatement AifStatement() throws ParseException {
        IASTMMPStatement node;
        Token start, eol;
        Token targetfile, sourcepath, resource;
        IASTListNode<IASTLiteralTextNode> colorDepthAndBitmaps = null;
    start = jj_consume_token(AIF);
    targetfile = jj_consume_token(ARGUMENT);
    sourcepath = jj_consume_token(ARGUMENT);
    resource = jj_consume_token(ARGUMENT);
    colorDepthAndBitmaps = Arguments();
    eol = jj_consume_token(EOL);
                IASTLiteralTextNode colorDepth = null;
        if (colorDepthAndBitmaps.size() > 0) {
                colorDepth = colorDepthAndBitmaps.remove(0);
                ParserUtils.setSourceRangeForListNode(resource, colorDepthAndBitmaps, null);
        } else {
                ParserUtils.setSourceRangeFromTokenSpanUpTo(colorDepthAndBitmaps, resource, resource);
        }
                node = ASTMMPFactory.createMMPAifStatement(
                        getLiteralTextNodeSpanning(targetfile, targetfile),
                        getLiteralTextNodeSpanning(sourcepath, sourcepath),
                        getLiteralTextNodeSpanning(resource, resource),
                        colorDepth,
                        colorDepthAndBitmaps);
                ParserUtils.setSourceRangeFromTokenSpan(node, start, eol);
                {if (true) return node;}
    throw new Error("Missing return statement in function");
  }

  final public IASTMMPStatement BitmapSourceStatement() throws ParseException {
        IASTMMPStatement node;
        Token start, eol;
        Token colorDepth;
        IASTListNode<IASTLiteralTextNode> bitmaps = null;
    start = jj_consume_token(BITMAP_SOURCE);
    colorDepth = jj_consume_token(ARGUMENT);
    bitmaps = Arguments();
    eol = jj_consume_token(EOL);
                if (bitmaps.size() == 0)
                ParserUtils.setSourceRangeFromTokenAfter(bitmaps, colorDepth);

                node = ASTMMPFactory.createMMPBitmapSourceStatement(
                        getLiteralTextNodeSpanning(colorDepth, colorDepth),
                        bitmaps);
                ParserUtils.setSourceRangeFromTokenSpan(node, start, eol);
                {if (true) return node;}
    throw new Error("Missing return statement in function");
  }

  final public IASTMMPStatement OptionStatement() throws ParseException {
        IASTMMPStatement node;
        Token start, eol;
        Token compiler;
        IASTListNode<IASTLiteralTextNode> option = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case OPTION:
      start = jj_consume_token(OPTION);
      break;
    case LINKEROPTION:
      start = jj_consume_token(LINKEROPTION);
      break;
    case OPTION_REPLACE:
      start = jj_consume_token(OPTION_REPLACE);
      break;
    default:
      jj_la1[4] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    compiler = jj_consume_token(ARGUMENT);
    option = Arguments();
    eol = jj_consume_token(EOL);
                node = ASTMMPFactory.createMMPOptionStatement(
                        getLiteralTextNodeSpanning(start, start),
                        getLiteralTextNodeSpanning(compiler, compiler),
                        option);
                ParserUtils.setSourceRangeFromTokenSpan(node, start, eol);
                ParserUtils.expandSourceRangeToLine(node);
                {if (true) return node;}
    throw new Error("Missing return statement in function");
  }

  final public IASTMMPStatement StartBlockStatement() throws ParseException {
        IASTMMPStatement node;
        Token start, end;
        Token blocktype, eol;
        IASTListNode<IASTLiteralTextNode> arguments = null;
        IASTListNode<IASTMMPStatement> statements = null;
        IASTLiteralTextNode extra = null;
    start = jj_consume_token(START);
    blocktype = jj_consume_token(ARGUMENT);
          ((MMPTokenManager) token_source).setBlockType(blocktype.image);
    arguments = Arguments();
    eol = jj_consume_token(EOL);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case FLAG_STATEMENT:
    case EOL:
    case SINGLE_ARGUMENT_STATEMENT:
    case ARGUMENT:
    case LIST_ARGUMENT_STATEMENT:
    case AIF:
    case BITMAP_SOURCE:
    case OPTION:
    case LINKEROPTION:
    case OPTION_REPLACE:
    case START:
    case UID:
      statements = StatementList();
      break;
    default:
      jj_la1[5] = jj_gen;
      ;
    }
    end = jj_consume_token(END);
    extra = ppRestOfLine(true);
          ((MMPTokenManager) token_source).setBlockType(null);
                if (arguments.size() == 0)
                ParserUtils.setSourceRangeFromTokenAfter(arguments, blocktype);
                if (statements == null) {
                        statements = ASTMMPFactory.createMMPStatementListNode();
                ParserUtils.setSourceRangeFromTokenAfter(statements, eol);
                }

                ParserUtils.setSourceRangeForListNode(eol, statements, end);
                node = ASTMMPFactory.createMMPStartBlockStatement(
                        getLiteralTextNodeSpanning(blocktype, blocktype),
                        arguments,
                        statements);
                //ParserUtils.setSourceRangeFromTokenSpan(node, start, end);
                ParserUtils.setSourceRangeFromTokenSpan(node, start, eol);
                ParserUtils.extendSourceRangeToInclude(node, statements);
                ParserUtils.extendSourceRangeToInclude(node, end);
                ParserUtils.extendSourceRangeToInclude(node, extra);
                ParserUtils.expandSourceRangeToLine(node);
                {if (true) return node;}
    throw new Error("Missing return statement in function");
  }

  final public IASTListNode<IASTMMPStatement> StatementList() throws ParseException {
        IASTMMPStatement statement;
        IASTListNode<IASTMMPStatement> list = null;
    statement = StatementOrProblem();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case FLAG_STATEMENT:
    case EOL:
    case SINGLE_ARGUMENT_STATEMENT:
    case ARGUMENT:
    case LIST_ARGUMENT_STATEMENT:
    case AIF:
    case BITMAP_SOURCE:
    case OPTION:
    case LINKEROPTION:
    case OPTION_REPLACE:
    case START:
    case UID:
      list = StatementList();
      break;
    default:
      jj_la1[6] = jj_gen;
      ;
    }
                if (statement != null) {
                        if (list == null)
                                list = ASTMMPFactory.createMMPStatementListNode();
                        list.add(0, statement);
                        ParserUtils.expandSourceRangeToLine(statement);
                }
                {if (true) return list;}
    throw new Error("Missing return statement in function");
  }

  final public IASTMMPStatement UidStatement() throws ParseException {
        IASTMMPStatement node;
        Token start, eol;
        Token uid2 = null, uid3 = null;
    start = jj_consume_token(UID);
    uid2 = jj_consume_token(ARGUMENT);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ARGUMENT:
      uid3 = jj_consume_token(ARGUMENT);
      break;
    default:
      jj_la1[7] = jj_gen;
      ;
    }
    eol = jj_consume_token(EOL);
                node = ASTMMPFactory.createMMPUidStatement(
                        getLiteralTextNodeSpanning(uid2, uid2),
                        getLiteralTextNodeSpanning(uid3, uid3));
                ParserUtils.setSourceRangeFromTokenSpan(node, start, eol);
                {if (true) return node;}
    throw new Error("Missing return statement in function");
  }

/**
 *	Non-empty text which is unrecognized.  If it doesn't follow the
 *	pattern <IDENTIFIER> ... then it's probably a parse error.
 */
  final public IASTMMPStatement UnknownStatement() throws ParseException {
        IASTMMPStatement node;
        Token errorStart = token;
        Token start, eol;
        IASTListNode<IASTLiteralTextNode> arguments = null;
    start = jj_consume_token(ARGUMENT);
    arguments = Arguments();
    eol = jj_consume_token(EOL);
                if (start.image.matches("\\w+")) {
                        if (arguments.size() == 0)
                        ParserUtils.setSourceRangeFromTokenAfter(arguments, start);

                        node = ASTMMPFactory.createMMPUnknownStatement(
                                getLiteralTextNodeSpanning(start, start),
                                arguments);
                        ParserUtils.setSourceRangeFromTokenSpan(node, start, eol);
            ParserUtils.expandSourceRangeToLine(node);
                        {if (true) return node;}
                } else {
                        {if (true) return createProblemStatement(errorStart, eol,
                                new ParseException("Invalid statement keyword token: " + start));}
                }
    throw new Error("Missing return statement in function");
  }

/**
 *	Empty line.
 */
  final public IASTMMPStatement Empty() throws ParseException {
    jj_consume_token(EOL);
                {if (true) return null;}
    throw new Error("Missing return statement in function");
  }

  final public IASTLiteralTextNode ppRestOfLine(boolean skip) throws ParseException {
        Token start = token, end = start;
        if (skip)
                start = end = getNextToken();
        if (end.kind != EOL && end.kind != EOF) {
                while (true) {
                        end = getNextToken();
                        if (end.kind == EOL || end.kind == EOF)
                                break;
                }
            }
                {if (true) return getLiteralTextNodeSpanningUpTo(start, end);}
    throw new Error("Missing return statement in function");
  }

  public TokenManager token_source;
  public Token token, jj_nt;
  private int jj_ntk;
  private int jj_gen;
  final private int[] jj_la1 = new int[8];
  static private int[] jj_la1_0;
  static {
      jj_la1_0();
   }
   private static void jj_la1_0() {
      jj_la1_0 = new int[] {0x2ffa,0x2ffe,0x10,0x10,0x700,0x2ffe,0x2ffe,0x10,};
   }


  public MMPParserCore(TokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 8; i++) jj_la1[i] = -1;
  }

  public void ReInit(TokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 8; i++) jj_la1[i] = -1;
  }

  final private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

  final public Token getToken(int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  final private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.Vector jj_expentries = new java.util.Vector();
  private int[] jj_expentry;
  private int jj_kind = -1;

  public ParseException generateParseException() {
    jj_expentries.removeAllElements();
    boolean[] la1tokens = new boolean[14];
    for (int i = 0; i < 14; i++) {
      la1tokens[i] = false;
    }
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 8; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 14; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.addElement(jj_expentry);
      }
    }
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = (int[])jj_expentries.elementAt(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  final public void enable_tracing() {
  }

  final public void disable_tracing() {
  }

}
