/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.batik.ext.awt.image.codec.PNGImageEncoder;
import org.apache.batik.svggen.AbstractImageHandlerEncoder;
import org.apache.batik.svggen.SVGGraphics2DIOException;

public class ImageHandlerPNGEncoder
extends AbstractImageHandlerEncoder {
    public ImageHandlerPNGEncoder(String string, String string2) throws SVGGraphics2DIOException {
        super(string, string2);
    }

    public final String getSuffix() {
        return ".png";
    }

    public final String getPrefix() {
        return "pngImage";
    }

    public void encodeImage(BufferedImage bufferedImage, File file) throws SVGGraphics2DIOException {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            PNGImageEncoder pNGImageEncoder = new PNGImageEncoder((OutputStream)fileOutputStream, null);
            pNGImageEncoder.encode((RenderedImage)bufferedImage);
            ((OutputStream)fileOutputStream).close();
        }
        catch (IOException iOException) {
            throw new SVGGraphics2DIOException("could not write image File " + file.getName());
        }
    }

    public BufferedImage buildBufferedImage(Dimension dimension) {
        return new BufferedImage(dimension.width, dimension.height, 2);
    }
}

