/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.awt.color.ICC_Profile;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.fop.pdf.PDFColorSpace;
import org.apache.fop.pdf.PDFStream;

public class PDFICCStream
extends PDFStream {
    private int origLength;
    private int len1;
    private int len3;
    private ICC_Profile cp = null;
    private PDFColorSpace pdfColorSpace;

    public void setColorSpace(ICC_Profile cp, PDFColorSpace alt) {
        this.cp = cp;
        this.pdfColorSpace = alt;
    }

    protected int output(OutputStream stream) throws IOException {
        int length = super.output(stream);
        this.cp = null;
        return length;
    }

    protected void outputRawStreamData(OutputStream out) throws IOException {
        this.cp.write(out);
    }

    protected String buildStreamDict(String lengthEntry) {
        String filterEntry = this.getFilterList().buildFilterDictEntries();
        StringBuffer sb = new StringBuffer(128);
        sb.append(this.getObjectID());
        sb.append("<< ");
        sb.append("/N " + this.cp.getNumComponents());
        if (this.pdfColorSpace != null) {
            sb.append("\n/Alternate /" + this.pdfColorSpace.getColorSpacePDFString() + " ");
        }
        sb.append("\n/Length " + lengthEntry);
        sb.append("\n" + filterEntry);
        sb.append("\n>>\n");
        return sb.toString();
    }
}

