/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.image.analyser;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.image.EPSImage;
import org.apache.fop.image.FopImage;
import org.apache.fop.image.analyser.ImageReader;

public class EPSReader
implements ImageReader {
    private static final byte[] EPS_HEADER_ASCII = "%!PS".getBytes();
    private static final byte[] BOUNDINGBOX = "%%BoundingBox: ".getBytes();

    public FopImage.ImageInfo verifySignature(String uri, InputStream bis, FOUserAgent ua) throws IOException {
        boolean isEPS = false;
        bis.mark(32);
        byte[] header = new byte[30];
        bis.read(header, 0, 30);
        bis.reset();
        EPSImage.EPSData data = new EPSImage.EPSData();
        if (this.getLong(header, 0) == -959196987L) {
            data.isAscii = false;
            isEPS = true;
            data.psStart = this.getLong(header, 4);
            data.psLength = this.getLong(header, 8);
            data.wmfStart = this.getLong(header, 12);
            data.wmfLength = this.getLong(header, 16);
            data.tiffStart = this.getLong(header, 20);
            data.tiffLength = this.getLong(header, 24);
        } else {
            byte[] epsh = "%!PS".getBytes();
            if (EPS_HEADER_ASCII[0] == header[0] && EPS_HEADER_ASCII[1] == header[1] && EPS_HEADER_ASCII[2] == header[2] && EPS_HEADER_ASCII[3] == header[3]) {
                data.isAscii = true;
                isEPS = true;
            }
        }
        if (isEPS) {
            FopImage.ImageInfo info = new FopImage.ImageInfo();
            info.mimeType = this.getMimeType();
            info.data = data;
            this.readEPSImage(bis, data);
            data.bbox = this.readBBox(data);
            if (data.bbox != null) {
                info.width = (int)(data.bbox[2] - data.bbox[0]);
                info.height = (int)(data.bbox[3] - data.bbox[1]);
                bis.close();
                info.inputStream = null;
                return info;
            }
            isEPS = false;
        }
        return null;
    }

    public String getMimeType() {
        return "image/eps";
    }

    private long getLong(byte[] buf, int idx) {
        int b1 = buf[idx] & 0xFF;
        int b2 = buf[idx + 1] & 0xFF;
        int b3 = buf[idx + 2] & 0xFF;
        int b4 = buf[idx + 3] & 0xFF;
        return b4 << 24 | b3 << 16 | b2 << 8 | b1;
    }

    private void readEPSImage(InputStream bis, EPSImage.EPSData data) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] readBuf = new byte[20480];
        boolean index = false;
        boolean cont = true;
        try {
            int bytesRead;
            while ((bytesRead = bis.read(readBuf)) != -1) {
                baos.write(readBuf, 0, bytesRead);
            }
        }
        catch (IOException ex) {
            throw new IOException("Error while loading EPS image: " + ex.getMessage());
        }
        byte[] file = baos.toByteArray();
        if (data.isAscii) {
            data.rawEps = null;
            data.epsFile = new byte[file.length];
            System.arraycopy(file, 0, data.epsFile, 0, data.epsFile.length);
        } else {
            data.rawEps = new byte[file.length];
            data.epsFile = new byte[(int)data.psLength];
            System.arraycopy(file, 0, data.rawEps, 0, data.rawEps.length);
            System.arraycopy(data.rawEps, (int)data.psStart, data.epsFile, 0, (int)data.psLength);
        }
    }

    public byte[] getPreview(EPSImage.EPSData data) {
        if (data.preview == null && data.tiffLength > 0L) {
            data.preview = new byte[(int)data.tiffLength];
            System.arraycopy(data.rawEps, (int)data.tiffStart, data.preview, 0, (int)data.tiffLength);
        }
        return data.preview;
    }

    private long[] readBBox(EPSImage.EPSData data) {
        long[] mbbox = null;
        int idx = 0;
        boolean found = false;
        while (!found && data.epsFile.length > idx + BOUNDINGBOX.length) {
            boolean sfound = true;
            int i = idx;
            i = idx;
            while (sfound && i - idx < BOUNDINGBOX.length) {
                if (BOUNDINGBOX[i - idx] != data.epsFile[i]) {
                    sfound = false;
                }
                ++i;
            }
            if (sfound) {
                found = true;
                idx = i;
                continue;
            }
            ++idx;
        }
        if (!found) {
            return mbbox;
        }
        mbbox = new long[4];
        idx += this.readLongString(data, mbbox, 0, idx);
        idx += this.readLongString(data, mbbox, 1, idx);
        idx += this.readLongString(data, mbbox, 2, idx);
        idx += this.readLongString(data, mbbox, 3, idx);
        return mbbox;
    }

    private int readLongString(EPSImage.EPSData data, long[] mbbox, int i, int idx) {
        int nidx;
        while (idx < data.epsFile.length && data.epsFile[idx] == 32) {
            ++idx;
        }
        for (nidx = idx; nidx < data.epsFile.length && (data.epsFile[nidx] >= 48 && data.epsFile[nidx] <= 57 || data.epsFile[nidx] == 45 || data.epsFile[nidx] == 46); ++nidx) {
        }
        byte[] num = new byte[nidx - idx];
        System.arraycopy(data.epsFile, idx, num, 0, nidx - idx);
        String ns = new String(num);
        mbbox[i] = (long)Math.ceil(Double.parseDouble(ns));
        return 1 + nidx - idx;
    }
}

