/*
========================================================================
 Name		: VerticalLabel.cpp

 Description: 

 Copyright (c) 2006 Nokia Corporation and/or its subsidiary(-ies).
 All rights reserved.
 This component and the accompanying materials are made available
 under the terms of the License "Eclipse Public License v1.0"
 which accompanies this distribution, and is available
 at the URL "http://www.eclipse.org/legal/epl-v10.html".

 Contributors:
 Nokia Corporation - initial contribution.
========================================================================
*/

#include "VerticalLabel.h"
#include <eikenv.h>
#include <barsread.h>

CVerticalLabel::CVerticalLabel() 
 : iText(NULL), iLineSize(1) 
 {}
 
CVerticalLabel::~CVerticalLabel()
	{
 	delete iText;
 	}
 
void CVerticalLabel::ConstructFromResourceL(TResourceReader& aReader)
	{
		iLineSize = aReader.ReadInt16();
		iText = aReader.ReadHBufCL();	
	}

void CVerticalLabel::Draw(const TRect& aRect) const
	{
		if (iText != NULL) 
			{
			CWindowGc &gc = SystemGc();
			const CFont *normalFont = iEikonEnv->NormalFont();
			gc.UseFont(normalFont);
							
			TRect r = Rect();
			r.Shrink(iLineSize+1, iLineSize+1);
			int baselineOffset = normalFont->AscentInPixels();
			gc.DrawTextVertical(*iText, r, baselineOffset, ETrue);
			
			if (iLineSize > 0)
				{
				TSize penSize(iLineSize, iLineSize);
				gc.SetPenSize(penSize);
				gc.DrawRect(Rect());
				}
			}
	}
	

void CVerticalLabel::SizeChanged()
	{
		
	}