/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.renderable;

import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderContext;
import org.apache.batik.ext.awt.color.ICCColorSpaceExt;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.ext.awt.image.renderable.AbstractRable;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.ext.awt.image.rendered.CachableRed;
import org.apache.batik.ext.awt.image.rendered.ProfileRed;

public class ProfileRable
extends AbstractRable {
    private ICCColorSpaceExt colorSpace;

    public ProfileRable(Filter filter, ICCColorSpaceExt iCCColorSpaceExt) {
        super(filter);
        this.colorSpace = iCCColorSpaceExt;
    }

    public void setSource(Filter filter) {
        this.init(filter, null);
    }

    public Filter getSource() {
        return (Filter)this.getSources().get(0);
    }

    public void setColorSpace(ICCColorSpaceExt iCCColorSpaceExt) {
        this.touch();
        this.colorSpace = iCCColorSpaceExt;
    }

    public ICCColorSpaceExt getColorSpace() {
        return this.colorSpace;
    }

    public RenderedImage createRendering(RenderContext renderContext) {
        RenderedImage renderedImage = this.getSource().createRendering(renderContext);
        if (renderedImage == null) {
            return null;
        }
        CachableRed cachableRed = GraphicsUtil.wrap(renderedImage);
        return new ProfileRed(cachableRed, this.colorSpace);
    }
}

