/*
* Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of the License "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description: 
* This interface maintains the data generated by the preprocessor.
*
*
*/
package com.nokia.carbide.internal.api.cpp.epoc.engine.preprocessor;

import com.nokia.carbide.internal.api.cpp.epoc.engine.dom.*;
import com.nokia.carbide.internal.cpp.epoc.engine.preprocessor.IConditionalBlock;

import java.io.File;
import java.util.Collection;
import java.util.Map;
public interface IPreprocessorResults {

	/**
	 * Get the original (preparsed) translation unit.
	 * @return TU with preprocessor directives and unexpanded macros;
	 * does not represent the #included files
	 * @see #get
	 */
	IASTTranslationUnit getOriginalTranslationUnit();
	
	/**
	 * Get the preprocessed translation unit
	 * @return TU without preprocessor directives, only with
	 * IASTPreprocessorTokenStreamStatements or IASTProblemTopLevelNodes
	 */
	IASTTranslationUnit getFilteredTranslationUnit();
	
	/**
	 * Get the filepaths referenced during the parse (excluding the toplevel)
	 * @return collection of #included files
	 */
	Collection<File> getReferencedFiles();

	/**
	 * Get the translation unit that was created for the given
	 * preparsed #include node, either in the main preparsed
	 * TU or in another TU returned from this one.
	 * @param include the preparsed #include statement
	 * @return the TU that was returned and parsed for that #include,
	 * or null if (1) the file was not found or (2) the #include
	 * was not expanded because it was in a false #if
	 */
	IASTTranslationUnit getTranslationUnitFor(IASTPreprocessorIncludeStatement include);

	/**
	 * Get the translation unit for the given path.
	 * @param include the full path to the file
	 * @return the TU that was returned and parsed for that #include,
	 * or null if (1) the file was not generated
	 */
	IASTTranslationUnit getTranslationUnitFor(File file);

	/**
	 * Replace a translation unit with another version
	 * @param file
	 * @param tu
	 */
	void replaceTranslationUnitFor(File file, IASTTranslationUnit tu);

	/**
	 * Get the root conditional block for the #ifdef structure of the file
	 * (regardless of the view filter, the whole structure is represented
	 * here, though the blocks only contain nodes for the filtered content).
	 * @return IConditionalBlock, never null
	 */
	IConditionalBlock getRootBlock();

	/**
	 * Tell whether the preprocessor nodes were expanded with variant macros.
	 * @param ppStmts
	 * @return
	 */
	boolean nodesUseVariantMacros(IASTNode[] ppStmts);

	/**
	 * Tell whether the node's source range includes macro expansions
	 * (but not of non-variant macros)
	 * @param node
	 * @return flag
	 */
	boolean nodeReferencesVariantMacros(IASTNode node);
	
	/**
	 * Tell whether the node's source range includes macro expansions that
	 * do not completely cover the node or a single child (ignoring non-variant macros)
	 * @param subNode
	 * @return true: macro expansion exists and obscures child, false:
	 * either no macro expansions or expansion completely contained in parent
	 */
	boolean nodeContainsNonSpanningVariantMacros(IASTNode node);
	
	/**
	 * Turn off the macro-using flag for this line.
	 * @param node
	 */
	void unsetNodeUsesMacros(IASTNode node);

	/**
	 * Return the map of nodes to blocks
	 * @return
	 */
	Map<IASTNode, IConditionalBlock> getNodeToBlockMap();
}
