/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.engine;

import org.apache.batik.css.engine.CSSEngine;
import org.apache.batik.css.engine.value.Value;

public class StyleMap {
    public static final short IMPORTANT_MASK = 1;
    public static final short COMPUTED_MASK = 2;
    public static final short NULL_CASCADED_MASK = 4;
    public static final short INHERITED_MASK = 8;
    public static final short LINE_HEIGHT_RELATIVE_MASK = 16;
    public static final short FONT_SIZE_RELATIVE_MASK = 32;
    public static final short COLOR_RELATIVE_MASK = 64;
    public static final short PARENT_RELATIVE_MASK = 128;
    public static final short BLOCK_WIDTH_RELATIVE_MASK = 256;
    public static final short BLOCK_HEIGHT_RELATIVE_MASK = 512;
    public static final short BOX_RELATIVE_MASK = 1024;
    public static final short ORIGIN_MASK = -8192;
    public static final short USER_AGENT_ORIGIN = 0;
    public static final short USER_ORIGIN = 8192;
    public static final short NON_CSS_ORIGIN = 16384;
    public static final short AUTHOR_ORIGIN = 24576;
    public static final short INLINE_AUTHOR_ORIGIN = Short.MIN_VALUE;
    protected Value[] values;
    protected short[] masks;
    protected boolean fixedCascadedValues;

    public StyleMap(int n) {
        this.values = new Value[n];
        this.masks = new short[n];
    }

    public boolean hasFixedCascadedValues() {
        return this.fixedCascadedValues;
    }

    public void setFixedCascadedStyle(boolean bl) {
        this.fixedCascadedValues = bl;
    }

    public Value getValue(int n) {
        return this.values[n];
    }

    public short getMask(int n) {
        return this.masks[n];
    }

    public boolean isImportant(int n) {
        return (this.masks[n] & 1) != 0;
    }

    public boolean isComputed(int n) {
        return (this.masks[n] & 2) != 0;
    }

    public boolean isNullCascaded(int n) {
        return (this.masks[n] & 4) != 0;
    }

    public boolean isInherited(int n) {
        return (this.masks[n] & 8) != 0;
    }

    public short getOrigin(int n) {
        return (short)(this.masks[n] & 0xFFFFE000);
    }

    public boolean isColorRelative(int n) {
        return (this.masks[n] & 0x40) != 0;
    }

    public boolean isParentRelative(int n) {
        return (this.masks[n] & 0x80) != 0;
    }

    public boolean isLineHeightRelative(int n) {
        return (this.masks[n] & 0x10) != 0;
    }

    public boolean isFontSizeRelative(int n) {
        return (this.masks[n] & 0x20) != 0;
    }

    public boolean isBlockWidthRelative(int n) {
        return (this.masks[n] & 0x100) != 0;
    }

    public boolean isBlockHeightRelative(int n) {
        return (this.masks[n] & 0x200) != 0;
    }

    public void putValue(int n, Value value) {
        this.values[n] = value;
    }

    public void putMask(int n, short s) {
        this.masks[n] = s;
    }

    public void putImportant(int n, boolean bl) {
        if (bl) {
            int n2 = n;
            this.masks[n2] = (short)(this.masks[n2] | 1);
        } else {
            int n3 = n;
            this.masks[n3] = (short)(this.masks[n3] & 0xFFFFFFFE);
        }
    }

    public void putOrigin(int n, short s) {
        int n2 = n;
        this.masks[n2] = (short)(this.masks[n2] & 0x1FFF);
        int n3 = n;
        this.masks[n3] = (short)(this.masks[n3] | (short)(s & 0xFFFFE000));
    }

    public void putComputed(int n, boolean bl) {
        if (bl) {
            int n2 = n;
            this.masks[n2] = (short)(this.masks[n2] | 2);
        } else {
            int n3 = n;
            this.masks[n3] = (short)(this.masks[n3] & 0xFFFFFFFD);
        }
    }

    public void putNullCascaded(int n, boolean bl) {
        if (bl) {
            int n2 = n;
            this.masks[n2] = (short)(this.masks[n2] | 4);
        } else {
            int n3 = n;
            this.masks[n3] = (short)(this.masks[n3] & 0xFFFFFFFB);
        }
    }

    public void putInherited(int n, boolean bl) {
        if (bl) {
            int n2 = n;
            this.masks[n2] = (short)(this.masks[n2] | 8);
        } else {
            int n3 = n;
            this.masks[n3] = (short)(this.masks[n3] & 0xFFFFFFF7);
        }
    }

    public void putColorRelative(int n, boolean bl) {
        if (bl) {
            int n2 = n;
            this.masks[n2] = (short)(this.masks[n2] | 0x40);
        } else {
            int n3 = n;
            this.masks[n3] = (short)(this.masks[n3] & 0xFFFFFFBF);
        }
    }

    public void putParentRelative(int n, boolean bl) {
        if (bl) {
            int n2 = n;
            this.masks[n2] = (short)(this.masks[n2] | 0x80);
        } else {
            int n3 = n;
            this.masks[n3] = (short)(this.masks[n3] & 0xFFFFFF7F);
        }
    }

    public void putLineHeightRelative(int n, boolean bl) {
        if (bl) {
            int n2 = n;
            this.masks[n2] = (short)(this.masks[n2] | 0x10);
        } else {
            int n3 = n;
            this.masks[n3] = (short)(this.masks[n3] & 0xFFFFFFEF);
        }
    }

    public void putFontSizeRelative(int n, boolean bl) {
        if (bl) {
            int n2 = n;
            this.masks[n2] = (short)(this.masks[n2] | 0x20);
        } else {
            int n3 = n;
            this.masks[n3] = (short)(this.masks[n3] & 0xFFFFFFDF);
        }
    }

    public void putBlockWidthRelative(int n, boolean bl) {
        if (bl) {
            int n2 = n;
            this.masks[n2] = (short)(this.masks[n2] | 0x100);
        } else {
            int n3 = n;
            this.masks[n3] = (short)(this.masks[n3] & 0xFFFFFEFF);
        }
    }

    public void putBlockHeightRelative(int n, boolean bl) {
        if (bl) {
            int n2 = n;
            this.masks[n2] = (short)(this.masks[n2] | 0x200);
        } else {
            int n3 = n;
            this.masks[n3] = (short)(this.masks[n3] & 0xFFFFFDFF);
        }
    }

    public String toString(CSSEngine cSSEngine) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.values.length; ++i) {
            Value value = this.values[i];
            if (value == null) continue;
            stringBuffer.append(cSSEngine.getPropertyName(i));
            stringBuffer.append(": ");
            stringBuffer.append(value);
            if (this.isImportant(i)) {
                stringBuffer.append(" !important");
            }
            stringBuffer.append(";\n");
        }
        return stringBuffer.toString();
    }
}

