// -*- Mode: C++; -*-
//                            Package   : omniORB2
// remoteIdentity.h           Created on: 16/6/99
//                            Author    : David Riddoch (djr)
//
//    Copyright (C) 1996-1999 AT&T Research Cambridge
//
//    This file is part of the omniORB library.
//
//    The omniORB library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Library General Public
//    License as published by the Free Software Foundation; either
//    version 2 of the License, or (at your option) any later version.
//
//    This library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Library General Public License for more details.
//
//    You should have received a copy of the GNU Library General Public
//    License along with this library; if not, write to the Free
//    Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
//    02111-1307, USA
//
//
// Description:
//    Encapsulation of the identity of a remote object implementation.
//      
 
/*
  $Log: remoteIdentity.h,v $
  Revision 1.1  2004/11/09 15:48:02  cortell
  Initial rev

  Revision 1.1.4.6  2002/11/29 14:03:41  dgrisby
  Rearrange declarations to make Code Warrior happy.

  Revision 1.1.4.5  2001/09/19 17:26:47  dpg1
  Full clean-up after orb->destroy().

  Revision 1.1.4.4  2001/09/03 16:52:05  sll
  New signature for locateRequest. Now accept a calldescriptor argument.

  Revision 1.1.4.3  2001/08/22 13:31:31  dpg1
  Christof's fixes for gcc 3.0.1.

  Revision 1.1.4.2  2001/08/15 10:26:10  dpg1
  New object table behaviour, correct POA semantics.

  Revision 1.1.4.1  2001/04/18 17:18:14  sll
  Big checkin with the brand new internal APIs.
  These files were relocated and scoped with the omni namespace.

  Revision 1.2.2.3  2000/10/03 17:41:45  sll
  Make sure object key is copied in ctor.

  Revision 1.2.2.2  2000/09/27 17:46:29  sll
  New data member pd_ior and the new ctor signature to match.

  Revision 1.2.2.1  2000/07/17 10:35:40  sll
  Merged from omni3_develop the diff between omni3_0_0_pre3 and omni3_0_0.

  Revision 1.3  2000/07/13 15:26:03  dpg1
  Merge from omni3_develop for 3.0 release.

  Revision 1.1.2.1  1999/09/22 14:26:26  djr
  Major rewrite of orbcore to support POA.

*/

#ifndef __OMNIORB_REMOTEIDENTITY_H__
#define __OMNIORB_REMOTEIDENTITY_H__

#include <omniIdentity.h>

OMNI_NAMESPACE_BEGIN(omni)

class omniRemoteIdentity_RefHolder;

OMNI_NAMESPACE_END(omni)

class omniRemoteIdentity : public omniIdentity {
public:
  static void* thisClassCompare(omniIdentity*, void*);

  inline omniRemoteIdentity(omniIOR* ior, 
			    const CORBA::Octet* key,
			    CORBA::ULong keysize,
			    _OMNI_NS(Rope)* rope,
			    classCompare_fn compare = thisClassCompare)
    : omniIdentity(key, keysize, compare),
      pd_refCount(0),
      pd_ior(ior),
      pd_rope(rope)
    {
      ASSERT_OMNI_TRACEDMUTEX_HELD(*omni::internalLock, 1);
      ++identity_count;
    }
  // Consumes <ior> and <rope>.  Copies <key>.  Constructs an identity
  // with ref count of 0.

  virtual void dispatch(omniCallDescriptor&);
  virtual void gainRef(omniObjRef* obj = 0);
  virtual void loseRef(omniObjRef* obj = 0);
  virtual omniIdentity::equivalent_fn get_real_is_equivalent() const;
  // Overrides omniIdentity.

  inline _OMNI_NS(Rope)* rope() const { return pd_rope; }
  // This function is thread-safe.  Does not increment
  // the reference count of the rope.

  virtual void locateRequest(omniCallDescriptor&);
  // If this returns normally, then the object exists.
  // Throws OBJECT_NOT_EXIST, or omniORB::LOCATION_FORWARD
  // otherwise.
  // Caller must hold <internalLock>. On return or raised exception, the
  // lock is released.

  virtual _CORBA_Boolean inThisAddressSpace();
  // Override omniIdentity.

  static inline omniRemoteIdentity* downcast(omniIdentity* id)
  {
    return (omniRemoteIdentity*)(id->classCompare()
				 (id, (void*)thisClassCompare));
  }

private:
  friend class _OMNI_NS(omniRemoteIdentity_RefHolder);

  ~omniRemoteIdentity();

  omniRemoteIdentity(const omniRemoteIdentity&);
  omniRemoteIdentity& operator = (const omniRemoteIdentity&);
  // Not implemented.


  int              pd_refCount;
  omniIOR*         pd_ior;
  _OMNI_NS(Rope)*  pd_rope;
  // Immutable.

  static _CORBA_Boolean real_is_equivalent(const omniIdentity*,
					   const omniIdentity*);

};

#endif  // __OMNIORB_REMOTEIDENTITY_H__
