/*
 * Copyright (c) 2006 Nokia Corporation and/or its subsidiary(-ies).
 * All rights reserved.
 * This component and the accompanying materials are made available
 * under the terms of the License "Eclipse Public License v1.0"
 * which accompanies this distribution, and is available
 * at the URL "http://www.eclipse.org/legal/epl-v10.html".
 *
 * Initial Contributors:
 * Nokia Corporation - initial contribution.
 *
 * Contributors:
 *
 * Description: 
 *
 */

include("ComponentUtils.js")

function EqualContainer() {

}

/**
  Lay out children.
 */
 
EqualContainer.prototype.layout = function(instance, laf) {
	var properties = instance.properties;
	
	var width = properties.size.width;
	var height = properties.size.height;
	var padding = properties.padding;
	var kids = getLayoutChildren(instance.children);

	if (properties.direction == "horizontal") {
		var rawChildSize = width / kids.length;
		var childSize = Math.max(rawChildSize - padding, 1);
		
		var col = 0;
		for (var i in instance.children) {
			var child = kids[i];
			child.properties.location.x = childSize * col + padding / 2;
			child.properties.location.y = 0;
			++col;
			child.properties.size.width = childSize;
			child.properties.size.height = height;
		}
	} else {
		var rawChildSize = height / kids.length;
		var childSize = Math.max(rawChildSize - padding, 1);
		
		var row = 0;
		for (var i in instance.children) {
			var child = kids[i];
			child.properties.location.x = 0;
			child.properties.location.y = childSize * row + padding / 2;
			++row;
			child.properties.size.width = width;
			child.properties.size.height = childSize;
		}
	
	}
	
}

EqualContainer.prototype.getPreferredSize = function(instance, laf, wHint, hHint) {
	return null;
}

