/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.lang.reflect.Method;
import org.mozilla.javascript.ClassShutter;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.FunctionObject;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeJavaClass;
import org.mozilla.javascript.PropertyException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Wrapper;

public class NativeJavaPackage
extends ScriptableObject {
    static final String[] commonPackages = new String[]{"java.lang", "java.lang.reflect", "java.io", "java.math", "java.util", "java.util.zip", "java.text", "java.text.resources", "java.applet"};
    private String packageName;
    private ClassLoader classLoader;
    static /* synthetic */ Class class$org$mozilla$javascript$NativeJavaPackage;

    public static Scriptable init(Scriptable scope) throws PropertyException {
        TopLevelPackage packages = new TopLevelPackage();
        packages.setPrototype(ScriptableObject.getObjectPrototype(scope));
        packages.setParentScope(scope);
        NativeJavaPackage javaAlias = (NativeJavaPackage)packages.get("java", (Scriptable)packages);
        ScriptableObject global = (ScriptableObject)scope;
        global.defineProperty("Packages", packages, 2);
        global.defineProperty("java", javaAlias, 2);
        int i = 0;
        while (i < commonPackages.length) {
            packages.forcePackage(commonPackages[i]);
            ++i;
        }
        Method[] m = FunctionObject.findMethods(class$org$mozilla$javascript$NativeJavaPackage == null ? (class$org$mozilla$javascript$NativeJavaPackage = NativeJavaPackage.class$("org.mozilla.javascript.NativeJavaPackage")) : class$org$mozilla$javascript$NativeJavaPackage, "jsFunction_getClass");
        FunctionObject f = new FunctionObject("getClass", m[0], global);
        global.defineProperty("getClass", f, 2);
        return packages;
    }

    void forcePackage(String name) {
        NativeJavaPackage pkg;
        String id;
        Object cached;
        int end = name.indexOf(46);
        if (end == -1) {
            end = name.length();
        }
        if ((cached = super.get(id = name.substring(0, end), (Scriptable)this)) != null && cached instanceof NativeJavaPackage) {
            pkg = (NativeJavaPackage)cached;
        } else {
            String newPackage = this.packageName.length() == 0 ? id : this.packageName + "." + id;
            pkg = new NativeJavaPackage(newPackage, this.classLoader);
            pkg.setParentScope(this);
            pkg.setPrototype(this.prototype);
            super.put(id, (Scriptable)this, (Object)pkg);
        }
        if (end < name.length()) {
            pkg.forcePackage(name.substring(end + 1));
        }
    }

    public NativeJavaPackage(String packageName) {
        this(packageName, null);
    }

    public NativeJavaPackage(String packageName, ClassLoader classLoader) {
        this.packageName = packageName;
        this.classLoader = classLoader != null ? classLoader : Context.getContext().getApplicationClassLoader();
    }

    public String getClassName() {
        return "JavaPackage";
    }

    public boolean has(String id, Scriptable start) {
        return true;
    }

    public boolean has(int index, Scriptable start) {
        return false;
    }

    public void put(String id, Scriptable start, Object value) {
    }

    public void put(int index, Scriptable start, Object value) {
        throw Context.reportRuntimeError0("msg.pkg.int");
    }

    public Object get(String id, Scriptable start) {
        return this.getPkgProperty(id, start, true);
    }

    public Object get(int index, Scriptable start) {
        return Scriptable.NOT_FOUND;
    }

    synchronized Object getPkgProperty(String name, Scriptable start, boolean createPkg) {
        Class cl;
        Object cached = super.get(name, start);
        if (cached != Scriptable.NOT_FOUND) {
            return cached;
        }
        String newPackage = this.packageName.length() == 0 ? name : this.packageName + '.' + name;
        Context cx = Context.getContext();
        ClassShutter shutter = cx.getClassShutter();
        Scriptable newValue = null;
        if ((shutter == null || shutter.visibleToScripts(newPackage)) && (cl = NativeJavaPackage.findClass(this.classLoader, newPackage)) != null) {
            newValue = new NativeJavaClass(ScriptableObject.getTopLevelScope(this), cl);
            newValue.setParentScope(this);
            newValue.setPrototype(this.prototype);
        }
        if (newValue == null && createPkg) {
            NativeJavaPackage pkg = new NativeJavaPackage(newPackage, this.classLoader);
            pkg.setParentScope(this);
            pkg.setPrototype(this.prototype);
            newValue = pkg;
        }
        if (newValue != null) {
            super.put(name, start, newValue);
        }
        return newValue;
    }

    public Object getDefaultValue(Class ignored) {
        return this.toString();
    }

    public String toString() {
        return "[JavaPackage " + this.packageName + "]";
    }

    public static Scriptable jsFunction_getClass(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        if (args.length > 0 && args[0] instanceof Wrapper) {
            int index;
            String propName;
            Object prop;
            Scriptable result = ScriptableObject.getTopLevelScope(thisObj);
            Class<?> cl = ((Wrapper)args[0]).unwrap().getClass();
            String name = "Packages." + cl.getName();
            int offset = 0;
            while ((prop = result.get(propName = (index = name.indexOf(46, offset)) == -1 ? name.substring(offset) : name.substring(offset, index), result)) instanceof Scriptable) {
                result = (Scriptable)prop;
                if (index == -1) {
                    return result;
                }
                offset = index + 1;
            }
        }
        throw Context.reportRuntimeError(Context.getMessage0("msg.not.java.obj"));
    }

    private static Class findClass(ClassLoader loader, String className) {
        Class<?> cl = null;
        if (loader != null) {
            try {
                cl = loader.loadClass(className);
            }
            catch (ClassNotFoundException ex) {
            }
            catch (LinkageError ex) {
            }
            catch (SecurityException ex) {}
        } else {
            try {
                cl = Class.forName(className);
            }
            catch (ClassNotFoundException ex) {
            }
            catch (LinkageError ex) {
            }
            catch (SecurityException ex) {
                // empty catch block
            }
        }
        return cl;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class TopLevelPackage
    extends NativeJavaPackage
    implements Function {
        public TopLevelPackage() {
            super("");
        }

        public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) throws JavaScriptException {
            return this.construct(cx, scope, args);
        }

        public Scriptable construct(Context cx, Scriptable scope, Object[] args) throws JavaScriptException {
            ClassLoader loader = this.getClassLoaderFromArgs(args);
            if (loader == null) {
                Context.reportRuntimeError0("msg.not.classloader");
                return null;
            }
            return new NativeJavaPackage("", loader);
        }

        private ClassLoader getClassLoaderFromArgs(Object[] args) {
            if (args.length < 1) {
                return null;
            }
            Object arg = args[0];
            if (arg instanceof Wrapper) {
                arg = ((Wrapper)arg).unwrap();
            }
            if (!(arg instanceof ClassLoader)) {
                return null;
            }
            return (ClassLoader)arg;
        }
    }
}

