/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.Cursor;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import org.apache.batik.bridge.AbstractGraphicsNodeBridge;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.bridge.UnitProcessor;
import org.apache.batik.css.engine.CSSImportedElementRoot;
import org.apache.batik.dom.AbstractDocument;
import org.apache.batik.dom.svg.SVGOMCSSImportedElementRoot;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.dom.svg.SVGOMUseElement;
import org.apache.batik.dom.util.XLinkSupport;
import org.apache.batik.gvt.CompositeGraphicsNode;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.parser.UnitProcessor;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.events.MutationEvent;

public class SVGUseElementBridge
extends AbstractGraphicsNodeBridge {
    protected ReferencedElementMutationListener l;
    protected BridgeContext subCtx = null;

    public String getLocalName() {
        return "use";
    }

    public Bridge getInstance() {
        return new SVGUseElementBridge();
    }

    public GraphicsNode createGraphicsNode(BridgeContext bridgeContext, Element element) {
        if (!SVGUtilities.matchUserAgent(element, bridgeContext.getUserAgent())) {
            return null;
        }
        CompositeGraphicsNode compositeGraphicsNode = this.buildCompositeGraphicsNode(bridgeContext, element, null);
        return compositeGraphicsNode;
    }

    public CompositeGraphicsNode buildCompositeGraphicsNode(BridgeContext bridgeContext, Element element, CompositeGraphicsNode compositeGraphicsNode) {
        EventTarget eventTarget;
        Rectangle2D rectangle2D;
        Object object;
        Object object2;
        int n;
        Object object3;
        Object object4;
        Object object5;
        String string = XLinkSupport.getXLinkHref((Element)element);
        if (string.length() == 0) {
            throw new BridgeException(element, "attribute.missing", new Object[]{"xlink:href"});
        }
        Element element2 = bridgeContext.getReferencedElement(element, string);
        SVGOMDocument sVGOMDocument = (SVGOMDocument)element.getOwnerDocument();
        SVGOMDocument sVGOMDocument2 = (SVGOMDocument)element2.getOwnerDocument();
        boolean bl = sVGOMDocument2 == sVGOMDocument;
        BridgeContext bridgeContext2 = bridgeContext;
        this.subCtx = null;
        if (!bl) {
            object5 = sVGOMDocument2.getCSSEngine();
            bridgeContext2 = this.subCtx = (BridgeContext)sVGOMDocument2.getCSSEngine().getCSSContext();
        }
        if ("symbol".equals((object5 = (Element)sVGOMDocument.importNode((Node)element2, true, true)).getLocalName())) {
            object4 = sVGOMDocument.createElementNS("http://www.w3.org/2000/svg", "svg");
            object3 = object5.getAttributes();
            n = object3.getLength();
            for (int i = 0; i < n; ++i) {
                object2 = (Attr)object3.item(i);
                object4.setAttributeNS(object2.getNamespaceURI(), object2.getName(), object2.getValue());
            }
            object = object5.getFirstChild();
            while (object != null) {
                object4.appendChild((Node)object);
                object = object5.getFirstChild();
            }
            object5 = object4;
        }
        if ("svg".equals(object5.getLocalName())) {
            object4 = element.getAttributeNS(null, "width");
            if (((String)object4).length() != 0) {
                object5.setAttributeNS(null, "width", (String)object4);
            }
            if (((String)(object3 = element.getAttributeNS(null, "height"))).length() != 0) {
                object5.setAttributeNS(null, "height", (String)object3);
            }
        }
        object4 = new SVGOMCSSImportedElementRoot((AbstractDocument)sVGOMDocument, element, bl);
        object4.appendChild((Node)object5);
        if (compositeGraphicsNode == null) {
            compositeGraphicsNode = new CompositeGraphicsNode();
        } else {
            int n2 = compositeGraphicsNode.size();
            for (n = 0; n < n2; ++n) {
                compositeGraphicsNode.remove(0);
            }
        }
        SVGOMUseElement sVGOMUseElement = (SVGOMUseElement)element;
        CSSImportedElementRoot cSSImportedElementRoot = sVGOMUseElement.getCSSImportedElementRoot();
        if (cSSImportedElementRoot != null) {
            SVGUseElementBridge.disposeTree((Node)cSSImportedElementRoot);
        }
        sVGOMUseElement.setCSSImportedElementRoot((CSSImportedElementRoot)object4);
        object = object5;
        CSSUtilities.computeStyleAndURIs(element2, (Element)object5, string);
        object2 = bridgeContext.getGVTBuilder();
        GraphicsNode graphicsNode = ((GVTBuilder)object2).build(bridgeContext, (Element)object);
        compositeGraphicsNode.getChildren().add(graphicsNode);
        compositeGraphicsNode.setTransform(this.computeTransform(element, bridgeContext));
        compositeGraphicsNode.setVisible(CSSUtilities.convertVisibility(element));
        RenderingHints renderingHints = null;
        renderingHints = CSSUtilities.convertColorRendering(element, renderingHints);
        if (renderingHints != null) {
            compositeGraphicsNode.setRenderingHints(renderingHints);
        }
        if ((rectangle2D = CSSUtilities.convertEnableBackground(element)) != null) {
            compositeGraphicsNode.setBackgroundEnable(rectangle2D);
        }
        if (this.l != null) {
            eventTarget = this.l.target;
            eventTarget.removeEventListener("DOMAttrModified", this.l, true);
            eventTarget.removeEventListener("DOMNodeInserted", this.l, true);
            eventTarget.removeEventListener("DOMNodeRemoved", this.l, true);
            eventTarget.removeEventListener("DOMCharacterDataModified", this.l, true);
            this.l = null;
        }
        if (bl && bridgeContext.isDynamic()) {
            this.l = new ReferencedElementMutationListener();
            this.l.target = eventTarget = (EventTarget)((Object)element2);
            eventTarget.addEventListener("DOMAttrModified", this.l, true);
            bridgeContext2.storeEventListener(eventTarget, "DOMAttrModified", this.l, true);
            eventTarget.addEventListener("DOMNodeInserted", this.l, true);
            bridgeContext2.storeEventListener(eventTarget, "DOMNodeInserted", this.l, true);
            eventTarget.addEventListener("DOMNodeRemoved", this.l, true);
            bridgeContext2.storeEventListener(eventTarget, "DOMNodeRemoved", this.l, true);
            eventTarget.addEventListener("DOMCharacterDataModified", this.l, true);
            bridgeContext2.storeEventListener(eventTarget, "DOMCharacterDataModified", this.l, true);
        }
        return compositeGraphicsNode;
    }

    public void dispose() {
        EventTarget eventTarget;
        if (this.l != null) {
            eventTarget = this.l.target;
            eventTarget.removeEventListener("DOMAttrModified", this.l, true);
            eventTarget.removeEventListener("DOMNodeInserted", this.l, true);
            eventTarget.removeEventListener("DOMNodeRemoved", this.l, true);
            eventTarget.removeEventListener("DOMCharacterDataModified", this.l, true);
            this.l = null;
        }
        if ((eventTarget = (SVGOMUseElement)this.e) != null && eventTarget.getCSSImportedElementRoot() != null) {
            SVGUseElementBridge.disposeTree((Node)eventTarget.getCSSImportedElementRoot());
        }
        super.dispose();
        this.subCtx = null;
    }

    protected AffineTransform computeTransform(Element element, BridgeContext bridgeContext) {
        UnitProcessor.Context context = UnitProcessor.createContext(bridgeContext, element);
        float f = 0.0f;
        String string = element.getAttributeNS(null, "x");
        if (string.length() != 0) {
            f = UnitProcessor.svgHorizontalCoordinateToUserSpace(string, "x", context);
        }
        float f2 = 0.0f;
        string = element.getAttributeNS(null, "y");
        if (string.length() != 0) {
            f2 = UnitProcessor.svgVerticalCoordinateToUserSpace(string, "y", context);
        }
        string = element.getAttributeNS(null, "transform");
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(f, f2);
        if (string.length() != 0) {
            affineTransform.preConcatenate(SVGUtilities.convertTransform(element, "transform", string));
        }
        return affineTransform;
    }

    protected GraphicsNode instantiateGraphicsNode() {
        return null;
    }

    public boolean isComposite() {
        return false;
    }

    public void buildGraphicsNode(BridgeContext bridgeContext, Element element, GraphicsNode graphicsNode) {
        super.buildGraphicsNode(bridgeContext, element, graphicsNode);
        if (bridgeContext.isInteractive()) {
            EventTarget eventTarget = (EventTarget)((Object)element);
            CursorMouseOverListener cursorMouseOverListener = new CursorMouseOverListener(bridgeContext);
            eventTarget.addEventListener("mouseover", cursorMouseOverListener, false);
            bridgeContext.storeEventListener(eventTarget, "mouseover", cursorMouseOverListener, false);
        }
    }

    public void handleDOMAttrModifiedEvent(MutationEvent mutationEvent) {
        String string = mutationEvent.getAttrName();
        Node node = mutationEvent.getRelatedNode();
        if (node.getNamespaceURI() == null && (string.equals("x") || string.equals("y") || string.equals("transform"))) {
            this.node.setTransform(this.computeTransform(this.e, this.ctx));
            this.handleGeometryChanged();
        } else if (node.getNamespaceURI() == null && (string.equals("width") || string.equals("height")) || "http://www.w3.org/1999/xlink".equals(node.getNamespaceURI()) && "href".equals(node.getLocalName())) {
            this.buildCompositeGraphicsNode(this.ctx, this.e, (CompositeGraphicsNode)this.node);
        }
    }

    public class ReferencedElementMutationListener
    implements EventListener {
        EventTarget target;

        public void handleEvent(Event event) {
            SVGUseElementBridge.this.buildCompositeGraphicsNode(SVGUseElementBridge.this.ctx, SVGUseElementBridge.this.e, (CompositeGraphicsNode)SVGUseElementBridge.this.node);
        }
    }

    public static class CursorMouseOverListener
    implements EventListener {
        protected BridgeContext ctx;

        public CursorMouseOverListener(BridgeContext bridgeContext) {
            this.ctx = bridgeContext;
        }

        public void handleEvent(Event event) {
            Cursor cursor;
            Element element = (Element)((Object)event.getCurrentTarget());
            if (!CSSUtilities.isAutoCursor(element) && (cursor = CSSUtilities.convertCursor(element, this.ctx)) != null) {
                this.ctx.getUserAgent().setSVGCursor(cursor);
            }
        }
    }
}

