/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.HTI.ScreenCapturingService;

import com.nokia.HTI.BaseService;
import com.nokia.HTI.HTIException;
import com.nokia.HTI.HTIMessage;
import com.nokia.HTI.IService;
import com.nokia.HTI.ScreenCapturingService.HTIFont;
import com.nokia.HTI.ScreenCapturingService.HTIScreenMode;
import com.nokia.HTI.ScreenCapturingService.HTITextRecognitionResult;
import com.nokia.HTI.ScreenCapturingService.MessageFactory;
import com.nokia.HTI.common.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScreenCapturingService
extends BaseService
implements IService {
    private final Logger log = Logger.getLogger(this.getClass().getName());

    public byte[] captureFullScreen(String imgMimeType, byte colorDepth, boolean zipped) throws HTIException, IOException {
        return this.captureFullScreen(imgMimeType, colorDepth, zipped, 0L);
    }

    public byte[] captureFullScreen(String imgMimeType, byte colorDepth, boolean zipped, long timeout) throws HTIException, IOException {
        this.log.info("Capturing full screen with mime type " + imgMimeType + ", zipped = " + zipped);
        byte[] imgData = null;
        HTIMessage command = MessageFactory.createCaptureFullScreenMessage(imgMimeType, colorDepth, zipped);
        HTIMessage response = this.sendHTIRequest(command, timeout);
        if (!response.isErrorResponse()) {
            imgData = response.getBody();
        }
        return imgData;
    }

    public byte[] captureFullScreen(String imgMimeType, byte colorDepth) throws HTIException, IOException {
        return this.captureFullScreen(imgMimeType, colorDepth, false);
    }

    public byte[] captureFullScreen(String imgMimeType, byte colorDepth, long timeout) throws HTIException, IOException {
        return this.captureFullScreen(imgMimeType, colorDepth, false, timeout);
    }

    public byte[] captureScreenRegion(int left, int top, int right, int bottom, String imgMimeType, byte colorDepth, boolean zipped, long timeout) throws HTIException, IOException {
        this.log.info("Capturing screen region (" + left + "," + top + ")x(" + right + "," + bottom + ") with mime type " + imgMimeType + ", zipped = " + zipped);
        byte[] imgData = null;
        HTIMessage command = MessageFactory.createCaptureScreenRegionMessage(left, top, right, bottom, imgMimeType, colorDepth, zipped);
        HTIMessage response = this.sendHTIRequest(command, timeout);
        if (!response.isErrorResponse()) {
            imgData = response.getBody();
        }
        return imgData;
    }

    public byte[] captureScreenRegion(int left, int top, int right, int bottom, String imgMimeType, byte colorDepth, boolean zipped) throws HTIException, IOException {
        return this.captureScreenRegion(left, top, right, bottom, imgMimeType, colorDepth, zipped, 0L);
    }

    public byte[] captureScreenRegion(int left, int top, int right, int bottom, String imgMimeType, byte colorDepth) throws HTIException, IOException {
        return this.captureScreenRegion(left, top, right, bottom, imgMimeType, colorDepth, false);
    }

    public byte[] captureScreenRegion(int left, int top, int right, int bottom, String imgMimeType, byte colorDepth, long timeout) throws HTIException, IOException {
        return this.captureScreenRegion(left, top, right, bottom, imgMimeType, colorDepth, false, timeout);
    }

    public List captureFullScreenDelta(String imgMimeType, byte colorDepth, boolean zipped) throws HTIException, IOException {
        return this.captureFullScreenDelta(imgMimeType, colorDepth, zipped, 0L);
    }

    public List captureFullScreenDelta(String imgMimeType, byte colorDepth, boolean zipped, long timeout) throws HTIException, IOException {
        this.log.info("Capturing full screen delta with mime type " + imgMimeType + ", zipped = " + zipped);
        byte[] imgData = new byte[]{};
        ArrayList<Object> ret = new ArrayList<Object>();
        HTIMessage command = MessageFactory.createCaptureFullScreenDeltaMessage(imgMimeType, colorDepth, zipped);
        HTIMessage response = this.sendHTIRequest(command, timeout);
        if (!response.isErrorResponse()) {
            byte[] responseBytes = response.getBody();
            byte[] coordinateBytes = new byte[2];
            System.arraycopy(responseBytes, 0, coordinateBytes, 0, 2);
            ret.add(new Integer(Util.littleEndianToInt(coordinateBytes)));
            System.arraycopy(responseBytes, 2, coordinateBytes, 0, 2);
            ret.add(new Integer(Util.littleEndianToInt(coordinateBytes)));
            System.arraycopy(responseBytes, 4, coordinateBytes, 0, 2);
            ret.add(new Integer(Util.littleEndianToInt(coordinateBytes)));
            System.arraycopy(responseBytes, 6, coordinateBytes, 0, 2);
            ret.add(new Integer(Util.littleEndianToInt(coordinateBytes)));
            imgData = new byte[responseBytes.length - 8];
            System.arraycopy(responseBytes, 8, imgData, 0, imgData.length);
            ret.add(imgData);
        } else {
            ret = null;
        }
        return ret;
    }

    public List captureFullScreenDelta(String imgMimeType, byte colorDepth) throws HTIException, IOException {
        return this.captureFullScreenDelta(imgMimeType, colorDepth, false);
    }

    public List captureFullScreenDelta(String imgMimeType, byte colorDepth, long timeout) throws HTIException, IOException {
        return this.captureFullScreenDelta(imgMimeType, colorDepth, false, timeout);
    }

    public List captureScreenRegionDelta(int left, int top, int right, int bottom, String imgMimeType, byte colorDepth, boolean zipped, long timeout) throws HTIException, IOException {
        this.log.info("Capturing screen region delta (" + left + "," + top + ")x(" + right + "," + bottom + ") with mime type " + imgMimeType + ", zipped = " + zipped);
        byte[] imgData = new byte[]{};
        ArrayList<Object> ret = new ArrayList<Object>();
        HTIMessage command = MessageFactory.createCaptureScreenRegionDeltaMessage(left, top, right, bottom, imgMimeType, colorDepth, zipped);
        HTIMessage response = this.sendHTIRequest(command, timeout);
        if (!response.isErrorResponse()) {
            byte[] responseBytes = response.getBody();
            byte[] coordinateBytes = new byte[2];
            System.arraycopy(responseBytes, 0, coordinateBytes, 0, 2);
            ret.add(new Integer(Util.littleEndianToInt(coordinateBytes)));
            System.arraycopy(responseBytes, 2, coordinateBytes, 0, 2);
            ret.add(new Integer(Util.littleEndianToInt(coordinateBytes)));
            System.arraycopy(responseBytes, 4, coordinateBytes, 0, 2);
            ret.add(new Integer(Util.littleEndianToInt(coordinateBytes)));
            System.arraycopy(responseBytes, 6, coordinateBytes, 0, 2);
            ret.add(new Integer(Util.littleEndianToInt(coordinateBytes)));
            imgData = new byte[responseBytes.length - 8];
            System.arraycopy(responseBytes, 8, imgData, 0, imgData.length);
            ret.add(imgData);
        } else {
            ret = null;
        }
        return ret;
    }

    public List captureScreenRegionDelta(int left, int top, int right, int bottom, String imgMimeType, byte colorDepth, boolean zipped) throws HTIException, IOException {
        return this.captureScreenRegionDelta(left, top, right, bottom, imgMimeType, colorDepth, zipped, 0L);
    }

    public List captureScreenRegionDelta(int left, int top, int right, int bottom, String imgMimeType, byte colorDepth) throws HTIException, IOException {
        return this.captureScreenRegionDelta(left, top, right, bottom, imgMimeType, colorDepth, false);
    }

    public List captureScreenRegionDelta(int left, int top, int right, int bottom, String imgMimeType, byte colorDepth, long timeout) throws HTIException, IOException {
        return this.captureScreenRegionDelta(left, top, right, bottom, imgMimeType, colorDepth, false, timeout);
    }

    public List captureFullScreenSeries(long duration, long interval, String imgMimeType, byte colorDepth, boolean zipped) throws HTIException, IOException {
        return this.captureFullScreenSeries(duration, interval, imgMimeType, colorDepth, zipped, 0L);
    }

    public List captureFullScreenSeries(long duration, long interval, String imgMimeType, byte colorDepth, boolean zipped, long timeout) throws HTIException, IOException {
        this.log.info("Capturing full screen with mime type " + imgMimeType + ", zipped = " + zipped);
        if (timeout > 0L && duration / 1000L > timeout) {
            throw new HTIException("Duration (" + duration / 1000L + " ms) is longer than command timeout (" + timeout + " ms)");
        }
        ArrayList<String> pathList = new ArrayList<String>();
        HTIMessage command = MessageFactory.createCaptureFullScreenSeriesMessage(duration, interval, imgMimeType, colorDepth, zipped);
        HTIMessage response = this.sendHTIRequest(command, timeout);
        if (!response.isErrorResponse()) {
            byte[] responseBytes = response.getBody();
            byte[] pathBytes = new byte[]{};
            int index = 0;
            if (responseBytes.length > 1) {
                while (index < responseBytes.length) {
                    pathBytes = new byte[responseBytes[index]];
                    System.arraycopy(responseBytes, ++index, pathBytes, 0, pathBytes.length);
                    index += pathBytes.length;
                    pathList.add(new String(pathBytes));
                }
            }
        }
        return pathList;
    }

    public List captureFullScreenSeries(long duration, long interval, String imgMimeType, byte colorDepth) throws HTIException, IOException {
        return this.captureFullScreenSeries(duration, interval, imgMimeType, colorDepth, false);
    }

    public List captureFullScreenSeries(long duration, long interval, String imgMimeType, byte colorDepth, long timeout) throws HTIException, IOException {
        return this.captureFullScreenSeries(duration, interval, imgMimeType, colorDepth, false, timeout);
    }

    public List captureScreenRegionSeries(long duration, long interval, int left, int top, int right, int bottom, String imgMimeType, byte colorDepth, boolean zipped, long timeout) throws HTIException, IOException {
        this.log.info("Capturing screen region (" + left + "," + top + ")x(" + right + "," + bottom + ") with mime type " + imgMimeType + ", zipped = " + zipped);
        if (timeout > 0L && duration / 1000L > timeout) {
            throw new HTIException("Duration (" + duration / 1000L + " ms) is longer than command timeout (" + timeout + " ms)");
        }
        ArrayList<String> pathList = new ArrayList<String>();
        HTIMessage command = MessageFactory.createCaptureScreenRegionSeriesMessage(duration, interval, left, top, right, bottom, imgMimeType, colorDepth, zipped);
        HTIMessage response = this.sendHTIRequest(command, timeout);
        if (!response.isErrorResponse()) {
            byte[] responseBytes = response.getBody();
            byte[] pathBytes = new byte[]{};
            int index = 0;
            if (responseBytes.length > 1) {
                while (index < responseBytes.length) {
                    pathBytes = new byte[responseBytes[index]];
                    System.arraycopy(responseBytes, ++index, pathBytes, 0, pathBytes.length);
                    index += pathBytes.length;
                    pathList.add(new String(pathBytes));
                }
            }
        }
        return pathList;
    }

    public List captureScreenRegionSeries(long duration, long interval, int left, int top, int right, int bottom, String imgMimeType, byte colorDepth, boolean zipped) throws HTIException, IOException {
        return this.captureScreenRegionSeries(duration, interval, left, top, right, bottom, imgMimeType, colorDepth, zipped, 0L);
    }

    public List captureScreenRegionSeries(long duration, long interval, int left, int top, int right, int bottom, String imgMimeType, byte colorDepth) throws HTIException, IOException {
        return this.captureScreenRegionSeries(duration, interval, left, top, right, bottom, imgMimeType, colorDepth, false);
    }

    public List captureScreenRegionSeries(long duration, long interval, int left, int top, int right, int bottom, String imgMimeType, byte colorDepth, long timeout) throws HTIException, IOException {
        return this.captureScreenRegionSeries(duration, interval, left, top, right, bottom, imgMimeType, colorDepth, false, timeout);
    }

    public HTIMessage resetScreenDelta() throws HTIException, IOException {
        return this.resetScreenDelta(0L);
    }

    public HTIMessage resetScreenDelta(long timeout) throws HTIException, IOException {
        HTIMessage command = MessageFactory.createResetScreenDeltaMessage();
        HTIMessage response = this.sendHTIRequest(command, timeout);
        return response;
    }

    public HTIMessage selectScreen(byte screenNumber) throws HTIException, IOException {
        return this.selectScreen(screenNumber, 0L);
    }

    public HTIMessage selectScreen(byte screenNumber, long timeout) throws HTIException, IOException {
        HTIMessage command = MessageFactory.createSelectScreenMessage(screenNumber);
        HTIMessage response = this.sendHTIRequest(command, timeout);
        return response;
    }

    public HTITextRecognitionResult recognizeText(String text, boolean unicode, List<HTIFont> fontList) throws HTIException, IOException {
        return this.recognizeText(text, unicode, fontList, 0L);
    }

    public HTITextRecognitionResult recognizeText(String text, boolean unicode, List<HTIFont> fontList, long timeout) throws HTIException, IOException {
        this.log.info("Recognizing text '" + text + "'");
        HTIMessage command = MessageFactory.createTextRecognitionMessage(text, unicode, fontList);
        HTIMessage response = this.sendHTIRequest(command, timeout);
        if (response.isErrorResponse()) {
            return null;
        }
        byte[] data = response.getBody();
        if (data[0] == -15) {
            return null;
        }
        int left = ((data[2] & 0xFF) << 8) + (data[1] & 0xFF);
        int top = ((data[4] & 0xFF) << 8) + (data[3] & 0xFF);
        int right = ((data[6] & 0xFF) << 8) + (data[5] & 0xFF);
        int bottom = ((data[8] & 0xFF) << 8) + (data[7] & 0xFF);
        byte fontIndex = data[9];
        HTITextRecognitionResult result = new HTITextRecognitionResult(left, top, right, bottom, fontIndex);
        return result;
    }

    public byte[] getTextBitmap(String text, boolean unicode, HTIFont font, long foregroundColor, long backgroundColor, String mimeType, byte colorDepth) throws HTIException, IOException {
        return this.getTextBitmap(text, unicode, font, foregroundColor, backgroundColor, mimeType, colorDepth, 0L);
    }

    public byte[] getTextBitmap(String text, boolean unicode, HTIFont font, long foregroundColor, long backgroundColor, String mimeType, byte colorDepth, long timeout) throws HTIException, IOException {
        this.log.info("Rendering text bitmap for '" + text + "' using '" + font.toString() + "' with MIME type '" + mimeType + "'");
        HTIMessage command = MessageFactory.createTextBitmapMessage(text, unicode, font, foregroundColor, backgroundColor, mimeType, colorDepth);
        HTIMessage response = this.sendHTIRequest(command, timeout);
        if (response.isErrorResponse()) {
            return null;
        }
        return response.getBody();
    }

    public HTIScreenMode getScreenMode() throws HTIException, IOException {
        return this.getScreenMode(0L);
    }

    public HTIScreenMode getScreenMode(long timeout) throws HTIException, IOException {
        this.log.info("Getting screen mode");
        HTIMessage command = MessageFactory.createScreenModeMessage();
        HTIMessage response = this.sendHTIRequest(command, timeout);
        if (response.isErrorResponse()) {
            return null;
        }
        byte[] data = response.getBody();
        byte index = data[0];
        int width = ((data[2] & 0xFF) << 8) + (data[1] & 0xFF);
        int height = ((data[4] & 0xFF) << 8) + (data[3] & 0xFF);
        byte rotation = data[5];
        byte mode = data[6];
        byte focusIndex = data[7];
        HTIScreenMode result = new HTIScreenMode(index, width, height, rotation, mode, focusIndex);
        return result;
    }
}

