/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.HTI.common;

import java.io.IOException;
import java.io.OutputStream;

public class ThreadedOutputStream
extends OutputStream {
    private OutputStream out;
    private long timeout = 0L;

    public ThreadedOutputStream(OutputStream out) {
        this.out = out;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public void write(int b) throws IOException {
        this.out.write(b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] b) throws IOException {
        if (this.timeout < 0L) {
            throw new IOException("HTI: I/O write operation timed out");
        }
        WriterThread wt = new WriterThread(b);
        Object object = wt.eventReady;
        synchronized (object) {
            if (!wt.isReady) {
                try {
                    wt.eventReady.wait(this.timeout);
                }
                catch (InterruptedException e) {
                    throw new IOException("HTI: Waiting for I/O write was interrupted");
                }
                if (!wt.isReady) {
                    wt.cancel();
                    throw new IOException("HTI: I/O write operation timed out");
                }
            }
        }
    }

    class WriterThread
    implements Runnable {
        private byte[] buffer;
        public Exception exception = null;
        public Object eventReady = new Object();
        public boolean isReady = false;
        private volatile Thread writer;

        public WriterThread(byte[] buffer) {
            this.buffer = buffer;
            this.writer = new Thread(this);
            this.writer.start();
        }

        public void cancel() {
            Thread interrupter = this.writer;
            this.writer = null;
            interrupter.interrupt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                ThreadedOutputStream.this.out.write(this.buffer);
            }
            catch (Exception e) {
                this.exception = e;
            }
            Object object = this.eventReady;
            synchronized (object) {
                this.isReady = true;
                this.eventReady.notifyAll();
            }
        }
    }
}

