/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.HTI.MessagesService;

import com.nokia.HTI.BaseService;
import com.nokia.HTI.HTIException;
import com.nokia.HTI.HTIMessage;
import com.nokia.HTI.IService;
import com.nokia.HTI.MessagesService.AccessPointFieldConstants;
import com.nokia.HTI.MessagesService.MessageFactory;
import java.io.IOException;
import java.util.Hashtable;

public class MessagesService
extends BaseService
implements IService {
    public HTIMessage addSMS(String fromTo, String description, String messageBody, boolean isNew, boolean isUnread, byte toFolder) throws HTIException, IOException {
        return this.addSMS(fromTo, description, messageBody, isNew, isUnread, toFolder, 0L);
    }

    public HTIMessage addSMS(String fromTo, String description, String messageBody, boolean isNew, boolean isUnread, byte toFolder, long timeout) throws HTIException, IOException {
        HTIMessage command = MessageFactory.createAddSMSMessage(fromTo, description, messageBody, isNew, isUnread, toFolder);
        HTIMessage response = this.sendHTIRequest(command, timeout);
        return response;
    }

    public HTIMessage addMMS(String fromTo, String description, String messageBody, String attachmentPath, boolean isNew, boolean isUnread, byte toFolderFlags) throws HTIException, IOException {
        return this.addMMS(fromTo, description, messageBody, attachmentPath, isNew, isUnread, toFolderFlags, 0L);
    }

    public HTIMessage addMMS(String fromTo, String description, String messageBody, String attachmentPath, boolean isNew, boolean isUnread, byte toFolderFlags, long timeout) throws HTIException, IOException {
        HTIMessage command = MessageFactory.createAddMMSMessage(fromTo, description, messageBody, attachmentPath, isNew, isUnread, toFolderFlags);
        HTIMessage response = this.sendHTIRequest(command, timeout);
        return response;
    }

    public HTIMessage addIRMessage(String fromTo, String description, String attachmentPath, boolean isNew, boolean isUnread, byte toFolderFlags) throws HTIException, IOException {
        return this.addIRMessage(fromTo, description, attachmentPath, isNew, isUnread, toFolderFlags, 0L);
    }

    public HTIMessage addIRMessage(String fromTo, String description, String attachmentPath, boolean isNew, boolean isUnread, byte toFolderFlags, long timeout) throws HTIException, IOException {
        HTIMessage command = MessageFactory.createAddIRMessage(fromTo, description, attachmentPath, isNew, isUnread, toFolderFlags);
        HTIMessage response = this.sendHTIRequest(command, timeout);
        return response;
    }

    public HTIMessage addBTMessage(String fromTo, String description, String attachmentPath, boolean isNew, boolean isUnread, byte toFolderFlags) throws HTIException, IOException {
        return this.addBTMessage(fromTo, description, attachmentPath, isNew, isUnread, toFolderFlags, 0L);
    }

    public HTIMessage addBTMessage(String fromTo, String description, String attachmentPath, boolean isNew, boolean isUnread, byte toFolderFlags, long timeout) throws HTIException, IOException {
        HTIMessage command = MessageFactory.createAddBTMessage(fromTo, description, attachmentPath, isNew, isUnread, toFolderFlags);
        HTIMessage response = this.sendHTIRequest(command, timeout);
        return response;
    }

    public HTIMessage addSmartMessage(String fromTo, String description, byte[] messageBody, boolean isNew, boolean isUnread, long messageType, byte toFolderFlags) throws HTIException, IOException {
        return this.addSmartMessage(fromTo, description, messageBody, isNew, isUnread, messageType, toFolderFlags, 0L);
    }

    public HTIMessage addSmartMessage(String fromTo, String description, byte[] messageBody, boolean isNew, boolean isUnread, long messageType, byte toFolderFlags, long timeout) throws HTIException, IOException {
        HTIMessage command = MessageFactory.createAddSmartMessage(fromTo, description, messageBody, isNew, isUnread, messageType, toFolderFlags);
        HTIMessage response = this.sendHTIRequest(command, timeout);
        return response;
    }

    public HTIMessage addEmail(String fromTo, String description, String messageBody, String attachmentPath, boolean isNew, boolean isUnread, byte toFolderFlags) throws HTIException, IOException {
        return this.addEmail(fromTo, description, messageBody, attachmentPath, isNew, isUnread, toFolderFlags, 0L);
    }

    public HTIMessage addEmail(String fromTo, String description, String messageBody, String attachmentPath, boolean isNew, boolean isUnread, byte toFolderFlags, long timeout) throws HTIException, IOException {
        HTIMessage command = MessageFactory.createAddEmailMessage(fromTo, description, messageBody, attachmentPath, isNew, isUnread, toFolderFlags);
        HTIMessage response = this.sendHTIRequest(command, timeout);
        return response;
    }

    public HTIMessage addAudioMessage(String fromTo, String description, String attachmentPath, boolean isNew, boolean isUnread, byte toFolderFlags) throws HTIException, IOException {
        return this.addAudioMessage(fromTo, description, attachmentPath, isNew, isUnread, toFolderFlags, 0L);
    }

    public HTIMessage addAudioMessage(String fromTo, String description, String attachmentPath, boolean isNew, boolean isUnread, byte toFolderFlags, long timeout) throws HTIException, IOException {
        HTIMessage command = MessageFactory.createAddAudioMessage(fromTo, description, attachmentPath, isNew, isUnread, toFolderFlags);
        HTIMessage response = this.sendHTIRequest(command, timeout);
        return response;
    }

    public HTIMessage deleteMessage(int id) throws HTIException, IOException {
        return this.deleteMessage(id, 0L);
    }

    public HTIMessage deleteMessage(int id, long timeout) throws HTIException, IOException {
        HTIMessage command = MessageFactory.createDeleteMessageMessage(id);
        HTIMessage response = this.sendHTIRequest(command, timeout);
        return response;
    }

    public HTIMessage deleteFolderContent(byte folder, byte messageType) throws HTIException, IOException {
        return this.deleteFolderContent(folder, messageType, 0L);
    }

    public HTIMessage deleteFolderContent(byte folder, byte messageType, long timeout) throws HTIException, IOException {
        HTIMessage command = MessageFactory.createDeleteFolderContentMessage(folder, messageType);
        HTIMessage response = this.sendHTIRequest(command, timeout);
        return response;
    }

    public HTIMessage createAccessPoint(byte bearerType, String name, Hashtable fields) throws HTIException, IOException {
        return this.createAccessPoint(bearerType, name, fields, 0L);
    }

    public HTIMessage createAccessPoint(byte bearerType, String name, Hashtable fields, long timeout) throws HTIException, IOException {
        fields = AccessPointFieldConstants.translateKeysAndValues(fields);
        HTIMessage command = MessageFactory.createCreateAccessPointMessage(bearerType, name, fields);
        HTIMessage response = this.sendHTIRequest(command, timeout);
        return response;
    }

    public HTIMessage deleteAccessPoint(String name) throws HTIException, IOException {
        return this.deleteAccessPoint(name, 0L);
    }

    public HTIMessage deleteAccessPoint(String name, long timeout) throws HTIException, IOException {
        HTIMessage command = MessageFactory.createDeleteAccessPointMessage(name);
        HTIMessage response = this.sendHTIRequest(command, timeout);
        return response;
    }

    public HTIMessage createMailbox(Hashtable fields) throws HTIException, IOException {
        return this.createMailbox(fields, 0L);
    }

    public HTIMessage createMailbox(Hashtable fields, long timeout) throws HTIException, IOException {
        HTIMessage command = MessageFactory.createCreateMailboxMessage(fields);
        HTIMessage response = this.sendHTIRequest(command, timeout);
        return response;
    }

    public HTIMessage deleteMailbox(String mailboxName) throws HTIException, IOException {
        return this.deleteMailbox(mailboxName, 0L);
    }

    public HTIMessage deleteMailbox(String mailboxName, long timeout) throws HTIException, IOException {
        HTIMessage command = MessageFactory.createDeleteMailboxMessage(mailboxName);
        HTIMessage response = this.sendHTIRequest(command, timeout);
        return response;
    }

    public HTIMessage setSmsCenter(String name, String number) throws HTIException, IOException {
        return this.setSmsCenter(name, number, 0L);
    }

    public HTIMessage setSmsCenter(String name, String number, long timeout) throws HTIException, IOException {
        HTIMessage command = MessageFactory.createSetSmsCenterMessage(name, number);
        HTIMessage response = this.sendHTIRequest(command, timeout);
        return response;
    }

    public HTIMessage setSMSSettings(byte characterSupport, boolean deliveryReport, byte validityPeriod, byte messageConversion, byte preferrerConnection, boolean replyViaSameCenter) throws HTIException, IOException {
        return this.setSMSSettings(characterSupport, deliveryReport, validityPeriod, messageConversion, preferrerConnection, replyViaSameCenter, 0L);
    }

    public HTIMessage setSMSSettings(byte characterSupport, boolean deliveryReport, byte validityPeriod, byte messageConversion, byte preferrerConnection, boolean replyViaSameCenter, long timeout) throws HTIException, IOException {
        HTIMessage command = MessageFactory.createSetSMSSettingsMessage(characterSupport, deliveryReport, validityPeriod, messageConversion, preferrerConnection, replyViaSameCenter);
        HTIMessage response = this.sendHTIRequest(command, timeout);
        return response;
    }

    public HTIMessage setMMSSettings(String accessPointName, byte creationMode, byte imageSize, byte mmsReception, boolean receiveAnonMsg, boolean receiveAds, boolean receiveDeliveryReport, boolean sendDeliveryReport, byte validityPeriod) throws HTIException, IOException {
        return this.setMMSSettings(accessPointName, creationMode, imageSize, mmsReception, receiveAnonMsg, receiveAds, receiveDeliveryReport, sendDeliveryReport, validityPeriod, 0L);
    }

    public HTIMessage setMMSSettings(String accessPointName, byte creationMode, byte imageSize, byte mmsReception, boolean receiveAnonMsg, boolean receiveAds, boolean receiveDeliveryReport, boolean sendDeliveryReport, byte validityPeriod, long timeout) throws HTIException, IOException {
        HTIMessage command = MessageFactory.createSetMMSSettingsMessage(accessPointName, creationMode, imageSize, mmsReception, receiveAnonMsg, receiveAds, receiveDeliveryReport, sendDeliveryReport, validityPeriod);
        HTIMessage response = this.sendHTIRequest(command, timeout);
        return response;
    }

    public boolean addToDestination(String accessPointName, String destinationName) throws HTIException, IOException {
        return this.addToDestination(accessPointName, destinationName, 0L);
    }

    public boolean addToDestination(String accessPointName, String destinationName, long timeout) throws HTIException, IOException {
        HTIMessage command = MessageFactory.createAddToDestinationMessage(accessPointName, destinationName);
        HTIMessage response = this.sendHTIRequest(command, timeout);
        return !response.isErrorResponse();
    }

    public boolean setDefaultConnection(int type, String name) throws HTIException, IOException {
        return this.setDefaultConnection(type, name, 0L);
    }

    public boolean setDefaultConnection(int type, String name, long timeout) throws HTIException, IOException {
        HTIMessage command = MessageFactory.createSetDefaultConnectionMessage(type, name);
        HTIMessage response = this.sendHTIRequest(command, timeout);
        return !response.isErrorResponse();
    }
}

