/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build.jarprocessor;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class Unsigner {
    private static final String META_INF = "META-INF";
    private static final String DSA_EXT = ".DSA";
    private static final String RSA_EXT = ".RSA";
    private static final String SF_EXT = ".SF";
    private static final String META_INF_PREFIX = "META-INF/";
    private String[] signers;
    private File jarFile;
    private boolean keepManifestContent = false;

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isSigned(File file) {
        block15: {
            jar = null;
            try {
                block16: {
                    jar = new ZipFile(file);
                    if (this.signers == null) break block16;
                    i = 0;
                    ** GOTO lbl12
                }
                entries = jar.entries();
                if (true) ** GOTO lbl36
                while (jar.getEntry(("META-INF/" + this.signers[i] + ".SF").toUpperCase()) == null) {
                    ++i;
lbl12:
                    // 2 sources

                    if (i < this.signers.length) continue;
                    break block15;
                }
            }
            catch (ZipException v0) {
                try {
                    break block15;
                    catch (IOException v1) {
                        break block15;
                    }
                }
                catch (Throwable var6_7) {
                    if (jar == null) throw var6_7;
                    try {
                        jar.close();
                        throw var6_7;
                    }
                    catch (IOException v2) {}
                    throw var6_7;
                }
            }
            while (true) {
                if (jar == null) return true;
                try {
                    jar.close();
                    return true;
                }
                catch (IOException v3) {}
                return true;
            }
            do {
                if ((entryName = (entry = entries.nextElement()).getName()).endsWith(".SF") && entryName.startsWith("META-INF")) ** continue;
lbl36:
                // 2 sources

            } while (entries.hasMoreElements());
        }
        if (jar == null) return false;
        try {
            jar.close();
            return false;
        }
        catch (IOException v4) {}
        return false;
    }

    public void execute() {
        this.processJar(this.jarFile);
    }

    private void processJar(File inputFile) {
        if (!this.isSigned(inputFile)) {
            return;
        }
        try {
            ZipInputStream input = new ZipInputStream(new BufferedInputStream(new FileInputStream(inputFile)));
            File outputFile = File.createTempFile("removing.", ".signature", inputFile.getParentFile());
            ZipOutputStream output = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(outputFile)));
            ZipEntry inputZe = input.getNextEntry();
            byte[] b = new byte[8192];
            while (inputZe != null) {
                byte remove = this.shouldRemove(inputZe);
                if (remove == 2) {
                    inputZe = input.getNextEntry();
                    continue;
                }
                if (remove == 1) {
                    output.putNextEntry(new ZipEntry(inputZe.getName()));
                    Manifest m = new Manifest();
                    m.read(input);
                    m.getEntries().clear();
                    m.write(output);
                } else {
                    output.putNextEntry(inputZe);
                    while (input.available() != 0) {
                        int read = input.read(b);
                        if (read == -1) continue;
                        output.write(b, 0, read);
                    }
                }
                output.closeEntry();
                input.closeEntry();
                inputZe = input.getNextEntry();
            }
            output.close();
            input.close();
            inputFile.delete();
            outputFile.renameTo(inputFile);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private byte shouldRemove(ZipEntry entry) {
        String entryName = entry.getName();
        if (!this.keepManifestContent && entryName.equalsIgnoreCase("META-INF/MANIFEST.MF")) {
            return 1;
        }
        if (this.signers != null) {
            int i = 0;
            while (i < this.signers.length) {
                if (entryName.equalsIgnoreCase(META_INF_PREFIX + this.signers[i] + SF_EXT) || entryName.equalsIgnoreCase(META_INF_PREFIX + this.signers[i] + RSA_EXT) || entryName.equalsIgnoreCase(META_INF_PREFIX + this.signers[i] + DSA_EXT)) {
                    return 2;
                }
                ++i;
            }
        } else if (entryName.startsWith(META_INF) && (entryName.endsWith(SF_EXT) || entryName.endsWith(RSA_EXT) || entryName.endsWith(DSA_EXT))) {
            return 2;
        }
        return 0;
    }

    public void setRemoveSigners(String[] fileName) {
        this.signers = fileName;
    }

    public void setJar(File file) {
        this.jarFile = file;
    }

    public void setKeepManifestEntries(boolean keep) {
        this.keepManifestContent = keep;
    }
}

