/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build.tasks;

import java.io.File;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.internal.build.AbstractScriptGenerator;
import org.eclipse.pde.internal.build.BundleHelper;
import org.eclipse.pde.internal.build.FeatureGenerator;
import org.eclipse.pde.internal.build.Utils;
import org.eclipse.pde.internal.build.site.BuildTimeSiteFactory;
import org.eclipse.pde.internal.build.tasks.TaskHelper;

public class FeatureGeneratorTask
extends Task {
    private FeatureGenerator generator = new FeatureGenerator();
    private Properties antProperties = new Properties();

    public void execute() throws BuildException {
        try {
            BundleHelper.getDefault().setLog((Object)this);
            String value = this.getProject().getProperty("resolution.devMode");
            if (Boolean.valueOf(value).booleanValue()) {
                this.antProperties.put("resolution.devMode", "true");
            }
            this.generator.setImmutableAntProperties(this.antProperties);
            this.run();
            BundleHelper.getDefault().setLog(null);
        }
        catch (CoreException e) {
            throw new BuildException(TaskHelper.statusToString(e.getStatus(), null).toString());
        }
    }

    public void run() throws CoreException {
        this.generator.generate();
    }

    public void setBuildDirectory(String buildDirectory) {
        this.generator.setWorkingDirectory(buildDirectory);
    }

    public void setProductFile(String productFile) {
        this.generator.setProductFile(productFile);
    }

    public void setIncludeLaunchers(boolean includeLaunchers) {
        this.generator.setIncludeLaunchers(includeLaunchers);
    }

    public void setBaseLocation(String baseLocation) {
        BuildTimeSiteFactory.setInstalledBaseSite((String)baseLocation);
    }

    public void setPluginList(String pluginList) {
        if (pluginList != null && !pluginList.startsWith("${")) {
            this.generator.setPluginList(Utils.getArrayFromString((String)pluginList));
        }
    }

    public void setFragmentList(String fragmentList) {
        if (fragmentList != null && !fragmentList.startsWith("${")) {
            this.generator.setFragmentList(Utils.getArrayFromString((String)fragmentList));
        }
    }

    public void setFeatureList(String featureList) {
        if (featureList != null && !featureList.startsWith("${")) {
            this.generator.setFeatureList(Utils.getArrayFromString((String)featureList));
        }
    }

    public void setFeatureId(String featureId) {
        this.generator.setFeatureId(featureId);
    }

    public void setPluginPath(String pluginPath) {
        this.generator.setPluginPath(Utils.getArrayFromString((String)pluginPath, (String)File.pathSeparator));
    }

    public void setVerify(boolean verify) {
        this.generator.setVerify(verify);
    }

    public void setConfigInfo(String configInfo) throws CoreException {
        AbstractScriptGenerator.setConfigInfo((String)configInfo);
    }
}

