/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.HTI.STIFTestFrameworkService;

import com.nokia.HTI.HTIMessage;
import com.nokia.HTI.HTIMessageFactory;

class MessageFactory
extends HTIMessageFactory {
    static final int uid = 270601411;

    MessageFactory() {
    }

    static HTIMessage createSTIFOpenMessage(String iniFile) {
        byte[] iniFileBytes = iniFile.getBytes();
        int msgBodySize = iniFileBytes.length + 1;
        byte[] header = MessageFactory.createHeader(270601411, msgBodySize);
        byte[] body = new byte[msgBodySize];
        byte[] command = new byte[header.length + msgBodySize];
        body[0] = 1;
        System.arraycopy(iniFileBytes, 0, body, 1, iniFileBytes.length);
        System.arraycopy(header, 0, command, 0, header.length);
        System.arraycopy(body, 0, command, header.length, body.length);
        return new HTIMessage(command);
    }

    static HTIMessage createSetMeasurementMessage(String enumIndex, String plugin) {
        byte[] enumIndexBytes = enumIndex.getBytes();
        byte[] pluginBytes = plugin.getBytes();
        int msgBodySize = enumIndexBytes.length + pluginBytes.length + 2;
        byte[] header = MessageFactory.createHeader(270601411, msgBodySize);
        byte[] body = new byte[msgBodySize];
        byte[] command = new byte[header.length + msgBodySize];
        body[0] = 16;
        body[1 + enumIndexBytes.length] = 124;
        System.arraycopy(enumIndexBytes, 0, body, 1, enumIndexBytes.length);
        System.arraycopy(pluginBytes, 0, body, enumIndexBytes.length + 2, pluginBytes.length);
        System.arraycopy(header, 0, command, 0, header.length);
        System.arraycopy(body, 0, command, header.length, body.length);
        return new HTIMessage(command);
    }

    static HTIMessage createSTIFCloseMessage() {
        int msgBodySize = 1;
        byte[] header = MessageFactory.createHeader(270601411, msgBodySize);
        byte[] command = new byte[header.length + msgBodySize];
        command[header.length] = 2;
        System.arraycopy(header, 0, command, 0, header.length);
        return new HTIMessage(command);
    }

    static HTIMessage createLoadTestModuleMessage(String moduleName, String moduleIniFile) {
        byte[] moduleIniFileBytes = moduleIniFile.getBytes();
        byte[] moduleNameBytes = moduleName.getBytes();
        int msgBodySize = moduleNameBytes.length + 1;
        if (moduleIniFileBytes.length > 0) {
            msgBodySize += moduleIniFileBytes.length + 1;
        }
        byte[] header = MessageFactory.createHeader(270601411, msgBodySize);
        byte[] body = new byte[msgBodySize];
        byte[] command = new byte[header.length + msgBodySize];
        body[0] = 3;
        System.arraycopy(moduleNameBytes, 0, body, 1, moduleNameBytes.length);
        if (moduleIniFileBytes.length > 0) {
            body[moduleNameBytes.length + 1] = 124;
            System.arraycopy(moduleIniFileBytes, 0, body, moduleNameBytes.length + 2, moduleIniFileBytes.length);
        }
        System.arraycopy(header, 0, command, 0, header.length);
        System.arraycopy(body, 0, command, header.length, body.length);
        return new HTIMessage(command);
    }

    static HTIMessage createUnloadTestModuleMessage(String moduleName) {
        byte[] moduleNameBytes = moduleName.getBytes();
        int msgBodySize = moduleNameBytes.length + 1;
        byte[] header = MessageFactory.createHeader(270601411, msgBodySize);
        byte[] command = new byte[header.length + msgBodySize];
        System.arraycopy(header, 0, command, 0, header.length);
        command[header.length] = 4;
        System.arraycopy(moduleNameBytes, 0, command, header.length + 1, moduleNameBytes.length);
        return new HTIMessage(command);
    }

    static HTIMessage createListTestCasesMessage(String moduleName) {
        byte[] moduleNameBytes = moduleName.getBytes();
        int msgBodySize = moduleNameBytes.length + 1;
        byte[] header = MessageFactory.createHeader(270601411, msgBodySize);
        byte[] command = new byte[header.length + msgBodySize];
        System.arraycopy(header, 0, command, 0, header.length);
        command[header.length] = 5;
        System.arraycopy(moduleNameBytes, 0, command, header.length + 1, moduleNameBytes.length);
        return new HTIMessage(command);
    }

    static HTIMessage createStartTestCaseMessage(String moduleName, String index) {
        String message = String.valueOf(moduleName) + "|" + index;
        byte[] messageBytes = message.getBytes();
        int msgBodySize = messageBytes.length + 1;
        byte[] header = MessageFactory.createHeader(270601411, msgBodySize);
        byte[] body = new byte[msgBodySize];
        byte[] command = new byte[header.length + msgBodySize];
        body[0] = 6;
        System.arraycopy(messageBytes, 0, body, 1, messageBytes.length);
        System.arraycopy(header, 0, command, 0, header.length);
        System.arraycopy(body, 0, command, header.length, body.length);
        return new HTIMessage(command);
    }

    static HTIMessage createCancelTestCaseMessage(String testCaseID) {
        byte[] testCaseIDBytes = testCaseID.getBytes();
        int msgBodySize = testCaseIDBytes.length + 1;
        byte[] header = MessageFactory.createHeader(270601411, msgBodySize);
        byte[] command = new byte[header.length + msgBodySize];
        System.arraycopy(header, 0, command, 0, header.length);
        command[header.length] = 7;
        System.arraycopy(testCaseIDBytes, 0, command, header.length + 1, testCaseIDBytes.length);
        return new HTIMessage(command);
    }

    static HTIMessage createPauseTestCaseMessage(String testCaseID) {
        byte[] testCaseIDBytes = testCaseID.getBytes();
        int msgBodySize = testCaseIDBytes.length + 1;
        byte[] header = MessageFactory.createHeader(270601411, msgBodySize);
        byte[] command = new byte[header.length + msgBodySize];
        System.arraycopy(header, 0, command, 0, header.length);
        command[header.length] = 8;
        System.arraycopy(testCaseIDBytes, 0, command, header.length + 1, testCaseIDBytes.length);
        return new HTIMessage(command);
    }

    static HTIMessage createResumeTestCaseMessage(String testCaseID) {
        byte[] testCaseIDBytes = testCaseID.getBytes();
        int msgBodySize = testCaseIDBytes.length + 1;
        byte[] header = MessageFactory.createHeader(270601411, msgBodySize);
        byte[] command = new byte[header.length + msgBodySize];
        System.arraycopy(header, 0, command, 0, header.length);
        command[header.length] = 9;
        System.arraycopy(testCaseIDBytes, 0, command, header.length + 1, testCaseIDBytes.length);
        return new HTIMessage(command);
    }

    static HTIMessage createAddTestCaseFileMessage(String moduleName, String testCaseFile) {
        String message = String.valueOf(moduleName) + "|" + testCaseFile;
        byte[] messageBytes = message.getBytes();
        int msgBodySize = messageBytes.length + 1;
        byte[] header = MessageFactory.createHeader(270601411, msgBodySize);
        byte[] body = new byte[msgBodySize];
        byte[] command = new byte[header.length + msgBodySize];
        body[0] = 10;
        System.arraycopy(messageBytes, 0, body, 1, messageBytes.length);
        System.arraycopy(header, 0, command, 0, header.length);
        System.arraycopy(body, 0, command, header.length, body.length);
        return new HTIMessage(command);
    }

    static HTIMessage createRemoveTestCaseFileMessage(String moduleName, int separator, String testCaseFile) {
        byte[] testCaseFileBytes = testCaseFile.getBytes();
        byte[] moduleNameBytes = moduleName.getBytes();
        int msgBodySize = testCaseFileBytes.length + moduleNameBytes.length + 2;
        byte[] header = MessageFactory.createHeader(270601411, msgBodySize);
        byte[] body = new byte[msgBodySize];
        byte[] command = new byte[header.length + msgBodySize];
        body[0] = 11;
        System.arraycopy(moduleNameBytes, 0, body, 1, moduleNameBytes.length);
        body[moduleNameBytes.length + 1] = (byte)(separator & 0xFF);
        System.arraycopy(testCaseFileBytes, 0, body, moduleNameBytes.length + 2, testCaseFileBytes.length);
        System.arraycopy(header, 0, command, 0, header.length);
        System.arraycopy(body, 0, command, header.length, body.length);
        return new HTIMessage(command);
    }

    static HTIMessage createTestCaseMessageMessage(String testCaseMessage) {
        byte[] testCaseMessageBytes = testCaseMessage.getBytes();
        int msgBodySize = testCaseMessageBytes.length + 1;
        byte[] header = MessageFactory.createHeader(270601411, msgBodySize);
        byte[] command = new byte[header.length + msgBodySize];
        System.arraycopy(header, 0, command, 0, header.length);
        command[header.length] = 12;
        System.arraycopy(testCaseMessageBytes, 0, command, header.length + 1, testCaseMessageBytes.length);
        return new HTIMessage(command);
    }

    static HTIMessage createSetDeviceIDMessage(String deviceID) {
        byte[] deviceIDBytes = deviceID.getBytes();
        int msgBodySize = deviceIDBytes.length + 1;
        byte[] header = MessageFactory.createHeader(270601411, msgBodySize);
        byte[] command = new byte[header.length + msgBodySize];
        System.arraycopy(header, 0, command, 0, header.length);
        command[header.length] = 13;
        System.arraycopy(deviceIDBytes, 0, command, header.length + 1, deviceIDBytes.length);
        return new HTIMessage(command);
    }
}

