/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.HTI.STIFTestFrameworkService;

import com.nokia.HTI.BaseService;
import com.nokia.HTI.HTIException;
import com.nokia.HTI.HTIMessage;
import com.nokia.HTI.IService;
import com.nokia.HTI.STIFTestFrameworkService.MessageFactory;
import com.nokia.HTI.common.Util;
import java.io.IOException;

public class STIFTestFrameworkService
extends BaseService
implements IService {
    public HTIMessage openSTIFTestFramework(String iniFile) throws HTIException, IOException {
        return this.openSTIFTestFramework(iniFile, 0L);
    }

    public HTIMessage openSTIFTestFramework(String iniFile, long timeout) throws HTIException, IOException {
        HTIMessage command = MessageFactory.createSTIFOpenMessage(iniFile);
        HTIMessage response = this.sendHTIRequest(command, timeout);
        return response;
    }

    public HTIMessage setMeasurement(String enumIndex, String plugin) throws HTIException, IOException {
        return this.setMeasurement(enumIndex, plugin, 0L);
    }

    public HTIMessage setMeasurement(String enumIndex, String plugin, long timeout) throws HTIException, IOException {
        HTIMessage command = MessageFactory.createSetMeasurementMessage(enumIndex, plugin);
        HTIMessage response = this.sendHTIRequest(command, timeout);
        return response;
    }

    public HTIMessage closeSTIFTestFramework() throws HTIException, IOException {
        return this.closeSTIFTestFramework(0L);
    }

    public HTIMessage closeSTIFTestFramework(long timeout) throws HTIException, IOException {
        HTIMessage command = MessageFactory.createSTIFCloseMessage();
        HTIMessage response = this.sendHTIRequest(command, timeout);
        return response;
    }

    public HTIMessage loadTestModule(String moduleName, String iniFile) throws HTIException, IOException {
        return this.loadTestModule(moduleName, iniFile, 0L);
    }

    public HTIMessage loadTestModule(String moduleName, String iniFile, long timeout) throws HTIException, IOException {
        HTIMessage command = MessageFactory.createLoadTestModuleMessage(moduleName, iniFile);
        HTIMessage response = this.sendHTIRequest(command, timeout);
        return response;
    }

    public HTIMessage unloadTestModule(String moduleName) throws HTIException, IOException {
        return this.unloadTestModule(moduleName, 0L);
    }

    public HTIMessage unloadTestModule(String moduleName, long timeout) throws HTIException, IOException {
        HTIMessage command = MessageFactory.createUnloadTestModuleMessage(moduleName);
        HTIMessage response = this.sendHTIRequest(command, timeout);
        return response;
    }

    public String[] listTestCases(String moduleName) throws HTIException, IOException {
        return this.listTestCases(moduleName, 0L);
    }

    public String[] listTestCases(String moduleName, long timeout) throws HTIException, IOException {
        HTIMessage command = MessageFactory.createListTestCasesMessage(moduleName);
        HTIMessage response = this.sendHTIRequest(command, timeout);
        byte[] body = response.getBody();
        return Util.separateResponse(body);
    }

    public HTIMessage startTestCase(String moduleName, String index) throws HTIException, IOException {
        return this.startTestCase(moduleName, index, 0L);
    }

    public HTIMessage startTestCase(String moduleName, String index, long timeout) throws HTIException, IOException {
        HTIMessage command = MessageFactory.createStartTestCaseMessage(moduleName, index);
        HTIMessage response = this.sendHTIRequest(command, timeout);
        return response;
    }

    public void startTestCaseAsync(String moduleName, String index) throws HTIException, IOException {
        this.startTestCaseAsync(moduleName, index, 0L);
    }

    public void startTestCaseAsync(String moduleName, String index, long timeout) throws HTIException, IOException {
        HTIMessage command = MessageFactory.createStartTestCaseMessage(moduleName, index);
        this.sendHTIAsyncMessage(command, timeout);
    }

    public HTIMessage cancelTestCase(String testCaseID) throws HTIException, IOException {
        return this.cancelTestCase(testCaseID, 0L);
    }

    public HTIMessage cancelTestCase(String testCaseID, long timeout) throws HTIException, IOException {
        HTIMessage command = MessageFactory.createCancelTestCaseMessage(testCaseID);
        HTIMessage response = this.sendHTIRequest(command, timeout);
        return response;
    }

    public HTIMessage pauseTestCase(String testCaseID) throws HTIException, IOException {
        return this.pauseTestCase(testCaseID, 0L);
    }

    public HTIMessage pauseTestCase(String testCaseID, long timeout) throws HTIException, IOException {
        HTIMessage command = MessageFactory.createPauseTestCaseMessage(testCaseID);
        HTIMessage response = this.sendHTIRequest(command, timeout);
        return response;
    }

    public HTIMessage resumeTestCase(String testCaseID) throws HTIException, IOException {
        return this.resumeTestCase(testCaseID, 0L);
    }

    public HTIMessage resumeTestCase(String testCaseID, long timeout) throws HTIException, IOException {
        HTIMessage command = MessageFactory.createResumeTestCaseMessage(testCaseID);
        HTIMessage response = this.sendHTIRequest(command, timeout);
        return response;
    }

    public HTIMessage addTestCaseFile(String moduleName, String testCaseFile) throws HTIException, IOException {
        return this.addTestCaseFile(moduleName, testCaseFile, 0L);
    }

    public HTIMessage addTestCaseFile(String moduleName, String testCaseFile, long timeout) throws HTIException, IOException {
        HTIMessage command = MessageFactory.createAddTestCaseFileMessage(moduleName, testCaseFile);
        HTIMessage response = this.sendHTIRequest(command, timeout);
        return response;
    }

    public HTIMessage removeTestCaseFile(String moduleName, int separator, String testCaseFile) throws HTIException, IOException {
        return this.removeTestCaseFile(moduleName, separator, testCaseFile, 0L);
    }

    public HTIMessage removeTestCaseFile(String moduleName, int separator, String testCaseFile, long timeout) throws HTIException, IOException {
        HTIMessage command = MessageFactory.createRemoveTestCaseFileMessage(moduleName, separator, testCaseFile);
        HTIMessage response = this.sendHTIRequest(command, timeout);
        return response;
    }

    public HTIMessage testCaseMessage(String message) throws HTIException, IOException {
        HTIMessage command = MessageFactory.createTestCaseMessageMessage(message);
        this.sendHTIAsyncMessage(command, 5000L);
        return null;
    }

    public HTIMessage setDeviceID(String deviceID) throws HTIException, IOException {
        return this.setDeviceID(deviceID, 0L);
    }

    public HTIMessage setDeviceID(String deviceID, long timeout) throws HTIException, IOException {
        HTIMessage command = MessageFactory.createSetDeviceIDMessage(deviceID);
        HTIMessage response = this.sendHTIRequest(command);
        return response;
    }
}

