/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.HTI.SysInfoService;

import com.nokia.HTI.HTIMessage;
import com.nokia.HTI.HTIMessageFactory;
import com.nokia.HTI.common.Util;

class MessageFactory
extends HTIMessageFactory {
    static final int uid = 270601415;

    MessageFactory() {
    }

    static HTIMessage createSetHomeTimeMessage(int year, int month, int day, int hour, int minute, int second) {
        byte[] yearBytes = new byte[2];
        Util.intToLittleEndianBytes(year, yearBytes, 0, 2);
        int msgBodySize = 8;
        byte[] command = MessageFactory.initMessageArray(270601415, msgBodySize);
        command[14] = 32;
        System.arraycopy(yearBytes, 0, command, 15, yearBytes.length);
        command[17] = (byte)(month & 0xFF);
        command[18] = (byte)(day & 0xFF);
        command[19] = (byte)(hour & 0xFF);
        command[20] = (byte)(minute & 0xFF);
        command[21] = (byte)(second & 0xFF);
        return new HTIMessage(command);
    }

    static HTIMessage createGetHomeTimeMessage() {
        int msgBodySize = 1;
        byte[] command = MessageFactory.initMessageArray(270601415, msgBodySize);
        command[14] = 33;
        return new HTIMessage(command);
    }

    static HTIMessage createGetFreeRAMMessage() {
        int msgBodySize = 1;
        byte[] command = MessageFactory.initMessageArray(270601415, msgBodySize);
        command[14] = 7;
        return new HTIMessage(command);
    }

    static HTIMessage createGetUsedRAMMessage() {
        int msgBodySize = 1;
        byte[] command = MessageFactory.initMessageArray(270601415, msgBodySize);
        command[14] = 8;
        return new HTIMessage(command);
    }

    static HTIMessage createGetTotalRAMMessage() {
        int msgBodySize = 1;
        byte[] command = MessageFactory.initMessageArray(270601415, msgBodySize);
        command[14] = 9;
        return new HTIMessage(command);
    }

    static HTIMessage createEatRAMMessage(int sizeOfMemory) {
        int msgBodySize = 5;
        byte[] command = MessageFactory.initMessageArray(270601415, msgBodySize);
        byte[] bytesToEat = new byte[4];
        Util.intToLittleEndianBytes(sizeOfMemory, bytesToEat, 0, 4);
        command[14] = 10;
        System.arraycopy(bytesToEat, 0, command, 15, bytesToEat.length);
        return new HTIMessage(command);
    }

    static HTIMessage createReleaseRAMMessage() {
        int msgBodySize = 1;
        byte[] command = MessageFactory.initMessageArray(270601415, msgBodySize);
        command[14] = 11;
        return new HTIMessage(command);
    }

    static HTIMessage createGetFreeDiskSpaceMessage(char driveLetter) {
        int msgBodySize = 2;
        byte[] command = MessageFactory.initMessageArray(270601415, msgBodySize);
        command[14] = 12;
        command[15] = (byte)driveLetter;
        return new HTIMessage(command);
    }

    static HTIMessage createGetUsedDiskSpaceMessage(char driveLetter) {
        int msgBodySize = 2;
        byte[] command = MessageFactory.initMessageArray(270601415, msgBodySize);
        command[14] = 13;
        command[15] = (byte)driveLetter;
        return new HTIMessage(command);
    }

    static HTIMessage createGetTotalDiskSpaceMessage(char driveLetter) {
        int msgBodySize = 2;
        byte[] command = MessageFactory.initMessageArray(270601415, msgBodySize);
        command[14] = 14;
        command[15] = (byte)driveLetter;
        return new HTIMessage(command);
    }

    static HTIMessage createEatDiskSpaceMessage(char driveLetter, long spaceLeft) {
        int msgBodySize = 10;
        byte[] command = MessageFactory.initMessageArray(270601415, msgBodySize);
        byte[] bytesLeft = new byte[8];
        Util.longToLittleEndianBytes(spaceLeft, bytesLeft, 0, 8);
        command[14] = 15;
        command[15] = (byte)driveLetter;
        System.arraycopy(bytesLeft, 0, command, 16, bytesLeft.length);
        return new HTIMessage(command);
    }

    static HTIMessage createReleaseDiskSpaceMessage(char driveLetter) {
        int msgBodySize = 2;
        byte[] command = MessageFactory.initMessageArray(270601415, msgBodySize);
        command[14] = 16;
        command[15] = (byte)driveLetter;
        return new HTIMessage(command);
    }

    static HTIMessage createLightStatusMessage(byte lightTarget) {
        int msgBodySize = 2;
        byte[] command = MessageFactory.initMessageArray(270601415, msgBodySize);
        command[14] = 48;
        command[15] = lightTarget;
        return new HTIMessage(command);
    }

    static HTIMessage createLightOnMessage(byte lightTarget, int duration, byte intensity, boolean fadeIn) {
        int msgBodySize = 6;
        byte[] command = MessageFactory.initMessageArray(270601415, msgBodySize);
        command[14] = 49;
        command[15] = lightTarget;
        byte[] durationBytes = new byte[2];
        Util.intToLittleEndianBytes(duration, durationBytes, 0, 2);
        System.arraycopy(durationBytes, 0, command, 16, durationBytes.length);
        command[18] = intensity;
        command[19] = fadeIn ? (byte)1 : 0;
        return new HTIMessage(command);
    }

    static HTIMessage createLightOffMessage(byte lightTarget, int duration, boolean fadeOut) {
        int msgBodySize = 5;
        byte[] command = MessageFactory.initMessageArray(270601415, msgBodySize);
        command[14] = 50;
        command[15] = lightTarget;
        byte[] durationBytes = new byte[2];
        Util.intToLittleEndianBytes(duration, durationBytes, 0, 2);
        System.arraycopy(durationBytes, 0, command, 16, durationBytes.length);
        command[18] = fadeOut ? (byte)1 : 0;
        return new HTIMessage(command);
    }

    static HTIMessage createLightBlinkMessage(byte lightTarget, int duration, int onDuration, int offDuration, byte intensity) {
        int msgBodySize = 9;
        byte[] command = MessageFactory.initMessageArray(270601415, msgBodySize);
        command[14] = 51;
        command[15] = lightTarget;
        byte[] durationBytes = new byte[2];
        Util.intToLittleEndianBytes(duration, durationBytes, 0, 2);
        System.arraycopy(durationBytes, 0, command, 16, durationBytes.length);
        byte[] onDurationBytes = new byte[2];
        Util.intToLittleEndianBytes(onDuration, onDurationBytes, 0, 2);
        System.arraycopy(onDurationBytes, 0, command, 18, onDurationBytes.length);
        byte[] offDurationBytes = new byte[2];
        Util.intToLittleEndianBytes(offDuration, offDurationBytes, 0, 2);
        System.arraycopy(offDurationBytes, 0, command, 20, offDurationBytes.length);
        command[22] = intensity;
        return new HTIMessage(command);
    }

    static HTIMessage createReleaseLightMessage() {
        int msgBodySize = 1;
        byte[] command = MessageFactory.initMessageArray(270601415, msgBodySize);
        command[14] = 58;
        return new HTIMessage(command);
    }

    static HTIMessage createSetNetworkModeMessage(int mode, boolean reboot) {
        int msgBodySize = 5;
        byte[] command = MessageFactory.initMessageArray(270601415, msgBodySize);
        int commandCode = 0;
        commandCode = reboot ? 81 : 82;
        command[14] = commandCode;
        Util.intToLittleEndianBytes(mode, command, 15, 4);
        return new HTIMessage(command);
    }

    static HTIMessage createGetNetworkModeMessage() {
        int msgBodySize = 1;
        byte[] command = MessageFactory.initMessageArray(270601415, msgBodySize);
        command[14] = 80;
        return new HTIMessage(command);
    }

    static HTIMessage createSetBluetoothPowerMessage(boolean on, boolean force) {
        int msgBodySize = 3;
        byte[] command = MessageFactory.initMessageArray(270601415, msgBodySize);
        command[14] = 91;
        command[15] = (byte)(on ? 1 : 0);
        command[16] = (byte)(force ? 1 : 0);
        return new HTIMessage(command);
    }

    static HTIMessage createSetBluetoothSettingsMessage(boolean discoverable, boolean enableSAP, String btName) {
        byte[] nameBytes = null;
        nameBytes = btName != null ? btName.getBytes() : new byte[]{};
        int msgBodySize = 4 + nameBytes.length;
        byte[] command = MessageFactory.initMessageArray(270601415, msgBodySize);
        int index = 14;
        command[index++] = 92;
        command[index++] = (byte)(discoverable ? 1 : 0);
        command[index++] = (byte)(enableSAP ? 1 : 0);
        command[index++] = (byte)(nameBytes.length & 0xFF);
        System.arraycopy(nameBytes, 0, command, index, nameBytes.length);
        return new HTIMessage(command);
    }

    static HTIMessage createDeleteBluetoothPairingMessage(boolean deleteActive, String pairingName) {
        byte[] nameBytes = null;
        boolean deleteAll = false;
        if (pairingName != null) {
            nameBytes = pairingName.getBytes();
        } else {
            nameBytes = new byte[]{};
            deleteAll = true;
        }
        int msgBodySize = 3 + nameBytes.length;
        byte[] command = MessageFactory.initMessageArray(270601415, msgBodySize);
        int index = 14;
        command[index++] = 93;
        command[index++] = (byte)(deleteActive ? 1 : 0);
        command[index++] = deleteAll ? (byte)0 : (byte)(nameBytes.length & 0xFF);
        System.arraycopy(nameBytes, 0, command, index, nameBytes.length);
        return new HTIMessage(command);
    }

    static HTIMessage createActivateIRMessage() {
        int msgBodySize = 1;
        byte[] command = MessageFactory.initMessageArray(270601415, msgBodySize);
        command[14] = 90;
        return new HTIMessage(command);
    }

    static HTIMessage createToggleKeyLockMessage(boolean lock, boolean showInfoNote) {
        int msgBodySize = 3;
        byte[] command = MessageFactory.initMessageArray(270601415, msgBodySize);
        command[14] = 96;
        command[15] = (byte)(lock ? 1 : 0);
        command[16] = (byte)(showInfoNote ? 1 : 0);
        return new HTIMessage(command);
    }

    static HTIMessage createSetAutoKeyGuardTimeMessage(int keylockTimeSeconds) {
        int msgBodySize = 3;
        byte[] command = MessageFactory.initMessageArray(270601415, msgBodySize);
        command[14] = 97;
        Util.intToLittleEndianBytes(keylockTimeSeconds, command, 15, 2);
        return new HTIMessage(command);
    }

    static HTIMessage createDisableScreenSaverMessage() {
        int msgBodySize = 1;
        byte[] command = MessageFactory.initMessageArray(270601415, msgBodySize);
        command[14] = 64;
        return new HTIMessage(command);
    }

    static HTIMessage createEnableScreenSaverMessage() {
        int msgBodySize = 1;
        byte[] command = MessageFactory.initMessageArray(270601415, msgBodySize);
        command[14] = 65;
        return new HTIMessage(command);
    }

    static HTIMessage createSetScreenSaverTimeoutMessage(byte period) {
        int msgBodySize = 2;
        byte[] command = MessageFactory.initMessageArray(270601415, msgBodySize);
        command[14] = 66;
        command[15] = period;
        return new HTIMessage(command);
    }

    static HTIMessage emptyDRMRightsDatabase() {
        int msgBodySize = 1;
        byte[] command = MessageFactory.initMessageArray(270601415, msgBodySize);
        command[14] = 101;
        return new HTIMessage(command);
    }

    static HTIMessage createGetIMEIMessage() {
        int msgBodySize = 1;
        byte[] command = MessageFactory.initMessageArray(270601415, msgBodySize);
        command[14] = 2;
        return new HTIMessage(command);
    }

    static HTIMessage createGetHALMessage() {
        int msgBodySize = 1;
        byte[] command = MessageFactory.initMessageArray(270601415, msgBodySize);
        command[14] = 1;
        return new HTIMessage(command);
    }

    static HTIMessage createGetSWVersionMessage() {
        int msgBodySize = 1;
        byte[] command = MessageFactory.initMessageArray(270601415, msgBodySize);
        command[14] = 3;
        return new HTIMessage(command);
    }

    static HTIMessage createGetLangVersionMessage() {
        int msgBodySize = 1;
        byte[] command = MessageFactory.initMessageArray(270601415, msgBodySize);
        command[14] = 4;
        return new HTIMessage(command);
    }

    static HTIMessage createGetSWLangVersionMessage() {
        int msgBodySize = 1;
        byte[] command = MessageFactory.initMessageArray(270601415, msgBodySize);
        command[14] = 5;
        return new HTIMessage(command);
    }

    static HTIMessage createGetUserAgentStringMessage() {
        int msgBodySize = 1;
        byte[] command = MessageFactory.initMessageArray(270601415, msgBodySize);
        command[14] = 6;
        return new HTIMessage(command);
    }

    static HTIMessage createGetBatteryStatusMessage() {
        int msgBodySize = 1;
        byte[] command = MessageFactory.initMessageArray(270601415, msgBodySize);
        command[14] = 112;
        return new HTIMessage(command);
    }

    static HTIMessage createGetSignalStrengthMessage() {
        int msgBodySize = 1;
        byte[] command = MessageFactory.initMessageArray(270601415, msgBodySize);
        command[14] = 113;
        return new HTIMessage(command);
    }

    static HTIMessage createSetHSDPAMessage(boolean enabled) {
        int msgBodySize = 2;
        byte[] command = MessageFactory.initMessageArray(270601415, msgBodySize);
        command[14] = 83;
        command[15] = (byte)(enabled ? 1 : 0);
        return new HTIMessage(command);
    }
}

