/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.HTI;

import com.nokia.HTI.HTIException;
import com.nokia.HTI.HTIMessage;
import com.nokia.HTI.HTIMessageFactory;
import com.nokia.HTI.HTISocket;
import com.nokia.HTI.HTIVersion;
import com.nokia.HTI.IService;
import com.nokia.HTI.common.Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;

public class BaseService
implements IService {
    boolean isConnected = false;
    String myHost = "";
    int myPort = -1;
    int UID = 0;
    protected HTISocket mySocket = null;
    private int connectionStatus = 3;
    private static final int HTI_CONNECTION_ACTIVE = -1;
    private static final int HTI_CONNECTION_FAILED = 0;
    private static final int HTI_CONNECT_MAX_RETRIES = 3;
    private static final int HTI_CONNECTION_REAUTHORIZED = -1002;
    private final Logger log = Logger.getLogger(this.getClass().getName());
    protected boolean cancelCurrentTransfer = false;

    public void connect(String host, int port) throws IOException {
        if (this.mySocket == null) {
            this.mySocket = HTISocket.getHTISocket(host, port);
        }
        this.myHost = host;
        this.myPort = port;
        this.isConnected = true;
    }

    public void connect() throws IOException {
        if (this.mySocket == null || this.mySocket.isClosed()) {
            this.mySocket = HTISocket.getHTISocket();
            this.myHost = this.mySocket.getInetAddress().getHostName();
            this.myPort = this.mySocket.getPort();
        }
        this.isConnected = true;
    }

    public void disconnect() throws IOException {
        this.isConnected = false;
        this.connectionStatus = 3;
        this.mySocket = null;
    }

    public void detach() throws IOException {
        this.isConnected = false;
        this.connectionStatus = 3;
        if (this.mySocket != null) {
            this.mySocket.close();
            this.mySocket = null;
        }
    }

    public String echo(String message) throws IOException, HTIException {
        return this.echo(message, 0L);
    }

    public void reboot() throws IOException, HTIException {
        byte[] command = HTIMessageFactory.createRebootMessage();
        this.log.finest("Sending reboot message");
        this.sendHTIAsyncMessage(new HTIMessage(command), 5000L);
    }

    public void reset() throws IOException, HTIException {
        byte[] command = HTIMessageFactory.createResetMessage();
        this.log.finest("Sending reset message");
        this.sendHTIAsyncMessage(new HTIMessage(command), 5000L);
    }

    public long getInstanceID(long timeout) throws IOException, HTIException {
        byte[] command = HTIMessageFactory.createInstanceIDMessage();
        this.log.finest("Sending instance ID message");
        HTIMessage response = this.sendHTIRequest(new HTIMessage(command), timeout);
        if (response.isErrorResponse()) {
            return -1L;
        }
        byte[] idBytes = new byte[4];
        System.arraycopy(response.getBody(), 0, idBytes, 0, 4);
        return Util.littleEndianUnsignedIntToLong(idBytes);
    }

    public boolean debugPrint(String message, long timeout) throws IOException, HTIException {
        HTIMessage msg = HTIMessageFactory.createDebugPrintMessage(message);
        this.log.finest("Sending instance ID message");
        HTIMessage response = this.sendHTIRequest(msg, timeout);
        if (response.isErrorResponse()) {
            return false;
        }
        byte[] resp = response.getBody();
        return resp != null && resp.length == 1 && resp[0] == 0;
    }

    public List listServices(long timeout) throws IOException, HTIException {
        int startIndex;
        byte[] command = HTIMessageFactory.createListHTIServicesMessage();
        this.log.finest("Sending list HTI services message");
        HTIMessage response = this.sendHTIRequest(new HTIMessage(command), timeout);
        if (response.isErrorResponse()) {
            return null;
        }
        ArrayList<String> services = new ArrayList<String>();
        int i = startIndex = 0;
        while (i + 128 <= response.getBody().length) {
            byte[] idBytes = new byte[4];
            System.arraycopy(response.getBody(), i, idBytes, 0, 4);
            byte[] nameBytes = new byte[124];
            System.arraycopy(response.getBody(), i + 4, nameBytes, 0, 124);
            long uid = Util.littleEndianUnsignedIntToLong(idBytes);
            String name = new String(nameBytes).trim();
            services.add(String.valueOf(Long.toHexString(uid)) + ":" + name);
            i += 128;
        }
        return services;
    }

    public HTIVersion getVersion(long timeout) throws IOException, HTIException {
        byte[] command = HTIMessageFactory.createGetVersionMessage();
        this.log.finest("Sending get version message");
        HTIMessage response = this.sendHTIRequest(new HTIMessage(command), timeout);
        if (response.isErrorResponse()) {
            return null;
        }
        byte[] majorBytes = new byte[1];
        System.arraycopy(response.getBody(), 0, majorBytes, 0, 1);
        byte[] minorBytes = new byte[1];
        System.arraycopy(response.getBody(), 1, minorBytes, 0, 1);
        return new HTIVersion(Util.littleEndianToInt(majorBytes), Util.littleEndianToInt(minorBytes));
    }

    public void stopHTI() throws IOException, HTIException {
        byte[] command = HTIMessageFactory.createStopHTIMessage();
        this.log.finest("Sending stop HTI message");
        this.sendHTIAsyncMessage(new HTIMessage(command), 5000L);
    }

    public void format(long timeout) throws IOException, HTIException {
        byte[] command = HTIMessageFactory.createFormatMessage();
        this.log.finest("Sending format message");
        this.sendHTIRequest(new HTIMessage(command), timeout);
    }

    public void format(int mode, long timeout) throws IOException, HTIException {
        byte[] command = HTIMessageFactory.createFormatMessage(mode);
        this.log.finest("Sending restore factory settings message");
        this.sendHTIAsyncMessage(new HTIMessage(command), timeout);
    }

    public String echo(String message, long timeout) throws IOException, HTIException {
        HTIMessage msg = HTIMessageFactory.createEchoMessage(message);
        HTIMessage response = this.sendHTIRequest(msg, timeout);
        return new String(response.getBody());
    }

    private int reInitializeHTI(long timeout) {
        this.connectionStatus = 3;
        return this.initializeHTI(timeout);
    }

    /*
     * Unable to fully structure code
     */
    private int initializeHTI(long timeout) {
        if (this.connectionStatus == -1) {
            return 0;
        }
        if (this.connectionStatus != 0) ** GOTO lbl29
        return -1;
lbl-1000:
        // 1 sources

        {
            --this.connectionStatus;
            this.log.info("Initializing HTI connection");
            try {
                this.connect(this.myHost, this.myPort);
                command = HTIMessageFactory.createAuthMessage();
                this.mySocket.setWriteTimeout(timeout);
                this.mySocket.getOutputStream().write(command, 0, command.length);
                this.getResponse((int)timeout);
            }
            catch (IOException e) {
                try {
                    tempstatus = this.connectionStatus;
                    this.detach();
                    this.connectionStatus = tempstatus;
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                }
                this.log.severe("Error when initializing HTI connection. Retrying " + this.connectionStatus + " more time(s). - " + e.getMessage());
                continue;
            }
            this.log.info("HTI connection HTI_OK.");
            this.connectionStatus = -1;
            this.mySocket.setInitialized(true);
            return 0;
lbl29:
            // 2 sources

            ** while (this.connectionStatus > 0)
        }
lbl30:
        // 1 sources

        return -1;
    }

    public HTIMessage sendHTIRequest(HTIMessage command) throws HTIException, IOException {
        return this.sendHTIRequest(command, 0L);
    }

    public HTIMessage sendHTIRequest(HTIMessage command, long timeout) throws HTIException, IOException {
        HTIMessage response;
        try {
            int initialized = this.initializeHTI(timeout);
            if (initialized != 0) {
                throw new HTIException("HTI NOT INITIALIZED");
            }
            this.mySocket.setWriteTimeout((int)timeout);
            this.mySocket.getOutputStream().write(command.getBytes(), 0, command.getBytes().length);
            response = this.getResponse(timeout);
        }
        catch (IOException e) {
            this.log.severe("IOException when sending request using HTI connection.");
            throw e;
        }
        boolean attemptReauthorization = true;
        int serviceUid = command.getServicePlugInID();
        int result = this.doErrorCheck(serviceUid, response, true, timeout);
        if (result != 0) {
            this.log.severe("Error when sending HTI request");
            if (result == -1002) {
                this.log.warning("Error check of HTI response suggests that HTI conection was lost but reinitialized, Retrying command once");
                return this.sendHTIRequest(command, timeout);
            }
            throw new HTIException("Response error check failed", response);
        }
        return response;
    }

    public void sendHTIAsyncMessage(HTIMessage command, long timeout) throws HTIException, IOException {
        try {
            int initialized = this.initializeHTI(timeout);
            if (initialized != 0) {
                throw new HTIException("HTI NOT INITIALIZED");
            }
            this.mySocket.setWriteTimeout(timeout);
            this.mySocket.getOutputStream().write(command.getBytes(), 0, command.getBytes().length);
        }
        catch (IOException e) {
            this.log.severe("IOException when sending request using HTI connection.");
            throw e;
        }
    }

    public void sendRawData(byte[] filePartData) throws IOException {
        this.sendRawData(filePartData, 0L);
    }

    public void sendRawData(byte[] filePartData, long timeout) throws IOException {
        this.log.finest("Constructing HTI header for FTP file/part of file.");
        byte[] header = new byte[14];
        Arrays.fill(header, (byte)0);
        Util.intToLittleEndianBytes(270589637, header, 0, 4);
        int dataLength = filePartData.length;
        Util.intToLittleEndianBytes(dataLength, header, 4, 4);
        int crc = HTIMessageFactory.CRC16CCITT(header, 12);
        Util.intToLittleEndianBytes(crc, header, 12, 2);
        this.mySocket.setWriteTimeout((int)timeout);
        OutputStream out = this.mySocket.getOutputStream();
        this.log.finest("Sending HTI header for FTP file/part of file.");
        out.write(header);
        this.log.finest("Sending file/part of file itself");
        out.write(filePartData, 0, filePartData.length);
        out.flush();
    }

    public byte[] readRawData(int dataLength) throws IOException, HTIException {
        return this.readRawData(dataLength, 0L);
    }

    public byte[] readRawData(int dataLength, long timeout) throws IOException, HTIException {
        int readHeaderBytes = 0;
        int readDataBytes = 0;
        int totalDataBytesRead = 0;
        long dynamicTimeout = 0L;
        boolean useTimeout = timeout > 0L;
        long deadline = System.currentTimeMillis() + timeout;
        byte[] data = new byte[dataLength];
        byte[] dataFragment = null;
        if (timeout > 0L) {
            this.mySocket.setSoTimeout((int)timeout);
        }
        InputStream in = this.mySocket.getInputStream();
        boolean allRead = false;
        byte[] header = new byte[14];
        do {
            if (this.cancelCurrentTransfer) {
                throw new HTIException("Downloading was canceled.");
            }
            if (useTimeout) {
                dynamicTimeout = deadline - System.currentTimeMillis();
                this.mySocket.setSoTimeout((int)dynamicTimeout);
                if (deadline <= System.currentTimeMillis()) {
                    throw new HTIException("Downloading was canceled.");
                }
            }
            this.log.finest("Reading HTI header for FTP file/part of file.");
            while ((readHeaderBytes += in.read(header, readHeaderBytes, 14 - readHeaderBytes)) < 14) {
            }
            readHeaderBytes = 0;
            int bodySize = ((header[7] & 0xFF) << 24) + ((header[6] & 0xFF) << 16) + ((header[5] & 0xFF) << 8) + (header[4] & 0xFF);
            dataFragment = bodySize > dataLength - totalDataBytesRead ? new byte[dataLength - totalDataBytesRead] : new byte[bodySize];
            if (this.cancelCurrentTransfer) {
                throw new HTIException("Downloading was canceled.");
            }
            if (useTimeout) {
                dynamicTimeout = deadline - System.currentTimeMillis();
                this.mySocket.setSoTimeout((int)dynamicTimeout);
                if (deadline <= System.currentTimeMillis()) {
                    throw new HTIException("Downloading was canceled.");
                }
            }
            this.log.finest("Reading HTI data for FTP file/part of file.");
            while ((readDataBytes += in.read(dataFragment, readDataBytes, dataFragment.length - readDataBytes)) < dataFragment.length) {
            }
            System.arraycopy(dataFragment, 0, data, totalDataBytesRead, dataFragment.length);
            allRead = (totalDataBytesRead += readDataBytes) >= dataLength;
            readDataBytes = 0;
        } while (!allRead);
        return data;
    }

    public HTIMessage getResponse() throws IOException {
        return this.getResponse(0L);
    }

    public HTIMessage getResponse(long timeout) throws IOException {
        byte[] body;
        byte[] header;
        block5: {
            this.mySocket.setSoTimeout((int)timeout);
            this.log.finest("Timeout for reading response: " + timeout);
            InputStream in = this.mySocket.getInputStream();
            int headerLen = 14;
            header = new byte[headerLen];
            int headerCount = 0;
            body = new byte[]{};
            try {
                int expectedCrc;
                while ((headerCount += in.read(header, headerCount, headerLen - headerCount)) < headerLen) {
                }
                int crc = HTIMessageFactory.CRC16CCITT(header, 12);
                if (crc != (expectedCrc = ((header[13] & 0xFF) << 8) + (header[12] & 0xFF))) {
                    throw new Exception("Invalid header");
                }
                int size = ((header[7] & 0xFF) << 24) + ((header[6] & 0xFF) << 16) + ((header[5] & 0xFF) << 8) + (header[4] & 0xFF);
                body = new byte[size];
                int readBytes = 0;
                while ((readBytes += in.read(body, readBytes, size - readBytes)) < size) {
                }
            }
            catch (Exception e) {
                this.log.severe("Error when getting HTI response from input stream - " + e.getMessage());
                if (!(e instanceof IOException)) break block5;
                throw (IOException)e;
            }
        }
        return new HTIMessage(header, body);
    }

    public int doErrorCheck(int serviceUid, HTIMessage response, boolean attemptReauthorization, long timeout) {
        byte[] responseHeader = response.getHeader();
        byte[] responseBody = response.getBody();
        if (responseHeader == null) {
            this.log.severe("Response header from HTI was null");
            return -1;
        }
        if (responseBody == null) {
            this.log.severe("Response header from HTI was null");
            return -1;
        }
        this.log.finest("Doing error check on HTI response with length " + (responseHeader.length + responseBody.length));
        if (responseHeader.length == 0) {
            this.log.severe("Response header from HTI had length 0");
            return -1;
        }
        if (HTIMessageFactory.checkHeaderCRC(responseHeader) == -1) {
            this.log.severe("CRC integrity check of response header failed");
            return -1;
        }
        int responseUid = response.getServicePlugInID();
        this.log.finest("UID in response header was: " + responseUid + ". Expected UID:" + serviceUid + ".");
        if (!response.isErrorResponse()) {
            return 0;
        }
        int errorCode = response.getHTIErrorCode();
        switch (errorCode) {
            case 1: {
                this.log.severe("HTI return error code: Message too large (Message body size exceeds predefined limit).");
                return -1;
            }
            case 2: {
                this.log.severe("HTI returned error code: Out of memory (No sufficient amount of memory to process request).");
                return -1;
            }
            case 3: {
                this.log.severe("HTI returned error code: Service not found (Message is addressed to non-existent service).");
                return -1;
            }
            case 4: {
                this.log.severe("HTI returned error code: Service error (Error in plug-in while processing request).");
                this.log.severe("Service error code " + response.getServiceErrorCode());
                this.log.severe("error description: " + response.getErrorDescription());
                return -1;
            }
            case 5: {
                int result;
                this.log.severe("HTI returned error code: Not authorized (Request is not authorized). Attempting reauthorization");
                if (attemptReauthorization && (result = this.reInitializeHTI(timeout)) == 0) {
                    return -1002;
                }
                return -1;
            }
            case 6: {
                this.log.severe("HTI returned error code: Failed unwrap (Security manager failed to decode message).");
                return -1;
            }
        }
        this.log.severe("HTI returned an unknown error code: " + errorCode + ".");
        return -1;
    }
}

