/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.HTI.KeyEventService;

import com.nokia.HTI.HTIMessage;
import com.nokia.HTI.HTIMessageFactory;
import com.nokia.HTI.common.Util;
import java.io.UnsupportedEncodingException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MessageFactory
extends HTIMessageFactory {
    static final int uid = 270589633;

    MessageFactory() {
    }

    static HTIMessage createPressKeyMessage(byte[] scanCode) {
        return MessageFactory.createKeyMessage(scanCode, (byte)1);
    }

    static HTIMessage createHoldKeyMessage(byte[] scanCode) {
        return MessageFactory.createKeyMessage(scanCode, (byte)2);
    }

    static HTIMessage createReleaseKeyMessage(byte[] scanCode) {
        return MessageFactory.createKeyMessage(scanCode, (byte)3);
    }

    static HTIMessage createLongKeyPressMessage(byte[] scanCode, int time) {
        int msgBodySize = 1 + scanCode.length + 2;
        byte[] timeBytes = new byte[2];
        Util.intToLittleEndianBytes(time, timeBytes, 0, 2);
        byte[] command = MessageFactory.initMessageArray(270589633, msgBodySize);
        command[14] = 5;
        System.arraycopy(scanCode, 0, command, 15, scanCode.length);
        System.arraycopy(timeBytes, 0, command, 15 + scanCode.length, timeBytes.length);
        return new HTIMessage(command);
    }

    private static HTIMessage createKeyMessage(byte[] scanCode, byte serviceCmd) {
        int msgBodySize = 1 + scanCode.length;
        byte[] command = MessageFactory.initMessageArray(270589633, msgBodySize);
        command[14] = (byte)(serviceCmd & 0xFF);
        System.arraycopy(scanCode, 0, command, 15, scanCode.length);
        return new HTIMessage(command);
    }

    static HTIMessage createTypeMessage(String text) {
        try {
            return MessageFactory.createKeyMessage(text.getBytes("UTF-16LE"), (byte)4);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    static HTIMessage createTypePasswordMessage(String text) {
        try {
            return MessageFactory.createKeyMessage(text.getBytes("UTF-16LE"), (byte)6);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    static HTIMessage createKeyPressSequenceMessage(List<byte[]> scanCodeList, int timeToHold, int interval) {
        int msgBodySize = 5 + scanCodeList.size() * 2;
        byte[] command = MessageFactory.initMessageArray(270589633, msgBodySize);
        int serviceCmd = 7;
        command[14] = (byte)(serviceCmd & 0xFF);
        byte[] timeToHoldBytes = new byte[2];
        Util.intToLittleEndianBytes(timeToHold, timeToHoldBytes, 0, 2);
        System.arraycopy(timeToHoldBytes, 0, command, 15, timeToHoldBytes.length);
        byte[] intervalBytes = new byte[2];
        Util.intToLittleEndianBytes(interval, intervalBytes, 0, 2);
        System.arraycopy(intervalBytes, 0, command, 17, intervalBytes.length);
        int msgOffset = 5;
        for (byte[] scanCode : scanCodeList) {
            System.arraycopy(scanCode, 0, command, 14 + msgOffset, scanCode.length);
            msgOffset += 2;
        }
        return new HTIMessage(command);
    }

    static HTIMessage createTapScreenMessage(int x, int y, int tapCount, int timeToHold, int pauseBetweenTaps) {
        int msgBodySize = 11;
        byte[] command = MessageFactory.initMessageArray(270589633, msgBodySize);
        int serviceCmd = 16;
        command[14] = (byte)(serviceCmd & 0xFF);
        byte[] xBytes = new byte[2];
        Util.intToLittleEndianBytes(x, xBytes, 0, 2);
        System.arraycopy(xBytes, 0, command, 15, xBytes.length);
        byte[] yBytes = new byte[2];
        Util.intToLittleEndianBytes(y, yBytes, 0, 2);
        System.arraycopy(yBytes, 0, command, 17, yBytes.length);
        byte[] timeToHoldBytes = new byte[2];
        Util.intToLittleEndianBytes(timeToHold, timeToHoldBytes, 0, 2);
        System.arraycopy(timeToHoldBytes, 0, command, 19, timeToHoldBytes.length);
        byte[] tapCountBytes = new byte[2];
        Util.intToLittleEndianBytes(tapCount, tapCountBytes, 0, 2);
        System.arraycopy(tapCountBytes, 0, command, 21, tapCountBytes.length);
        byte[] pauseBytes = new byte[2];
        Util.intToLittleEndianBytes(pauseBetweenTaps, pauseBytes, 0, 2);
        System.arraycopy(pauseBytes, 0, command, 23, pauseBytes.length);
        return new HTIMessage(command);
    }

    static HTIMessage createTapAndDragMessage(int startX, int startY, int endX, int endY, int dragTime) {
        int msgBodySize = 11;
        byte[] command = MessageFactory.initMessageArray(270589633, msgBodySize);
        int serviceCmd = 17;
        command[14] = (byte)(serviceCmd & 0xFF);
        byte[] x1Bytes = new byte[2];
        Util.intToLittleEndianBytes(startX, x1Bytes, 0, 2);
        System.arraycopy(x1Bytes, 0, command, 15, x1Bytes.length);
        byte[] y1Bytes = new byte[2];
        Util.intToLittleEndianBytes(startY, y1Bytes, 0, 2);
        System.arraycopy(y1Bytes, 0, command, 17, y1Bytes.length);
        byte[] x2Bytes = new byte[2];
        Util.intToLittleEndianBytes(endX, x2Bytes, 0, 2);
        System.arraycopy(x2Bytes, 0, command, 19, x2Bytes.length);
        byte[] y2Bytes = new byte[2];
        Util.intToLittleEndianBytes(endY, y2Bytes, 0, 2);
        System.arraycopy(y2Bytes, 0, command, 21, y2Bytes.length);
        byte[] timeBytes = new byte[2];
        Util.intToLittleEndianBytes(dragTime, timeBytes, 0, 2);
        System.arraycopy(timeBytes, 0, command, 23, timeBytes.length);
        return new HTIMessage(command);
    }

    static HTIMessage createTapAndDragMultipointMessage(int pointTime, int lineTime, List coordinateList) {
        int msgBodySize = 7 + coordinateList.size() * 2;
        byte[] command = MessageFactory.initMessageArray(270589633, msgBodySize);
        int serviceCmd = 18;
        command[14] = (byte)(serviceCmd & 0xFF);
        byte[] pointTimeBytes = new byte[2];
        Util.intToLittleEndianBytes(pointTime, pointTimeBytes, 0, 2);
        System.arraycopy(pointTimeBytes, 0, command, 15, pointTimeBytes.length);
        byte[] lineTimeBytes = new byte[2];
        Util.intToLittleEndianBytes(lineTime, lineTimeBytes, 0, 2);
        System.arraycopy(lineTimeBytes, 0, command, 17, lineTimeBytes.length);
        byte[] listSizeBytes = new byte[2];
        int pointCount = coordinateList.size() / 2;
        Util.intToLittleEndianBytes(pointCount, listSizeBytes, 0, 2);
        System.arraycopy(listSizeBytes, 0, command, 19, listSizeBytes.length);
        byte[] listBytes = new byte[2];
        int counter = 7;
        int i = 0;
        while (i < coordinateList.size()) {
            Object item = coordinateList.get(i);
            String itemS = item.toString();
            Util.intToLittleEndianBytes(Integer.parseInt(itemS), listBytes, 0, 2);
            System.arraycopy(listBytes, 0, command, 14 + counter, listBytes.length);
            ++counter;
            ++counter;
            ++i;
        }
        return new HTIMessage(command);
    }
}

