/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.HTI.MessagesService;

import com.nokia.HTI.HTIException;
import com.nokia.HTI.HTIMessage;
import com.nokia.HTI.HTIMessageFactory;
import com.nokia.HTI.common.Util;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;

class MessageFactory
extends HTIMessageFactory {
    private static final int uid = 270601423;

    MessageFactory() {
    }

    static HTIMessage createAddSMSMessage(String fromTo, String description, String messageBody, boolean isNew, boolean isUnread, byte toFolder) {
        byte[] fromToBytes = new byte[]{};
        try {
            fromToBytes = fromTo.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        byte[] descriptionBytes = new byte[]{};
        try {
            descriptionBytes = description.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
        byte[] messageBodyBytes = new byte[]{};
        try {
            messageBodyBytes = messageBody.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
        byte isNewByte = 0;
        byte isUnreadByte = 0;
        int index = 0;
        if (isNew) {
            isNewByte = 1;
        }
        if (isUnread) {
            isUnreadByte = 1;
        }
        int msgBodySize = fromToBytes.length + descriptionBytes.length + messageBodyBytes.length + 8;
        byte[] header = MessageFactory.createHeader(270601423, msgBodySize);
        byte[] body = new byte[msgBodySize];
        byte[] command = new byte[header.length + msgBodySize];
        body[index++] = 1;
        body[index++] = (byte)fromToBytes.length;
        System.arraycopy(fromToBytes, 0, body, index, fromToBytes.length);
        index += fromToBytes.length;
        body[index++] = (byte)descriptionBytes.length;
        System.arraycopy(descriptionBytes, 0, body, index, descriptionBytes.length);
        Util.intToLittleEndianBytes(messageBodyBytes.length, body, index += descriptionBytes.length, 2);
        System.arraycopy(messageBodyBytes, 0, body, index += 2, messageBodyBytes.length);
        index += messageBodyBytes.length;
        body[index++] = isNewByte;
        body[index++] = isUnreadByte;
        body[index++] = toFolder;
        System.arraycopy(header, 0, command, 0, header.length);
        System.arraycopy(body, 0, command, header.length, body.length);
        return new HTIMessage(command);
    }

    static HTIMessage createDeleteMessageMessage(int id) {
        int msgBodySize = 5;
        byte[] command = MessageFactory.initMessageArray(270601423, msgBodySize);
        command[14] = 16;
        Util.intToLittleEndianBytes(id, command, 15, 4);
        return new HTIMessage(command);
    }

    static HTIMessage createDeleteFolderContentMessage(byte folder, byte messageType) {
        int msgBodySize = 3;
        byte[] command = MessageFactory.initMessageArray(270601423, msgBodySize);
        command[14] = 17;
        command[15] = folder;
        command[16] = messageType;
        return new HTIMessage(command);
    }

    static HTIMessage createAddSmartMessage(String fromTo, String description, byte[] messageBodyBytes, boolean isNew, boolean isUnread, long messageType, byte toFolderFlags) {
        byte[] fromToBytes = new byte[]{};
        try {
            fromToBytes = fromTo.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
        byte[] descriptionBytes = new byte[]{};
        try {
            descriptionBytes = description.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
        byte isNewByte = 0;
        byte isUnreadByte = 0;
        int index = 0;
        if (isNew) {
            isNewByte = 1;
        }
        if (isUnread) {
            isUnreadByte = 1;
        }
        int msgBodySize = fromToBytes.length + descriptionBytes.length + messageBodyBytes.length + 12;
        byte[] header = MessageFactory.createHeader(270601423, msgBodySize);
        byte[] body = new byte[msgBodySize];
        byte[] command = new byte[header.length + msgBodySize];
        body[index++] = 6;
        body[index++] = (byte)fromToBytes.length;
        System.arraycopy(fromToBytes, 0, body, index, fromToBytes.length);
        index += fromToBytes.length;
        body[index++] = (byte)descriptionBytes.length;
        System.arraycopy(descriptionBytes, 0, body, index, descriptionBytes.length);
        Util.intToLittleEndianBytes(messageBodyBytes.length, body, index += descriptionBytes.length, 2);
        System.arraycopy(messageBodyBytes, 0, body, index += 2, messageBodyBytes.length);
        index += messageBodyBytes.length;
        body[index++] = isNewByte;
        body[index++] = isUnreadByte;
        body[index++] = toFolderFlags;
        Util.longToLittleEndianBytes(messageType, body, index, 4);
        index += 4;
        System.arraycopy(header, 0, command, 0, header.length);
        System.arraycopy(body, 0, command, header.length, body.length);
        return new HTIMessage(command);
    }

    static HTIMessage createAddEmailMessage(String fromTo, String description, String messageBody, String attachmentPath, boolean isNew, boolean isUnread, byte toFolderFlags) {
        return MessageFactory.createAddEmailOrMMSMessage(3, fromTo, description, messageBody, attachmentPath, isNew, isUnread, toFolderFlags);
    }

    static HTIMessage createAddMMSMessage(String fromTo, String description, String messageBody, String attachmentPath, boolean isNew, boolean isUnread, byte toFolderFlags) {
        return MessageFactory.createAddEmailOrMMSMessage(2, fromTo, description, messageBody, attachmentPath, isNew, isUnread, toFolderFlags);
    }

    static HTIMessage createAddAudioMessage(String fromTo, String description, String attachmentPath, boolean isNew, boolean isUnread, byte toFolderFlags) {
        return MessageFactory.createAddEmailOrMMSMessage(2, fromTo, description, "", attachmentPath, isNew, isUnread, toFolderFlags);
    }

    private static HTIMessage createAddEmailOrMMSMessage(int messageType, String fromTo, String description, String messageBody, String attachmentPath, boolean isNew, boolean isUnread, byte toFolderFlags) {
        byte[] fromToBytes = new byte[]{};
        try {
            fromToBytes = fromTo.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
        byte[] descriptionBytes = new byte[]{};
        try {
            descriptionBytes = description.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
        byte[] messageBodyBytes = new byte[]{};
        try {
            messageBodyBytes = messageBody.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
        byte[] attachmentPathBytes = null;
        if (attachmentPath != null) {
            try {
                attachmentPathBytes = attachmentPath.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                return null;
            }
        } else {
            attachmentPathBytes = new byte[]{};
        }
        byte isNewByte = 0;
        byte isUnreadByte = 0;
        int index = 0;
        if (isNew) {
            isNewByte = 1;
        }
        if (isUnread) {
            isUnreadByte = 1;
        }
        int msgBodySize = fromToBytes.length + descriptionBytes.length + messageBodyBytes.length + attachmentPathBytes.length + 9;
        byte[] header = MessageFactory.createHeader(270601423, msgBodySize);
        byte[] body = new byte[msgBodySize];
        byte[] command = new byte[header.length + msgBodySize];
        body[index++] = (byte)(messageType & 0xFF);
        body[index++] = (byte)fromToBytes.length;
        System.arraycopy(fromToBytes, 0, body, index, fromToBytes.length);
        index += fromToBytes.length;
        body[index++] = (byte)descriptionBytes.length;
        System.arraycopy(descriptionBytes, 0, body, index, descriptionBytes.length);
        Util.intToLittleEndianBytes(messageBodyBytes.length, body, index += descriptionBytes.length, 2);
        System.arraycopy(messageBodyBytes, 0, body, index += 2, messageBodyBytes.length);
        index += messageBodyBytes.length;
        body[index++] = (byte)attachmentPathBytes.length;
        System.arraycopy(attachmentPathBytes, 0, body, index, attachmentPathBytes.length);
        index += attachmentPathBytes.length;
        body[index++] = isNewByte;
        body[index++] = isUnreadByte;
        body[index++] = toFolderFlags;
        System.arraycopy(header, 0, command, 0, header.length);
        System.arraycopy(body, 0, command, header.length, body.length);
        return new HTIMessage(command);
    }

    private static HTIMessage createAddBTOrIRMessage(int messageType, String fromTo, String description, String attachmentPath, boolean isNew, boolean isUnread, byte toFolderFlags) {
        byte[] fromToBytes = new byte[]{};
        try {
            fromToBytes = fromTo.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
        byte[] descriptionBytes = new byte[]{};
        try {
            descriptionBytes = description.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
        byte[] attachmentPathBytes = null;
        if (attachmentPath != null) {
            try {
                attachmentPathBytes = attachmentPath.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                return null;
            }
        } else {
            attachmentPathBytes = new byte[]{};
        }
        byte isNewByte = 0;
        byte isUnreadByte = 0;
        int index = 0;
        if (isNew) {
            isNewByte = 1;
        }
        if (isUnread) {
            isUnreadByte = 1;
        }
        int msgBodySize = fromToBytes.length + descriptionBytes.length + attachmentPathBytes.length + 7;
        byte[] header = MessageFactory.createHeader(270601423, msgBodySize);
        byte[] body = new byte[msgBodySize];
        byte[] command = new byte[header.length + msgBodySize];
        body[index++] = (byte)(messageType & 0xFF);
        body[index++] = (byte)fromToBytes.length;
        System.arraycopy(fromToBytes, 0, body, index, fromToBytes.length);
        index += fromToBytes.length;
        body[index++] = (byte)descriptionBytes.length;
        System.arraycopy(descriptionBytes, 0, body, index, descriptionBytes.length);
        index += descriptionBytes.length;
        body[index++] = (byte)attachmentPathBytes.length;
        System.arraycopy(attachmentPathBytes, 0, body, index, attachmentPathBytes.length);
        index += attachmentPathBytes.length;
        body[index++] = isNewByte;
        body[index++] = isUnreadByte;
        body[index++] = toFolderFlags;
        System.arraycopy(header, 0, command, 0, header.length);
        System.arraycopy(body, 0, command, header.length, body.length);
        return new HTIMessage(command);
    }

    static HTIMessage createAddIRMessage(String fromTo, String description, String attachmentPath, boolean isNew, boolean isUnread, byte toFolderFlags) {
        return MessageFactory.createAddBTOrIRMessage(4, fromTo, description, attachmentPath, isNew, isUnread, toFolderFlags);
    }

    static HTIMessage createAddBTMessage(String fromTo, String description, String attachmentPath, boolean isNew, boolean isUnread, byte toFolderFlags) {
        return MessageFactory.createAddBTOrIRMessage(5, fromTo, description, attachmentPath, isNew, isUnread, toFolderFlags);
    }

    static HTIMessage createCreateAccessPointMessage(byte bearerType, String name, Hashtable fields) {
        byte[] nameBytes = name.getBytes();
        int index = 0;
        int msgBodySize = 4;
        msgBodySize += nameBytes.length;
        Enumeration e = fields.keys();
        while (e.hasMoreElements()) {
            msgBodySize += 2;
            Object key = e.nextElement();
            String value = (String)fields.get(key);
            msgBodySize += value.getBytes().length;
        }
        e = null;
        byte[] header = MessageFactory.createHeader(270601423, msgBodySize);
        byte[] body = new byte[msgBodySize];
        body[index++] = 48;
        body[index++] = bearerType;
        body[index++] = (byte)nameBytes.length;
        System.arraycopy(nameBytes, 0, body, index, nameBytes.length);
        index += nameBytes.length;
        body[index++] = (byte)fields.size();
        e = fields.keys();
        while (e.hasMoreElements()) {
            Byte key = (Byte)e.nextElement();
            String value = (String)fields.remove(key);
            byte[] valueBytes = value.getBytes();
            body[index++] = key;
            body[index++] = (byte)valueBytes.length;
            System.arraycopy(valueBytes, 0, body, index, valueBytes.length);
            index += valueBytes.length;
        }
        byte[] command = new byte[header.length + msgBodySize];
        System.arraycopy(header, 0, command, 0, header.length);
        System.arraycopy(body, 0, command, header.length, body.length);
        return new HTIMessage(command);
    }

    static HTIMessage createCreateMailboxMessage(Hashtable fields) throws HTIException {
        int mailLimit;
        int sizeLimit;
        int port;
        int index = 0;
        int msgBodySize = 33 + MessageFactory.getVariableFieldLengths(fields);
        byte[] header = MessageFactory.createHeader(270601423, msgBodySize);
        byte[] body = new byte[msgBodySize];
        body[index++] = 32;
        String mailboxType = (String)fields.get("type");
        if (mailboxType == null || mailboxType.length() < 1) {
            throw new HTIException("Mailbox type must be set when adding new mailbox.");
        }
        if ("0".equals(mailboxType = mailboxType.trim().toLowerCase()) || "pop3".equals(mailboxType)) {
            body[index++] = 0;
        } else if ("1".equals(mailboxType) || "imap4".equals(mailboxType)) {
            body[index++] = 1;
        } else {
            throw new HTIException("Unknown mailbox type: " + mailboxType);
        }
        index += MessageFactory.addMailboxField(fields, "name", body, index, 1, 30, 1);
        index += MessageFactory.addMailboxField(fields, "incoming_server", body, index, 3, 50, 1);
        index += MessageFactory.addMailboxField(fields, "incoming_accesspoint", body, index, 0, 255, 1);
        index += MessageFactory.addMailboxField(fields, "incoming_username", body, index, 0, 50, 1);
        index += MessageFactory.addMailboxField(fields, "incoming_password", body, index, 0, 50, 1);
        String security = (String)fields.get("incoming_security");
        if (security == null || security.length() < 1) {
            throw new HTIException("Incoming security must be set when adding new mailbox.");
        }
        if ("0".equals(security = security.trim().toLowerCase()) || "off".equals(security)) {
            body[index++] = 0;
        } else if ("1".equals(security) || "tls".equals(security)) {
            body[index++] = 1;
        } else if ("2".equals(security) || "ssl".equals(security)) {
            body[index++] = 2;
        } else {
            throw new HTIException("Unknown incoming security type: " + security);
        }
        String incomingPort = (String)fields.get("incoming_port");
        if (incomingPort == null) {
            incomingPort = "0";
        }
        try {
            port = Integer.parseInt(incomingPort);
        }
        catch (NumberFormatException e) {
            throw new HTIException(e.getMessage());
        }
        Util.intToLittleEndianBytes(port, body, index, 2);
        index += 2;
        security = (String)fields.get("pop3_secure_login");
        if (security == null || security.length() < 1) {
            throw new HTIException("Pop3 secure login must be set when adding new mailbox.");
        }
        if ("0".equals(security = security.trim().toLowerCase()) || "no".equals(security) || "false".equals(security)) {
            body[index++] = 0;
        } else if ("1".equals(security) || "yes".equals(security) || "true".equals(security)) {
            body[index++] = 1;
        } else {
            throw new HTIException("Unknown POP3 secure login type: " + security);
        }
        index += MessageFactory.addMailboxField(fields, "outgoing_server", body, index, 3, 50, 1);
        index += MessageFactory.addMailboxField(fields, "outgoing_accesspoint", body, index, 0, 255, 1);
        index += MessageFactory.addMailboxField(fields, "outgoing_username", body, index, 0, 50, 1);
        index += MessageFactory.addMailboxField(fields, "outgoing_password", body, index, 0, 50, 1);
        security = (String)fields.get("outgoing_security");
        if (security == null || security.length() < 1) {
            throw new HTIException("Outgoing security must be set when adding new mailbox.");
        }
        if ("0".equals(security = security.trim().toLowerCase()) || "off".equals(security)) {
            body[index++] = 0;
        } else if ("1".equals(security) || "tls".equals(security)) {
            body[index++] = 1;
        } else if ("2".equals(security) || "ssl".equals(security)) {
            body[index++] = 2;
        } else {
            throw new HTIException("Unknown outgoing security type: " + security);
        }
        String outgoingPort = (String)fields.get("outgoing_port");
        if (outgoingPort == null) {
            outgoingPort = "0";
        }
        try {
            port = Integer.parseInt(incomingPort);
        }
        catch (NumberFormatException e) {
            throw new HTIException(e.getMessage());
        }
        Util.intToLittleEndianBytes(port, body, index, 2);
        index += 2;
        index += MessageFactory.addMailboxField(fields, "from_address", body, index, 1, 100, 1);
        index += MessageFactory.addMailboxField(fields, "from_name", body, index, 0, 100, 1);
        String sendOption = (String)fields.get("send_option");
        if (sendOption == null || sendOption.length() < 1) {
            throw new HTIException("Send option must be set when adding new mailbox.");
        }
        if ("0".equals(sendOption = sendOption.trim().toLowerCase()) || "immediately".equals(sendOption)) {
            body[index++] = 0;
        } else if ("1".equals(sendOption) || "on_next_connection".equals(sendOption)) {
            body[index++] = 1;
        } else if ("2".equals(sendOption) || "on_request".equals(sendOption)) {
            body[index++] = 2;
        } else {
            throw new HTIException("Unknown send option type: " + sendOption);
        }
        String copyToOwnAddress = (String)fields.get("copy_to_own_address");
        if (copyToOwnAddress == null || copyToOwnAddress.length() < 1) {
            throw new HTIException("copy_to_own_address must be set when adding new mailbox.");
        }
        if ("0".equals(copyToOwnAddress = copyToOwnAddress.trim().toLowerCase()) || "no".equals(copyToOwnAddress)) {
            body[index++] = 0;
        } else if ("1".equals(copyToOwnAddress) || "to_field".equals(copyToOwnAddress)) {
            body[index++] = 1;
        } else if ("2".equals(copyToOwnAddress) || "cc_field".equals(copyToOwnAddress)) {
            body[index++] = 2;
        } else if ("3".equals(copyToOwnAddress) || "bcc_field".equals(copyToOwnAddress)) {
            body[index++] = 3;
        } else {
            throw new HTIException("Unknown copy_to_own_address type: " + copyToOwnAddress);
        }
        index += MessageFactory.addMailboxField(fields, "signature", body, index, 0, 500, 2);
        String newMailIndicator = (String)fields.get("new_mail_indicators");
        if (newMailIndicator == null || newMailIndicator.length() < 1) {
            throw new HTIException("New mail indicators must be set when adding new mailbox.");
        }
        if ("0".equals(newMailIndicator = newMailIndicator.trim().toLowerCase()) || "no".equals(newMailIndicator) || "false".equals(newMailIndicator)) {
            body[index++] = 0;
        } else if ("1".equals(newMailIndicator) || "yes".equals(newMailIndicator) || "true".equals(newMailIndicator)) {
            body[index++] = 1;
        } else {
            throw new HTIException("Unknown new mail indicator type: " + newMailIndicator);
        }
        String retrieveParts = (String)fields.get("retrieve_parts");
        if (retrieveParts == null || retrieveParts.length() < 1) {
            throw new HTIException("retrieve_parts must be set when adding new mailbox.");
        }
        if ("0".equals(retrieveParts = retrieveParts.trim().toLowerCase()) || "headers".equals(retrieveParts)) {
            body[index++] = 0;
        } else if ("1".equals(retrieveParts) || "less_than_size_limit".equals(retrieveParts)) {
            body[index++] = 1;
        } else if ("2".equals(retrieveParts) || "body_and_attachments".equals(retrieveParts)) {
            body[index++] = 2;
        } else {
            throw new HTIException("Unknown retrieve_parts type: " + retrieveParts);
        }
        String retrieveSizeLimit = (String)fields.get("retrieve_size_limit");
        if (retrieveSizeLimit == null) {
            retrieveSizeLimit = "0";
        }
        try {
            sizeLimit = Integer.parseInt(retrieveSizeLimit);
        }
        catch (NumberFormatException e) {
            throw new HTIException(e.getMessage());
        }
        Util.intToLittleEndianBytes(sizeLimit, body, index, 2);
        index += 2;
        String retrieveMailLimit = (String)fields.get("retrieve_mail_limit");
        if (retrieveMailLimit == null) {
            retrieveMailLimit = "0";
        }
        try {
            mailLimit = Integer.parseInt(retrieveMailLimit);
        }
        catch (NumberFormatException e) {
            throw new HTIException(e.getMessage());
        }
        Util.intToLittleEndianBytes(mailLimit, body, index, 2);
        index += 2;
        index += MessageFactory.addMailboxField(fields, "imap4_path", body, index, 0, 100, 1);
        String automaticUpdate = (String)fields.get("auto_update");
        if (automaticUpdate == null || automaticUpdate.length() < 1) {
            throw new HTIException("auto_update must be set when adding new mailbox.");
        }
        if ("0".equals(automaticUpdate = automaticUpdate.trim().toLowerCase()) || "always".equals(automaticUpdate)) {
            body[index++] = 0;
        } else if ("1".equals(automaticUpdate) || "only_home".equals(automaticUpdate)) {
            body[index++] = 1;
        } else if ("2".equals(automaticUpdate) || "never".equals(automaticUpdate)) {
            body[index++] = 1;
        } else {
            throw new HTIException("Unknown auto_update type: " + automaticUpdate);
        }
        String setAsDefault = (String)fields.get("default");
        if (setAsDefault == null || setAsDefault.length() < 1) {
            throw new HTIException("default must be set when adding new mailbox.");
        }
        if ("0".equals(setAsDefault = setAsDefault.trim().toLowerCase()) || "false".equals(setAsDefault)) {
            body[index++] = 0;
        } else if ("1".equals(setAsDefault) || "true".equals(setAsDefault)) {
            body[index++] = 1;
        } else {
            throw new HTIException("Unknown setAsDefault type: " + setAsDefault);
        }
        byte[] command = new byte[header.length + msgBodySize];
        System.arraycopy(header, 0, command, 0, header.length);
        System.arraycopy(body, 0, command, header.length, body.length);
        return new HTIMessage(command);
    }

    private static int getVariableFieldLengths(Hashtable fields) {
        int length = 0;
        length += MessageFactory.getFieldLength(fields, "name");
        length += MessageFactory.getFieldLength(fields, "incoming_server");
        length += MessageFactory.getFieldLength(fields, "incoming_accesspoint");
        length += MessageFactory.getFieldLength(fields, "incoming_username");
        length += MessageFactory.getFieldLength(fields, "incoming_password");
        length += MessageFactory.getFieldLength(fields, "outgoing_server");
        length += MessageFactory.getFieldLength(fields, "outgoing_accesspoint");
        length += MessageFactory.getFieldLength(fields, "outgoing_username");
        length += MessageFactory.getFieldLength(fields, "outgoing_password");
        length += MessageFactory.getFieldLength(fields, "from_address");
        length += MessageFactory.getFieldLength(fields, "from_name");
        length += MessageFactory.getFieldLength(fields, "signature");
        return length += MessageFactory.getFieldLength(fields, "imap4_path");
    }

    private static int getFieldLength(Hashtable fields, String key) {
        String value = (String)fields.get(key);
        if (value == null) {
            return 0;
        }
        return value.length();
    }

    private static int addMailboxField(Hashtable source, String sourceName, byte[] dest, int destPos, int minLength, int maxLength, int indexLength) throws HTIException {
        String value = (String)source.get(sourceName);
        int valueLength = value == null ? 0 : value.length();
        if (minLength > 0 && value == null) {
            throw new HTIException("Value of field " + sourceName + " is null, but has min length > 0.");
        }
        if (valueLength < minLength) {
            throw new HTIException("Value of field " + sourceName + " (" + value + ") is shorter than minimum length: " + minLength);
        }
        if (valueLength > maxLength) {
            throw new HTIException("Value of field " + sourceName + " (" + value + ") is longer than maximum length: " + maxLength);
        }
        Util.intToLittleEndianBytes(valueLength, dest, destPos, indexLength);
        destPos += indexLength;
        if (valueLength > 0) {
            byte[] valueBytes = value.getBytes();
            System.arraycopy(valueBytes, 0, dest, destPos, value.length());
        }
        return indexLength + valueLength;
    }

    static HTIMessage createDeleteMailboxMessage(String mailboxName) {
        byte[] mailboxNameBytes = mailboxName.getBytes();
        int msgBodySize = 2 + mailboxNameBytes.length;
        byte[] command = MessageFactory.initMessageArray(270601423, msgBodySize);
        command[14] = 33;
        command[15] = (byte)mailboxNameBytes.length;
        System.arraycopy(mailboxNameBytes, 0, command, 16, mailboxNameBytes.length);
        return new HTIMessage(command);
    }

    static HTIMessage createDeleteAccessPointMessage(String accessPointName) {
        byte[] accessPointNameBytes = accessPointName.getBytes();
        int msgBodySize = 2 + accessPointNameBytes.length;
        byte[] command = MessageFactory.initMessageArray(270601423, msgBodySize);
        command[14] = 49;
        command[15] = (byte)accessPointNameBytes.length;
        System.arraycopy(accessPointNameBytes, 0, command, 16, accessPointNameBytes.length);
        return new HTIMessage(command);
    }

    static HTIMessage createSetSmsCenterMessage(String name, String number) {
        byte[] nameBytes = name.getBytes();
        byte[] numberBytes = number.getBytes();
        int msgBodySize = 3 + nameBytes.length + numberBytes.length;
        byte[] command = MessageFactory.initMessageArray(270601423, msgBodySize);
        command[14] = 64;
        command[15] = (byte)nameBytes.length;
        System.arraycopy(nameBytes, 0, command, 16, nameBytes.length);
        command[16 + nameBytes.length] = (byte)numberBytes.length;
        System.arraycopy(numberBytes, 0, command, 17 + nameBytes.length, numberBytes.length);
        return new HTIMessage(command);
    }

    static HTIMessage createSetMMSSettingsMessage(String accessPointName, byte creationMode, byte imageSize, byte mmsReception, boolean receiveAnonMsg, boolean receiveAds, boolean receiveDeliveryReport, boolean sendDeliveryReport, byte validityPeriod) {
        byte[] accessPointNameBytes = accessPointName.getBytes();
        int msgBodySize = accessPointNameBytes.length + 10;
        byte[] header = MessageFactory.createHeader(270601423, msgBodySize);
        byte[] body = new byte[msgBodySize];
        byte[] command = new byte[header.length + msgBodySize];
        int index = 0;
        body[index++] = 69;
        body[index++] = (byte)accessPointNameBytes.length;
        System.arraycopy(accessPointNameBytes, 0, body, index, accessPointNameBytes.length);
        index += accessPointNameBytes.length;
        body[index++] = creationMode;
        body[index++] = imageSize;
        body[index++] = mmsReception;
        body[index++] = (byte)(receiveAnonMsg ? 1 : 0);
        body[index++] = (byte)(receiveAds ? 1 : 0);
        body[index++] = (byte)(receiveDeliveryReport ? 1 : 0);
        body[index++] = (byte)(sendDeliveryReport ? 1 : 0);
        body[index++] = validityPeriod;
        System.arraycopy(header, 0, command, 0, header.length);
        System.arraycopy(body, 0, command, header.length, body.length);
        return new HTIMessage(command);
    }

    static HTIMessage createSetSMSSettingsMessage(byte characterSupport, boolean deliveryReport, byte validityPeriod, byte messageConversion, byte preferrerConnection, boolean replyViaSameCenter) {
        int msgBodySize = 7;
        byte[] header = MessageFactory.createHeader(270601423, msgBodySize);
        byte[] body = new byte[msgBodySize];
        byte[] command = new byte[header.length + msgBodySize];
        int index = 0;
        body[index++] = 66;
        body[index++] = characterSupport;
        body[index++] = (byte)(deliveryReport ? 1 : 0);
        body[index++] = validityPeriod;
        body[index++] = messageConversion;
        body[index++] = preferrerConnection;
        body[index++] = (byte)(replyViaSameCenter ? 1 : 0);
        System.arraycopy(header, 0, command, 0, header.length);
        System.arraycopy(body, 0, command, header.length, body.length);
        return new HTIMessage(command);
    }

    static HTIMessage createAddToDestinationMessage(String accessPointName, String destinationName) {
        int msgBodySize = 3;
        byte[] accessPointBytes = accessPointName.getBytes();
        int accessPointSize = accessPointBytes.length;
        byte accessPointLength = (byte)accessPointName.length();
        msgBodySize += accessPointSize;
        byte[] destinationBytes = destinationName.getBytes();
        int destinationSize = destinationBytes.length;
        byte destinationLength = (byte)destinationName.length();
        byte[] command = MessageFactory.initMessageArray(270601423, msgBodySize += destinationSize);
        int index = 14;
        command[index++] = 52;
        command[index++] = accessPointLength;
        if (accessPointSize > 0) {
            System.arraycopy(accessPointBytes, 0, command, index, accessPointSize);
            index += accessPointSize;
        }
        command[index++] = destinationLength;
        if (destinationSize > 0) {
            System.arraycopy(destinationBytes, 0, command, index, destinationSize);
            index += destinationSize;
        }
        return new HTIMessage(command);
    }

    public static HTIMessage createSetDefaultConnectionMessage(int type, String name) {
        int msgBodySize = 3;
        byte[] nameBytes = name.getBytes();
        int nameSize = nameBytes.length;
        byte accessPointLength = (byte)name.length();
        byte[] command = MessageFactory.initMessageArray(270601423, msgBodySize += nameSize);
        int index = 14;
        command[index++] = 54;
        command[index++] = (byte)type;
        command[index++] = accessPointLength;
        if (nameSize > 0) {
            System.arraycopy(nameBytes, 0, command, index, nameSize);
            index += nameSize;
        }
        return new HTIMessage(command);
    }
}

