/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.HTI.FTPService;

import com.nokia.HTI.BaseService;
import com.nokia.HTI.FTPService.DriveInfo;
import com.nokia.HTI.FTPService.FileInfo;
import com.nokia.HTI.FTPService.MessageFactory;
import com.nokia.HTI.HTIException;
import com.nokia.HTI.HTIMessage;
import com.nokia.HTI.IService;
import com.nokia.HTI.common.Util;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import java.util.logging.Logger;

public class FTPService
extends BaseService
implements IService {
    private final Logger log = Logger.getLogger(this.getClass().getName());

    public HTIMessage uploadFile(byte[] fileData, String remoteFile) throws HTIException, IOException {
        return this.uploadFile(fileData, remoteFile, 0L);
    }

    public HTIMessage uploadFile(byte[] fileData, String remoteFile, long timeout) throws HTIException, IOException {
        long dynamicTimeout = 0L;
        boolean useTimeout = timeout > 0L;
        this.log.info("Uploading file data to file " + remoteFile);
        if (timeout > 0L) {
            this.log.info("timeout for upload is: " + timeout / 1000L);
        } else {
            this.log.info("no timeout");
        }
        remoteFile = remoteFile.replace('/', '\\');
        int dirEndIndex = remoteFile.lastIndexOf("\\");
        String remoteDir = remoteFile.substring(0, dirEndIndex);
        long deadline = System.currentTimeMillis() + timeout;
        this.checkUploadCancel();
        if (useTimeout) {
            dynamicTimeout = deadline - System.currentTimeMillis();
            if (deadline <= System.currentTimeMillis()) {
                try {
                    this.cancel(5000L);
                }
                catch (HTIException e) {
                    this.log.severe("Error when cancelling file upload: " + e.getMessage());
                }
                catch (IOException e) {
                    this.log.severe("Error when cancelling file upload: " + e.getMessage());
                }
                throw new HTIException("Timeout when uploading file");
            }
        }
        this.makeDir(remoteDir, dynamicTimeout);
        long fileSize = fileData.length;
        HTIMessage command = MessageFactory.createUploadFileMessage(remoteFile, fileSize);
        this.checkUploadCancel();
        if (useTimeout) {
            dynamicTimeout = deadline - System.currentTimeMillis();
            if (deadline <= System.currentTimeMillis()) {
                try {
                    this.cancel(5000L);
                }
                catch (HTIException e) {
                    this.log.severe("Error when cancelling file upload: " + e.getMessage());
                }
                catch (IOException e) {
                    this.log.severe("Error when cancelling file upload: " + e.getMessage());
                }
                throw new HTIException("Timeout when uploading file");
            }
        }
        HTIMessage response = this.sendHTIRequest(command, dynamicTimeout);
        boolean isFinal = false;
        boolean dataRemaining = true;
        int totalNrOfBytesRead = 0;
        byte[] fileFragment = null;
        byte[] remainingData = fileData;
        while (dataRemaining) {
            if (remainingData.length < 10226) {
                fileFragment = remainingData;
                isFinal = true;
            } else {
                fileFragment = new byte[10226];
                System.arraycopy(remainingData, 0, fileFragment, 0, 10226);
                remainingData = new byte[fileData.length - (totalNrOfBytesRead += 10226)];
                System.arraycopy(fileData, totalNrOfBytesRead, remainingData, 0, remainingData.length);
            }
            this.log.finest("Sending file fragment of size: " + fileFragment.length + " from total: " + fileData.length);
            this.checkUploadCancel();
            if (useTimeout) {
                dynamicTimeout = deadline - System.currentTimeMillis();
                if (deadline <= System.currentTimeMillis()) {
                    try {
                        this.cancel(5000L);
                    }
                    catch (HTIException e) {
                        this.log.severe("Error when cancelling file upload: " + e.getMessage());
                    }
                    catch (IOException e) {
                        this.log.severe("Error when cancelling file upload: " + e.getMessage());
                    }
                    throw new HTIException("Timeout when uploading file");
                }
            }
            this.sendRawData(fileFragment, dynamicTimeout);
            if (!isFinal) continue;
            this.log.finest("File/last part of file sent, waiting for response.");
            this.checkUploadCancel();
            if (useTimeout) {
                dynamicTimeout = deadline - System.currentTimeMillis();
                if (deadline <= System.currentTimeMillis()) {
                    try {
                        this.cancel(5000L);
                    }
                    catch (HTIException e) {
                        this.log.severe("Error when cancelling file upload: " + e.getMessage());
                    }
                    catch (IOException e) {
                        this.log.severe("Error when cancelling file upload: " + e.getMessage());
                    }
                    throw new HTIException("Timeout when getting response for file transfer");
                }
            }
            try {
                long responseTimeout = useTimeout ? dynamicTimeout : 5000L;
                response = this.getResponse(responseTimeout);
            }
            catch (IOException e) {
                try {
                    this.cancel(5000L);
                }
                catch (HTIException e1) {
                    this.log.severe("Error when cancelling file upload: " + e.getMessage());
                }
                catch (IOException e1) {
                    this.log.severe("Error when cancelling file upload: " + e.getMessage());
                }
                throw e;
            }
            boolean attemptReauthorization = false;
            int result = this.doErrorCheck(command.getServicePlugInID(), response, false, dynamicTimeout);
            if (result == 0) break;
            this.log.severe("Error when sending file/last part of file.");
            try {
                this.cancel(5000L);
            }
            catch (HTIException e) {
                this.log.severe("Error when cancelling file upload: " + e.getMessage());
            }
            catch (IOException e) {
                this.log.severe("Error when cancelling file upload: " + e.getMessage());
            }
            throw new IOException("Error when sending file/last part of file.");
        }
        return response;
    }

    public HTIMessage makeDir(String remoteDir) throws HTIException, IOException {
        return this.makeDir(remoteDir, 0L);
    }

    public HTIMessage makeDir(String remoteDir, long timeout) throws HTIException, IOException {
        this.log.info("Creating directory " + remoteDir);
        remoteDir = remoteDir.replace('/', '\\');
        HTIMessage command = MessageFactory.createCreateDirectoryMessage(remoteDir);
        HTIMessage response = this.sendHTIRequest(command, timeout);
        return response;
    }

    public byte[] downloadFile(String remoteFile) throws HTIException, IOException {
        return this.downloadFile(remoteFile, 0L);
    }

    public byte[] downloadFile(String remoteFile, long timeout) throws HTIException, IOException {
        this.log.info("Downloading file " + remoteFile);
        remoteFile = remoteFile.replace('/', '\\');
        byte[] fileData = null;
        if (this.cancelCurrentTransfer) {
            throw new HTIException("Downloading was canceled.");
        }
        HTIMessage command = MessageFactory.createDownloadFileMessage(remoteFile);
        HTIMessage response = this.sendHTIRequest(command, timeout);
        if (!response.isErrorResponse() && response.getCommand() == 15) {
            byte[] rawResponseBody = response.getBody();
            int fileSize = ((rawResponseBody[4] & 0xFF) << 24) + ((rawResponseBody[3] & 0xFF) << 16) + ((rawResponseBody[2] & 0xFF) << 8) + (rawResponseBody[1] & 0xFF);
            try {
                fileData = this.readRawData(fileSize, timeout);
            }
            catch (HTIException e) {
                this.cancelFileTransfer();
                this.skipInputData();
                if (this.cancelCurrentTransfer) {
                    throw new HTIException("Downloading was canceled.");
                }
                throw e;
            }
            catch (IOException e) {
                this.cancelFileTransfer();
                this.skipInputData();
                if (this.cancelCurrentTransfer) {
                    throw new HTIException("Downloading was canceled.");
                }
                throw e;
            }
        }
        return fileData;
    }

    public String[] listFiles(String remoteDir) throws HTIException, IOException {
        return this.listFiles(remoteDir, 0L);
    }

    public String[] listFiles(String remoteDir, long timeout) throws HTIException, IOException {
        this.log.info("Listing files under directory " + remoteDir);
        remoteDir = remoteDir.replace('/', '\\');
        Vector<String> files = new Vector<String>();
        HTIMessage command = MessageFactory.createListFilesMessage(remoteDir);
        HTIMessage response = this.sendHTIRequest(command, timeout);
        byte[] body = response.getBody();
        int i = 0;
        while (i < body.length) {
            int sizeInBytes = body[i] * 2;
            byte[] name = new byte[sizeInBytes];
            int j = 0;
            while (j < sizeInBytes) {
                name[j] = body[i + 1];
                ++i;
                ++j;
            }
            files.add(new String(name, "UTF-16LE"));
            ++i;
        }
        return files.toArray(new String[0]);
    }

    public FileInfo[] listFilesWithSize(String remoteDir) throws HTIException, IOException {
        return this.listFilesWithSize(remoteDir, 0L);
    }

    public FileInfo[] listFilesWithSize(String remoteDir, long timeout) throws HTIException, IOException {
        this.log.info("Listing files and sizes under directory " + remoteDir);
        remoteDir = remoteDir.replace('/', '\\');
        Vector<FileInfo> fileInfos = new Vector<FileInfo>();
        HTIMessage command = MessageFactory.createListFilesWithSizeMessage(remoteDir);
        HTIMessage response = this.sendHTIRequest(command, timeout);
        byte[] body = response.getBody();
        int i = 0;
        while (i < body.length) {
            FileInfo info = new FileInfo();
            int sizeInBytes = body[i] * 2;
            byte[] name = new byte[sizeInBytes];
            int j = 0;
            while (j < sizeInBytes) {
                name[j] = body[i + 1];
                ++i;
                ++j;
            }
            info.setName(new String(name, "UTF-16LE"));
            byte[] size = new byte[4];
            int j2 = 0;
            while (j2 < 4) {
                size[j2] = body[i + 1];
                ++i;
                ++j2;
            }
            info.setSize(Util.littleEndianUnsignedIntToLong(size));
            fileInfos.add(info);
            ++i;
        }
        return fileInfos.toArray(new FileInfo[0]);
    }

    public String[] listDirs(String remoteDir) throws HTIException, IOException {
        return this.listDirs(remoteDir, 0L);
    }

    public String[] listDirs(String remoteDir, long timeout) throws HTIException, IOException {
        this.log.info("Listing directories under directory " + remoteDir);
        remoteDir = remoteDir.replace('/', '\\');
        Vector<String> files = new Vector<String>();
        HTIMessage command = MessageFactory.createListDirsMessage(remoteDir);
        HTIMessage response = this.sendHTIRequest(command, timeout);
        byte[] body = response.getBody();
        int i = 0;
        while (i < body.length) {
            int sizeInBytes = body[i] * 2;
            byte[] name = new byte[sizeInBytes];
            int j = 0;
            while (j < sizeInBytes) {
                name[j] = body[i + 1];
                ++i;
                ++j;
            }
            files.add(new String(name, "UTF-16LE"));
            ++i;
        }
        return files.toArray(new String[0]);
    }

    public DriveInfo[] listDrives() throws HTIException, IOException {
        return this.listDrives(0L);
    }

    public DriveInfo[] listDrives(long timeout) throws HTIException, IOException {
        this.log.info("Listing drives");
        HTIMessage command = MessageFactory.createListDrivesMessage();
        HTIMessage response = this.sendHTIRequest(command, timeout);
        byte[] body = response.getBody();
        Vector<DriveInfo> driveInfos = new Vector<DriveInfo>();
        int i = 1;
        while (i < body.length) {
            DriveInfo.MediaType mediaType;
            DriveInfo info = new DriveInfo();
            int sizeInBytes = body[i] * 2;
            ++i;
            byte[] path = new byte[sizeInBytes];
            int j = 0;
            while (j < sizeInBytes) {
                path[j] = body[i];
                ++i;
                ++j;
            }
            info.setRootPath(new String(path, "UTF-16LE"));
            byte[] mediaTypeByte = new byte[]{body[i]};
            ++i;
            byte type = mediaTypeByte[0];
            switch (type) {
                case 0: {
                    mediaType = DriveInfo.MediaType.NOT_PRESET;
                    break;
                }
                case 1: {
                    mediaType = DriveInfo.MediaType.UNKNOWN;
                    break;
                }
                case 2: {
                    mediaType = DriveInfo.MediaType.FLOPPY;
                    break;
                }
                case 3: {
                    mediaType = DriveInfo.MediaType.HARD_DISK;
                    break;
                }
                case 4: {
                    mediaType = DriveInfo.MediaType.CDROM;
                    break;
                }
                case 5: {
                    mediaType = DriveInfo.MediaType.RAM;
                    break;
                }
                case 6: {
                    mediaType = DriveInfo.MediaType.FLASH;
                    break;
                }
                case 7: {
                    mediaType = DriveInfo.MediaType.ROM;
                    break;
                }
                case 8: {
                    mediaType = DriveInfo.MediaType.REMOTE;
                    break;
                }
                case 9: {
                    mediaType = DriveInfo.MediaType.NAND_FLASH;
                    break;
                }
                case 10: {
                    mediaType = DriveInfo.MediaType.ROTATING_MEDIA;
                    break;
                }
                default: {
                    mediaType = DriveInfo.MediaType.UNKNOWN;
                }
            }
            info.setType(mediaType);
            byte[] uid = new byte[4];
            int j2 = 0;
            while (j2 < 4) {
                uid[j2] = body[i];
                ++i;
                ++j2;
            }
            info.setUid(Util.littleEndianToLong(uid));
            byte[] size = new byte[8];
            int j3 = 0;
            while (j3 < 8) {
                size[j3] = body[i];
                ++i;
                ++j3;
            }
            info.setSize(Util.littleEndianToLong(size));
            byte[] space = new byte[8];
            int j4 = 0;
            while (j4 < 8) {
                space[j4] = body[i];
                ++i;
                ++j4;
            }
            info.setFreeSpace(Util.littleEndianToLong(space));
            sizeInBytes = body[i] * 2;
            byte[] name = new byte[sizeInBytes];
            int j5 = 0;
            while (j5 < sizeInBytes) {
                name[j5] = body[i + 1];
                ++i;
                ++j5;
            }
            info.setName(new String(name, "UTF-16LE"));
            driveInfos.add(info);
            ++i;
        }
        return driveInfos.toArray(new DriveInfo[0]);
    }

    public HTIMessage deleteFile(String fileName) throws HTIException, IOException {
        return this.deleteFile(fileName, 0L);
    }

    public HTIMessage deleteFile(String fileName, long timeout) throws HTIException, IOException {
        this.log.info("Deleting file " + fileName);
        fileName = fileName.replace('/', '\\');
        HTIMessage command = MessageFactory.createDeleteFileMessage(fileName);
        HTIMessage response = this.sendHTIRequest(command, timeout);
        return response;
    }

    public HTIMessage deleteDirectory(String dirName) throws HTIException, IOException {
        return this.deleteDirectory(dirName, 0L);
    }

    public HTIMessage deleteDirectory(String dirName, long timeout) throws HTIException, IOException {
        this.log.info("Deleting directory " + dirName);
        dirName = dirName.replace('/', '\\');
        HTIMessage command = MessageFactory.createDeleteDirectoryMessage(dirName);
        HTIMessage response = this.sendHTIRequest(command);
        return response;
    }

    public HTIMessage checksum(String file, byte algorithmID) throws HTIException, IOException {
        return this.checksum(file, algorithmID, 0L);
    }

    public HTIMessage checksum(String file, byte algorithmID, long timeout) throws HTIException, IOException {
        this.log.info("Getting checksum of file " + file);
        file = file.replace('/', '\\');
        HTIMessage command = MessageFactory.createChecksumMessage(file, algorithmID);
        HTIMessage response = this.sendHTIRequest(command);
        return response;
    }

    public boolean cancel(long timeout) throws HTIException, IOException {
        this.log.info("Canceling file transfer");
        HTIMessage command = MessageFactory.createCancelFileTransferMessage();
        HTIMessage response = this.sendHTIRequest(command, timeout);
        return !response.isErrorResponse() && response.getCommand() == -16;
    }

    public HTIMessage renameFileFolder(String oldName, String newName) throws HTIException, IOException {
        return this.renameFileFolder(oldName, newName, 0L);
    }

    public HTIMessage renameFileFolder(String oldName, String newName, long timeout) throws HTIException, IOException {
        this.log.info("Renaming file " + oldName + " to " + newName);
        oldName = oldName.replace('/', '\\');
        newName = newName.replace('/', '\\');
        HTIMessage command = MessageFactory.createRenameFileFolderMessage(oldName, newName);
        HTIMessage response = this.sendHTIRequest(command, timeout);
        return response;
    }

    public HTIMessage copyFileFolder(String originalPath, String copyPath) throws HTIException, IOException {
        return this.copyFileFolder(originalPath, copyPath, 0L);
    }

    public HTIMessage copyFileFolder(String originalPath, String copyPath, long timeout) throws HTIException, IOException {
        this.log.info("Copying file " + originalPath + " to " + copyPath);
        originalPath = originalPath.replace('/', '\\');
        copyPath = copyPath.replace('/', '\\');
        HTIMessage command = MessageFactory.createCopyFileFolderMessage(originalPath, copyPath);
        HTIMessage response = this.sendHTIRequest(command, timeout);
        return response;
    }

    public HTIMessage moveFileFolder(String oldPath, String newLocation) throws HTIException, IOException {
        return this.moveFileFolder(oldPath, newLocation, 0L);
    }

    public HTIMessage moveFileFolder(String oldPath, String newLocation, long timeout) throws HTIException, IOException {
        this.log.info("Moving file " + oldPath + " to " + newLocation);
        oldPath = oldPath.replace('/', '\\');
        newLocation = newLocation.replace('/', '\\');
        HTIMessage command = MessageFactory.createMoveFileFolderMessage(oldPath, newLocation);
        HTIMessage response = this.sendHTIRequest(command, timeout);
        return response;
    }

    public synchronized void cancelCurrentTransfer() {
        this.cancelCurrentTransfer = true;
    }

    private void cancelFileTransfer() {
        try {
            this.cancel(5000L);
        }
        catch (Exception e) {
            this.log.severe("Error when cancelling file download: " + e.getMessage());
        }
    }

    private void skipInputData() throws IOException {
        InputStream in = this.mySocket.getInputStream();
        byte[] skippedBytes = new byte[10000];
        int skipTimeout = 1000;
        this.mySocket.setSoTimeout(skipTimeout);
        int skipped = 0;
        do {
            try {
                skipped = in.read(skippedBytes, 0, skippedBytes.length);
            }
            catch (IOException e) {
                skipped = 0;
            }
        } while (skipped > 0);
    }

    private void checkUploadCancel() throws HTIException {
        if (!this.cancelCurrentTransfer) {
            return;
        }
        try {
            this.cancel(5000L);
        }
        catch (HTIException e) {
            this.log.severe("Error when cancelling file upload: " + e.getMessage());
        }
        catch (IOException e) {
            this.log.severe("Error when cancelling file upload: " + e.getMessage());
        }
        throw new HTIException("Uploading was canceled.");
    }
}

