/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.HTI.FTPService;

import com.nokia.HTI.HTIMessage;
import com.nokia.HTI.HTIMessageFactory;
import com.nokia.HTI.common.Util;
import java.io.UnsupportedEncodingException;

class MessageFactory
extends HTIMessageFactory {
    static final int uid = 270589637;

    MessageFactory() {
    }

    static HTIMessage createUploadFileMessage(String fileName, long fileSize) throws UnsupportedEncodingException {
        byte[] fileNameBytes = new byte[]{};
        fileNameBytes = fileName.getBytes("UTF-16LE");
        int msgBodySize = fileNameBytes.length + 6;
        byte[] command = MessageFactory.initMessageArray(270589637, msgBodySize);
        command[14] = 3;
        Util.longToLittleEndianBytes(fileSize, command, 15, 4);
        command[19] = (byte)fileName.length();
        System.arraycopy(fileNameBytes, 0, command, 20, fileNameBytes.length);
        return new HTIMessage(command);
    }

    static HTIMessage createCreateDirectoryMessage(String directoryName) throws UnsupportedEncodingException {
        byte[] directoryNameBytes = new byte[]{};
        directoryNameBytes = directoryName.getBytes("UTF-16LE");
        int msgBodySize = directoryNameBytes.length + 2;
        byte[] command = MessageFactory.initMessageArray(270589637, msgBodySize);
        command[14] = 9;
        command[15] = (byte)directoryName.length();
        System.arraycopy(directoryNameBytes, 0, command, 16, directoryNameBytes.length);
        return new HTIMessage(command);
    }

    static HTIMessage createDownloadFileMessage(String fileName) throws UnsupportedEncodingException {
        byte[] fileNameBytes = new byte[]{};
        fileNameBytes = fileName.getBytes("UTF-16LE");
        int msgBodySize = fileNameBytes.length + 2;
        byte[] command = MessageFactory.initMessageArray(270589637, msgBodySize);
        command[14] = 5;
        command[15] = (byte)fileName.length();
        System.arraycopy(fileNameBytes, 0, command, 16, fileNameBytes.length);
        return new HTIMessage(command);
    }

    static HTIMessage createListFilesMessage(String directoryName) throws UnsupportedEncodingException {
        byte[] directoryNameBytes = new byte[]{};
        directoryNameBytes = directoryName.getBytes("UTF-16LE");
        int msgBodySize = directoryNameBytes.length + 2;
        byte[] command = MessageFactory.initMessageArray(270589637, msgBodySize);
        command[14] = 7;
        command[15] = (byte)directoryName.length();
        System.arraycopy(directoryNameBytes, 0, command, 16, directoryNameBytes.length);
        return new HTIMessage(command);
    }

    static HTIMessage createListFilesWithSizeMessage(String directoryName) throws UnsupportedEncodingException {
        byte[] directoryNameBytes = new byte[]{};
        directoryNameBytes = directoryName.getBytes("UTF-16LE");
        int msgBodySize = directoryNameBytes.length + 2;
        byte[] command = MessageFactory.initMessageArray(270589637, msgBodySize);
        command[14] = 19;
        command[15] = (byte)directoryName.length();
        System.arraycopy(directoryNameBytes, 0, command, 16, directoryNameBytes.length);
        return new HTIMessage(command);
    }

    static HTIMessage createListDirsMessage(String directoryName) throws UnsupportedEncodingException {
        byte[] directoryNameBytes = new byte[]{};
        directoryNameBytes = directoryName.getBytes("UTF-16LE");
        int msgBodySize = directoryNameBytes.length + 2;
        byte[] command = MessageFactory.initMessageArray(270589637, msgBodySize);
        command[14] = 17;
        command[15] = (byte)directoryName.length();
        System.arraycopy(directoryNameBytes, 0, command, 16, directoryNameBytes.length);
        return new HTIMessage(command);
    }

    static HTIMessage createDeleteFileMessage(String fileName) throws UnsupportedEncodingException {
        byte[] fileNameBytes = new byte[]{};
        fileNameBytes = fileName.getBytes("UTF-16LE");
        int msgBodySize = fileNameBytes.length + 2;
        byte[] command = MessageFactory.initMessageArray(270589637, msgBodySize);
        command[14] = 13;
        command[15] = (byte)fileName.length();
        System.arraycopy(fileNameBytes, 0, command, 16, fileNameBytes.length);
        return new HTIMessage(command);
    }

    static HTIMessage createDeleteDirectoryMessage(String dirName) throws UnsupportedEncodingException {
        byte[] dirNameBytes = new byte[]{};
        dirNameBytes = dirName.getBytes("UTF-16LE");
        int msgBodySize = dirNameBytes.length + 2;
        byte[] command = MessageFactory.initMessageArray(270589637, msgBodySize);
        command[14] = 11;
        command[15] = (byte)dirName.length();
        System.arraycopy(dirNameBytes, 0, command, 16, dirNameBytes.length);
        return new HTIMessage(command);
    }

    static HTIMessage createChecksumMessage(String fileName, byte algorithmID) throws UnsupportedEncodingException {
        byte[] fileNameBytes = new byte[]{};
        fileNameBytes = fileName.getBytes("UTF-16LE");
        int msgBodySize = fileNameBytes.length + 3;
        byte[] command = MessageFactory.initMessageArray(270589637, msgBodySize);
        command[14] = 49;
        command[15] = algorithmID;
        command[16] = (byte)fileName.length();
        System.arraycopy(fileNameBytes, 0, command, 17, fileNameBytes.length);
        return new HTIMessage(command);
    }

    static HTIMessage createCancelFileTransferMessage() throws UnsupportedEncodingException {
        int msgBodySize = 1;
        byte[] command = MessageFactory.initMessageArray(270589637, msgBodySize);
        command[14] = 14;
        return new HTIMessage(command);
    }

    static HTIMessage createListDrivesMessage() throws UnsupportedEncodingException {
        int msgBodySize = 1;
        byte[] command = MessageFactory.initMessageArray(270589637, msgBodySize);
        command[14] = 21;
        return new HTIMessage(command);
    }

    public static HTIMessage createRenameFileFolderMessage(String oldName, String newName) throws UnsupportedEncodingException {
        return MessageFactory.createRenameCopyMoveMessage(oldName, newName, 22);
    }

    public static HTIMessage createCopyFileFolderMessage(String originalPath, String copyPath) throws UnsupportedEncodingException {
        return MessageFactory.createRenameCopyMoveMessage(originalPath, copyPath, 24);
    }

    public static HTIMessage createMoveFileFolderMessage(String oldPath, String newLocation) throws UnsupportedEncodingException {
        return MessageFactory.createRenameCopyMoveMessage(oldPath, newLocation, 26);
    }

    private static HTIMessage createRenameCopyMoveMessage(String oldPath, String newPath, int commandConstant) throws UnsupportedEncodingException {
        byte[] oldPathBytes = oldPath.getBytes();
        byte[] newPathBytes = newPath.getBytes();
        int msgBodySize = oldPathBytes.length + newPathBytes.length + 3;
        byte[] command = MessageFactory.initMessageArray(270589637, msgBodySize);
        command[14] = (byte)(commandConstant & 0xFF);
        command[15] = (byte)oldPath.length();
        System.arraycopy(oldPathBytes, 0, command, 16, oldPathBytes.length);
        int newLocationPlace = 16 + oldPathBytes.length;
        command[newLocationPlace] = (byte)newPath.length();
        System.arraycopy(newPathBytes, 0, command, newLocationPlace + 1, newPathBytes.length);
        return new HTIMessage(command);
    }
}

