/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.HTI.ScreenCapturingService;

import com.nokia.HTI.HTIMessage;
import com.nokia.HTI.HTIMessageFactory;
import com.nokia.HTI.ScreenCapturingService.HTIFont;
import com.nokia.HTI.common.Util;
import java.io.UnsupportedEncodingException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MessageFactory
extends HTIMessageFactory {
    static final int uid = 270589635;

    MessageFactory() {
    }

    static HTIMessage createCaptureFullScreenMessage(String imgMimeType, byte colorDepth, boolean zipped) {
        int msgBodySize = 2;
        byte[] mimeType = null;
        if (imgMimeType != null && imgMimeType.length() > 0) {
            mimeType = imgMimeType.getBytes();
            msgBodySize += mimeType.length;
        }
        byte[] command = MessageFactory.initMessageArray(270589635, msgBodySize);
        command[14] = zipped ? 3 : 1;
        command[15] = colorDepth;
        if (mimeType != null) {
            System.arraycopy(mimeType, 0, command, 16, mimeType.length);
        }
        return new HTIMessage(command);
    }

    static HTIMessage createCaptureScreenRegionMessage(int left, int top, int right, int bottom, String imgMimeType, byte colorDepth, boolean zipped) {
        int msgBodySize = 10;
        byte[] mimeType = null;
        if (imgMimeType != null && imgMimeType.length() > 0) {
            mimeType = imgMimeType.getBytes();
            msgBodySize += mimeType.length;
        }
        byte[] command = MessageFactory.initMessageArray(270589635, msgBodySize);
        command[14] = zipped ? 4 : 2;
        Util.intToLittleEndianBytes(left, command, 15, 2);
        Util.intToLittleEndianBytes(top, command, 17, 2);
        Util.intToLittleEndianBytes(right, command, 19, 2);
        Util.intToLittleEndianBytes(bottom, command, 21, 2);
        command[23] = colorDepth;
        if (mimeType != null) {
            System.arraycopy(mimeType, 0, command, 24, mimeType.length);
        }
        return new HTIMessage(command);
    }

    static HTIMessage createTextRecognitionMessage(String text, boolean unicode, List<HTIFont> fontList) {
        int msgBodySize = 3;
        String charset = "ISO-8859-1";
        if (unicode) {
            charset = "UTF-16LE";
        }
        byte[] textBytes = null;
        int textByteSize = 0;
        int textLength = 0;
        if (text != null) {
            textLength = text.length();
            try {
                textBytes = text.getBytes(charset);
            }
            catch (UnsupportedEncodingException e) {
                throw new Error(e);
            }
            textByteSize = textBytes.length;
            msgBodySize += textByteSize;
        }
        for (HTIFont font : fontList) {
            byte[] fontBytes = font.getBytes(charset);
            msgBodySize += fontBytes.length;
        }
        byte[] command = MessageFactory.initMessageArray(270589635, msgBodySize);
        int index = 14;
        command[index++] = unicode ? 17 : 16;
        command[index++] = (byte)textLength;
        if (textByteSize > 0) {
            System.arraycopy(textBytes, 0, command, index, textByteSize);
            index += textByteSize;
        }
        command[index++] = (byte)fontList.size();
        for (HTIFont font : fontList) {
            byte[] fontBytes = font.getBytes(charset);
            int fontByteSize = fontBytes.length;
            System.arraycopy(fontBytes, 0, command, index, fontByteSize);
            index += fontByteSize;
        }
        return new HTIMessage(command);
    }

    static HTIMessage createTextBitmapMessage(String text, boolean unicode, HTIFont font, long foregroundColor, long backgroundColor, String mimeType, byte colorDepth) {
        int msgBodySize = 12;
        String charset = "ISO-8859-1";
        if (unicode) {
            charset = "UTF-16LE";
        }
        byte[] mimeTypeBytes = null;
        int mimeTypeLength = 0;
        if (mimeType != null) {
            mimeTypeBytes = mimeType.getBytes();
            mimeTypeLength = mimeTypeBytes.length;
            msgBodySize += mimeTypeLength;
        }
        byte[] textBytes = null;
        int textByteSize = 0;
        int textLength = 0;
        if (text != null) {
            textLength = text.length();
            try {
                textBytes = text.getBytes(charset);
            }
            catch (UnsupportedEncodingException e) {
                throw new Error(e);
            }
            textByteSize = textBytes.length;
            msgBodySize += textByteSize;
        }
        byte[] fontBytes = font.getBytes(charset);
        int fontByteSize = fontBytes.length;
        byte[] command = MessageFactory.initMessageArray(270589635, msgBodySize += fontByteSize);
        int index = 14;
        command[index++] = unicode ? 19 : 18;
        command[index++] = colorDepth;
        command[index++] = (byte)mimeTypeLength;
        if (mimeTypeLength > 0) {
            System.arraycopy(mimeTypeBytes, 0, command, index, mimeTypeLength);
            index += mimeTypeLength;
        }
        command[index++] = (byte)textLength;
        if (textByteSize > 0) {
            System.arraycopy(textBytes, 0, command, index, textByteSize);
            index += textByteSize;
        }
        System.arraycopy(fontBytes, 0, command, index, fontByteSize);
        Util.longToLittleEndianBytes(foregroundColor, command, index += fontByteSize, 4);
        Util.longToLittleEndianBytes(backgroundColor, command, index += 4, 4);
        index += 4;
        return new HTIMessage(command);
    }

    static HTIMessage createCaptureFullScreenSeriesMessage(long duration, long interval, String imgMimeType, byte colorDepth, boolean zipped) {
        int msgBodySize = 10;
        byte[] mimeType = null;
        byte[] durationBytes = new byte[4];
        byte[] intervalBytes = new byte[4];
        Util.longToLittleEndianBytes(duration, durationBytes, 0, 4);
        Util.longToLittleEndianBytes(interval, intervalBytes, 0, 4);
        if (imgMimeType != null && imgMimeType.length() > 0) {
            mimeType = imgMimeType.getBytes();
            msgBodySize += mimeType.length;
        }
        byte[] command = MessageFactory.initMessageArray(270589635, msgBodySize);
        command[14] = zipped ? 35 : 33;
        int index = 14;
        System.arraycopy(durationBytes, 0, command, ++index, durationBytes.length);
        System.arraycopy(intervalBytes, 0, command, index += durationBytes.length, intervalBytes.length);
        command[index += intervalBytes.length] = colorDepth;
        if (mimeType != null) {
            System.arraycopy(mimeType, 0, command, ++index, mimeType.length);
        }
        return new HTIMessage(command);
    }

    static HTIMessage createCaptureScreenRegionSeriesMessage(long duration, long interval, int left, int top, int right, int bottom, String imgMimeType, byte colorDepth, boolean zipped) {
        int msgBodySize = 18;
        byte[] mimeType = null;
        if (imgMimeType != null && imgMimeType.length() > 0) {
            mimeType = imgMimeType.getBytes();
            msgBodySize += mimeType.length;
        }
        byte[] command = MessageFactory.initMessageArray(270589635, msgBodySize);
        command[14] = zipped ? 36 : 34;
        Util.longToLittleEndianBytes(duration, command, 15, 4);
        Util.longToLittleEndianBytes(interval, command, 19, 4);
        Util.intToLittleEndianBytes(left, command, 24, 2);
        Util.intToLittleEndianBytes(top, command, 26, 2);
        Util.intToLittleEndianBytes(right, command, 28, 2);
        Util.intToLittleEndianBytes(bottom, command, 30, 2);
        command[23] = colorDepth;
        if (mimeType != null) {
            System.arraycopy(mimeType, 0, command, 32, mimeType.length);
        }
        return new HTIMessage(command);
    }

    static HTIMessage createSelectScreenMessage(byte screenNumber) {
        int msgBodySize = 2;
        byte[] command = MessageFactory.initMessageArray(270589635, msgBodySize);
        command[14] = 48;
        command[15] = screenNumber;
        return new HTIMessage(command);
    }

    static HTIMessage createScreenModeMessage() {
        int msgBodySize = 1;
        byte[] command = MessageFactory.initMessageArray(270589635, msgBodySize);
        command[14] = 58;
        return new HTIMessage(command);
    }

    static HTIMessage createCaptureFullScreenDeltaMessage(String imgMimeType, byte colorDepth, boolean zipped) {
        int msgBodySize = 2;
        byte[] mimeType = null;
        if (imgMimeType != null && imgMimeType.length() > 0) {
            mimeType = imgMimeType.getBytes();
            msgBodySize += mimeType.length;
        }
        byte[] command = MessageFactory.initMessageArray(270589635, msgBodySize);
        command[14] = zipped ? -125 : -127;
        command[15] = colorDepth;
        if (mimeType != null) {
            System.arraycopy(mimeType, 0, command, 16, mimeType.length);
        }
        return new HTIMessage(command);
    }

    static HTIMessage createCaptureScreenRegionDeltaMessage(int left, int top, int right, int bottom, String imgMimeType, byte colorDepth, boolean zipped) {
        int msgBodySize = 10;
        byte[] mimeType = null;
        if (imgMimeType != null && imgMimeType.length() > 0) {
            mimeType = imgMimeType.getBytes();
            msgBodySize += mimeType.length;
        }
        byte[] command = MessageFactory.initMessageArray(270589635, msgBodySize);
        command[14] = zipped ? -124 : -126;
        Util.intToLittleEndianBytes(left, command, 15, 2);
        Util.intToLittleEndianBytes(top, command, 17, 2);
        Util.intToLittleEndianBytes(right, command, 19, 2);
        Util.intToLittleEndianBytes(bottom, command, 21, 2);
        command[23] = colorDepth;
        if (mimeType != null) {
            System.arraycopy(mimeType, 0, command, 24, mimeType.length);
        }
        return new HTIMessage(command);
    }

    static HTIMessage createResetScreenDeltaMessage() {
        int msgBodySize = 1;
        byte[] command = MessageFactory.initMessageArray(270589635, msgBodySize);
        command[14] = -123;
        return new HTIMessage(command);
    }
}

