/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build.tasks;

import java.io.File;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.internal.build.AbstractScriptGenerator;
import org.eclipse.pde.internal.build.BuildScriptGenerator;
import org.eclipse.pde.internal.build.BundleHelper;
import org.eclipse.pde.internal.build.Utils;
import org.eclipse.pde.internal.build.site.BuildTimeSiteFactory;
import org.eclipse.pde.internal.build.site.QualifierReplacer;
import org.eclipse.pde.internal.build.tasks.TaskHelper;

public class BuildScriptGeneratorTask
extends Task {
    private Properties antProperties = new Properties();
    protected BuildScriptGenerator generator = new BuildScriptGenerator();

    public void setChildren(boolean children) {
        this.generator.setChildren(children);
    }

    public void setDevEntries(String devEntries) {
        this.generator.setDevEntries(devEntries);
    }

    public void setPluginPath(String pluginPath) {
        this.generator.setPluginPath(Utils.getArrayFromString((String)pluginPath, (String)File.pathSeparator));
    }

    public void setElements(String elements) {
        this.generator.setElements(Utils.getArrayFromString((String)elements));
    }

    public void setSignificantVersionDigits(String significantDigits) {
        this.antProperties.put("significantVersionDigits", significantDigits);
    }

    public void setGeneratedVersionLength(String generatedLength) {
        this.antProperties.put("generatedVersionLength", generatedLength);
    }

    public void execute() throws BuildException {
        try {
            this.run();
        }
        catch (CoreException e) {
            throw new BuildException(TaskHelper.statusToString(e.getStatus(), null).toString());
        }
    }

    public void run() throws CoreException {
        this.generator.setReportResolutionErrors(true);
        String value = this.getProject().getProperty("resolution.devMode");
        if (Boolean.valueOf(value).booleanValue()) {
            this.antProperties.put("resolution.devMode", "true");
        }
        this.generator.setImmutableAntProperties(this.antProperties);
        BundleHelper.getDefault().setLog((Object)this);
        this.generator.generate();
        BundleHelper.getDefault().setLog(null);
    }

    public void setBuildDirectory(String buildDirectory) {
        this.generator.setWorkingDirectory(buildDirectory);
    }

    public void setInstall(String installLocation) {
        this.generator.setWorkingDirectory(installLocation);
    }

    public void setRecursiveGeneration(boolean recursiveGeneration) {
        this.generator.setRecursiveGeneration(recursiveGeneration);
    }

    public void setConfigInfo(String configInfo) throws CoreException {
        AbstractScriptGenerator.setConfigInfo((String)configInfo);
    }

    public void setArchivesFormat(String archivesFormat) throws CoreException {
        this.generator.setArchivesFormat(archivesFormat);
    }

    public void setBaseLocation(String baseLocation) {
        BuildTimeSiteFactory.setInstalledBaseSite((String)baseLocation);
    }

    public void setBuildingOSGi(boolean osgi) {
        this.generator.setBuildingOSGi(osgi);
    }

    public void setWorkingDirectory(String installLocation) {
        this.generator.setWorkingDirectory(installLocation);
    }

    public void setProduct(String value) {
        this.generator.setProduct(value);
    }

    public void setSignJars(boolean value) {
        this.generator.setSignJars(value);
    }

    public void setGenerateJnlp(boolean value) {
        this.generator.setGenerateJnlp(value);
    }

    public void setOutputUpdateJars(boolean value) {
        AbstractScriptGenerator.setForceUpdateJar((boolean)value);
    }

    public void setForceContextQualifier(String value) {
        QualifierReplacer.setGlobalQualifier((String)value);
    }

    public void setGenerateFeatureVersionSuffix(boolean value) {
        this.generator.setGenerateFeatureVersionSuffix(value);
    }

    public void setGenerateVersionsLists(boolean value) {
        this.generator.setGenerateVersionsList(value);
    }

    public void setGroupConfiguration(boolean value) {
        this.generator.setGroupConfigs(value);
    }

    public void setFilteredDependencyCheck(boolean value) {
        this.generator.setFilterState(value);
    }

    public void setPlatformProperties(String filename) {
        this.generator.setPlatformProperties(filename);
    }
}

