/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.HTI;

public class HTIMessage {
    private byte[] rawMessage = null;
    private int serviceUID = 0;
    private int htiErrorCode = 0;
    private int serviceErrorCode = 0;
    private String errorDescription = "";
    private static final int HEADER_LENGTH = 14;
    private static final int ERROR_MESSAGE_FIXED_LENGTH = 10;

    public HTIMessage(byte[] bytes) {
        this.rawMessage = bytes;
    }

    public HTIMessage(byte[] header, byte[] body) {
        this.rawMessage = new byte[header.length + body.length];
        System.arraycopy(header, 0, this.rawMessage, 0, header.length);
        System.arraycopy(body, 0, this.rawMessage, header.length, body.length);
    }

    public byte[] getHeader() {
        byte[] header = new byte[14];
        System.arraycopy(this.rawMessage, 0, header, 0, 14);
        return header;
    }

    public byte getCommand() {
        if (this.rawMessage.length == 14) {
            return 0;
        }
        return this.rawMessage[14];
    }

    public byte[] getBody() {
        byte[] body = new byte[this.rawMessage.length - 14];
        System.arraycopy(this.rawMessage, 14, body, 0, body.length);
        return body;
    }

    public boolean isErrorResponse() {
        int servicePluginUID = ((this.rawMessage[3] & 0xFF) << 24) + ((this.rawMessage[2] & 0xFF) << 16) + ((this.rawMessage[1] & 0xFF) << 8) + (this.rawMessage[0] & 0xFF);
        if (servicePluginUID == 270589622) {
            Byte error = new Byte(-1);
            Byte command = new Byte(this.getCommand());
            int result = error.compareTo(command);
            return result == 0 && this.getBody().length > 1;
        }
        return false;
    }

    public int getHTIErrorCode() {
        if (this.isErrorResponse()) {
            this.htiErrorCode = this.getBody()[1];
        }
        return this.htiErrorCode;
    }

    public int getServiceErrorCode() {
        if (this.isErrorResponse()) {
            byte[] body = this.getBody();
            this.serviceErrorCode = ((body[5] & 0xFF) << 24) + ((body[4] & 0xFF) << 16) + ((body[3] & 0xFF) << 8) + (body[2] & 0xFF);
        }
        return this.serviceErrorCode;
    }

    public int getServicePlugInID() {
        if (this.isErrorResponse()) {
            byte[] body = this.getBody();
            if (body == null || body.length < 10) {
                return -1;
            }
            this.serviceUID = ((body[9] & 0xFF) << 24) + ((body[8] & 0xFF) << 16) + ((body[7] & 0xFF) << 8) + (body[6] & 0xFF);
        } else {
            this.serviceUID = ((this.rawMessage[3] & 0xFF) << 24) + ((this.rawMessage[2] & 0xFF) << 16) + ((this.rawMessage[1] & 0xFF) << 8) + (this.rawMessage[0] & 0xFF);
        }
        return this.serviceUID;
    }

    public String getErrorDescription() {
        byte[] body = this.getBody();
        if (this.isErrorResponse() && body.length > 10) {
            byte[] error = new byte[body.length - 10];
            System.arraycopy(body, 10, error, 0, error.length);
            this.errorDescription = new String(error);
        }
        return this.errorDescription;
    }

    public byte[] getBytes() {
        return this.rawMessage;
    }
}

